// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLicenseGetParams creates a new LicenseGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLicenseGetParams() *LicenseGetParams {
	return &LicenseGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLicenseGetParamsWithTimeout creates a new LicenseGetParams object
// with the ability to set a timeout on a request.
func NewLicenseGetParamsWithTimeout(timeout time.Duration) *LicenseGetParams {
	return &LicenseGetParams{
		timeout: timeout,
	}
}

// NewLicenseGetParamsWithContext creates a new LicenseGetParams object
// with the ability to set a context for a request.
func NewLicenseGetParamsWithContext(ctx context.Context) *LicenseGetParams {
	return &LicenseGetParams{
		Context: ctx,
	}
}

// NewLicenseGetParamsWithHTTPClient creates a new LicenseGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLicenseGetParamsWithHTTPClient(client *http.Client) *LicenseGetParams {
	return &LicenseGetParams{
		HTTPClient: client,
	}
}

/*
LicenseGetParams contains all the parameters to send to the API endpoint

	for the license get operation.

	Typically these are written to a http.Request.
*/
type LicenseGetParams struct {

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EntitlementAction.

	   Filter by entitlement.action
	*/
	EntitlementAction *string

	/* EntitlementRisk.

	   Filter by entitlement.risk
	*/
	EntitlementRisk *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LicensesActive.

	   Filter by licenses.active
	*/
	LicensesActive *bool

	/* LicensesCapacityDisabledSize.

	   Filter by licenses.capacity.disabled_size
	*/
	LicensesCapacityDisabledSize *int64

	/* LicensesCapacityMaximumSize.

	   Filter by licenses.capacity.maximum_size
	*/
	LicensesCapacityMaximumSize *int64

	/* LicensesCapacityMeasurementUnit.

	   Filter by licenses.capacity.measurement_unit
	*/
	LicensesCapacityMeasurementUnit *string

	/* LicensesCapacityUsedSize.

	   Filter by licenses.capacity.used_size
	*/
	LicensesCapacityUsedSize *int64

	/* LicensesComplianceState.

	   Filter by licenses.compliance.state
	*/
	LicensesComplianceState *string

	/* LicensesEvaluation.

	   Filter by licenses.evaluation
	*/
	LicensesEvaluation *bool

	/* LicensesExpiryTime.

	   Filter by licenses.expiry_time
	*/
	LicensesExpiryTime *string

	/* LicensesHostID.

	   Filter by licenses.host_id
	*/
	LicensesHostID *string

	/* LicensesInstalledLicense.

	   Filter by licenses.installed_license
	*/
	LicensesInstalledLicense *string

	/* LicensesOwner.

	   Filter by licenses.owner
	*/
	LicensesOwner *string

	/* LicensesSerialNumber.

	   Filter by licenses.serial_number
	*/
	LicensesSerialNumber *string

	/* LicensesShutdownImminent.

	   Filter by licenses.shutdown_imminent
	*/
	LicensesShutdownImminent *bool

	/* LicensesStartTime.

	   Filter by licenses.start_time
	*/
	LicensesStartTime *string

	/* Name.

	   Name of the license package.
	*/
	Name string

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* State.

	   Filter by state
	*/
	State *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the license get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicenseGetParams) WithDefaults() *LicenseGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the license get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicenseGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the license get params
func (o *LicenseGetParams) WithTimeout(timeout time.Duration) *LicenseGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the license get params
func (o *LicenseGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the license get params
func (o *LicenseGetParams) WithContext(ctx context.Context) *LicenseGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the license get params
func (o *LicenseGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the license get params
func (o *LicenseGetParams) WithHTTPClient(client *http.Client) *LicenseGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the license get params
func (o *LicenseGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDescription adds the description to the license get params
func (o *LicenseGetParams) WithDescription(description *string) *LicenseGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the license get params
func (o *LicenseGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithEntitlementAction adds the entitlementAction to the license get params
func (o *LicenseGetParams) WithEntitlementAction(entitlementAction *string) *LicenseGetParams {
	o.SetEntitlementAction(entitlementAction)
	return o
}

// SetEntitlementAction adds the entitlementAction to the license get params
func (o *LicenseGetParams) SetEntitlementAction(entitlementAction *string) {
	o.EntitlementAction = entitlementAction
}

// WithEntitlementRisk adds the entitlementRisk to the license get params
func (o *LicenseGetParams) WithEntitlementRisk(entitlementRisk *string) *LicenseGetParams {
	o.SetEntitlementRisk(entitlementRisk)
	return o
}

// SetEntitlementRisk adds the entitlementRisk to the license get params
func (o *LicenseGetParams) SetEntitlementRisk(entitlementRisk *string) {
	o.EntitlementRisk = entitlementRisk
}

// WithFields adds the fields to the license get params
func (o *LicenseGetParams) WithFields(fields []string) *LicenseGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the license get params
func (o *LicenseGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLicensesActive adds the licensesActive to the license get params
func (o *LicenseGetParams) WithLicensesActive(licensesActive *bool) *LicenseGetParams {
	o.SetLicensesActive(licensesActive)
	return o
}

// SetLicensesActive adds the licensesActive to the license get params
func (o *LicenseGetParams) SetLicensesActive(licensesActive *bool) {
	o.LicensesActive = licensesActive
}

// WithLicensesCapacityDisabledSize adds the licensesCapacityDisabledSize to the license get params
func (o *LicenseGetParams) WithLicensesCapacityDisabledSize(licensesCapacityDisabledSize *int64) *LicenseGetParams {
	o.SetLicensesCapacityDisabledSize(licensesCapacityDisabledSize)
	return o
}

// SetLicensesCapacityDisabledSize adds the licensesCapacityDisabledSize to the license get params
func (o *LicenseGetParams) SetLicensesCapacityDisabledSize(licensesCapacityDisabledSize *int64) {
	o.LicensesCapacityDisabledSize = licensesCapacityDisabledSize
}

// WithLicensesCapacityMaximumSize adds the licensesCapacityMaximumSize to the license get params
func (o *LicenseGetParams) WithLicensesCapacityMaximumSize(licensesCapacityMaximumSize *int64) *LicenseGetParams {
	o.SetLicensesCapacityMaximumSize(licensesCapacityMaximumSize)
	return o
}

// SetLicensesCapacityMaximumSize adds the licensesCapacityMaximumSize to the license get params
func (o *LicenseGetParams) SetLicensesCapacityMaximumSize(licensesCapacityMaximumSize *int64) {
	o.LicensesCapacityMaximumSize = licensesCapacityMaximumSize
}

// WithLicensesCapacityMeasurementUnit adds the licensesCapacityMeasurementUnit to the license get params
func (o *LicenseGetParams) WithLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit *string) *LicenseGetParams {
	o.SetLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit)
	return o
}

// SetLicensesCapacityMeasurementUnit adds the licensesCapacityMeasurementUnit to the license get params
func (o *LicenseGetParams) SetLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit *string) {
	o.LicensesCapacityMeasurementUnit = licensesCapacityMeasurementUnit
}

// WithLicensesCapacityUsedSize adds the licensesCapacityUsedSize to the license get params
func (o *LicenseGetParams) WithLicensesCapacityUsedSize(licensesCapacityUsedSize *int64) *LicenseGetParams {
	o.SetLicensesCapacityUsedSize(licensesCapacityUsedSize)
	return o
}

// SetLicensesCapacityUsedSize adds the licensesCapacityUsedSize to the license get params
func (o *LicenseGetParams) SetLicensesCapacityUsedSize(licensesCapacityUsedSize *int64) {
	o.LicensesCapacityUsedSize = licensesCapacityUsedSize
}

// WithLicensesComplianceState adds the licensesComplianceState to the license get params
func (o *LicenseGetParams) WithLicensesComplianceState(licensesComplianceState *string) *LicenseGetParams {
	o.SetLicensesComplianceState(licensesComplianceState)
	return o
}

// SetLicensesComplianceState adds the licensesComplianceState to the license get params
func (o *LicenseGetParams) SetLicensesComplianceState(licensesComplianceState *string) {
	o.LicensesComplianceState = licensesComplianceState
}

// WithLicensesEvaluation adds the licensesEvaluation to the license get params
func (o *LicenseGetParams) WithLicensesEvaluation(licensesEvaluation *bool) *LicenseGetParams {
	o.SetLicensesEvaluation(licensesEvaluation)
	return o
}

// SetLicensesEvaluation adds the licensesEvaluation to the license get params
func (o *LicenseGetParams) SetLicensesEvaluation(licensesEvaluation *bool) {
	o.LicensesEvaluation = licensesEvaluation
}

// WithLicensesExpiryTime adds the licensesExpiryTime to the license get params
func (o *LicenseGetParams) WithLicensesExpiryTime(licensesExpiryTime *string) *LicenseGetParams {
	o.SetLicensesExpiryTime(licensesExpiryTime)
	return o
}

// SetLicensesExpiryTime adds the licensesExpiryTime to the license get params
func (o *LicenseGetParams) SetLicensesExpiryTime(licensesExpiryTime *string) {
	o.LicensesExpiryTime = licensesExpiryTime
}

// WithLicensesHostID adds the licensesHostID to the license get params
func (o *LicenseGetParams) WithLicensesHostID(licensesHostID *string) *LicenseGetParams {
	o.SetLicensesHostID(licensesHostID)
	return o
}

// SetLicensesHostID adds the licensesHostId to the license get params
func (o *LicenseGetParams) SetLicensesHostID(licensesHostID *string) {
	o.LicensesHostID = licensesHostID
}

// WithLicensesInstalledLicense adds the licensesInstalledLicense to the license get params
func (o *LicenseGetParams) WithLicensesInstalledLicense(licensesInstalledLicense *string) *LicenseGetParams {
	o.SetLicensesInstalledLicense(licensesInstalledLicense)
	return o
}

// SetLicensesInstalledLicense adds the licensesInstalledLicense to the license get params
func (o *LicenseGetParams) SetLicensesInstalledLicense(licensesInstalledLicense *string) {
	o.LicensesInstalledLicense = licensesInstalledLicense
}

// WithLicensesOwner adds the licensesOwner to the license get params
func (o *LicenseGetParams) WithLicensesOwner(licensesOwner *string) *LicenseGetParams {
	o.SetLicensesOwner(licensesOwner)
	return o
}

// SetLicensesOwner adds the licensesOwner to the license get params
func (o *LicenseGetParams) SetLicensesOwner(licensesOwner *string) {
	o.LicensesOwner = licensesOwner
}

// WithLicensesSerialNumber adds the licensesSerialNumber to the license get params
func (o *LicenseGetParams) WithLicensesSerialNumber(licensesSerialNumber *string) *LicenseGetParams {
	o.SetLicensesSerialNumber(licensesSerialNumber)
	return o
}

// SetLicensesSerialNumber adds the licensesSerialNumber to the license get params
func (o *LicenseGetParams) SetLicensesSerialNumber(licensesSerialNumber *string) {
	o.LicensesSerialNumber = licensesSerialNumber
}

// WithLicensesShutdownImminent adds the licensesShutdownImminent to the license get params
func (o *LicenseGetParams) WithLicensesShutdownImminent(licensesShutdownImminent *bool) *LicenseGetParams {
	o.SetLicensesShutdownImminent(licensesShutdownImminent)
	return o
}

// SetLicensesShutdownImminent adds the licensesShutdownImminent to the license get params
func (o *LicenseGetParams) SetLicensesShutdownImminent(licensesShutdownImminent *bool) {
	o.LicensesShutdownImminent = licensesShutdownImminent
}

// WithLicensesStartTime adds the licensesStartTime to the license get params
func (o *LicenseGetParams) WithLicensesStartTime(licensesStartTime *string) *LicenseGetParams {
	o.SetLicensesStartTime(licensesStartTime)
	return o
}

// SetLicensesStartTime adds the licensesStartTime to the license get params
func (o *LicenseGetParams) SetLicensesStartTime(licensesStartTime *string) {
	o.LicensesStartTime = licensesStartTime
}

// WithName adds the name to the license get params
func (o *LicenseGetParams) WithName(name string) *LicenseGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the license get params
func (o *LicenseGetParams) SetName(name string) {
	o.Name = name
}

// WithScope adds the scope to the license get params
func (o *LicenseGetParams) WithScope(scope *string) *LicenseGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the license get params
func (o *LicenseGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithState adds the state to the license get params
func (o *LicenseGetParams) WithState(state *string) *LicenseGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the license get params
func (o *LicenseGetParams) SetState(state *string) {
	o.State = state
}

// WriteToRequest writes these params to a swagger request
func (o *LicenseGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EntitlementAction != nil {

		// query param entitlement.action
		var qrEntitlementAction string

		if o.EntitlementAction != nil {
			qrEntitlementAction = *o.EntitlementAction
		}
		qEntitlementAction := qrEntitlementAction
		if qEntitlementAction != "" {

			if err := r.SetQueryParam("entitlement.action", qEntitlementAction); err != nil {
				return err
			}
		}
	}

	if o.EntitlementRisk != nil {

		// query param entitlement.risk
		var qrEntitlementRisk string

		if o.EntitlementRisk != nil {
			qrEntitlementRisk = *o.EntitlementRisk
		}
		qEntitlementRisk := qrEntitlementRisk
		if qEntitlementRisk != "" {

			if err := r.SetQueryParam("entitlement.risk", qEntitlementRisk); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LicensesActive != nil {

		// query param licenses.active
		var qrLicensesActive bool

		if o.LicensesActive != nil {
			qrLicensesActive = *o.LicensesActive
		}
		qLicensesActive := swag.FormatBool(qrLicensesActive)
		if qLicensesActive != "" {

			if err := r.SetQueryParam("licenses.active", qLicensesActive); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityDisabledSize != nil {

		// query param licenses.capacity.disabled_size
		var qrLicensesCapacityDisabledSize int64

		if o.LicensesCapacityDisabledSize != nil {
			qrLicensesCapacityDisabledSize = *o.LicensesCapacityDisabledSize
		}
		qLicensesCapacityDisabledSize := swag.FormatInt64(qrLicensesCapacityDisabledSize)
		if qLicensesCapacityDisabledSize != "" {

			if err := r.SetQueryParam("licenses.capacity.disabled_size", qLicensesCapacityDisabledSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityMaximumSize != nil {

		// query param licenses.capacity.maximum_size
		var qrLicensesCapacityMaximumSize int64

		if o.LicensesCapacityMaximumSize != nil {
			qrLicensesCapacityMaximumSize = *o.LicensesCapacityMaximumSize
		}
		qLicensesCapacityMaximumSize := swag.FormatInt64(qrLicensesCapacityMaximumSize)
		if qLicensesCapacityMaximumSize != "" {

			if err := r.SetQueryParam("licenses.capacity.maximum_size", qLicensesCapacityMaximumSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityMeasurementUnit != nil {

		// query param licenses.capacity.measurement_unit
		var qrLicensesCapacityMeasurementUnit string

		if o.LicensesCapacityMeasurementUnit != nil {
			qrLicensesCapacityMeasurementUnit = *o.LicensesCapacityMeasurementUnit
		}
		qLicensesCapacityMeasurementUnit := qrLicensesCapacityMeasurementUnit
		if qLicensesCapacityMeasurementUnit != "" {

			if err := r.SetQueryParam("licenses.capacity.measurement_unit", qLicensesCapacityMeasurementUnit); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityUsedSize != nil {

		// query param licenses.capacity.used_size
		var qrLicensesCapacityUsedSize int64

		if o.LicensesCapacityUsedSize != nil {
			qrLicensesCapacityUsedSize = *o.LicensesCapacityUsedSize
		}
		qLicensesCapacityUsedSize := swag.FormatInt64(qrLicensesCapacityUsedSize)
		if qLicensesCapacityUsedSize != "" {

			if err := r.SetQueryParam("licenses.capacity.used_size", qLicensesCapacityUsedSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesComplianceState != nil {

		// query param licenses.compliance.state
		var qrLicensesComplianceState string

		if o.LicensesComplianceState != nil {
			qrLicensesComplianceState = *o.LicensesComplianceState
		}
		qLicensesComplianceState := qrLicensesComplianceState
		if qLicensesComplianceState != "" {

			if err := r.SetQueryParam("licenses.compliance.state", qLicensesComplianceState); err != nil {
				return err
			}
		}
	}

	if o.LicensesEvaluation != nil {

		// query param licenses.evaluation
		var qrLicensesEvaluation bool

		if o.LicensesEvaluation != nil {
			qrLicensesEvaluation = *o.LicensesEvaluation
		}
		qLicensesEvaluation := swag.FormatBool(qrLicensesEvaluation)
		if qLicensesEvaluation != "" {

			if err := r.SetQueryParam("licenses.evaluation", qLicensesEvaluation); err != nil {
				return err
			}
		}
	}

	if o.LicensesExpiryTime != nil {

		// query param licenses.expiry_time
		var qrLicensesExpiryTime string

		if o.LicensesExpiryTime != nil {
			qrLicensesExpiryTime = *o.LicensesExpiryTime
		}
		qLicensesExpiryTime := qrLicensesExpiryTime
		if qLicensesExpiryTime != "" {

			if err := r.SetQueryParam("licenses.expiry_time", qLicensesExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.LicensesHostID != nil {

		// query param licenses.host_id
		var qrLicensesHostID string

		if o.LicensesHostID != nil {
			qrLicensesHostID = *o.LicensesHostID
		}
		qLicensesHostID := qrLicensesHostID
		if qLicensesHostID != "" {

			if err := r.SetQueryParam("licenses.host_id", qLicensesHostID); err != nil {
				return err
			}
		}
	}

	if o.LicensesInstalledLicense != nil {

		// query param licenses.installed_license
		var qrLicensesInstalledLicense string

		if o.LicensesInstalledLicense != nil {
			qrLicensesInstalledLicense = *o.LicensesInstalledLicense
		}
		qLicensesInstalledLicense := qrLicensesInstalledLicense
		if qLicensesInstalledLicense != "" {

			if err := r.SetQueryParam("licenses.installed_license", qLicensesInstalledLicense); err != nil {
				return err
			}
		}
	}

	if o.LicensesOwner != nil {

		// query param licenses.owner
		var qrLicensesOwner string

		if o.LicensesOwner != nil {
			qrLicensesOwner = *o.LicensesOwner
		}
		qLicensesOwner := qrLicensesOwner
		if qLicensesOwner != "" {

			if err := r.SetQueryParam("licenses.owner", qLicensesOwner); err != nil {
				return err
			}
		}
	}

	if o.LicensesSerialNumber != nil {

		// query param licenses.serial_number
		var qrLicensesSerialNumber string

		if o.LicensesSerialNumber != nil {
			qrLicensesSerialNumber = *o.LicensesSerialNumber
		}
		qLicensesSerialNumber := qrLicensesSerialNumber
		if qLicensesSerialNumber != "" {

			if err := r.SetQueryParam("licenses.serial_number", qLicensesSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.LicensesShutdownImminent != nil {

		// query param licenses.shutdown_imminent
		var qrLicensesShutdownImminent bool

		if o.LicensesShutdownImminent != nil {
			qrLicensesShutdownImminent = *o.LicensesShutdownImminent
		}
		qLicensesShutdownImminent := swag.FormatBool(qrLicensesShutdownImminent)
		if qLicensesShutdownImminent != "" {

			if err := r.SetQueryParam("licenses.shutdown_imminent", qLicensesShutdownImminent); err != nil {
				return err
			}
		}
	}

	if o.LicensesStartTime != nil {

		// query param licenses.start_time
		var qrLicensesStartTime string

		if o.LicensesStartTime != nil {
			qrLicensesStartTime = *o.LicensesStartTime
		}
		qLicensesStartTime := qrLicensesStartTime
		if qLicensesStartTime != "" {

			if err := r.SetQueryParam("licenses.start_time", qLicensesStartTime); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLicenseGet binds the parameter fields
func (o *LicenseGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
