// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LicenseGetReader is a Reader for the LicenseGet structure.
type LicenseGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LicenseGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLicenseGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLicenseGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLicenseGetOK creates a LicenseGetOK with default headers values
func NewLicenseGetOK() *LicenseGetOK {
	return &LicenseGetOK{}
}

/*
LicenseGetOK describes a response with status code 200, with default header values.

OK
*/
type LicenseGetOK struct {
	Payload *models.LicensePackage
}

// IsSuccess returns true when this license get o k response has a 2xx status code
func (o *LicenseGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this license get o k response has a 3xx status code
func (o *LicenseGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this license get o k response has a 4xx status code
func (o *LicenseGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this license get o k response has a 5xx status code
func (o *LicenseGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this license get o k response a status code equal to that given
func (o *LicenseGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the license get o k response
func (o *LicenseGetOK) Code() int {
	return 200
}

func (o *LicenseGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/licenses/{name}][%d] licenseGetOK %s", 200, payload)
}

func (o *LicenseGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/licenses/{name}][%d] licenseGetOK %s", 200, payload)
}

func (o *LicenseGetOK) GetPayload() *models.LicensePackage {
	return o.Payload
}

func (o *LicenseGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LicensePackage)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLicenseGetDefault creates a LicenseGetDefault with default headers values
func NewLicenseGetDefault(code int) *LicenseGetDefault {
	return &LicenseGetDefault{
		_statusCode: code,
	}
}

/*
LicenseGetDefault describes a response with status code -1, with default header values.

Error
*/
type LicenseGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this license get default response has a 2xx status code
func (o *LicenseGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this license get default response has a 3xx status code
func (o *LicenseGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this license get default response has a 4xx status code
func (o *LicenseGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this license get default response has a 5xx status code
func (o *LicenseGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this license get default response a status code equal to that given
func (o *LicenseGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the license get default response
func (o *LicenseGetDefault) Code() int {
	return o._statusCode
}

func (o *LicenseGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/licenses/{name}][%d] license_get default %s", o._statusCode, payload)
}

func (o *LicenseGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/licenses/{name}][%d] license_get default %s", o._statusCode, payload)
}

func (o *LicenseGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LicenseGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
