// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLicenseManagerCollectionGetParams creates a new LicenseManagerCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLicenseManagerCollectionGetParams() *LicenseManagerCollectionGetParams {
	return &LicenseManagerCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLicenseManagerCollectionGetParamsWithTimeout creates a new LicenseManagerCollectionGetParams object
// with the ability to set a timeout on a request.
func NewLicenseManagerCollectionGetParamsWithTimeout(timeout time.Duration) *LicenseManagerCollectionGetParams {
	return &LicenseManagerCollectionGetParams{
		timeout: timeout,
	}
}

// NewLicenseManagerCollectionGetParamsWithContext creates a new LicenseManagerCollectionGetParams object
// with the ability to set a context for a request.
func NewLicenseManagerCollectionGetParamsWithContext(ctx context.Context) *LicenseManagerCollectionGetParams {
	return &LicenseManagerCollectionGetParams{
		Context: ctx,
	}
}

// NewLicenseManagerCollectionGetParamsWithHTTPClient creates a new LicenseManagerCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLicenseManagerCollectionGetParamsWithHTTPClient(client *http.Client) *LicenseManagerCollectionGetParams {
	return &LicenseManagerCollectionGetParams{
		HTTPClient: client,
	}
}

/*
LicenseManagerCollectionGetParams contains all the parameters to send to the API endpoint

	for the license manager collection get operation.

	Typically these are written to a http.Request.
*/
type LicenseManagerCollectionGetParams struct {

	/* Default.

	   Filter by default
	*/
	Default *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* URIHost.

	   Filter by uri.host
	*/
	URIHost *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the license manager collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicenseManagerCollectionGetParams) WithDefaults() *LicenseManagerCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the license manager collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicenseManagerCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := LicenseManagerCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithTimeout(timeout time.Duration) *LicenseManagerCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithContext(ctx context.Context) *LicenseManagerCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithHTTPClient(client *http.Client) *LicenseManagerCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDefault adds the defaultVar to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithDefault(defaultVar *bool) *LicenseManagerCollectionGetParams {
	o.SetDefault(defaultVar)
	return o
}

// SetDefault adds the default to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetDefault(defaultVar *bool) {
	o.Default = defaultVar
}

// WithFields adds the fields to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithFields(fields []string) *LicenseManagerCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithMaxRecords(maxRecords *int64) *LicenseManagerCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithOrderBy(orderBy []string) *LicenseManagerCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithReturnRecords(returnRecords *bool) *LicenseManagerCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *LicenseManagerCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithURIHost adds the uRIHost to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithURIHost(uRIHost *string) *LicenseManagerCollectionGetParams {
	o.SetURIHost(uRIHost)
	return o
}

// SetURIHost adds the uriHost to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetURIHost(uRIHost *string) {
	o.URIHost = uRIHost
}

// WithUUID adds the uuid to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) WithUUID(uuid *string) *LicenseManagerCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the license manager collection get params
func (o *LicenseManagerCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *LicenseManagerCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Default != nil {

		// query param default
		var qrDefault bool

		if o.Default != nil {
			qrDefault = *o.Default
		}
		qDefault := swag.FormatBool(qrDefault)
		if qDefault != "" {

			if err := r.SetQueryParam("default", qDefault); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.URIHost != nil {

		// query param uri.host
		var qrURIHost string

		if o.URIHost != nil {
			qrURIHost = *o.URIHost
		}
		qURIHost := qrURIHost
		if qURIHost != "" {

			if err := r.SetQueryParam("uri.host", qURIHost); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLicenseManagerCollectionGet binds the parameter fields
func (o *LicenseManagerCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamLicenseManagerCollectionGet binds the parameter order_by
func (o *LicenseManagerCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
