// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LicenseManagerGetReader is a Reader for the LicenseManagerGet structure.
type LicenseManagerGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LicenseManagerGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLicenseManagerGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLicenseManagerGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLicenseManagerGetOK creates a LicenseManagerGetOK with default headers values
func NewLicenseManagerGetOK() *LicenseManagerGetOK {
	return &LicenseManagerGetOK{}
}

/*
LicenseManagerGetOK describes a response with status code 200, with default header values.

OK
*/
type LicenseManagerGetOK struct {
	Payload *models.LicenseManager
}

// IsSuccess returns true when this license manager get o k response has a 2xx status code
func (o *LicenseManagerGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this license manager get o k response has a 3xx status code
func (o *LicenseManagerGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this license manager get o k response has a 4xx status code
func (o *LicenseManagerGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this license manager get o k response has a 5xx status code
func (o *LicenseManagerGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this license manager get o k response a status code equal to that given
func (o *LicenseManagerGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the license manager get o k response
func (o *LicenseManagerGetOK) Code() int {
	return 200
}

func (o *LicenseManagerGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/license-managers/{uuid}][%d] licenseManagerGetOK %s", 200, payload)
}

func (o *LicenseManagerGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/license-managers/{uuid}][%d] licenseManagerGetOK %s", 200, payload)
}

func (o *LicenseManagerGetOK) GetPayload() *models.LicenseManager {
	return o.Payload
}

func (o *LicenseManagerGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LicenseManager)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLicenseManagerGetDefault creates a LicenseManagerGetDefault with default headers values
func NewLicenseManagerGetDefault(code int) *LicenseManagerGetDefault {
	return &LicenseManagerGetDefault{
		_statusCode: code,
	}
}

/*
LicenseManagerGetDefault describes a response with status code -1, with default header values.

Error
*/
type LicenseManagerGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this license manager get default response has a 2xx status code
func (o *LicenseManagerGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this license manager get default response has a 3xx status code
func (o *LicenseManagerGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this license manager get default response has a 4xx status code
func (o *LicenseManagerGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this license manager get default response has a 5xx status code
func (o *LicenseManagerGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this license manager get default response a status code equal to that given
func (o *LicenseManagerGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the license manager get default response
func (o *LicenseManagerGetDefault) Code() int {
	return o._statusCode
}

func (o *LicenseManagerGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/license-managers/{uuid}][%d] license_manager_get default %s", o._statusCode, payload)
}

func (o *LicenseManagerGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/licensing/license-managers/{uuid}][%d] license_manager_get default %s", o._statusCode, payload)
}

func (o *LicenseManagerGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LicenseManagerGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
