// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LicenseManagerModifyReader is a Reader for the LicenseManagerModify structure.
type LicenseManagerModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LicenseManagerModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLicenseManagerModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewLicenseManagerModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLicenseManagerModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLicenseManagerModifyOK creates a LicenseManagerModifyOK with default headers values
func NewLicenseManagerModifyOK() *LicenseManagerModifyOK {
	return &LicenseManagerModifyOK{}
}

/*
LicenseManagerModifyOK describes a response with status code 200, with default header values.

OK
*/
type LicenseManagerModifyOK struct {
	Payload *models.LicenseManagerJobLinkResponse
}

// IsSuccess returns true when this license manager modify o k response has a 2xx status code
func (o *LicenseManagerModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this license manager modify o k response has a 3xx status code
func (o *LicenseManagerModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this license manager modify o k response has a 4xx status code
func (o *LicenseManagerModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this license manager modify o k response has a 5xx status code
func (o *LicenseManagerModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this license manager modify o k response a status code equal to that given
func (o *LicenseManagerModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the license manager modify o k response
func (o *LicenseManagerModifyOK) Code() int {
	return 200
}

func (o *LicenseManagerModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/licensing/license-managers/{uuid}][%d] licenseManagerModifyOK %s", 200, payload)
}

func (o *LicenseManagerModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/licensing/license-managers/{uuid}][%d] licenseManagerModifyOK %s", 200, payload)
}

func (o *LicenseManagerModifyOK) GetPayload() *models.LicenseManagerJobLinkResponse {
	return o.Payload
}

func (o *LicenseManagerModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LicenseManagerJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLicenseManagerModifyAccepted creates a LicenseManagerModifyAccepted with default headers values
func NewLicenseManagerModifyAccepted() *LicenseManagerModifyAccepted {
	return &LicenseManagerModifyAccepted{}
}

/*
LicenseManagerModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type LicenseManagerModifyAccepted struct {
	Payload *models.LicenseManagerJobLinkResponse
}

// IsSuccess returns true when this license manager modify accepted response has a 2xx status code
func (o *LicenseManagerModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this license manager modify accepted response has a 3xx status code
func (o *LicenseManagerModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this license manager modify accepted response has a 4xx status code
func (o *LicenseManagerModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this license manager modify accepted response has a 5xx status code
func (o *LicenseManagerModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this license manager modify accepted response a status code equal to that given
func (o *LicenseManagerModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the license manager modify accepted response
func (o *LicenseManagerModifyAccepted) Code() int {
	return 202
}

func (o *LicenseManagerModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/licensing/license-managers/{uuid}][%d] licenseManagerModifyAccepted %s", 202, payload)
}

func (o *LicenseManagerModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/licensing/license-managers/{uuid}][%d] licenseManagerModifyAccepted %s", 202, payload)
}

func (o *LicenseManagerModifyAccepted) GetPayload() *models.LicenseManagerJobLinkResponse {
	return o.Payload
}

func (o *LicenseManagerModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LicenseManagerJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLicenseManagerModifyDefault creates a LicenseManagerModifyDefault with default headers values
func NewLicenseManagerModifyDefault(code int) *LicenseManagerModifyDefault {
	return &LicenseManagerModifyDefault{
		_statusCode: code,
	}
}

/*
	LicenseManagerModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1115532 | The requested update to the license manager information failed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LicenseManagerModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponses
}

// IsSuccess returns true when this license manager modify default response has a 2xx status code
func (o *LicenseManagerModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this license manager modify default response has a 3xx status code
func (o *LicenseManagerModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this license manager modify default response has a 4xx status code
func (o *LicenseManagerModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this license manager modify default response has a 5xx status code
func (o *LicenseManagerModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this license manager modify default response a status code equal to that given
func (o *LicenseManagerModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the license manager modify default response
func (o *LicenseManagerModifyDefault) Code() int {
	return o._statusCode
}

func (o *LicenseManagerModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/licensing/license-managers/{uuid}][%d] license_manager_modify default %s", o._statusCode, payload)
}

func (o *LicenseManagerModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/licensing/license-managers/{uuid}][%d] license_manager_modify default %s", o._statusCode, payload)
}

func (o *LicenseManagerModifyDefault) GetPayload() *models.ErrorResponses {
	return o.Payload
}

func (o *LicenseManagerModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponses)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
