// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLicensesGetParams creates a new LicensesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLicensesGetParams() *LicensesGetParams {
	return &LicensesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLicensesGetParamsWithTimeout creates a new LicensesGetParams object
// with the ability to set a timeout on a request.
func NewLicensesGetParamsWithTimeout(timeout time.Duration) *LicensesGetParams {
	return &LicensesGetParams{
		timeout: timeout,
	}
}

// NewLicensesGetParamsWithContext creates a new LicensesGetParams object
// with the ability to set a context for a request.
func NewLicensesGetParamsWithContext(ctx context.Context) *LicensesGetParams {
	return &LicensesGetParams{
		Context: ctx,
	}
}

// NewLicensesGetParamsWithHTTPClient creates a new LicensesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLicensesGetParamsWithHTTPClient(client *http.Client) *LicensesGetParams {
	return &LicensesGetParams{
		HTTPClient: client,
	}
}

/*
LicensesGetParams contains all the parameters to send to the API endpoint

	for the licenses get operation.

	Typically these are written to a http.Request.
*/
type LicensesGetParams struct {

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EntitlementAction.

	   Filter by entitlement.action
	*/
	EntitlementAction *string

	/* EntitlementRisk.

	   Filter by entitlement.risk
	*/
	EntitlementRisk *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LicensesActive.

	   Filter by licenses.active
	*/
	LicensesActive *bool

	/* LicensesCapacityDisabledSize.

	   Filter by licenses.capacity.disabled_size
	*/
	LicensesCapacityDisabledSize *int64

	/* LicensesCapacityMaximumSize.

	   Filter by licenses.capacity.maximum_size
	*/
	LicensesCapacityMaximumSize *int64

	/* LicensesCapacityMeasurementUnit.

	   Filter by licenses.capacity.measurement_unit
	*/
	LicensesCapacityMeasurementUnit *string

	/* LicensesCapacityUsedSize.

	   Filter by licenses.capacity.used_size
	*/
	LicensesCapacityUsedSize *int64

	/* LicensesComplianceState.

	   Filter by licenses.compliance.state
	*/
	LicensesComplianceState *string

	/* LicensesEvaluation.

	   Filter by licenses.evaluation
	*/
	LicensesEvaluation *bool

	/* LicensesExpiryTime.

	   Filter by licenses.expiry_time
	*/
	LicensesExpiryTime *string

	/* LicensesHostID.

	   Filter by licenses.host_id
	*/
	LicensesHostID *string

	/* LicensesInstalledLicense.

	   Filter by licenses.installed_license
	*/
	LicensesInstalledLicense *string

	/* LicensesOwner.

	   Filter by licenses.owner
	*/
	LicensesOwner *string

	/* LicensesSerialNumber.

	   Filter by licenses.serial_number
	*/
	LicensesSerialNumber *string

	/* LicensesShutdownImminent.

	   Filter by licenses.shutdown_imminent
	*/
	LicensesShutdownImminent *bool

	/* LicensesStartTime.

	   Filter by licenses.start_time
	*/
	LicensesStartTime *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* State.

	   Filter by state
	*/
	State *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the licenses get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicensesGetParams) WithDefaults() *LicensesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the licenses get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LicensesGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := LicensesGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the licenses get params
func (o *LicensesGetParams) WithTimeout(timeout time.Duration) *LicensesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the licenses get params
func (o *LicensesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the licenses get params
func (o *LicensesGetParams) WithContext(ctx context.Context) *LicensesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the licenses get params
func (o *LicensesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the licenses get params
func (o *LicensesGetParams) WithHTTPClient(client *http.Client) *LicensesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the licenses get params
func (o *LicensesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDescription adds the description to the licenses get params
func (o *LicensesGetParams) WithDescription(description *string) *LicensesGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the licenses get params
func (o *LicensesGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithEntitlementAction adds the entitlementAction to the licenses get params
func (o *LicensesGetParams) WithEntitlementAction(entitlementAction *string) *LicensesGetParams {
	o.SetEntitlementAction(entitlementAction)
	return o
}

// SetEntitlementAction adds the entitlementAction to the licenses get params
func (o *LicensesGetParams) SetEntitlementAction(entitlementAction *string) {
	o.EntitlementAction = entitlementAction
}

// WithEntitlementRisk adds the entitlementRisk to the licenses get params
func (o *LicensesGetParams) WithEntitlementRisk(entitlementRisk *string) *LicensesGetParams {
	o.SetEntitlementRisk(entitlementRisk)
	return o
}

// SetEntitlementRisk adds the entitlementRisk to the licenses get params
func (o *LicensesGetParams) SetEntitlementRisk(entitlementRisk *string) {
	o.EntitlementRisk = entitlementRisk
}

// WithFields adds the fields to the licenses get params
func (o *LicensesGetParams) WithFields(fields []string) *LicensesGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the licenses get params
func (o *LicensesGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLicensesActive adds the licensesActive to the licenses get params
func (o *LicensesGetParams) WithLicensesActive(licensesActive *bool) *LicensesGetParams {
	o.SetLicensesActive(licensesActive)
	return o
}

// SetLicensesActive adds the licensesActive to the licenses get params
func (o *LicensesGetParams) SetLicensesActive(licensesActive *bool) {
	o.LicensesActive = licensesActive
}

// WithLicensesCapacityDisabledSize adds the licensesCapacityDisabledSize to the licenses get params
func (o *LicensesGetParams) WithLicensesCapacityDisabledSize(licensesCapacityDisabledSize *int64) *LicensesGetParams {
	o.SetLicensesCapacityDisabledSize(licensesCapacityDisabledSize)
	return o
}

// SetLicensesCapacityDisabledSize adds the licensesCapacityDisabledSize to the licenses get params
func (o *LicensesGetParams) SetLicensesCapacityDisabledSize(licensesCapacityDisabledSize *int64) {
	o.LicensesCapacityDisabledSize = licensesCapacityDisabledSize
}

// WithLicensesCapacityMaximumSize adds the licensesCapacityMaximumSize to the licenses get params
func (o *LicensesGetParams) WithLicensesCapacityMaximumSize(licensesCapacityMaximumSize *int64) *LicensesGetParams {
	o.SetLicensesCapacityMaximumSize(licensesCapacityMaximumSize)
	return o
}

// SetLicensesCapacityMaximumSize adds the licensesCapacityMaximumSize to the licenses get params
func (o *LicensesGetParams) SetLicensesCapacityMaximumSize(licensesCapacityMaximumSize *int64) {
	o.LicensesCapacityMaximumSize = licensesCapacityMaximumSize
}

// WithLicensesCapacityMeasurementUnit adds the licensesCapacityMeasurementUnit to the licenses get params
func (o *LicensesGetParams) WithLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit *string) *LicensesGetParams {
	o.SetLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit)
	return o
}

// SetLicensesCapacityMeasurementUnit adds the licensesCapacityMeasurementUnit to the licenses get params
func (o *LicensesGetParams) SetLicensesCapacityMeasurementUnit(licensesCapacityMeasurementUnit *string) {
	o.LicensesCapacityMeasurementUnit = licensesCapacityMeasurementUnit
}

// WithLicensesCapacityUsedSize adds the licensesCapacityUsedSize to the licenses get params
func (o *LicensesGetParams) WithLicensesCapacityUsedSize(licensesCapacityUsedSize *int64) *LicensesGetParams {
	o.SetLicensesCapacityUsedSize(licensesCapacityUsedSize)
	return o
}

// SetLicensesCapacityUsedSize adds the licensesCapacityUsedSize to the licenses get params
func (o *LicensesGetParams) SetLicensesCapacityUsedSize(licensesCapacityUsedSize *int64) {
	o.LicensesCapacityUsedSize = licensesCapacityUsedSize
}

// WithLicensesComplianceState adds the licensesComplianceState to the licenses get params
func (o *LicensesGetParams) WithLicensesComplianceState(licensesComplianceState *string) *LicensesGetParams {
	o.SetLicensesComplianceState(licensesComplianceState)
	return o
}

// SetLicensesComplianceState adds the licensesComplianceState to the licenses get params
func (o *LicensesGetParams) SetLicensesComplianceState(licensesComplianceState *string) {
	o.LicensesComplianceState = licensesComplianceState
}

// WithLicensesEvaluation adds the licensesEvaluation to the licenses get params
func (o *LicensesGetParams) WithLicensesEvaluation(licensesEvaluation *bool) *LicensesGetParams {
	o.SetLicensesEvaluation(licensesEvaluation)
	return o
}

// SetLicensesEvaluation adds the licensesEvaluation to the licenses get params
func (o *LicensesGetParams) SetLicensesEvaluation(licensesEvaluation *bool) {
	o.LicensesEvaluation = licensesEvaluation
}

// WithLicensesExpiryTime adds the licensesExpiryTime to the licenses get params
func (o *LicensesGetParams) WithLicensesExpiryTime(licensesExpiryTime *string) *LicensesGetParams {
	o.SetLicensesExpiryTime(licensesExpiryTime)
	return o
}

// SetLicensesExpiryTime adds the licensesExpiryTime to the licenses get params
func (o *LicensesGetParams) SetLicensesExpiryTime(licensesExpiryTime *string) {
	o.LicensesExpiryTime = licensesExpiryTime
}

// WithLicensesHostID adds the licensesHostID to the licenses get params
func (o *LicensesGetParams) WithLicensesHostID(licensesHostID *string) *LicensesGetParams {
	o.SetLicensesHostID(licensesHostID)
	return o
}

// SetLicensesHostID adds the licensesHostId to the licenses get params
func (o *LicensesGetParams) SetLicensesHostID(licensesHostID *string) {
	o.LicensesHostID = licensesHostID
}

// WithLicensesInstalledLicense adds the licensesInstalledLicense to the licenses get params
func (o *LicensesGetParams) WithLicensesInstalledLicense(licensesInstalledLicense *string) *LicensesGetParams {
	o.SetLicensesInstalledLicense(licensesInstalledLicense)
	return o
}

// SetLicensesInstalledLicense adds the licensesInstalledLicense to the licenses get params
func (o *LicensesGetParams) SetLicensesInstalledLicense(licensesInstalledLicense *string) {
	o.LicensesInstalledLicense = licensesInstalledLicense
}

// WithLicensesOwner adds the licensesOwner to the licenses get params
func (o *LicensesGetParams) WithLicensesOwner(licensesOwner *string) *LicensesGetParams {
	o.SetLicensesOwner(licensesOwner)
	return o
}

// SetLicensesOwner adds the licensesOwner to the licenses get params
func (o *LicensesGetParams) SetLicensesOwner(licensesOwner *string) {
	o.LicensesOwner = licensesOwner
}

// WithLicensesSerialNumber adds the licensesSerialNumber to the licenses get params
func (o *LicensesGetParams) WithLicensesSerialNumber(licensesSerialNumber *string) *LicensesGetParams {
	o.SetLicensesSerialNumber(licensesSerialNumber)
	return o
}

// SetLicensesSerialNumber adds the licensesSerialNumber to the licenses get params
func (o *LicensesGetParams) SetLicensesSerialNumber(licensesSerialNumber *string) {
	o.LicensesSerialNumber = licensesSerialNumber
}

// WithLicensesShutdownImminent adds the licensesShutdownImminent to the licenses get params
func (o *LicensesGetParams) WithLicensesShutdownImminent(licensesShutdownImminent *bool) *LicensesGetParams {
	o.SetLicensesShutdownImminent(licensesShutdownImminent)
	return o
}

// SetLicensesShutdownImminent adds the licensesShutdownImminent to the licenses get params
func (o *LicensesGetParams) SetLicensesShutdownImminent(licensesShutdownImminent *bool) {
	o.LicensesShutdownImminent = licensesShutdownImminent
}

// WithLicensesStartTime adds the licensesStartTime to the licenses get params
func (o *LicensesGetParams) WithLicensesStartTime(licensesStartTime *string) *LicensesGetParams {
	o.SetLicensesStartTime(licensesStartTime)
	return o
}

// SetLicensesStartTime adds the licensesStartTime to the licenses get params
func (o *LicensesGetParams) SetLicensesStartTime(licensesStartTime *string) {
	o.LicensesStartTime = licensesStartTime
}

// WithMaxRecords adds the maxRecords to the licenses get params
func (o *LicensesGetParams) WithMaxRecords(maxRecords *int64) *LicensesGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the licenses get params
func (o *LicensesGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the licenses get params
func (o *LicensesGetParams) WithName(name *string) *LicensesGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the licenses get params
func (o *LicensesGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the licenses get params
func (o *LicensesGetParams) WithOrderBy(orderBy []string) *LicensesGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the licenses get params
func (o *LicensesGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the licenses get params
func (o *LicensesGetParams) WithReturnRecords(returnRecords *bool) *LicensesGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the licenses get params
func (o *LicensesGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the licenses get params
func (o *LicensesGetParams) WithReturnTimeout(returnTimeout *int64) *LicensesGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the licenses get params
func (o *LicensesGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the licenses get params
func (o *LicensesGetParams) WithScope(scope *string) *LicensesGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the licenses get params
func (o *LicensesGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithState adds the state to the licenses get params
func (o *LicensesGetParams) WithState(state *string) *LicensesGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the licenses get params
func (o *LicensesGetParams) SetState(state *string) {
	o.State = state
}

// WriteToRequest writes these params to a swagger request
func (o *LicensesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EntitlementAction != nil {

		// query param entitlement.action
		var qrEntitlementAction string

		if o.EntitlementAction != nil {
			qrEntitlementAction = *o.EntitlementAction
		}
		qEntitlementAction := qrEntitlementAction
		if qEntitlementAction != "" {

			if err := r.SetQueryParam("entitlement.action", qEntitlementAction); err != nil {
				return err
			}
		}
	}

	if o.EntitlementRisk != nil {

		// query param entitlement.risk
		var qrEntitlementRisk string

		if o.EntitlementRisk != nil {
			qrEntitlementRisk = *o.EntitlementRisk
		}
		qEntitlementRisk := qrEntitlementRisk
		if qEntitlementRisk != "" {

			if err := r.SetQueryParam("entitlement.risk", qEntitlementRisk); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LicensesActive != nil {

		// query param licenses.active
		var qrLicensesActive bool

		if o.LicensesActive != nil {
			qrLicensesActive = *o.LicensesActive
		}
		qLicensesActive := swag.FormatBool(qrLicensesActive)
		if qLicensesActive != "" {

			if err := r.SetQueryParam("licenses.active", qLicensesActive); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityDisabledSize != nil {

		// query param licenses.capacity.disabled_size
		var qrLicensesCapacityDisabledSize int64

		if o.LicensesCapacityDisabledSize != nil {
			qrLicensesCapacityDisabledSize = *o.LicensesCapacityDisabledSize
		}
		qLicensesCapacityDisabledSize := swag.FormatInt64(qrLicensesCapacityDisabledSize)
		if qLicensesCapacityDisabledSize != "" {

			if err := r.SetQueryParam("licenses.capacity.disabled_size", qLicensesCapacityDisabledSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityMaximumSize != nil {

		// query param licenses.capacity.maximum_size
		var qrLicensesCapacityMaximumSize int64

		if o.LicensesCapacityMaximumSize != nil {
			qrLicensesCapacityMaximumSize = *o.LicensesCapacityMaximumSize
		}
		qLicensesCapacityMaximumSize := swag.FormatInt64(qrLicensesCapacityMaximumSize)
		if qLicensesCapacityMaximumSize != "" {

			if err := r.SetQueryParam("licenses.capacity.maximum_size", qLicensesCapacityMaximumSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityMeasurementUnit != nil {

		// query param licenses.capacity.measurement_unit
		var qrLicensesCapacityMeasurementUnit string

		if o.LicensesCapacityMeasurementUnit != nil {
			qrLicensesCapacityMeasurementUnit = *o.LicensesCapacityMeasurementUnit
		}
		qLicensesCapacityMeasurementUnit := qrLicensesCapacityMeasurementUnit
		if qLicensesCapacityMeasurementUnit != "" {

			if err := r.SetQueryParam("licenses.capacity.measurement_unit", qLicensesCapacityMeasurementUnit); err != nil {
				return err
			}
		}
	}

	if o.LicensesCapacityUsedSize != nil {

		// query param licenses.capacity.used_size
		var qrLicensesCapacityUsedSize int64

		if o.LicensesCapacityUsedSize != nil {
			qrLicensesCapacityUsedSize = *o.LicensesCapacityUsedSize
		}
		qLicensesCapacityUsedSize := swag.FormatInt64(qrLicensesCapacityUsedSize)
		if qLicensesCapacityUsedSize != "" {

			if err := r.SetQueryParam("licenses.capacity.used_size", qLicensesCapacityUsedSize); err != nil {
				return err
			}
		}
	}

	if o.LicensesComplianceState != nil {

		// query param licenses.compliance.state
		var qrLicensesComplianceState string

		if o.LicensesComplianceState != nil {
			qrLicensesComplianceState = *o.LicensesComplianceState
		}
		qLicensesComplianceState := qrLicensesComplianceState
		if qLicensesComplianceState != "" {

			if err := r.SetQueryParam("licenses.compliance.state", qLicensesComplianceState); err != nil {
				return err
			}
		}
	}

	if o.LicensesEvaluation != nil {

		// query param licenses.evaluation
		var qrLicensesEvaluation bool

		if o.LicensesEvaluation != nil {
			qrLicensesEvaluation = *o.LicensesEvaluation
		}
		qLicensesEvaluation := swag.FormatBool(qrLicensesEvaluation)
		if qLicensesEvaluation != "" {

			if err := r.SetQueryParam("licenses.evaluation", qLicensesEvaluation); err != nil {
				return err
			}
		}
	}

	if o.LicensesExpiryTime != nil {

		// query param licenses.expiry_time
		var qrLicensesExpiryTime string

		if o.LicensesExpiryTime != nil {
			qrLicensesExpiryTime = *o.LicensesExpiryTime
		}
		qLicensesExpiryTime := qrLicensesExpiryTime
		if qLicensesExpiryTime != "" {

			if err := r.SetQueryParam("licenses.expiry_time", qLicensesExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.LicensesHostID != nil {

		// query param licenses.host_id
		var qrLicensesHostID string

		if o.LicensesHostID != nil {
			qrLicensesHostID = *o.LicensesHostID
		}
		qLicensesHostID := qrLicensesHostID
		if qLicensesHostID != "" {

			if err := r.SetQueryParam("licenses.host_id", qLicensesHostID); err != nil {
				return err
			}
		}
	}

	if o.LicensesInstalledLicense != nil {

		// query param licenses.installed_license
		var qrLicensesInstalledLicense string

		if o.LicensesInstalledLicense != nil {
			qrLicensesInstalledLicense = *o.LicensesInstalledLicense
		}
		qLicensesInstalledLicense := qrLicensesInstalledLicense
		if qLicensesInstalledLicense != "" {

			if err := r.SetQueryParam("licenses.installed_license", qLicensesInstalledLicense); err != nil {
				return err
			}
		}
	}

	if o.LicensesOwner != nil {

		// query param licenses.owner
		var qrLicensesOwner string

		if o.LicensesOwner != nil {
			qrLicensesOwner = *o.LicensesOwner
		}
		qLicensesOwner := qrLicensesOwner
		if qLicensesOwner != "" {

			if err := r.SetQueryParam("licenses.owner", qLicensesOwner); err != nil {
				return err
			}
		}
	}

	if o.LicensesSerialNumber != nil {

		// query param licenses.serial_number
		var qrLicensesSerialNumber string

		if o.LicensesSerialNumber != nil {
			qrLicensesSerialNumber = *o.LicensesSerialNumber
		}
		qLicensesSerialNumber := qrLicensesSerialNumber
		if qLicensesSerialNumber != "" {

			if err := r.SetQueryParam("licenses.serial_number", qLicensesSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.LicensesShutdownImminent != nil {

		// query param licenses.shutdown_imminent
		var qrLicensesShutdownImminent bool

		if o.LicensesShutdownImminent != nil {
			qrLicensesShutdownImminent = *o.LicensesShutdownImminent
		}
		qLicensesShutdownImminent := swag.FormatBool(qrLicensesShutdownImminent)
		if qLicensesShutdownImminent != "" {

			if err := r.SetQueryParam("licenses.shutdown_imminent", qLicensesShutdownImminent); err != nil {
				return err
			}
		}
	}

	if o.LicensesStartTime != nil {

		// query param licenses.start_time
		var qrLicensesStartTime string

		if o.LicensesStartTime != nil {
			qrLicensesStartTime = *o.LicensesStartTime
		}
		qLicensesStartTime := qrLicensesStartTime
		if qLicensesStartTime != "" {

			if err := r.SetQueryParam("licenses.start_time", qLicensesStartTime); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLicensesGet binds the parameter fields
func (o *LicensesGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamLicensesGet binds the parameter order_by
func (o *LicensesGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
