// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMediatorCollectionGetParams creates a new MediatorCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMediatorCollectionGetParams() *MediatorCollectionGetParams {
	return &MediatorCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMediatorCollectionGetParamsWithTimeout creates a new MediatorCollectionGetParams object
// with the ability to set a timeout on a request.
func NewMediatorCollectionGetParamsWithTimeout(timeout time.Duration) *MediatorCollectionGetParams {
	return &MediatorCollectionGetParams{
		timeout: timeout,
	}
}

// NewMediatorCollectionGetParamsWithContext creates a new MediatorCollectionGetParams object
// with the ability to set a context for a request.
func NewMediatorCollectionGetParamsWithContext(ctx context.Context) *MediatorCollectionGetParams {
	return &MediatorCollectionGetParams{
		Context: ctx,
	}
}

// NewMediatorCollectionGetParamsWithHTTPClient creates a new MediatorCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewMediatorCollectionGetParamsWithHTTPClient(client *http.Client) *MediatorCollectionGetParams {
	return &MediatorCollectionGetParams{
		HTTPClient: client,
	}
}

/*
MediatorCollectionGetParams contains all the parameters to send to the API endpoint

	for the mediator collection get operation.

	Typically these are written to a http.Request.
*/
type MediatorCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IPAddress.

	   Filter by ip_address
	*/
	IPAddress *string

	/* LocalMediatorConnectivity.

	   Filter by local_mediator_connectivity
	*/
	LocalMediatorConnectivity *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PeerClusterName.

	   Filter by peer_cluster.name
	*/
	PeerClusterName *string

	/* PeerClusterUUID.

	   Filter by peer_cluster.uuid
	*/
	PeerClusterUUID *string

	/* PeerMediatorConnectivity.

	   Filter by peer_mediator_connectivity
	*/
	PeerMediatorConnectivity *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* Reachable.

	   Filter by reachable
	*/
	Reachable *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* StrictCertValidation.

	   Filter by strict_cert_validation
	*/
	StrictCertValidation *bool

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UseHTTPProxyLocal.

	   Filter by use_http_proxy_local
	*/
	UseHTTPProxyLocal *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the mediator collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorCollectionGetParams) WithDefaults() *MediatorCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the mediator collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := MediatorCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the mediator collection get params
func (o *MediatorCollectionGetParams) WithTimeout(timeout time.Duration) *MediatorCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the mediator collection get params
func (o *MediatorCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the mediator collection get params
func (o *MediatorCollectionGetParams) WithContext(ctx context.Context) *MediatorCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the mediator collection get params
func (o *MediatorCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the mediator collection get params
func (o *MediatorCollectionGetParams) WithHTTPClient(client *http.Client) *MediatorCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the mediator collection get params
func (o *MediatorCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the mediator collection get params
func (o *MediatorCollectionGetParams) WithFields(fields []string) *MediatorCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the mediator collection get params
func (o *MediatorCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIPAddress adds the iPAddress to the mediator collection get params
func (o *MediatorCollectionGetParams) WithIPAddress(iPAddress *string) *MediatorCollectionGetParams {
	o.SetIPAddress(iPAddress)
	return o
}

// SetIPAddress adds the ipAddress to the mediator collection get params
func (o *MediatorCollectionGetParams) SetIPAddress(iPAddress *string) {
	o.IPAddress = iPAddress
}

// WithLocalMediatorConnectivity adds the localMediatorConnectivity to the mediator collection get params
func (o *MediatorCollectionGetParams) WithLocalMediatorConnectivity(localMediatorConnectivity *string) *MediatorCollectionGetParams {
	o.SetLocalMediatorConnectivity(localMediatorConnectivity)
	return o
}

// SetLocalMediatorConnectivity adds the localMediatorConnectivity to the mediator collection get params
func (o *MediatorCollectionGetParams) SetLocalMediatorConnectivity(localMediatorConnectivity *string) {
	o.LocalMediatorConnectivity = localMediatorConnectivity
}

// WithMaxRecords adds the maxRecords to the mediator collection get params
func (o *MediatorCollectionGetParams) WithMaxRecords(maxRecords *int64) *MediatorCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the mediator collection get params
func (o *MediatorCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the mediator collection get params
func (o *MediatorCollectionGetParams) WithOrderBy(orderBy []string) *MediatorCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the mediator collection get params
func (o *MediatorCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPeerClusterName adds the peerClusterName to the mediator collection get params
func (o *MediatorCollectionGetParams) WithPeerClusterName(peerClusterName *string) *MediatorCollectionGetParams {
	o.SetPeerClusterName(peerClusterName)
	return o
}

// SetPeerClusterName adds the peerClusterName to the mediator collection get params
func (o *MediatorCollectionGetParams) SetPeerClusterName(peerClusterName *string) {
	o.PeerClusterName = peerClusterName
}

// WithPeerClusterUUID adds the peerClusterUUID to the mediator collection get params
func (o *MediatorCollectionGetParams) WithPeerClusterUUID(peerClusterUUID *string) *MediatorCollectionGetParams {
	o.SetPeerClusterUUID(peerClusterUUID)
	return o
}

// SetPeerClusterUUID adds the peerClusterUuid to the mediator collection get params
func (o *MediatorCollectionGetParams) SetPeerClusterUUID(peerClusterUUID *string) {
	o.PeerClusterUUID = peerClusterUUID
}

// WithPeerMediatorConnectivity adds the peerMediatorConnectivity to the mediator collection get params
func (o *MediatorCollectionGetParams) WithPeerMediatorConnectivity(peerMediatorConnectivity *string) *MediatorCollectionGetParams {
	o.SetPeerMediatorConnectivity(peerMediatorConnectivity)
	return o
}

// SetPeerMediatorConnectivity adds the peerMediatorConnectivity to the mediator collection get params
func (o *MediatorCollectionGetParams) SetPeerMediatorConnectivity(peerMediatorConnectivity *string) {
	o.PeerMediatorConnectivity = peerMediatorConnectivity
}

// WithPort adds the port to the mediator collection get params
func (o *MediatorCollectionGetParams) WithPort(port *int64) *MediatorCollectionGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the mediator collection get params
func (o *MediatorCollectionGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithReachable adds the reachable to the mediator collection get params
func (o *MediatorCollectionGetParams) WithReachable(reachable *bool) *MediatorCollectionGetParams {
	o.SetReachable(reachable)
	return o
}

// SetReachable adds the reachable to the mediator collection get params
func (o *MediatorCollectionGetParams) SetReachable(reachable *bool) {
	o.Reachable = reachable
}

// WithReturnRecords adds the returnRecords to the mediator collection get params
func (o *MediatorCollectionGetParams) WithReturnRecords(returnRecords *bool) *MediatorCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the mediator collection get params
func (o *MediatorCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the mediator collection get params
func (o *MediatorCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *MediatorCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the mediator collection get params
func (o *MediatorCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStrictCertValidation adds the strictCertValidation to the mediator collection get params
func (o *MediatorCollectionGetParams) WithStrictCertValidation(strictCertValidation *bool) *MediatorCollectionGetParams {
	o.SetStrictCertValidation(strictCertValidation)
	return o
}

// SetStrictCertValidation adds the strictCertValidation to the mediator collection get params
func (o *MediatorCollectionGetParams) SetStrictCertValidation(strictCertValidation *bool) {
	o.StrictCertValidation = strictCertValidation
}

// WithType adds the typeVar to the mediator collection get params
func (o *MediatorCollectionGetParams) WithType(typeVar *string) *MediatorCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the mediator collection get params
func (o *MediatorCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUseHTTPProxyLocal adds the useHTTPProxyLocal to the mediator collection get params
func (o *MediatorCollectionGetParams) WithUseHTTPProxyLocal(useHTTPProxyLocal *bool) *MediatorCollectionGetParams {
	o.SetUseHTTPProxyLocal(useHTTPProxyLocal)
	return o
}

// SetUseHTTPProxyLocal adds the useHttpProxyLocal to the mediator collection get params
func (o *MediatorCollectionGetParams) SetUseHTTPProxyLocal(useHTTPProxyLocal *bool) {
	o.UseHTTPProxyLocal = useHTTPProxyLocal
}

// WithUUID adds the uuid to the mediator collection get params
func (o *MediatorCollectionGetParams) WithUUID(uuid *string) *MediatorCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the mediator collection get params
func (o *MediatorCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *MediatorCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IPAddress != nil {

		// query param ip_address
		var qrIPAddress string

		if o.IPAddress != nil {
			qrIPAddress = *o.IPAddress
		}
		qIPAddress := qrIPAddress
		if qIPAddress != "" {

			if err := r.SetQueryParam("ip_address", qIPAddress); err != nil {
				return err
			}
		}
	}

	if o.LocalMediatorConnectivity != nil {

		// query param local_mediator_connectivity
		var qrLocalMediatorConnectivity string

		if o.LocalMediatorConnectivity != nil {
			qrLocalMediatorConnectivity = *o.LocalMediatorConnectivity
		}
		qLocalMediatorConnectivity := qrLocalMediatorConnectivity
		if qLocalMediatorConnectivity != "" {

			if err := r.SetQueryParam("local_mediator_connectivity", qLocalMediatorConnectivity); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PeerClusterName != nil {

		// query param peer_cluster.name
		var qrPeerClusterName string

		if o.PeerClusterName != nil {
			qrPeerClusterName = *o.PeerClusterName
		}
		qPeerClusterName := qrPeerClusterName
		if qPeerClusterName != "" {

			if err := r.SetQueryParam("peer_cluster.name", qPeerClusterName); err != nil {
				return err
			}
		}
	}

	if o.PeerClusterUUID != nil {

		// query param peer_cluster.uuid
		var qrPeerClusterUUID string

		if o.PeerClusterUUID != nil {
			qrPeerClusterUUID = *o.PeerClusterUUID
		}
		qPeerClusterUUID := qrPeerClusterUUID
		if qPeerClusterUUID != "" {

			if err := r.SetQueryParam("peer_cluster.uuid", qPeerClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.PeerMediatorConnectivity != nil {

		// query param peer_mediator_connectivity
		var qrPeerMediatorConnectivity string

		if o.PeerMediatorConnectivity != nil {
			qrPeerMediatorConnectivity = *o.PeerMediatorConnectivity
		}
		qPeerMediatorConnectivity := qrPeerMediatorConnectivity
		if qPeerMediatorConnectivity != "" {

			if err := r.SetQueryParam("peer_mediator_connectivity", qPeerMediatorConnectivity); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.Reachable != nil {

		// query param reachable
		var qrReachable bool

		if o.Reachable != nil {
			qrReachable = *o.Reachable
		}
		qReachable := swag.FormatBool(qrReachable)
		if qReachable != "" {

			if err := r.SetQueryParam("reachable", qReachable); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.StrictCertValidation != nil {

		// query param strict_cert_validation
		var qrStrictCertValidation bool

		if o.StrictCertValidation != nil {
			qrStrictCertValidation = *o.StrictCertValidation
		}
		qStrictCertValidation := swag.FormatBool(qrStrictCertValidation)
		if qStrictCertValidation != "" {

			if err := r.SetQueryParam("strict_cert_validation", qStrictCertValidation); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UseHTTPProxyLocal != nil {

		// query param use_http_proxy_local
		var qrUseHTTPProxyLocal bool

		if o.UseHTTPProxyLocal != nil {
			qrUseHTTPProxyLocal = *o.UseHTTPProxyLocal
		}
		qUseHTTPProxyLocal := swag.FormatBool(qrUseHTTPProxyLocal)
		if qUseHTTPProxyLocal != "" {

			if err := r.SetQueryParam("use_http_proxy_local", qUseHTTPProxyLocal); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMediatorCollectionGet binds the parameter fields
func (o *MediatorCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamMediatorCollectionGet binds the parameter order_by
func (o *MediatorCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
