// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MediatorCreateReader is a Reader for the MediatorCreate structure.
type MediatorCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MediatorCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewMediatorCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewMediatorCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMediatorCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMediatorCreateCreated creates a MediatorCreateCreated with default headers values
func NewMediatorCreateCreated() *MediatorCreateCreated {
	return &MediatorCreateCreated{}
}

/*
MediatorCreateCreated describes a response with status code 201, with default header values.

Created
*/
type MediatorCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator create created response has a 2xx status code
func (o *MediatorCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator create created response has a 3xx status code
func (o *MediatorCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator create created response has a 4xx status code
func (o *MediatorCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator create created response has a 5xx status code
func (o *MediatorCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator create created response a status code equal to that given
func (o *MediatorCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the mediator create created response
func (o *MediatorCreateCreated) Code() int {
	return 201
}

func (o *MediatorCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediators][%d] mediatorCreateCreated %s", 201, payload)
}

func (o *MediatorCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediators][%d] mediatorCreateCreated %s", 201, payload)
}

func (o *MediatorCreateCreated) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorCreateAccepted creates a MediatorCreateAccepted with default headers values
func NewMediatorCreateAccepted() *MediatorCreateAccepted {
	return &MediatorCreateAccepted{}
}

/*
MediatorCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type MediatorCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator create accepted response has a 2xx status code
func (o *MediatorCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator create accepted response has a 3xx status code
func (o *MediatorCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator create accepted response has a 4xx status code
func (o *MediatorCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator create accepted response has a 5xx status code
func (o *MediatorCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator create accepted response a status code equal to that given
func (o *MediatorCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the mediator create accepted response
func (o *MediatorCreateAccepted) Code() int {
	return 202
}

func (o *MediatorCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediators][%d] mediatorCreateAccepted %s", 202, payload)
}

func (o *MediatorCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediators][%d] mediatorCreateAccepted %s", 202, payload)
}

func (o *MediatorCreateAccepted) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorCreateDefault creates a MediatorCreateDefault with default headers values
func NewMediatorCreateDefault(code int) *MediatorCreateDefault {
	return &MediatorCreateDefault{
		_statusCode: code,
	}
}

/*
	MediatorCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13369351    | Update to mediator failed. Reason: does not authorized for that command. Check that the peer cluster and mediator are reachable.|
| 2430758     | Mediator cannot be added. Reason: Some of the nodes in the cluster have incorrect MetroCluster IP configuration.|
| 2430734     | Unable to add Mediator. Reason : Authentication failed.|
| 2430774     | Failed to add Mediator. Reason : Node is not reachable or does not exist.|
| 2432871     | Failed to add Mediator. Reason : Some of the parameters in the request is invalid.|
*/
type MediatorCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this mediator create default response has a 2xx status code
func (o *MediatorCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this mediator create default response has a 3xx status code
func (o *MediatorCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this mediator create default response has a 4xx status code
func (o *MediatorCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this mediator create default response has a 5xx status code
func (o *MediatorCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this mediator create default response a status code equal to that given
func (o *MediatorCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the mediator create default response
func (o *MediatorCreateDefault) Code() int {
	return o._statusCode
}

func (o *MediatorCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediators][%d] mediator_create default %s", o._statusCode, payload)
}

func (o *MediatorCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediators][%d] mediator_create default %s", o._statusCode, payload)
}

func (o *MediatorCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MediatorCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
