// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MediatorDeleteCollectionReader is a Reader for the MediatorDeleteCollection structure.
type MediatorDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MediatorDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMediatorDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewMediatorDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMediatorDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMediatorDeleteCollectionOK creates a MediatorDeleteCollectionOK with default headers values
func NewMediatorDeleteCollectionOK() *MediatorDeleteCollectionOK {
	return &MediatorDeleteCollectionOK{}
}

/*
MediatorDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MediatorDeleteCollectionOK struct {
	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator delete collection o k response has a 2xx status code
func (o *MediatorDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator delete collection o k response has a 3xx status code
func (o *MediatorDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator delete collection o k response has a 4xx status code
func (o *MediatorDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator delete collection o k response has a 5xx status code
func (o *MediatorDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator delete collection o k response a status code equal to that given
func (o *MediatorDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the mediator delete collection o k response
func (o *MediatorDeleteCollectionOK) Code() int {
	return 200
}

func (o *MediatorDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/mediators][%d] mediatorDeleteCollectionOK %s", 200, payload)
}

func (o *MediatorDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/mediators][%d] mediatorDeleteCollectionOK %s", 200, payload)
}

func (o *MediatorDeleteCollectionOK) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorDeleteCollectionAccepted creates a MediatorDeleteCollectionAccepted with default headers values
func NewMediatorDeleteCollectionAccepted() *MediatorDeleteCollectionAccepted {
	return &MediatorDeleteCollectionAccepted{}
}

/*
MediatorDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type MediatorDeleteCollectionAccepted struct {
	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator delete collection accepted response has a 2xx status code
func (o *MediatorDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator delete collection accepted response has a 3xx status code
func (o *MediatorDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator delete collection accepted response has a 4xx status code
func (o *MediatorDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator delete collection accepted response has a 5xx status code
func (o *MediatorDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator delete collection accepted response a status code equal to that given
func (o *MediatorDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the mediator delete collection accepted response
func (o *MediatorDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *MediatorDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/mediators][%d] mediatorDeleteCollectionAccepted %s", 202, payload)
}

func (o *MediatorDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/mediators][%d] mediatorDeleteCollectionAccepted %s", 202, payload)
}

func (o *MediatorDeleteCollectionAccepted) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorDeleteCollectionDefault creates a MediatorDeleteCollectionDefault with default headers values
func NewMediatorDeleteCollectionDefault(code int) *MediatorDeleteCollectionDefault {
	return &MediatorDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	MediatorDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13369377    | Mediator field "mediator.id" does not exist.|
*/
type MediatorDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this mediator delete collection default response has a 2xx status code
func (o *MediatorDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this mediator delete collection default response has a 3xx status code
func (o *MediatorDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this mediator delete collection default response has a 4xx status code
func (o *MediatorDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this mediator delete collection default response has a 5xx status code
func (o *MediatorDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this mediator delete collection default response a status code equal to that given
func (o *MediatorDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the mediator delete collection default response
func (o *MediatorDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MediatorDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/mediators][%d] mediator_delete_collection default %s", o._statusCode, payload)
}

func (o *MediatorDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/mediators][%d] mediator_delete_collection default %s", o._statusCode, payload)
}

func (o *MediatorDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MediatorDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MediatorDeleteCollectionBody mediator delete collection body
swagger:model MediatorDeleteCollectionBody
*/
type MediatorDeleteCollectionBody struct {

	// mediator response inline records
	MediatorResponseInlineRecords []*models.MediatorResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this mediator delete collection body
func (o *MediatorDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMediatorResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorDeleteCollectionBody) validateMediatorResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MediatorResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MediatorResponseInlineRecords); i++ {
		if swag.IsZero(o.MediatorResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MediatorResponseInlineRecords[i] != nil {
			if err := o.MediatorResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this mediator delete collection body based on the context it is used
func (o *MediatorDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMediatorResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorDeleteCollectionBody) contextValidateMediatorResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MediatorResponseInlineRecords); i++ {

		if o.MediatorResponseInlineRecords[i] != nil {
			if err := o.MediatorResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *MediatorDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MediatorDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res MediatorDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MediatorResponseInlineRecordsInlineArrayItem Mediator information
swagger:model mediator_response_inline_records_inline_array_item
*/
type MediatorResponseInlineRecordsInlineArrayItem struct {

	// BlueXP account token. This field is only applicable to the ONTAP cloud mediator.
	BluexpAccountToken *string `json:"bluexp_account_token,omitempty"`

	// BlueXP organization ID. This field is only applicable to the ONTAP cloud mediator.
	BluexpOrgID *string `json:"bluexp_org_id,omitempty"`

	// CA certificate for ONTAP Mediator. This is optional if the certificate is already installed.
	CaCertificate *string `json:"ca_certificate,omitempty"`

	// dr group
	DrGroup *models.MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup `json:"dr_group,omitempty"`

	// The IP address of the mediator.
	// Example: 10.10.10.7
	IPAddress *string `json:"ip_address,omitempty"`

	// Indicates the mediator connectivity status of the local cluster. Possible values are connected, unreachable, unusable and down-high-latency. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Example: connected
	// Read Only: true
	LocalMediatorConnectivity *string `json:"local_mediator_connectivity,omitempty"`

	// The password used to connect to the REST server on the mediator.
	// Example: mypassword
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// peer cluster
	PeerCluster *models.MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster `json:"peer_cluster,omitempty"`

	// Indicates the mediator connectivity status of the peer cluster. Possible values are connected, unreachable, unknown and down-high-latency.
	// Example: connected
	// Read Only: true
	PeerMediatorConnectivity *string `json:"peer_mediator_connectivity,omitempty"`

	// The REST server's port number on the mediator.
	// Example: 31784
	Port *int64 `json:"port,omitempty"`

	// Indicates the connectivity status of the mediator.
	// Example: true
	// Read Only: true
	Reachable *bool `json:"reachable,omitempty"`

	// Client ID of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientID *string `json:"service_account_client_id,omitempty"`

	// Client secret token of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientSecret *string `json:"service_account_client_secret,omitempty"`

	// Indicates if strict validation of certificates is performed while making REST API calls to the mediator. This field is only applicable to the ONTAP Cloud Mediator.
	// Example: true
	StrictCertValidation *bool `json:"strict_cert_validation,omitempty"`

	// Mediator type. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Enum: ["cloud","on_prem"]
	Type *string `json:"type,omitempty"`

	// Indicates if the local cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyLocal *bool `json:"use_http_proxy_local,omitempty"`

	// Indicates if the remote cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyRemote *bool `json:"use_http_proxy_remote,omitempty"`

	// The username used to connect to the REST server on the mediator.
	// Example: myusername
	User *string `json:"user,omitempty"`

	// The unique identifier for the mediator service.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this mediator response inline records inline array item
func (o *MediatorResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDrGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeerCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) validateDrGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.DrGroup) { // not required
		return nil
	}

	if o.DrGroup != nil {
		if err := o.DrGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_group")
			}
			return err
		}
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(o.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", o.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) validatePeerCluster(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerCluster) { // not required
		return nil
	}

	if o.PeerCluster != nil {
		if err := o.PeerCluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster")
			}
			return err
		}
	}

	return nil
}

var mediatorResponseInlineRecordsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cloud","on_prem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mediatorResponseInlineRecordsInlineArrayItemTypeTypePropEnum = append(mediatorResponseInlineRecordsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mediator_response_inline_records_inline_array_item
	// MediatorResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// cloud
	// END DEBUGGING
	// MediatorResponseInlineRecordsInlineArrayItemTypeCloud captures enum value "cloud"
	MediatorResponseInlineRecordsInlineArrayItemTypeCloud string = "cloud"

	// BEGIN DEBUGGING
	// mediator_response_inline_records_inline_array_item
	// MediatorResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// on_prem
	// END DEBUGGING
	// MediatorResponseInlineRecordsInlineArrayItemTypeOnPrem captures enum value "on_prem"
	MediatorResponseInlineRecordsInlineArrayItemTypeOnPrem string = "on_prem"
)

// prop value enum
func (o *MediatorResponseInlineRecordsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mediatorResponseInlineRecordsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this mediator response inline records inline array item based on the context it is used
func (o *MediatorResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) contextValidateDrGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.DrGroup != nil {
		if err := o.DrGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_group")
			}
			return err
		}
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) contextValidateLocalMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local_mediator_connectivity", "body", o.LocalMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) contextValidatePeerCluster(ctx context.Context, formats strfmt.Registry) error {

	if o.PeerCluster != nil {
		if err := o.PeerCluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster")
			}
			return err
		}
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) contextValidatePeerMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "peer_mediator_connectivity", "body", o.PeerMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) contextValidateReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reachable", "body", o.Reachable); err != nil {
		return err
	}

	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MediatorResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup DR group reference.
swagger:model mediator_response_inline_records_inline_array_item_inline_dr_group
*/
type MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup struct {

	// DR Group ID
	// Read Only: true
	ID *int64 `json:"id,omitempty"`
}

// Validate validates this mediator response inline records inline array item inline dr group
func (o *MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this mediator response inline records inline array item inline dr group based on the context it is used
func (o *MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dr_group"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup) UnmarshalBinary(b []byte) error {
	var res MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster The peer cluster that the mediator service is used for.
swagger:model mediator_response_inline_records_inline_array_item_inline_peer_cluster
*/
type MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster struct {

	// links
	Links *models.MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: ebe27c49-1adf-4496-8335-ab862aebebf2
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this mediator response inline records inline array item inline peer cluster
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mediator response inline records inline array item inline peer cluster based on the context it is used
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster) UnmarshalBinary(b []byte) error {
	var res MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks mediator response inline records inline array item inline peer cluster inline links
swagger:model mediator_response_inline_records_inline_array_item_inline_peer_cluster_inline__links
*/
type MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this mediator response inline records inline array item inline peer cluster inline links
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mediator response inline records inline array item inline peer cluster inline links based on the context it is used
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MediatorResponseInlineRecordsInlineArrayItemInlinePeerClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
