// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMediatorGetParams creates a new MediatorGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMediatorGetParams() *MediatorGetParams {
	return &MediatorGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMediatorGetParamsWithTimeout creates a new MediatorGetParams object
// with the ability to set a timeout on a request.
func NewMediatorGetParamsWithTimeout(timeout time.Duration) *MediatorGetParams {
	return &MediatorGetParams{
		timeout: timeout,
	}
}

// NewMediatorGetParamsWithContext creates a new MediatorGetParams object
// with the ability to set a context for a request.
func NewMediatorGetParamsWithContext(ctx context.Context) *MediatorGetParams {
	return &MediatorGetParams{
		Context: ctx,
	}
}

// NewMediatorGetParamsWithHTTPClient creates a new MediatorGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewMediatorGetParamsWithHTTPClient(client *http.Client) *MediatorGetParams {
	return &MediatorGetParams{
		HTTPClient: client,
	}
}

/*
MediatorGetParams contains all the parameters to send to the API endpoint

	for the mediator get operation.

	Typically these are written to a http.Request.
*/
type MediatorGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	// UUID.
	//
	// Format: uuid
	UUID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the mediator get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorGetParams) WithDefaults() *MediatorGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the mediator get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the mediator get params
func (o *MediatorGetParams) WithTimeout(timeout time.Duration) *MediatorGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the mediator get params
func (o *MediatorGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the mediator get params
func (o *MediatorGetParams) WithContext(ctx context.Context) *MediatorGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the mediator get params
func (o *MediatorGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the mediator get params
func (o *MediatorGetParams) WithHTTPClient(client *http.Client) *MediatorGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the mediator get params
func (o *MediatorGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the mediator get params
func (o *MediatorGetParams) WithFields(fields []string) *MediatorGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the mediator get params
func (o *MediatorGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the mediator get params
func (o *MediatorGetParams) WithUUID(uuid strfmt.UUID) *MediatorGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the mediator get params
func (o *MediatorGetParams) SetUUID(uuid strfmt.UUID) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *MediatorGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMediatorGet binds the parameter fields
func (o *MediatorGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
