// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MediatorGetReader is a Reader for the MediatorGet structure.
type MediatorGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MediatorGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMediatorGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMediatorGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMediatorGetOK creates a MediatorGetOK with default headers values
func NewMediatorGetOK() *MediatorGetOK {
	return &MediatorGetOK{}
}

/*
MediatorGetOK describes a response with status code 200, with default header values.

OK
*/
type MediatorGetOK struct {
	Payload *models.Mediator
}

// IsSuccess returns true when this mediator get o k response has a 2xx status code
func (o *MediatorGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator get o k response has a 3xx status code
func (o *MediatorGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator get o k response has a 4xx status code
func (o *MediatorGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator get o k response has a 5xx status code
func (o *MediatorGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator get o k response a status code equal to that given
func (o *MediatorGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the mediator get o k response
func (o *MediatorGetOK) Code() int {
	return 200
}

func (o *MediatorGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/mediators/{uuid}][%d] mediatorGetOK %s", 200, payload)
}

func (o *MediatorGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/mediators/{uuid}][%d] mediatorGetOK %s", 200, payload)
}

func (o *MediatorGetOK) GetPayload() *models.Mediator {
	return o.Payload
}

func (o *MediatorGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Mediator)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorGetDefault creates a MediatorGetDefault with default headers values
func NewMediatorGetDefault(code int) *MediatorGetDefault {
	return &MediatorGetDefault{
		_statusCode: code,
	}
}

/*
MediatorGetDefault describes a response with status code -1, with default header values.

Error
*/
type MediatorGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this mediator get default response has a 2xx status code
func (o *MediatorGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this mediator get default response has a 3xx status code
func (o *MediatorGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this mediator get default response has a 4xx status code
func (o *MediatorGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this mediator get default response has a 5xx status code
func (o *MediatorGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this mediator get default response a status code equal to that given
func (o *MediatorGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the mediator get default response
func (o *MediatorGetDefault) Code() int {
	return o._statusCode
}

func (o *MediatorGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/mediators/{uuid}][%d] mediator_get default %s", o._statusCode, payload)
}

func (o *MediatorGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/mediators/{uuid}][%d] mediator_get default %s", o._statusCode, payload)
}

func (o *MediatorGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MediatorGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
