// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMediatorModifyCollectionParams creates a new MediatorModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMediatorModifyCollectionParams() *MediatorModifyCollectionParams {
	return &MediatorModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMediatorModifyCollectionParamsWithTimeout creates a new MediatorModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewMediatorModifyCollectionParamsWithTimeout(timeout time.Duration) *MediatorModifyCollectionParams {
	return &MediatorModifyCollectionParams{
		timeout: timeout,
	}
}

// NewMediatorModifyCollectionParamsWithContext creates a new MediatorModifyCollectionParams object
// with the ability to set a context for a request.
func NewMediatorModifyCollectionParamsWithContext(ctx context.Context) *MediatorModifyCollectionParams {
	return &MediatorModifyCollectionParams{
		Context: ctx,
	}
}

// NewMediatorModifyCollectionParamsWithHTTPClient creates a new MediatorModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewMediatorModifyCollectionParamsWithHTTPClient(client *http.Client) *MediatorModifyCollectionParams {
	return &MediatorModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
MediatorModifyCollectionParams contains all the parameters to send to the API endpoint

	for the mediator modify collection operation.

	Typically these are written to a http.Request.
*/
type MediatorModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info MediatorModifyCollectionBody

	/* IPAddress.

	   Filter by ip_address
	*/
	IPAddress *string

	/* LocalMediatorConnectivity.

	   Filter by local_mediator_connectivity
	*/
	LocalMediatorConnectivity *string

	/* PeerClusterName.

	   Filter by peer_cluster.name
	*/
	PeerClusterName *string

	/* PeerClusterUUID.

	   Filter by peer_cluster.uuid
	*/
	PeerClusterUUID *string

	/* PeerMediatorConnectivity.

	   Filter by peer_mediator_connectivity
	*/
	PeerMediatorConnectivity *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* Reachable.

	   Filter by reachable
	*/
	Reachable *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StrictCertValidation.

	   Filter by strict_cert_validation
	*/
	StrictCertValidation *bool

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UseHTTPProxyLocal.

	   Filter by use_http_proxy_local
	*/
	UseHTTPProxyLocal *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the mediator modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorModifyCollectionParams) WithDefaults() *MediatorModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the mediator modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := MediatorModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithTimeout(timeout time.Duration) *MediatorModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithContext(ctx context.Context) *MediatorModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithHTTPClient(client *http.Client) *MediatorModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *MediatorModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithInfo(info MediatorModifyCollectionBody) *MediatorModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetInfo(info MediatorModifyCollectionBody) {
	o.Info = info
}

// WithIPAddress adds the iPAddress to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithIPAddress(iPAddress *string) *MediatorModifyCollectionParams {
	o.SetIPAddress(iPAddress)
	return o
}

// SetIPAddress adds the ipAddress to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetIPAddress(iPAddress *string) {
	o.IPAddress = iPAddress
}

// WithLocalMediatorConnectivity adds the localMediatorConnectivity to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithLocalMediatorConnectivity(localMediatorConnectivity *string) *MediatorModifyCollectionParams {
	o.SetLocalMediatorConnectivity(localMediatorConnectivity)
	return o
}

// SetLocalMediatorConnectivity adds the localMediatorConnectivity to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetLocalMediatorConnectivity(localMediatorConnectivity *string) {
	o.LocalMediatorConnectivity = localMediatorConnectivity
}

// WithPeerClusterName adds the peerClusterName to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithPeerClusterName(peerClusterName *string) *MediatorModifyCollectionParams {
	o.SetPeerClusterName(peerClusterName)
	return o
}

// SetPeerClusterName adds the peerClusterName to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetPeerClusterName(peerClusterName *string) {
	o.PeerClusterName = peerClusterName
}

// WithPeerClusterUUID adds the peerClusterUUID to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithPeerClusterUUID(peerClusterUUID *string) *MediatorModifyCollectionParams {
	o.SetPeerClusterUUID(peerClusterUUID)
	return o
}

// SetPeerClusterUUID adds the peerClusterUuid to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetPeerClusterUUID(peerClusterUUID *string) {
	o.PeerClusterUUID = peerClusterUUID
}

// WithPeerMediatorConnectivity adds the peerMediatorConnectivity to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithPeerMediatorConnectivity(peerMediatorConnectivity *string) *MediatorModifyCollectionParams {
	o.SetPeerMediatorConnectivity(peerMediatorConnectivity)
	return o
}

// SetPeerMediatorConnectivity adds the peerMediatorConnectivity to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetPeerMediatorConnectivity(peerMediatorConnectivity *string) {
	o.PeerMediatorConnectivity = peerMediatorConnectivity
}

// WithPort adds the port to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithPort(port *int64) *MediatorModifyCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithReachable adds the reachable to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithReachable(reachable *bool) *MediatorModifyCollectionParams {
	o.SetReachable(reachable)
	return o
}

// SetReachable adds the reachable to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetReachable(reachable *bool) {
	o.Reachable = reachable
}

// WithReturnRecords adds the returnRecords to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithReturnRecords(returnRecords *bool) *MediatorModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *MediatorModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithSerialRecords(serialRecords *bool) *MediatorModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStrictCertValidation adds the strictCertValidation to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithStrictCertValidation(strictCertValidation *bool) *MediatorModifyCollectionParams {
	o.SetStrictCertValidation(strictCertValidation)
	return o
}

// SetStrictCertValidation adds the strictCertValidation to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetStrictCertValidation(strictCertValidation *bool) {
	o.StrictCertValidation = strictCertValidation
}

// WithType adds the typeVar to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithType(typeVar *string) *MediatorModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUseHTTPProxyLocal adds the useHTTPProxyLocal to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithUseHTTPProxyLocal(useHTTPProxyLocal *bool) *MediatorModifyCollectionParams {
	o.SetUseHTTPProxyLocal(useHTTPProxyLocal)
	return o
}

// SetUseHTTPProxyLocal adds the useHttpProxyLocal to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetUseHTTPProxyLocal(useHTTPProxyLocal *bool) {
	o.UseHTTPProxyLocal = useHTTPProxyLocal
}

// WithUUID adds the uuid to the mediator modify collection params
func (o *MediatorModifyCollectionParams) WithUUID(uuid *string) *MediatorModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the mediator modify collection params
func (o *MediatorModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *MediatorModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IPAddress != nil {

		// query param ip_address
		var qrIPAddress string

		if o.IPAddress != nil {
			qrIPAddress = *o.IPAddress
		}
		qIPAddress := qrIPAddress
		if qIPAddress != "" {

			if err := r.SetQueryParam("ip_address", qIPAddress); err != nil {
				return err
			}
		}
	}

	if o.LocalMediatorConnectivity != nil {

		// query param local_mediator_connectivity
		var qrLocalMediatorConnectivity string

		if o.LocalMediatorConnectivity != nil {
			qrLocalMediatorConnectivity = *o.LocalMediatorConnectivity
		}
		qLocalMediatorConnectivity := qrLocalMediatorConnectivity
		if qLocalMediatorConnectivity != "" {

			if err := r.SetQueryParam("local_mediator_connectivity", qLocalMediatorConnectivity); err != nil {
				return err
			}
		}
	}

	if o.PeerClusterName != nil {

		// query param peer_cluster.name
		var qrPeerClusterName string

		if o.PeerClusterName != nil {
			qrPeerClusterName = *o.PeerClusterName
		}
		qPeerClusterName := qrPeerClusterName
		if qPeerClusterName != "" {

			if err := r.SetQueryParam("peer_cluster.name", qPeerClusterName); err != nil {
				return err
			}
		}
	}

	if o.PeerClusterUUID != nil {

		// query param peer_cluster.uuid
		var qrPeerClusterUUID string

		if o.PeerClusterUUID != nil {
			qrPeerClusterUUID = *o.PeerClusterUUID
		}
		qPeerClusterUUID := qrPeerClusterUUID
		if qPeerClusterUUID != "" {

			if err := r.SetQueryParam("peer_cluster.uuid", qPeerClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.PeerMediatorConnectivity != nil {

		// query param peer_mediator_connectivity
		var qrPeerMediatorConnectivity string

		if o.PeerMediatorConnectivity != nil {
			qrPeerMediatorConnectivity = *o.PeerMediatorConnectivity
		}
		qPeerMediatorConnectivity := qrPeerMediatorConnectivity
		if qPeerMediatorConnectivity != "" {

			if err := r.SetQueryParam("peer_mediator_connectivity", qPeerMediatorConnectivity); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.Reachable != nil {

		// query param reachable
		var qrReachable bool

		if o.Reachable != nil {
			qrReachable = *o.Reachable
		}
		qReachable := swag.FormatBool(qrReachable)
		if qReachable != "" {

			if err := r.SetQueryParam("reachable", qReachable); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StrictCertValidation != nil {

		// query param strict_cert_validation
		var qrStrictCertValidation bool

		if o.StrictCertValidation != nil {
			qrStrictCertValidation = *o.StrictCertValidation
		}
		qStrictCertValidation := swag.FormatBool(qrStrictCertValidation)
		if qStrictCertValidation != "" {

			if err := r.SetQueryParam("strict_cert_validation", qStrictCertValidation); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UseHTTPProxyLocal != nil {

		// query param use_http_proxy_local
		var qrUseHTTPProxyLocal bool

		if o.UseHTTPProxyLocal != nil {
			qrUseHTTPProxyLocal = *o.UseHTTPProxyLocal
		}
		qUseHTTPProxyLocal := swag.FormatBool(qrUseHTTPProxyLocal)
		if qUseHTTPProxyLocal != "" {

			if err := r.SetQueryParam("use_http_proxy_local", qUseHTTPProxyLocal); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
