// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MediatorModifyCollectionReader is a Reader for the MediatorModifyCollection structure.
type MediatorModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MediatorModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMediatorModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewMediatorModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMediatorModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMediatorModifyCollectionOK creates a MediatorModifyCollectionOK with default headers values
func NewMediatorModifyCollectionOK() *MediatorModifyCollectionOK {
	return &MediatorModifyCollectionOK{}
}

/*
MediatorModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MediatorModifyCollectionOK struct {
	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator modify collection o k response has a 2xx status code
func (o *MediatorModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator modify collection o k response has a 3xx status code
func (o *MediatorModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator modify collection o k response has a 4xx status code
func (o *MediatorModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator modify collection o k response has a 5xx status code
func (o *MediatorModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator modify collection o k response a status code equal to that given
func (o *MediatorModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the mediator modify collection o k response
func (o *MediatorModifyCollectionOK) Code() int {
	return 200
}

func (o *MediatorModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators][%d] mediatorModifyCollectionOK %s", 200, payload)
}

func (o *MediatorModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators][%d] mediatorModifyCollectionOK %s", 200, payload)
}

func (o *MediatorModifyCollectionOK) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorModifyCollectionAccepted creates a MediatorModifyCollectionAccepted with default headers values
func NewMediatorModifyCollectionAccepted() *MediatorModifyCollectionAccepted {
	return &MediatorModifyCollectionAccepted{}
}

/*
MediatorModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type MediatorModifyCollectionAccepted struct {
	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator modify collection accepted response has a 2xx status code
func (o *MediatorModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator modify collection accepted response has a 3xx status code
func (o *MediatorModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator modify collection accepted response has a 4xx status code
func (o *MediatorModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator modify collection accepted response has a 5xx status code
func (o *MediatorModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator modify collection accepted response a status code equal to that given
func (o *MediatorModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the mediator modify collection accepted response
func (o *MediatorModifyCollectionAccepted) Code() int {
	return 202
}

func (o *MediatorModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators][%d] mediatorModifyCollectionAccepted %s", 202, payload)
}

func (o *MediatorModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators][%d] mediatorModifyCollectionAccepted %s", 202, payload)
}

func (o *MediatorModifyCollectionAccepted) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorModifyCollectionDefault creates a MediatorModifyCollectionDefault with default headers values
func NewMediatorModifyCollectionDefault(code int) *MediatorModifyCollectionDefault {
	return &MediatorModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	MediatorModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13369377    | Mediator field "mediator.id" does not exist.|
| 13369412    | Modification of the mediator configuration succeeded on the peer cluster but failed on the local cluster. Reason : {Reason of failure}. Wait a few minutes, then try the operation again.|
| 13369421    | Failed to modify mediator configuration on the cluster. Reason : {Reason of failure}. Wait a few minutes, then try the operation again.|
*/
type MediatorModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this mediator modify collection default response has a 2xx status code
func (o *MediatorModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this mediator modify collection default response has a 3xx status code
func (o *MediatorModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this mediator modify collection default response has a 4xx status code
func (o *MediatorModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this mediator modify collection default response has a 5xx status code
func (o *MediatorModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this mediator modify collection default response a status code equal to that given
func (o *MediatorModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the mediator modify collection default response
func (o *MediatorModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MediatorModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators][%d] mediator_modify_collection default %s", o._statusCode, payload)
}

func (o *MediatorModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators][%d] mediator_modify_collection default %s", o._statusCode, payload)
}

func (o *MediatorModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MediatorModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MediatorModifyCollectionBody mediator modify collection body
swagger:model MediatorModifyCollectionBody
*/
type MediatorModifyCollectionBody struct {

	// BlueXP account token. This field is only applicable to the ONTAP cloud mediator.
	BluexpAccountToken *string `json:"bluexp_account_token,omitempty"`

	// BlueXP organization ID. This field is only applicable to the ONTAP cloud mediator.
	BluexpOrgID *string `json:"bluexp_org_id,omitempty"`

	// CA certificate for ONTAP Mediator. This is optional if the certificate is already installed.
	CaCertificate *string `json:"ca_certificate,omitempty"`

	// dr group
	DrGroup *models.MediatorResponseInlineRecordsInlineArrayItemInlineDrGroup `json:"dr_group,omitempty"`

	// The IP address of the mediator.
	// Example: 10.10.10.7
	IPAddress *string `json:"ip_address,omitempty"`

	// Indicates the mediator connectivity status of the local cluster. Possible values are connected, unreachable, unusable and down-high-latency. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Example: connected
	// Read Only: true
	LocalMediatorConnectivity *string `json:"local_mediator_connectivity,omitempty"`

	// mediator response inline records
	MediatorResponseInlineRecords []*models.MediatorResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// The password used to connect to the REST server on the mediator.
	// Example: mypassword
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// peer cluster
	PeerCluster *models.MediatorResponseInlineRecordsInlineArrayItemInlinePeerCluster `json:"peer_cluster,omitempty"`

	// Indicates the mediator connectivity status of the peer cluster. Possible values are connected, unreachable, unknown and down-high-latency.
	// Example: connected
	// Read Only: true
	PeerMediatorConnectivity *string `json:"peer_mediator_connectivity,omitempty"`

	// The REST server's port number on the mediator.
	// Example: 31784
	Port *int64 `json:"port,omitempty"`

	// Indicates the connectivity status of the mediator.
	// Example: true
	// Read Only: true
	Reachable *bool `json:"reachable,omitempty"`

	// Client ID of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientID *string `json:"service_account_client_id,omitempty"`

	// Client secret token of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientSecret *string `json:"service_account_client_secret,omitempty"`

	// Indicates if strict validation of certificates is performed while making REST API calls to the mediator. This field is only applicable to the ONTAP Cloud Mediator.
	// Example: true
	StrictCertValidation *bool `json:"strict_cert_validation,omitempty"`

	// Mediator type. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Enum: ["cloud","on_prem"]
	Type *string `json:"type,omitempty"`

	// Indicates if the local cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyLocal *bool `json:"use_http_proxy_local,omitempty"`

	// Indicates if the remote cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyRemote *bool `json:"use_http_proxy_remote,omitempty"`

	// The username used to connect to the REST server on the mediator.
	// Example: myusername
	User *string `json:"user,omitempty"`

	// The unique identifier for the mediator service.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this mediator modify collection body
func (o *MediatorModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDrGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMediatorResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeerCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorModifyCollectionBody) validateDrGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.DrGroup) { // not required
		return nil
	}

	if o.DrGroup != nil {
		if err := o.DrGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dr_group")
			}
			return err
		}
	}

	return nil
}

func (o *MediatorModifyCollectionBody) validateMediatorResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MediatorResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MediatorResponseInlineRecords); i++ {
		if swag.IsZero(o.MediatorResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MediatorResponseInlineRecords[i] != nil {
			if err := o.MediatorResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MediatorModifyCollectionBody) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(o.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"password", "body", "password", o.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MediatorModifyCollectionBody) validatePeerCluster(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerCluster) { // not required
		return nil
	}

	if o.PeerCluster != nil {
		if err := o.PeerCluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "peer_cluster")
			}
			return err
		}
	}

	return nil
}

var mediatorModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cloud","on_prem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mediatorModifyCollectionBodyTypeTypePropEnum = append(mediatorModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// MediatorModifyCollectionBody
	// MediatorModifyCollectionBody
	// type
	// Type
	// cloud
	// END DEBUGGING
	// MediatorModifyCollectionBodyTypeCloud captures enum value "cloud"
	MediatorModifyCollectionBodyTypeCloud string = "cloud"

	// BEGIN DEBUGGING
	// MediatorModifyCollectionBody
	// MediatorModifyCollectionBody
	// type
	// Type
	// on_prem
	// END DEBUGGING
	// MediatorModifyCollectionBodyTypeOnPrem captures enum value "on_prem"
	MediatorModifyCollectionBodyTypeOnPrem string = "on_prem"
)

// prop value enum
func (o *MediatorModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mediatorModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MediatorModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this mediator modify collection body based on the context it is used
func (o *MediatorModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMediatorResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MediatorModifyCollectionBody) contextValidateDrGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.DrGroup != nil {
		if err := o.DrGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dr_group")
			}
			return err
		}
	}

	return nil
}

func (o *MediatorModifyCollectionBody) contextValidateLocalMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"local_mediator_connectivity", "body", o.LocalMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (o *MediatorModifyCollectionBody) contextValidateMediatorResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MediatorResponseInlineRecords); i++ {

		if o.MediatorResponseInlineRecords[i] != nil {
			if err := o.MediatorResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MediatorModifyCollectionBody) contextValidatePeerCluster(ctx context.Context, formats strfmt.Registry) error {

	if o.PeerCluster != nil {
		if err := o.PeerCluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "peer_cluster")
			}
			return err
		}
	}

	return nil
}

func (o *MediatorModifyCollectionBody) contextValidatePeerMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"peer_mediator_connectivity", "body", o.PeerMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (o *MediatorModifyCollectionBody) contextValidateReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"reachable", "body", o.Reachable); err != nil {
		return err
	}

	return nil
}

func (o *MediatorModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MediatorModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MediatorModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res MediatorModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
