// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MediatorModifyReader is a Reader for the MediatorModify structure.
type MediatorModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MediatorModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMediatorModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewMediatorModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMediatorModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMediatorModifyOK creates a MediatorModifyOK with default headers values
func NewMediatorModifyOK() *MediatorModifyOK {
	return &MediatorModifyOK{}
}

/*
MediatorModifyOK describes a response with status code 200, with default header values.

OK
*/
type MediatorModifyOK struct {
	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator modify o k response has a 2xx status code
func (o *MediatorModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator modify o k response has a 3xx status code
func (o *MediatorModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator modify o k response has a 4xx status code
func (o *MediatorModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator modify o k response has a 5xx status code
func (o *MediatorModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator modify o k response a status code equal to that given
func (o *MediatorModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the mediator modify o k response
func (o *MediatorModifyOK) Code() int {
	return 200
}

func (o *MediatorModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators/{uuid}][%d] mediatorModifyOK %s", 200, payload)
}

func (o *MediatorModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators/{uuid}][%d] mediatorModifyOK %s", 200, payload)
}

func (o *MediatorModifyOK) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorModifyAccepted creates a MediatorModifyAccepted with default headers values
func NewMediatorModifyAccepted() *MediatorModifyAccepted {
	return &MediatorModifyAccepted{}
}

/*
MediatorModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type MediatorModifyAccepted struct {
	Payload *models.MediatorJobLinkResponse
}

// IsSuccess returns true when this mediator modify accepted response has a 2xx status code
func (o *MediatorModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator modify accepted response has a 3xx status code
func (o *MediatorModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator modify accepted response has a 4xx status code
func (o *MediatorModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator modify accepted response has a 5xx status code
func (o *MediatorModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator modify accepted response a status code equal to that given
func (o *MediatorModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the mediator modify accepted response
func (o *MediatorModifyAccepted) Code() int {
	return 202
}

func (o *MediatorModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators/{uuid}][%d] mediatorModifyAccepted %s", 202, payload)
}

func (o *MediatorModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators/{uuid}][%d] mediatorModifyAccepted %s", 202, payload)
}

func (o *MediatorModifyAccepted) GetPayload() *models.MediatorJobLinkResponse {
	return o.Payload
}

func (o *MediatorModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorModifyDefault creates a MediatorModifyDefault with default headers values
func NewMediatorModifyDefault(code int) *MediatorModifyDefault {
	return &MediatorModifyDefault{
		_statusCode: code,
	}
}

/*
	MediatorModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13369377    | Mediator field "mediator.id" does not exist.|
| 13369412    | Modification of the mediator configuration succeeded on the peer cluster but failed on the local cluster. Reason : {Reason of failure}. Wait a few minutes, then try the operation again.|
| 13369421    | Failed to modify mediator configuration on the cluster. Reason : {Reason of failure}. Wait a few minutes, then try the operation again.|
*/
type MediatorModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this mediator modify default response has a 2xx status code
func (o *MediatorModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this mediator modify default response has a 3xx status code
func (o *MediatorModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this mediator modify default response has a 4xx status code
func (o *MediatorModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this mediator modify default response has a 5xx status code
func (o *MediatorModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this mediator modify default response a status code equal to that given
func (o *MediatorModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the mediator modify default response
func (o *MediatorModifyDefault) Code() int {
	return o._statusCode
}

func (o *MediatorModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators/{uuid}][%d] mediator_modify default %s", o._statusCode, payload)
}

func (o *MediatorModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/mediators/{uuid}][%d] mediator_modify default %s", o._statusCode, payload)
}

func (o *MediatorModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MediatorModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
