// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewMediatorPingParams creates a new MediatorPingParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMediatorPingParams() *MediatorPingParams {
	return &MediatorPingParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMediatorPingParamsWithTimeout creates a new MediatorPingParams object
// with the ability to set a timeout on a request.
func NewMediatorPingParamsWithTimeout(timeout time.Duration) *MediatorPingParams {
	return &MediatorPingParams{
		timeout: timeout,
	}
}

// NewMediatorPingParamsWithContext creates a new MediatorPingParams object
// with the ability to set a context for a request.
func NewMediatorPingParamsWithContext(ctx context.Context) *MediatorPingParams {
	return &MediatorPingParams{
		Context: ctx,
	}
}

// NewMediatorPingParamsWithHTTPClient creates a new MediatorPingParams object
// with the ability to set a custom HTTPClient for a request.
func NewMediatorPingParamsWithHTTPClient(client *http.Client) *MediatorPingParams {
	return &MediatorPingParams{
		HTTPClient: client,
	}
}

/*
MediatorPingParams contains all the parameters to send to the API endpoint

	for the mediator ping operation.

	Typically these are written to a http.Request.
*/
type MediatorPingParams struct {

	/* Info.

	   Information for the ping operation.
	*/
	Info *models.MediatorPing

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the mediator ping params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorPingParams) WithDefaults() *MediatorPingParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the mediator ping params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MediatorPingParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := MediatorPingParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the mediator ping params
func (o *MediatorPingParams) WithTimeout(timeout time.Duration) *MediatorPingParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the mediator ping params
func (o *MediatorPingParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the mediator ping params
func (o *MediatorPingParams) WithContext(ctx context.Context) *MediatorPingParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the mediator ping params
func (o *MediatorPingParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the mediator ping params
func (o *MediatorPingParams) WithHTTPClient(client *http.Client) *MediatorPingParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the mediator ping params
func (o *MediatorPingParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the mediator ping params
func (o *MediatorPingParams) WithInfo(info *models.MediatorPing) *MediatorPingParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the mediator ping params
func (o *MediatorPingParams) SetInfo(info *models.MediatorPing) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the mediator ping params
func (o *MediatorPingParams) WithReturnRecords(returnRecords *bool) *MediatorPingParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the mediator ping params
func (o *MediatorPingParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *MediatorPingParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
