// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MediatorPingReader is a Reader for the MediatorPing structure.
type MediatorPingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MediatorPingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMediatorPingOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMediatorPingDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMediatorPingOK creates a MediatorPingOK with default headers values
func NewMediatorPingOK() *MediatorPingOK {
	return &MediatorPingOK{}
}

/*
MediatorPingOK describes a response with status code 200, with default header values.

OK
*/
type MediatorPingOK struct {
	Payload *models.MediatorPing
}

// IsSuccess returns true when this mediator ping o k response has a 2xx status code
func (o *MediatorPingOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this mediator ping o k response has a 3xx status code
func (o *MediatorPingOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this mediator ping o k response has a 4xx status code
func (o *MediatorPingOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this mediator ping o k response has a 5xx status code
func (o *MediatorPingOK) IsServerError() bool {
	return false
}

// IsCode returns true when this mediator ping o k response a status code equal to that given
func (o *MediatorPingOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the mediator ping o k response
func (o *MediatorPingOK) Code() int {
	return 200
}

func (o *MediatorPingOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediator-ping][%d] mediatorPingOK %s", 200, payload)
}

func (o *MediatorPingOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediator-ping][%d] mediatorPingOK %s", 200, payload)
}

func (o *MediatorPingOK) GetPayload() *models.MediatorPing {
	return o.Payload
}

func (o *MediatorPingOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorPing)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMediatorPingDefault creates a MediatorPingDefault with default headers values
func NewMediatorPingDefault(code int) *MediatorPingDefault {
	return &MediatorPingDefault{
		_statusCode: code,
	}
}

/*
	MediatorPingDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 13369414    | Failed to talk to the BlueXP cloud service. Check the need for an HTTP proxy and network settings like firewall.|
| 13369417    | Failed to check if an HTTP proxy is configured on the cluster.|
*/
type MediatorPingDefault struct {
	_statusCode int

	Payload *models.MediatorPingError
}

// IsSuccess returns true when this mediator ping default response has a 2xx status code
func (o *MediatorPingDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this mediator ping default response has a 3xx status code
func (o *MediatorPingDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this mediator ping default response has a 4xx status code
func (o *MediatorPingDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this mediator ping default response has a 5xx status code
func (o *MediatorPingDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this mediator ping default response a status code equal to that given
func (o *MediatorPingDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the mediator ping default response
func (o *MediatorPingDefault) Code() int {
	return o._statusCode
}

func (o *MediatorPingDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediator-ping][%d] _mediator_ping_ default %s", o._statusCode, payload)
}

func (o *MediatorPingDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cluster/mediator-ping][%d] _mediator_ping_ default %s", o._statusCode, payload)
}

func (o *MediatorPingDefault) GetPayload() *models.MediatorPingError {
	return o.Payload
}

func (o *MediatorPingDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MediatorPingError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
