// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MetroclusterDrGroupDeleteCollectionReader is a Reader for the MetroclusterDrGroupDeleteCollection structure.
type MetroclusterDrGroupDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MetroclusterDrGroupDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMetroclusterDrGroupDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewMetroclusterDrGroupDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMetroclusterDrGroupDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMetroclusterDrGroupDeleteCollectionOK creates a MetroclusterDrGroupDeleteCollectionOK with default headers values
func NewMetroclusterDrGroupDeleteCollectionOK() *MetroclusterDrGroupDeleteCollectionOK {
	return &MetroclusterDrGroupDeleteCollectionOK{}
}

/*
MetroclusterDrGroupDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MetroclusterDrGroupDeleteCollectionOK struct {
	Payload *models.MetroclusterDrGroupJobLinkResponse
}

// IsSuccess returns true when this metrocluster dr group delete collection o k response has a 2xx status code
func (o *MetroclusterDrGroupDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster dr group delete collection o k response has a 3xx status code
func (o *MetroclusterDrGroupDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster dr group delete collection o k response has a 4xx status code
func (o *MetroclusterDrGroupDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster dr group delete collection o k response has a 5xx status code
func (o *MetroclusterDrGroupDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster dr group delete collection o k response a status code equal to that given
func (o *MetroclusterDrGroupDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the metrocluster dr group delete collection o k response
func (o *MetroclusterDrGroupDeleteCollectionOK) Code() int {
	return 200
}

func (o *MetroclusterDrGroupDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/metrocluster/dr-groups][%d] metroclusterDrGroupDeleteCollectionOK %s", 200, payload)
}

func (o *MetroclusterDrGroupDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/metrocluster/dr-groups][%d] metroclusterDrGroupDeleteCollectionOK %s", 200, payload)
}

func (o *MetroclusterDrGroupDeleteCollectionOK) GetPayload() *models.MetroclusterDrGroupJobLinkResponse {
	return o.Payload
}

func (o *MetroclusterDrGroupDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterDrGroupJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterDrGroupDeleteCollectionAccepted creates a MetroclusterDrGroupDeleteCollectionAccepted with default headers values
func NewMetroclusterDrGroupDeleteCollectionAccepted() *MetroclusterDrGroupDeleteCollectionAccepted {
	return &MetroclusterDrGroupDeleteCollectionAccepted{}
}

/*
MetroclusterDrGroupDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type MetroclusterDrGroupDeleteCollectionAccepted struct {
	Payload *models.MetroclusterDrGroupJobLinkResponse
}

// IsSuccess returns true when this metrocluster dr group delete collection accepted response has a 2xx status code
func (o *MetroclusterDrGroupDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster dr group delete collection accepted response has a 3xx status code
func (o *MetroclusterDrGroupDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster dr group delete collection accepted response has a 4xx status code
func (o *MetroclusterDrGroupDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster dr group delete collection accepted response has a 5xx status code
func (o *MetroclusterDrGroupDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster dr group delete collection accepted response a status code equal to that given
func (o *MetroclusterDrGroupDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the metrocluster dr group delete collection accepted response
func (o *MetroclusterDrGroupDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *MetroclusterDrGroupDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/metrocluster/dr-groups][%d] metroclusterDrGroupDeleteCollectionAccepted %s", 202, payload)
}

func (o *MetroclusterDrGroupDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/metrocluster/dr-groups][%d] metroclusterDrGroupDeleteCollectionAccepted %s", 202, payload)
}

func (o *MetroclusterDrGroupDeleteCollectionAccepted) GetPayload() *models.MetroclusterDrGroupJobLinkResponse {
	return o.Payload
}

func (o *MetroclusterDrGroupDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterDrGroupJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterDrGroupDeleteCollectionDefault creates a MetroclusterDrGroupDeleteCollectionDefault with default headers values
func NewMetroclusterDrGroupDeleteCollectionDefault(code int) *MetroclusterDrGroupDeleteCollectionDefault {
	return &MetroclusterDrGroupDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	MetroclusterDrGroupDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2425574 | Two or more DR groups must be configured to remove a DR group from the MetroCluster configuration. |
| 2425734 | An internal error occurred. Wait a few minutes, and try the operation again. For further assistance, contact technical support. |
| 2432833 | Operation is already running. |
| 2432859 | Unconfiguring MetroCluster DR Group |
| 2432860 | Unmirroring Aggregates |
| 2432861 | Unassigning Remote Disks |
| 2432862 | Disabling Cluster HA and Storage Failover HA |
| 2432863 | Disconnecting and deleting network connections |
| 2432864 | Unconfiguring and deleting the DR Group |
| 2432865 | Deleting MetroCluster DR Group |
| 2432866 | MetroCluster DR Group delete done |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MetroclusterDrGroupDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this metrocluster dr group delete collection default response has a 2xx status code
func (o *MetroclusterDrGroupDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this metrocluster dr group delete collection default response has a 3xx status code
func (o *MetroclusterDrGroupDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this metrocluster dr group delete collection default response has a 4xx status code
func (o *MetroclusterDrGroupDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this metrocluster dr group delete collection default response has a 5xx status code
func (o *MetroclusterDrGroupDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this metrocluster dr group delete collection default response a status code equal to that given
func (o *MetroclusterDrGroupDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the metrocluster dr group delete collection default response
func (o *MetroclusterDrGroupDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MetroclusterDrGroupDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/metrocluster/dr-groups][%d] metrocluster_dr_group_delete_collection default %s", o._statusCode, payload)
}

func (o *MetroclusterDrGroupDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/metrocluster/dr-groups][%d] metrocluster_dr_group_delete_collection default %s", o._statusCode, payload)
}

func (o *MetroclusterDrGroupDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MetroclusterDrGroupDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MetroclusterDrGroupDeleteCollectionBody metrocluster dr group delete collection body
swagger:model MetroclusterDrGroupDeleteCollectionBody
*/
type MetroclusterDrGroupDeleteCollectionBody struct {

	// metrocluster dr group response inline records
	MetroclusterDrGroupResponseInlineRecords []*models.MetroclusterDrGroup `json:"records,omitempty"`
}

// Validate validates this metrocluster dr group delete collection body
func (o *MetroclusterDrGroupDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMetroclusterDrGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterDrGroupDeleteCollectionBody) validateMetroclusterDrGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MetroclusterDrGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MetroclusterDrGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.MetroclusterDrGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MetroclusterDrGroupResponseInlineRecords[i] != nil {
			if err := o.MetroclusterDrGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this metrocluster dr group delete collection body based on the context it is used
func (o *MetroclusterDrGroupDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMetroclusterDrGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterDrGroupDeleteCollectionBody) contextValidateMetroclusterDrGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MetroclusterDrGroupResponseInlineRecords); i++ {

		if o.MetroclusterDrGroupResponseInlineRecords[i] != nil {
			if err := o.MetroclusterDrGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *MetroclusterDrGroupDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MetroclusterDrGroupDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
