// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMetroclusterDrGroupDeleteParams creates a new MetroclusterDrGroupDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMetroclusterDrGroupDeleteParams() *MetroclusterDrGroupDeleteParams {
	return &MetroclusterDrGroupDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMetroclusterDrGroupDeleteParamsWithTimeout creates a new MetroclusterDrGroupDeleteParams object
// with the ability to set a timeout on a request.
func NewMetroclusterDrGroupDeleteParamsWithTimeout(timeout time.Duration) *MetroclusterDrGroupDeleteParams {
	return &MetroclusterDrGroupDeleteParams{
		timeout: timeout,
	}
}

// NewMetroclusterDrGroupDeleteParamsWithContext creates a new MetroclusterDrGroupDeleteParams object
// with the ability to set a context for a request.
func NewMetroclusterDrGroupDeleteParamsWithContext(ctx context.Context) *MetroclusterDrGroupDeleteParams {
	return &MetroclusterDrGroupDeleteParams{
		Context: ctx,
	}
}

// NewMetroclusterDrGroupDeleteParamsWithHTTPClient creates a new MetroclusterDrGroupDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewMetroclusterDrGroupDeleteParamsWithHTTPClient(client *http.Client) *MetroclusterDrGroupDeleteParams {
	return &MetroclusterDrGroupDeleteParams{
		HTTPClient: client,
	}
}

/*
MetroclusterDrGroupDeleteParams contains all the parameters to send to the API endpoint

	for the metrocluster dr group delete operation.

	Typically these are written to a http.Request.
*/
type MetroclusterDrGroupDeleteParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	// ID.
	ID string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the metrocluster dr group delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterDrGroupDeleteParams) WithDefaults() *MetroclusterDrGroupDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the metrocluster dr group delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterDrGroupDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := MetroclusterDrGroupDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) WithTimeout(timeout time.Duration) *MetroclusterDrGroupDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) WithContext(ctx context.Context) *MetroclusterDrGroupDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) WithHTTPClient(client *http.Client) *MetroclusterDrGroupDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) WithFields(fields []string) *MetroclusterDrGroupDeleteParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) WithID(id string) *MetroclusterDrGroupDeleteParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) SetID(id string) {
	o.ID = id
}

// WithReturnTimeout adds the returnTimeout to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) WithReturnTimeout(returnTimeout *int64) *MetroclusterDrGroupDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the metrocluster dr group delete params
func (o *MetroclusterDrGroupDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *MetroclusterDrGroupDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMetroclusterDrGroupDelete binds the parameter fields
func (o *MetroclusterDrGroupDeleteParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
