// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMetroclusterInterconnectGetParams creates a new MetroclusterInterconnectGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMetroclusterInterconnectGetParams() *MetroclusterInterconnectGetParams {
	return &MetroclusterInterconnectGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMetroclusterInterconnectGetParamsWithTimeout creates a new MetroclusterInterconnectGetParams object
// with the ability to set a timeout on a request.
func NewMetroclusterInterconnectGetParamsWithTimeout(timeout time.Duration) *MetroclusterInterconnectGetParams {
	return &MetroclusterInterconnectGetParams{
		timeout: timeout,
	}
}

// NewMetroclusterInterconnectGetParamsWithContext creates a new MetroclusterInterconnectGetParams object
// with the ability to set a context for a request.
func NewMetroclusterInterconnectGetParamsWithContext(ctx context.Context) *MetroclusterInterconnectGetParams {
	return &MetroclusterInterconnectGetParams{
		Context: ctx,
	}
}

// NewMetroclusterInterconnectGetParamsWithHTTPClient creates a new MetroclusterInterconnectGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewMetroclusterInterconnectGetParamsWithHTTPClient(client *http.Client) *MetroclusterInterconnectGetParams {
	return &MetroclusterInterconnectGetParams{
		HTTPClient: client,
	}
}

/*
MetroclusterInterconnectGetParams contains all the parameters to send to the API endpoint

	for the metrocluster interconnect get operation.

	Typically these are written to a http.Request.
*/
type MetroclusterInterconnectGetParams struct {

	/* Adapter.

	   Interconnect adapter.
	*/
	Adapter string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	/* PartnerType.

	   DR Partner type
	*/
	PartnerType string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the metrocluster interconnect get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterInterconnectGetParams) WithDefaults() *MetroclusterInterconnectGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the metrocluster interconnect get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterInterconnectGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithTimeout(timeout time.Duration) *MetroclusterInterconnectGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithContext(ctx context.Context) *MetroclusterInterconnectGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithHTTPClient(client *http.Client) *MetroclusterInterconnectGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdapter adds the adapter to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithAdapter(adapter string) *MetroclusterInterconnectGetParams {
	o.SetAdapter(adapter)
	return o
}

// SetAdapter adds the adapter to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetAdapter(adapter string) {
	o.Adapter = adapter
}

// WithFields adds the fields to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithFields(fields []string) *MetroclusterInterconnectGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithNodeUUID adds the nodeUUID to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithNodeUUID(nodeUUID string) *MetroclusterInterconnectGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithPartnerType adds the partnerType to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) WithPartnerType(partnerType string) *MetroclusterInterconnectGetParams {
	o.SetPartnerType(partnerType)
	return o
}

// SetPartnerType adds the partnerType to the metrocluster interconnect get params
func (o *MetroclusterInterconnectGetParams) SetPartnerType(partnerType string) {
	o.PartnerType = partnerType
}

// WriteToRequest writes these params to a swagger request
func (o *MetroclusterInterconnectGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param adapter
	if err := r.SetPathParam("adapter", o.Adapter); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	// path param partner_type
	if err := r.SetPathParam("partner_type", o.PartnerType); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMetroclusterInterconnectGet binds the parameter fields
func (o *MetroclusterInterconnectGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
