// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMetroclusterInterconnectModifyCollectionParams creates a new MetroclusterInterconnectModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMetroclusterInterconnectModifyCollectionParams() *MetroclusterInterconnectModifyCollectionParams {
	return &MetroclusterInterconnectModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMetroclusterInterconnectModifyCollectionParamsWithTimeout creates a new MetroclusterInterconnectModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewMetroclusterInterconnectModifyCollectionParamsWithTimeout(timeout time.Duration) *MetroclusterInterconnectModifyCollectionParams {
	return &MetroclusterInterconnectModifyCollectionParams{
		timeout: timeout,
	}
}

// NewMetroclusterInterconnectModifyCollectionParamsWithContext creates a new MetroclusterInterconnectModifyCollectionParams object
// with the ability to set a context for a request.
func NewMetroclusterInterconnectModifyCollectionParamsWithContext(ctx context.Context) *MetroclusterInterconnectModifyCollectionParams {
	return &MetroclusterInterconnectModifyCollectionParams{
		Context: ctx,
	}
}

// NewMetroclusterInterconnectModifyCollectionParamsWithHTTPClient creates a new MetroclusterInterconnectModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewMetroclusterInterconnectModifyCollectionParamsWithHTTPClient(client *http.Client) *MetroclusterInterconnectModifyCollectionParams {
	return &MetroclusterInterconnectModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
MetroclusterInterconnectModifyCollectionParams contains all the parameters to send to the API endpoint

	for the metrocluster interconnect modify collection operation.

	Typically these are written to a http.Request.
*/
type MetroclusterInterconnectModifyCollectionParams struct {

	/* Adapter.

	   Filter by adapter
	*/
	Adapter *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info MetroclusterInterconnectModifyCollectionBody

	/* InterfacesAddress.

	   Filter by interfaces.address
	*/
	InterfacesAddress *string

	/* InterfacesGateway.

	   Filter by interfaces.gateway
	*/
	InterfacesGateway *string

	/* InterfacesNetmask.

	   Filter by interfaces.netmask
	*/
	InterfacesNetmask *string

	/* MirrorEnabled.

	   Filter by mirror.enabled
	*/
	MirrorEnabled *bool

	/* MirrorState.

	   Filter by mirror.state
	*/
	MirrorState *string

	/* MultipathPolicy.

	   Filter by multipath_policy
	*/
	MultipathPolicy *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* PartnerType.

	   Filter by partner_type
	*/
	PartnerType *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* State.

	   Filter by state
	*/
	State *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* VlanID.

	   Filter by vlan_id
	*/
	VlanID *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the metrocluster interconnect modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterInterconnectModifyCollectionParams) WithDefaults() *MetroclusterInterconnectModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the metrocluster interconnect modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterInterconnectModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := MetroclusterInterconnectModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithTimeout(timeout time.Duration) *MetroclusterInterconnectModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithContext(ctx context.Context) *MetroclusterInterconnectModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithHTTPClient(client *http.Client) *MetroclusterInterconnectModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdapter adds the adapter to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithAdapter(adapter *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetAdapter(adapter)
	return o
}

// SetAdapter adds the adapter to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetAdapter(adapter *string) {
	o.Adapter = adapter
}

// WithContinueOnFailure adds the continueOnFailure to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *MetroclusterInterconnectModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithInfo(info MetroclusterInterconnectModifyCollectionBody) *MetroclusterInterconnectModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetInfo(info MetroclusterInterconnectModifyCollectionBody) {
	o.Info = info
}

// WithInterfacesAddress adds the interfacesAddress to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithInterfacesAddress(interfacesAddress *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetInterfacesAddress(interfacesAddress)
	return o
}

// SetInterfacesAddress adds the interfacesAddress to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetInterfacesAddress(interfacesAddress *string) {
	o.InterfacesAddress = interfacesAddress
}

// WithInterfacesGateway adds the interfacesGateway to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithInterfacesGateway(interfacesGateway *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetInterfacesGateway(interfacesGateway)
	return o
}

// SetInterfacesGateway adds the interfacesGateway to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetInterfacesGateway(interfacesGateway *string) {
	o.InterfacesGateway = interfacesGateway
}

// WithInterfacesNetmask adds the interfacesNetmask to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithInterfacesNetmask(interfacesNetmask *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetInterfacesNetmask(interfacesNetmask)
	return o
}

// SetInterfacesNetmask adds the interfacesNetmask to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetInterfacesNetmask(interfacesNetmask *string) {
	o.InterfacesNetmask = interfacesNetmask
}

// WithMirrorEnabled adds the mirrorEnabled to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithMirrorEnabled(mirrorEnabled *bool) *MetroclusterInterconnectModifyCollectionParams {
	o.SetMirrorEnabled(mirrorEnabled)
	return o
}

// SetMirrorEnabled adds the mirrorEnabled to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetMirrorEnabled(mirrorEnabled *bool) {
	o.MirrorEnabled = mirrorEnabled
}

// WithMirrorState adds the mirrorState to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithMirrorState(mirrorState *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetMirrorState(mirrorState)
	return o
}

// SetMirrorState adds the mirrorState to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetMirrorState(mirrorState *string) {
	o.MirrorState = mirrorState
}

// WithMultipathPolicy adds the multipathPolicy to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithMultipathPolicy(multipathPolicy *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetMultipathPolicy(multipathPolicy)
	return o
}

// SetMultipathPolicy adds the multipathPolicy to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetMultipathPolicy(multipathPolicy *string) {
	o.MultipathPolicy = multipathPolicy
}

// WithNodeName adds the nodeName to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithNodeName(nodeName *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithNodeUUID(nodeUUID *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithPartnerType adds the partnerType to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithPartnerType(partnerType *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetPartnerType(partnerType)
	return o
}

// SetPartnerType adds the partnerType to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetPartnerType(partnerType *string) {
	o.PartnerType = partnerType
}

// WithReturnRecords adds the returnRecords to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithReturnRecords(returnRecords *bool) *MetroclusterInterconnectModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *MetroclusterInterconnectModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithSerialRecords(serialRecords *bool) *MetroclusterInterconnectModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithState adds the state to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithState(state *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithType adds the typeVar to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithType(typeVar *string) *MetroclusterInterconnectModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithVlanID adds the vlanID to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) WithVlanID(vlanID *int64) *MetroclusterInterconnectModifyCollectionParams {
	o.SetVlanID(vlanID)
	return o
}

// SetVlanID adds the vlanId to the metrocluster interconnect modify collection params
func (o *MetroclusterInterconnectModifyCollectionParams) SetVlanID(vlanID *int64) {
	o.VlanID = vlanID
}

// WriteToRequest writes these params to a swagger request
func (o *MetroclusterInterconnectModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Adapter != nil {

		// query param adapter
		var qrAdapter string

		if o.Adapter != nil {
			qrAdapter = *o.Adapter
		}
		qAdapter := qrAdapter
		if qAdapter != "" {

			if err := r.SetQueryParam("adapter", qAdapter); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InterfacesAddress != nil {

		// query param interfaces.address
		var qrInterfacesAddress string

		if o.InterfacesAddress != nil {
			qrInterfacesAddress = *o.InterfacesAddress
		}
		qInterfacesAddress := qrInterfacesAddress
		if qInterfacesAddress != "" {

			if err := r.SetQueryParam("interfaces.address", qInterfacesAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfacesGateway != nil {

		// query param interfaces.gateway
		var qrInterfacesGateway string

		if o.InterfacesGateway != nil {
			qrInterfacesGateway = *o.InterfacesGateway
		}
		qInterfacesGateway := qrInterfacesGateway
		if qInterfacesGateway != "" {

			if err := r.SetQueryParam("interfaces.gateway", qInterfacesGateway); err != nil {
				return err
			}
		}
	}

	if o.InterfacesNetmask != nil {

		// query param interfaces.netmask
		var qrInterfacesNetmask string

		if o.InterfacesNetmask != nil {
			qrInterfacesNetmask = *o.InterfacesNetmask
		}
		qInterfacesNetmask := qrInterfacesNetmask
		if qInterfacesNetmask != "" {

			if err := r.SetQueryParam("interfaces.netmask", qInterfacesNetmask); err != nil {
				return err
			}
		}
	}

	if o.MirrorEnabled != nil {

		// query param mirror.enabled
		var qrMirrorEnabled bool

		if o.MirrorEnabled != nil {
			qrMirrorEnabled = *o.MirrorEnabled
		}
		qMirrorEnabled := swag.FormatBool(qrMirrorEnabled)
		if qMirrorEnabled != "" {

			if err := r.SetQueryParam("mirror.enabled", qMirrorEnabled); err != nil {
				return err
			}
		}
	}

	if o.MirrorState != nil {

		// query param mirror.state
		var qrMirrorState string

		if o.MirrorState != nil {
			qrMirrorState = *o.MirrorState
		}
		qMirrorState := qrMirrorState
		if qMirrorState != "" {

			if err := r.SetQueryParam("mirror.state", qMirrorState); err != nil {
				return err
			}
		}
	}

	if o.MultipathPolicy != nil {

		// query param multipath_policy
		var qrMultipathPolicy string

		if o.MultipathPolicy != nil {
			qrMultipathPolicy = *o.MultipathPolicy
		}
		qMultipathPolicy := qrMultipathPolicy
		if qMultipathPolicy != "" {

			if err := r.SetQueryParam("multipath_policy", qMultipathPolicy); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PartnerType != nil {

		// query param partner_type
		var qrPartnerType string

		if o.PartnerType != nil {
			qrPartnerType = *o.PartnerType
		}
		qPartnerType := qrPartnerType
		if qPartnerType != "" {

			if err := r.SetQueryParam("partner_type", qPartnerType); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.VlanID != nil {

		// query param vlan_id
		var qrVlanID int64

		if o.VlanID != nil {
			qrVlanID = *o.VlanID
		}
		qVlanID := swag.FormatInt64(qrVlanID)
		if qVlanID != "" {

			if err := r.SetQueryParam("vlan_id", qVlanID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
