// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MetroclusterInterconnectModifyCollectionReader is a Reader for the MetroclusterInterconnectModifyCollection structure.
type MetroclusterInterconnectModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MetroclusterInterconnectModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMetroclusterInterconnectModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewMetroclusterInterconnectModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMetroclusterInterconnectModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMetroclusterInterconnectModifyCollectionOK creates a MetroclusterInterconnectModifyCollectionOK with default headers values
func NewMetroclusterInterconnectModifyCollectionOK() *MetroclusterInterconnectModifyCollectionOK {
	return &MetroclusterInterconnectModifyCollectionOK{}
}

/*
MetroclusterInterconnectModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MetroclusterInterconnectModifyCollectionOK struct {
	Payload *models.MetroclusterInterconnectJobLinkResponse
}

// IsSuccess returns true when this metrocluster interconnect modify collection o k response has a 2xx status code
func (o *MetroclusterInterconnectModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster interconnect modify collection o k response has a 3xx status code
func (o *MetroclusterInterconnectModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster interconnect modify collection o k response has a 4xx status code
func (o *MetroclusterInterconnectModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster interconnect modify collection o k response has a 5xx status code
func (o *MetroclusterInterconnectModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster interconnect modify collection o k response a status code equal to that given
func (o *MetroclusterInterconnectModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the metrocluster interconnect modify collection o k response
func (o *MetroclusterInterconnectModifyCollectionOK) Code() int {
	return 200
}

func (o *MetroclusterInterconnectModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/metrocluster/interconnects][%d] metroclusterInterconnectModifyCollectionOK %s", 200, payload)
}

func (o *MetroclusterInterconnectModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/metrocluster/interconnects][%d] metroclusterInterconnectModifyCollectionOK %s", 200, payload)
}

func (o *MetroclusterInterconnectModifyCollectionOK) GetPayload() *models.MetroclusterInterconnectJobLinkResponse {
	return o.Payload
}

func (o *MetroclusterInterconnectModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterInterconnectJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterInterconnectModifyCollectionAccepted creates a MetroclusterInterconnectModifyCollectionAccepted with default headers values
func NewMetroclusterInterconnectModifyCollectionAccepted() *MetroclusterInterconnectModifyCollectionAccepted {
	return &MetroclusterInterconnectModifyCollectionAccepted{}
}

/*
MetroclusterInterconnectModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type MetroclusterInterconnectModifyCollectionAccepted struct {
	Payload *models.MetroclusterInterconnectJobLinkResponse
}

// IsSuccess returns true when this metrocluster interconnect modify collection accepted response has a 2xx status code
func (o *MetroclusterInterconnectModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster interconnect modify collection accepted response has a 3xx status code
func (o *MetroclusterInterconnectModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster interconnect modify collection accepted response has a 4xx status code
func (o *MetroclusterInterconnectModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster interconnect modify collection accepted response has a 5xx status code
func (o *MetroclusterInterconnectModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster interconnect modify collection accepted response a status code equal to that given
func (o *MetroclusterInterconnectModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the metrocluster interconnect modify collection accepted response
func (o *MetroclusterInterconnectModifyCollectionAccepted) Code() int {
	return 202
}

func (o *MetroclusterInterconnectModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/metrocluster/interconnects][%d] metroclusterInterconnectModifyCollectionAccepted %s", 202, payload)
}

func (o *MetroclusterInterconnectModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/metrocluster/interconnects][%d] metroclusterInterconnectModifyCollectionAccepted %s", 202, payload)
}

func (o *MetroclusterInterconnectModifyCollectionAccepted) GetPayload() *models.MetroclusterInterconnectJobLinkResponse {
	return o.Payload
}

func (o *MetroclusterInterconnectModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterInterconnectJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterInterconnectModifyCollectionDefault creates a MetroclusterInterconnectModifyCollectionDefault with default headers values
func NewMetroclusterInterconnectModifyCollectionDefault(code int) *MetroclusterInterconnectModifyCollectionDefault {
	return &MetroclusterInterconnectModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	MetroclusterInterconnectModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2425734 | An internal error has occurred. Wait a few minutes, and try the operation again. For further assistance, contact technical support. |
| 2430347 | The interface is already configured for port "adapter" with IP address "interfaces.address" on node "node.name". To configure a new IP address, run the "metrocluster configuration-settings interface delete" command to delete this interface and then run the "metrocluster configuration-settings interface create" command with the new IP address. |
| 2430348 | The interface is already configured for port "adapter" with gateway "interfaces.gateway" on node "node.name". To configure a new gateway or no gateway, run the "metrocluster configuration-settings interface delete" command to delete this interface and then run the "metrocluster configuration-settings interface create" command with the new gateway or no gateway. |
| 2430352 | The interface is already configured for port "adapter" with netmask "interfaces.netmask" on node "node.name". To configure a new netmask, run the "metrocluster configuration-settings interface delete" command to delete this interface and then run the "metrocluster configuration-settings interface create" command with the new netmask. |
| 2430445 | Configuration for the interface "port" on node "node.name" in cluster "cluster" does not exist. Use the "metrocluster configuration-settings interface show" command to list the valid interfaces configured for MetroCluster over IP. |
| 2432885 | Unable to modify the interface for adapter "port". Reason&#58; At least one interface parameter is required to modify the interface. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MetroclusterInterconnectModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this metrocluster interconnect modify collection default response has a 2xx status code
func (o *MetroclusterInterconnectModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this metrocluster interconnect modify collection default response has a 3xx status code
func (o *MetroclusterInterconnectModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this metrocluster interconnect modify collection default response has a 4xx status code
func (o *MetroclusterInterconnectModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this metrocluster interconnect modify collection default response has a 5xx status code
func (o *MetroclusterInterconnectModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this metrocluster interconnect modify collection default response a status code equal to that given
func (o *MetroclusterInterconnectModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the metrocluster interconnect modify collection default response
func (o *MetroclusterInterconnectModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MetroclusterInterconnectModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/metrocluster/interconnects][%d] metrocluster_interconnect_modify_collection default %s", o._statusCode, payload)
}

func (o *MetroclusterInterconnectModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/metrocluster/interconnects][%d] metrocluster_interconnect_modify_collection default %s", o._statusCode, payload)
}

func (o *MetroclusterInterconnectModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MetroclusterInterconnectModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MetroclusterInterconnectModifyCollectionBody metrocluster interconnect modify collection body
swagger:model MetroclusterInterconnectModifyCollectionBody
*/
type MetroclusterInterconnectModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Adapter
	// Read Only: true
	Adapter *string `json:"adapter,omitempty"`

	// List of objects which contain interface information such as its IP address, netmask and gateway.
	MetroclusterInterconnectInlineInterfaces []*models.MetroclusterInterconnectInlineInterfacesInlineArrayItem `json:"interfaces,omitempty"`

	// metrocluster interconnect response inline records
	MetroclusterInterconnectResponseInlineRecords []*models.MetroclusterInterconnect `json:"records,omitempty"`

	// mirror
	Mirror *models.MetroclusterInterconnectInlineMirror `json:"mirror,omitempty"`

	// Displays the NVRAM mirror multipath policy for the nodes configured in a MetroCluster.
	// Read Only: true
	// Enum: ["no_mp","static_map","dynamic_map","round_robin"]
	MultipathPolicy *string `json:"multipath_policy,omitempty"`

	// node
	Node *models.MetroclusterInterconnectInlineNode `json:"node,omitempty"`

	// Partner type
	// Read Only: true
	// Enum: ["aux","dr","ha"]
	PartnerType *string `json:"partner_type,omitempty"`

	// Adapter status
	// Read Only: true
	// Enum: ["down","up"]
	State *string `json:"state,omitempty"`

	// Adapter type
	// Read Only: true
	// Enum: ["roce","iwarp","unknown"]
	Type *string `json:"type,omitempty"`

	// VLAN ID
	// Read Only: true
	// Maximum: 4095
	// Minimum: 1
	VlanID *int64 `json:"vlan_id,omitempty"`
}

// Validate validates this metrocluster interconnect modify collection body
func (o *MetroclusterInterconnectModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetroclusterInterconnectInlineInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetroclusterInterconnectResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMirror(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMultipathPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePartnerType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVlanID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateMetroclusterInterconnectInlineInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.MetroclusterInterconnectInlineInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(o.MetroclusterInterconnectInlineInterfaces); i++ {
		if swag.IsZero(o.MetroclusterInterconnectInlineInterfaces[i]) { // not required
			continue
		}

		if o.MetroclusterInterconnectInlineInterfaces[i] != nil {
			if err := o.MetroclusterInterconnectInlineInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateMetroclusterInterconnectResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MetroclusterInterconnectResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MetroclusterInterconnectResponseInlineRecords); i++ {
		if swag.IsZero(o.MetroclusterInterconnectResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MetroclusterInterconnectResponseInlineRecords[i] != nil {
			if err := o.MetroclusterInterconnectResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateMirror(formats strfmt.Registry) error {
	if swag.IsZero(o.Mirror) { // not required
		return nil
	}

	if o.Mirror != nil {
		if err := o.Mirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "mirror")
			}
			return err
		}
	}

	return nil
}

var metroclusterInterconnectModifyCollectionBodyTypeMultipathPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_mp","static_map","dynamic_map","round_robin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInterconnectModifyCollectionBodyTypeMultipathPolicyPropEnum = append(metroclusterInterconnectModifyCollectionBodyTypeMultipathPolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// multipath_policy
	// MultipathPolicy
	// no_mp
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyMultipathPolicyNoMp captures enum value "no_mp"
	MetroclusterInterconnectModifyCollectionBodyMultipathPolicyNoMp string = "no_mp"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// multipath_policy
	// MultipathPolicy
	// static_map
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyMultipathPolicyStaticMap captures enum value "static_map"
	MetroclusterInterconnectModifyCollectionBodyMultipathPolicyStaticMap string = "static_map"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// multipath_policy
	// MultipathPolicy
	// dynamic_map
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyMultipathPolicyDynamicMap captures enum value "dynamic_map"
	MetroclusterInterconnectModifyCollectionBodyMultipathPolicyDynamicMap string = "dynamic_map"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// multipath_policy
	// MultipathPolicy
	// round_robin
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyMultipathPolicyRoundRobin captures enum value "round_robin"
	MetroclusterInterconnectModifyCollectionBodyMultipathPolicyRoundRobin string = "round_robin"
)

// prop value enum
func (o *MetroclusterInterconnectModifyCollectionBody) validateMultipathPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInterconnectModifyCollectionBodyTypeMultipathPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateMultipathPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.MultipathPolicy) { // not required
		return nil
	}

	// value enum
	if err := o.validateMultipathPolicyEnum("info"+"."+"multipath_policy", "body", *o.MultipathPolicy); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

var metroclusterInterconnectModifyCollectionBodyTypePartnerTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aux","dr","ha"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInterconnectModifyCollectionBodyTypePartnerTypePropEnum = append(metroclusterInterconnectModifyCollectionBodyTypePartnerTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// partner_type
	// PartnerType
	// aux
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyPartnerTypeAux captures enum value "aux"
	MetroclusterInterconnectModifyCollectionBodyPartnerTypeAux string = "aux"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// partner_type
	// PartnerType
	// dr
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyPartnerTypeDr captures enum value "dr"
	MetroclusterInterconnectModifyCollectionBodyPartnerTypeDr string = "dr"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// partner_type
	// PartnerType
	// ha
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyPartnerTypeHa captures enum value "ha"
	MetroclusterInterconnectModifyCollectionBodyPartnerTypeHa string = "ha"
)

// prop value enum
func (o *MetroclusterInterconnectModifyCollectionBody) validatePartnerTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInterconnectModifyCollectionBodyTypePartnerTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validatePartnerType(formats strfmt.Registry) error {
	if swag.IsZero(o.PartnerType) { // not required
		return nil
	}

	// value enum
	if err := o.validatePartnerTypeEnum("info"+"."+"partner_type", "body", *o.PartnerType); err != nil {
		return err
	}

	return nil
}

var metroclusterInterconnectModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","up"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInterconnectModifyCollectionBodyTypeStatePropEnum = append(metroclusterInterconnectModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyStateDown captures enum value "down"
	MetroclusterInterconnectModifyCollectionBodyStateDown string = "down"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyStateUp captures enum value "up"
	MetroclusterInterconnectModifyCollectionBodyStateUp string = "up"
)

// prop value enum
func (o *MetroclusterInterconnectModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInterconnectModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var metroclusterInterconnectModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["roce","iwarp","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInterconnectModifyCollectionBodyTypeTypePropEnum = append(metroclusterInterconnectModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// type
	// Type
	// roce
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyTypeRoce captures enum value "roce"
	MetroclusterInterconnectModifyCollectionBodyTypeRoce string = "roce"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// type
	// Type
	// iwarp
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyTypeIwarp captures enum value "iwarp"
	MetroclusterInterconnectModifyCollectionBodyTypeIwarp string = "iwarp"

	// BEGIN DEBUGGING
	// MetroclusterInterconnectModifyCollectionBody
	// MetroclusterInterconnectModifyCollectionBody
	// type
	// Type
	// unknown
	// END DEBUGGING
	// MetroclusterInterconnectModifyCollectionBodyTypeUnknown captures enum value "unknown"
	MetroclusterInterconnectModifyCollectionBodyTypeUnknown string = "unknown"
)

// prop value enum
func (o *MetroclusterInterconnectModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInterconnectModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) validateVlanID(formats strfmt.Registry) error {
	if swag.IsZero(o.VlanID) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"vlan_id", "body", *o.VlanID, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"vlan_id", "body", *o.VlanID, 4095, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster interconnect modify collection body based on the context it is used
func (o *MetroclusterInterconnectModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAdapter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetroclusterInterconnectInlineInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetroclusterInterconnectResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMultipathPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePartnerType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVlanID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateAdapter(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"adapter", "body", o.Adapter); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateMetroclusterInterconnectInlineInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MetroclusterInterconnectInlineInterfaces); i++ {

		if o.MetroclusterInterconnectInlineInterfaces[i] != nil {
			if err := o.MetroclusterInterconnectInlineInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateMetroclusterInterconnectResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MetroclusterInterconnectResponseInlineRecords); i++ {

		if o.MetroclusterInterconnectResponseInlineRecords[i] != nil {
			if err := o.MetroclusterInterconnectResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateMirror(ctx context.Context, formats strfmt.Registry) error {

	if o.Mirror != nil {
		if err := o.Mirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "mirror")
			}
			return err
		}
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateMultipathPolicy(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"multipath_policy", "body", o.MultipathPolicy); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidatePartnerType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"partner_type", "body", o.PartnerType); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

func (o *MetroclusterInterconnectModifyCollectionBody) contextValidateVlanID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"vlan_id", "body", o.VlanID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MetroclusterInterconnectModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MetroclusterInterconnectModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res MetroclusterInterconnectModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MetroclusterInterconnectInlineInterfacesInlineArrayItem Object to setup an interface along with its default router.
swagger:model metrocluster_interconnect_inline_interfaces_inline_array_item
*/
type MetroclusterInterconnectInlineInterfacesInlineArrayItem struct {

	// IPv4 or IPv6 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// netmask
	Netmask *models.IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this metrocluster interconnect inline interfaces inline array item
func (o *MetroclusterInterconnectInlineInterfacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineInterfacesInlineArrayItem) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(o.Netmask) { // not required
		return nil
	}

	if o.Netmask != nil {
		if err := o.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster interconnect inline interfaces inline array item based on the context it is used
func (o *MetroclusterInterconnectInlineInterfacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineInterfacesInlineArrayItem) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if o.Netmask != nil {
		if err := o.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineInterfacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineInterfacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MetroclusterInterconnectInlineInterfacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MetroclusterInterconnectInlineMirror metrocluster interconnect inline mirror
swagger:model metrocluster_interconnect_inline_mirror
*/
type MetroclusterInterconnectInlineMirror struct {

	// Specifies the administrative state of the NVRAM mirror between partner nodes.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the operational state of the NVRAM mirror between partner nodes.
	// Read Only: true
	// Enum: ["online","offline","unknown"]
	State *string `json:"state,omitempty"`
}

// Validate validates this metrocluster interconnect inline mirror
func (o *MetroclusterInterconnectInlineMirror) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var metroclusterInterconnectInlineMirrorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInterconnectInlineMirrorTypeStatePropEnum = append(metroclusterInterconnectInlineMirrorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_interconnect_inline_mirror
	// MetroclusterInterconnectInlineMirror
	// state
	// State
	// online
	// END DEBUGGING
	// MetroclusterInterconnectInlineMirrorStateOnline captures enum value "online"
	MetroclusterInterconnectInlineMirrorStateOnline string = "online"

	// BEGIN DEBUGGING
	// metrocluster_interconnect_inline_mirror
	// MetroclusterInterconnectInlineMirror
	// state
	// State
	// offline
	// END DEBUGGING
	// MetroclusterInterconnectInlineMirrorStateOffline captures enum value "offline"
	MetroclusterInterconnectInlineMirrorStateOffline string = "offline"

	// BEGIN DEBUGGING
	// metrocluster_interconnect_inline_mirror
	// MetroclusterInterconnectInlineMirror
	// state
	// State
	// unknown
	// END DEBUGGING
	// MetroclusterInterconnectInlineMirrorStateUnknown captures enum value "unknown"
	MetroclusterInterconnectInlineMirrorStateUnknown string = "unknown"
)

// prop value enum
func (o *MetroclusterInterconnectInlineMirror) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInterconnectInlineMirrorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MetroclusterInterconnectInlineMirror) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"mirror"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster interconnect inline mirror based on the context it is used
func (o *MetroclusterInterconnectInlineMirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineMirror) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"mirror"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineMirror) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineMirror) UnmarshalBinary(b []byte) error {
	var res MetroclusterInterconnectInlineMirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MetroclusterInterconnectInlineNode metrocluster interconnect inline node
swagger:model metrocluster_interconnect_inline_node
*/
type MetroclusterInterconnectInlineNode struct {

	// links
	Links *models.MetroclusterInterconnectInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster interconnect inline node
func (o *MetroclusterInterconnectInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster interconnect inline node based on the context it is used
func (o *MetroclusterInterconnectInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineNode) UnmarshalBinary(b []byte) error {
	var res MetroclusterInterconnectInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MetroclusterInterconnectInlineNodeInlineLinks metrocluster interconnect inline node inline links
swagger:model metrocluster_interconnect_inline_node_inline__links
*/
type MetroclusterInterconnectInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this metrocluster interconnect inline node inline links
func (o *MetroclusterInterconnectInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster interconnect inline node inline links based on the context it is used
func (o *MetroclusterInterconnectInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MetroclusterInterconnectInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MetroclusterInterconnectInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInterconnectInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
