// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewMetroclusterModifyParams creates a new MetroclusterModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMetroclusterModifyParams() *MetroclusterModifyParams {
	return &MetroclusterModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMetroclusterModifyParamsWithTimeout creates a new MetroclusterModifyParams object
// with the ability to set a timeout on a request.
func NewMetroclusterModifyParamsWithTimeout(timeout time.Duration) *MetroclusterModifyParams {
	return &MetroclusterModifyParams{
		timeout: timeout,
	}
}

// NewMetroclusterModifyParamsWithContext creates a new MetroclusterModifyParams object
// with the ability to set a context for a request.
func NewMetroclusterModifyParamsWithContext(ctx context.Context) *MetroclusterModifyParams {
	return &MetroclusterModifyParams{
		Context: ctx,
	}
}

// NewMetroclusterModifyParamsWithHTTPClient creates a new MetroclusterModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewMetroclusterModifyParamsWithHTTPClient(client *http.Client) *MetroclusterModifyParams {
	return &MetroclusterModifyParams{
		HTTPClient: client,
	}
}

/*
MetroclusterModifyParams contains all the parameters to send to the API endpoint

	for the metrocluster modify operation.

	Typically these are written to a http.Request.
*/
type MetroclusterModifyParams struct {

	/* Action.

	   Action to perform on the MetroCluster.
	*/
	Action *string

	/* DrGroupID.

	   DR group ID.
	*/
	DrGroupID *int64

	/* EncryptionEnabled.

	   Specifies if encryption for NVLog and storage traffic is enabled.
	*/
	EncryptionEnabled *bool

	/* Info.

	   Specifies the configuration of automatic switchover.
	*/
	Info *models.Metrocluster

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the metrocluster modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterModifyParams) WithDefaults() *MetroclusterModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the metrocluster modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := MetroclusterModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the metrocluster modify params
func (o *MetroclusterModifyParams) WithTimeout(timeout time.Duration) *MetroclusterModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the metrocluster modify params
func (o *MetroclusterModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the metrocluster modify params
func (o *MetroclusterModifyParams) WithContext(ctx context.Context) *MetroclusterModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the metrocluster modify params
func (o *MetroclusterModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the metrocluster modify params
func (o *MetroclusterModifyParams) WithHTTPClient(client *http.Client) *MetroclusterModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the metrocluster modify params
func (o *MetroclusterModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the metrocluster modify params
func (o *MetroclusterModifyParams) WithAction(action *string) *MetroclusterModifyParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the metrocluster modify params
func (o *MetroclusterModifyParams) SetAction(action *string) {
	o.Action = action
}

// WithDrGroupID adds the drGroupID to the metrocluster modify params
func (o *MetroclusterModifyParams) WithDrGroupID(drGroupID *int64) *MetroclusterModifyParams {
	o.SetDrGroupID(drGroupID)
	return o
}

// SetDrGroupID adds the drGroupId to the metrocluster modify params
func (o *MetroclusterModifyParams) SetDrGroupID(drGroupID *int64) {
	o.DrGroupID = drGroupID
}

// WithEncryptionEnabled adds the encryptionEnabled to the metrocluster modify params
func (o *MetroclusterModifyParams) WithEncryptionEnabled(encryptionEnabled *bool) *MetroclusterModifyParams {
	o.SetEncryptionEnabled(encryptionEnabled)
	return o
}

// SetEncryptionEnabled adds the encryptionEnabled to the metrocluster modify params
func (o *MetroclusterModifyParams) SetEncryptionEnabled(encryptionEnabled *bool) {
	o.EncryptionEnabled = encryptionEnabled
}

// WithInfo adds the info to the metrocluster modify params
func (o *MetroclusterModifyParams) WithInfo(info *models.Metrocluster) *MetroclusterModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the metrocluster modify params
func (o *MetroclusterModifyParams) SetInfo(info *models.Metrocluster) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the metrocluster modify params
func (o *MetroclusterModifyParams) WithReturnTimeout(returnTimeout *int64) *MetroclusterModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the metrocluster modify params
func (o *MetroclusterModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *MetroclusterModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.DrGroupID != nil {

		// query param dr_group_id
		var qrDrGroupID int64

		if o.DrGroupID != nil {
			qrDrGroupID = *o.DrGroupID
		}
		qDrGroupID := swag.FormatInt64(qrDrGroupID)
		if qDrGroupID != "" {

			if err := r.SetQueryParam("dr_group_id", qDrGroupID); err != nil {
				return err
			}
		}
	}

	if o.EncryptionEnabled != nil {

		// query param encryption_enabled
		var qrEncryptionEnabled bool

		if o.EncryptionEnabled != nil {
			qrEncryptionEnabled = *o.EncryptionEnabled
		}
		qEncryptionEnabled := swag.FormatBool(qrEncryptionEnabled)
		if qEncryptionEnabled != "" {

			if err := r.SetQueryParam("encryption_enabled", qEncryptionEnabled); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
