// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMetroclusterNodeCollectionGetParams creates a new MetroclusterNodeCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMetroclusterNodeCollectionGetParams() *MetroclusterNodeCollectionGetParams {
	return &MetroclusterNodeCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMetroclusterNodeCollectionGetParamsWithTimeout creates a new MetroclusterNodeCollectionGetParams object
// with the ability to set a timeout on a request.
func NewMetroclusterNodeCollectionGetParamsWithTimeout(timeout time.Duration) *MetroclusterNodeCollectionGetParams {
	return &MetroclusterNodeCollectionGetParams{
		timeout: timeout,
	}
}

// NewMetroclusterNodeCollectionGetParamsWithContext creates a new MetroclusterNodeCollectionGetParams object
// with the ability to set a context for a request.
func NewMetroclusterNodeCollectionGetParamsWithContext(ctx context.Context) *MetroclusterNodeCollectionGetParams {
	return &MetroclusterNodeCollectionGetParams{
		Context: ctx,
	}
}

// NewMetroclusterNodeCollectionGetParamsWithHTTPClient creates a new MetroclusterNodeCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewMetroclusterNodeCollectionGetParamsWithHTTPClient(client *http.Client) *MetroclusterNodeCollectionGetParams {
	return &MetroclusterNodeCollectionGetParams{
		HTTPClient: client,
	}
}

/*
MetroclusterNodeCollectionGetParams contains all the parameters to send to the API endpoint

	for the metrocluster node collection get operation.

	Typically these are written to a http.Request.
*/
type MetroclusterNodeCollectionGetParams struct {

	/* AutomaticUso.

	   Filter by automatic_uso
	*/
	AutomaticUso *bool

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* ConfigurationState.

	   Filter by configuration_state
	*/
	ConfigurationState *string

	/* DrAuxiliaryClusterName.

	   Filter by dr_auxiliary_cluster.name
	*/
	DrAuxiliaryClusterName *string

	/* DrAuxiliaryClusterUUID.

	   Filter by dr_auxiliary_cluster.uuid
	*/
	DrAuxiliaryClusterUUID *string

	/* DrAuxiliaryPartnerName.

	   Filter by dr_auxiliary_partner.name
	*/
	DrAuxiliaryPartnerName *string

	/* DrAuxiliaryPartnerSystemID.

	   Filter by dr_auxiliary_partner.system_id
	*/
	DrAuxiliaryPartnerSystemID *string

	/* DrAuxiliaryPartnerUUID.

	   Filter by dr_auxiliary_partner.uuid
	*/
	DrAuxiliaryPartnerUUID *string

	/* DrGroupID.

	   Filter by dr_group_id
	*/
	DrGroupID *int64

	/* DrMirroringState.

	   Filter by dr_mirroring_state
	*/
	DrMirroringState *string

	/* DrOperationState.

	   Filter by dr_operation_state
	*/
	DrOperationState *string

	/* DrPartnerName.

	   Filter by dr_partner.name
	*/
	DrPartnerName *string

	/* DrPartnerSystemID.

	   Filter by dr_partner.system_id
	*/
	DrPartnerSystemID *string

	/* DrPartnerUUID.

	   Filter by dr_partner.uuid
	*/
	DrPartnerUUID *string

	/* DrPartnerClusterName.

	   Filter by dr_partner_cluster.name
	*/
	DrPartnerClusterName *string

	/* DrPartnerClusterUUID.

	   Filter by dr_partner_cluster.uuid
	*/
	DrPartnerClusterUUID *string

	/* EncryptionEnabled.

	   Filter by encryption_enabled
	*/
	EncryptionEnabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* HaPartnerName.

	   Filter by ha_partner.name
	*/
	HaPartnerName *string

	/* HaPartnerSystemID.

	   Filter by ha_partner.system_id
	*/
	HaPartnerSystemID *string

	/* HaPartnerUUID.

	   Filter by ha_partner.uuid
	*/
	HaPartnerUUID *string

	/* HaPartnerClusterName.

	   Filter by ha_partner_cluster.name
	*/
	HaPartnerClusterName *string

	/* HaPartnerClusterUUID.

	   Filter by ha_partner_cluster.uuid
	*/
	HaPartnerClusterUUID *string

	/* IsMccip.

	   Filter by is_mccip
	*/
	IsMccip *bool

	/* LimitEnforcement.

	   Filter by limit_enforcement
	*/
	LimitEnforcement *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeSystemID.

	   Filter by node.system_id
	*/
	NodeSystemID *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the metrocluster node collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterNodeCollectionGetParams) WithDefaults() *MetroclusterNodeCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the metrocluster node collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterNodeCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := MetroclusterNodeCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithTimeout(timeout time.Duration) *MetroclusterNodeCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithContext(ctx context.Context) *MetroclusterNodeCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithHTTPClient(client *http.Client) *MetroclusterNodeCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAutomaticUso adds the automaticUso to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithAutomaticUso(automaticUso *bool) *MetroclusterNodeCollectionGetParams {
	o.SetAutomaticUso(automaticUso)
	return o
}

// SetAutomaticUso adds the automaticUso to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetAutomaticUso(automaticUso *bool) {
	o.AutomaticUso = automaticUso
}

// WithClusterName adds the clusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithClusterName(clusterName *string) *MetroclusterNodeCollectionGetParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithClusterUUID(clusterUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithConfigurationState adds the configurationState to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithConfigurationState(configurationState *string) *MetroclusterNodeCollectionGetParams {
	o.SetConfigurationState(configurationState)
	return o
}

// SetConfigurationState adds the configurationState to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetConfigurationState(configurationState *string) {
	o.ConfigurationState = configurationState
}

// WithDrAuxiliaryClusterName adds the drAuxiliaryClusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrAuxiliaryClusterName(drAuxiliaryClusterName *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrAuxiliaryClusterName(drAuxiliaryClusterName)
	return o
}

// SetDrAuxiliaryClusterName adds the drAuxiliaryClusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrAuxiliaryClusterName(drAuxiliaryClusterName *string) {
	o.DrAuxiliaryClusterName = drAuxiliaryClusterName
}

// WithDrAuxiliaryClusterUUID adds the drAuxiliaryClusterUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrAuxiliaryClusterUUID(drAuxiliaryClusterUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrAuxiliaryClusterUUID(drAuxiliaryClusterUUID)
	return o
}

// SetDrAuxiliaryClusterUUID adds the drAuxiliaryClusterUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrAuxiliaryClusterUUID(drAuxiliaryClusterUUID *string) {
	o.DrAuxiliaryClusterUUID = drAuxiliaryClusterUUID
}

// WithDrAuxiliaryPartnerName adds the drAuxiliaryPartnerName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrAuxiliaryPartnerName(drAuxiliaryPartnerName *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrAuxiliaryPartnerName(drAuxiliaryPartnerName)
	return o
}

// SetDrAuxiliaryPartnerName adds the drAuxiliaryPartnerName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrAuxiliaryPartnerName(drAuxiliaryPartnerName *string) {
	o.DrAuxiliaryPartnerName = drAuxiliaryPartnerName
}

// WithDrAuxiliaryPartnerSystemID adds the drAuxiliaryPartnerSystemID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrAuxiliaryPartnerSystemID(drAuxiliaryPartnerSystemID *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrAuxiliaryPartnerSystemID(drAuxiliaryPartnerSystemID)
	return o
}

// SetDrAuxiliaryPartnerSystemID adds the drAuxiliaryPartnerSystemId to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrAuxiliaryPartnerSystemID(drAuxiliaryPartnerSystemID *string) {
	o.DrAuxiliaryPartnerSystemID = drAuxiliaryPartnerSystemID
}

// WithDrAuxiliaryPartnerUUID adds the drAuxiliaryPartnerUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrAuxiliaryPartnerUUID(drAuxiliaryPartnerUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrAuxiliaryPartnerUUID(drAuxiliaryPartnerUUID)
	return o
}

// SetDrAuxiliaryPartnerUUID adds the drAuxiliaryPartnerUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrAuxiliaryPartnerUUID(drAuxiliaryPartnerUUID *string) {
	o.DrAuxiliaryPartnerUUID = drAuxiliaryPartnerUUID
}

// WithDrGroupID adds the drGroupID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrGroupID(drGroupID *int64) *MetroclusterNodeCollectionGetParams {
	o.SetDrGroupID(drGroupID)
	return o
}

// SetDrGroupID adds the drGroupId to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrGroupID(drGroupID *int64) {
	o.DrGroupID = drGroupID
}

// WithDrMirroringState adds the drMirroringState to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrMirroringState(drMirroringState *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrMirroringState(drMirroringState)
	return o
}

// SetDrMirroringState adds the drMirroringState to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrMirroringState(drMirroringState *string) {
	o.DrMirroringState = drMirroringState
}

// WithDrOperationState adds the drOperationState to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrOperationState(drOperationState *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrOperationState(drOperationState)
	return o
}

// SetDrOperationState adds the drOperationState to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrOperationState(drOperationState *string) {
	o.DrOperationState = drOperationState
}

// WithDrPartnerName adds the drPartnerName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrPartnerName(drPartnerName *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrPartnerName(drPartnerName)
	return o
}

// SetDrPartnerName adds the drPartnerName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrPartnerName(drPartnerName *string) {
	o.DrPartnerName = drPartnerName
}

// WithDrPartnerSystemID adds the drPartnerSystemID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrPartnerSystemID(drPartnerSystemID *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrPartnerSystemID(drPartnerSystemID)
	return o
}

// SetDrPartnerSystemID adds the drPartnerSystemId to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrPartnerSystemID(drPartnerSystemID *string) {
	o.DrPartnerSystemID = drPartnerSystemID
}

// WithDrPartnerUUID adds the drPartnerUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrPartnerUUID(drPartnerUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrPartnerUUID(drPartnerUUID)
	return o
}

// SetDrPartnerUUID adds the drPartnerUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrPartnerUUID(drPartnerUUID *string) {
	o.DrPartnerUUID = drPartnerUUID
}

// WithDrPartnerClusterName adds the drPartnerClusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrPartnerClusterName(drPartnerClusterName *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrPartnerClusterName(drPartnerClusterName)
	return o
}

// SetDrPartnerClusterName adds the drPartnerClusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrPartnerClusterName(drPartnerClusterName *string) {
	o.DrPartnerClusterName = drPartnerClusterName
}

// WithDrPartnerClusterUUID adds the drPartnerClusterUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithDrPartnerClusterUUID(drPartnerClusterUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetDrPartnerClusterUUID(drPartnerClusterUUID)
	return o
}

// SetDrPartnerClusterUUID adds the drPartnerClusterUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetDrPartnerClusterUUID(drPartnerClusterUUID *string) {
	o.DrPartnerClusterUUID = drPartnerClusterUUID
}

// WithEncryptionEnabled adds the encryptionEnabled to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithEncryptionEnabled(encryptionEnabled *bool) *MetroclusterNodeCollectionGetParams {
	o.SetEncryptionEnabled(encryptionEnabled)
	return o
}

// SetEncryptionEnabled adds the encryptionEnabled to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetEncryptionEnabled(encryptionEnabled *bool) {
	o.EncryptionEnabled = encryptionEnabled
}

// WithFields adds the fields to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithFields(fields []string) *MetroclusterNodeCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHaPartnerName adds the haPartnerName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithHaPartnerName(haPartnerName *string) *MetroclusterNodeCollectionGetParams {
	o.SetHaPartnerName(haPartnerName)
	return o
}

// SetHaPartnerName adds the haPartnerName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetHaPartnerName(haPartnerName *string) {
	o.HaPartnerName = haPartnerName
}

// WithHaPartnerSystemID adds the haPartnerSystemID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithHaPartnerSystemID(haPartnerSystemID *string) *MetroclusterNodeCollectionGetParams {
	o.SetHaPartnerSystemID(haPartnerSystemID)
	return o
}

// SetHaPartnerSystemID adds the haPartnerSystemId to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetHaPartnerSystemID(haPartnerSystemID *string) {
	o.HaPartnerSystemID = haPartnerSystemID
}

// WithHaPartnerUUID adds the haPartnerUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithHaPartnerUUID(haPartnerUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetHaPartnerUUID(haPartnerUUID)
	return o
}

// SetHaPartnerUUID adds the haPartnerUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetHaPartnerUUID(haPartnerUUID *string) {
	o.HaPartnerUUID = haPartnerUUID
}

// WithHaPartnerClusterName adds the haPartnerClusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithHaPartnerClusterName(haPartnerClusterName *string) *MetroclusterNodeCollectionGetParams {
	o.SetHaPartnerClusterName(haPartnerClusterName)
	return o
}

// SetHaPartnerClusterName adds the haPartnerClusterName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetHaPartnerClusterName(haPartnerClusterName *string) {
	o.HaPartnerClusterName = haPartnerClusterName
}

// WithHaPartnerClusterUUID adds the haPartnerClusterUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithHaPartnerClusterUUID(haPartnerClusterUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetHaPartnerClusterUUID(haPartnerClusterUUID)
	return o
}

// SetHaPartnerClusterUUID adds the haPartnerClusterUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetHaPartnerClusterUUID(haPartnerClusterUUID *string) {
	o.HaPartnerClusterUUID = haPartnerClusterUUID
}

// WithIsMccip adds the isMccip to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithIsMccip(isMccip *bool) *MetroclusterNodeCollectionGetParams {
	o.SetIsMccip(isMccip)
	return o
}

// SetIsMccip adds the isMccip to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetIsMccip(isMccip *bool) {
	o.IsMccip = isMccip
}

// WithLimitEnforcement adds the limitEnforcement to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithLimitEnforcement(limitEnforcement *string) *MetroclusterNodeCollectionGetParams {
	o.SetLimitEnforcement(limitEnforcement)
	return o
}

// SetLimitEnforcement adds the limitEnforcement to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetLimitEnforcement(limitEnforcement *string) {
	o.LimitEnforcement = limitEnforcement
}

// WithMaxRecords adds the maxRecords to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithMaxRecords(maxRecords *int64) *MetroclusterNodeCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithNodeName(nodeName *string) *MetroclusterNodeCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeSystemID adds the nodeSystemID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithNodeSystemID(nodeSystemID *string) *MetroclusterNodeCollectionGetParams {
	o.SetNodeSystemID(nodeSystemID)
	return o
}

// SetNodeSystemID adds the nodeSystemId to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetNodeSystemID(nodeSystemID *string) {
	o.NodeSystemID = nodeSystemID
}

// WithNodeUUID adds the nodeUUID to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithNodeUUID(nodeUUID *string) *MetroclusterNodeCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithOrderBy(orderBy []string) *MetroclusterNodeCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithReturnRecords(returnRecords *bool) *MetroclusterNodeCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *MetroclusterNodeCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the metrocluster node collection get params
func (o *MetroclusterNodeCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *MetroclusterNodeCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AutomaticUso != nil {

		// query param automatic_uso
		var qrAutomaticUso bool

		if o.AutomaticUso != nil {
			qrAutomaticUso = *o.AutomaticUso
		}
		qAutomaticUso := swag.FormatBool(qrAutomaticUso)
		if qAutomaticUso != "" {

			if err := r.SetQueryParam("automatic_uso", qAutomaticUso); err != nil {
				return err
			}
		}
	}

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationState != nil {

		// query param configuration_state
		var qrConfigurationState string

		if o.ConfigurationState != nil {
			qrConfigurationState = *o.ConfigurationState
		}
		qConfigurationState := qrConfigurationState
		if qConfigurationState != "" {

			if err := r.SetQueryParam("configuration_state", qConfigurationState); err != nil {
				return err
			}
		}
	}

	if o.DrAuxiliaryClusterName != nil {

		// query param dr_auxiliary_cluster.name
		var qrDrAuxiliaryClusterName string

		if o.DrAuxiliaryClusterName != nil {
			qrDrAuxiliaryClusterName = *o.DrAuxiliaryClusterName
		}
		qDrAuxiliaryClusterName := qrDrAuxiliaryClusterName
		if qDrAuxiliaryClusterName != "" {

			if err := r.SetQueryParam("dr_auxiliary_cluster.name", qDrAuxiliaryClusterName); err != nil {
				return err
			}
		}
	}

	if o.DrAuxiliaryClusterUUID != nil {

		// query param dr_auxiliary_cluster.uuid
		var qrDrAuxiliaryClusterUUID string

		if o.DrAuxiliaryClusterUUID != nil {
			qrDrAuxiliaryClusterUUID = *o.DrAuxiliaryClusterUUID
		}
		qDrAuxiliaryClusterUUID := qrDrAuxiliaryClusterUUID
		if qDrAuxiliaryClusterUUID != "" {

			if err := r.SetQueryParam("dr_auxiliary_cluster.uuid", qDrAuxiliaryClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.DrAuxiliaryPartnerName != nil {

		// query param dr_auxiliary_partner.name
		var qrDrAuxiliaryPartnerName string

		if o.DrAuxiliaryPartnerName != nil {
			qrDrAuxiliaryPartnerName = *o.DrAuxiliaryPartnerName
		}
		qDrAuxiliaryPartnerName := qrDrAuxiliaryPartnerName
		if qDrAuxiliaryPartnerName != "" {

			if err := r.SetQueryParam("dr_auxiliary_partner.name", qDrAuxiliaryPartnerName); err != nil {
				return err
			}
		}
	}

	if o.DrAuxiliaryPartnerSystemID != nil {

		// query param dr_auxiliary_partner.system_id
		var qrDrAuxiliaryPartnerSystemID string

		if o.DrAuxiliaryPartnerSystemID != nil {
			qrDrAuxiliaryPartnerSystemID = *o.DrAuxiliaryPartnerSystemID
		}
		qDrAuxiliaryPartnerSystemID := qrDrAuxiliaryPartnerSystemID
		if qDrAuxiliaryPartnerSystemID != "" {

			if err := r.SetQueryParam("dr_auxiliary_partner.system_id", qDrAuxiliaryPartnerSystemID); err != nil {
				return err
			}
		}
	}

	if o.DrAuxiliaryPartnerUUID != nil {

		// query param dr_auxiliary_partner.uuid
		var qrDrAuxiliaryPartnerUUID string

		if o.DrAuxiliaryPartnerUUID != nil {
			qrDrAuxiliaryPartnerUUID = *o.DrAuxiliaryPartnerUUID
		}
		qDrAuxiliaryPartnerUUID := qrDrAuxiliaryPartnerUUID
		if qDrAuxiliaryPartnerUUID != "" {

			if err := r.SetQueryParam("dr_auxiliary_partner.uuid", qDrAuxiliaryPartnerUUID); err != nil {
				return err
			}
		}
	}

	if o.DrGroupID != nil {

		// query param dr_group_id
		var qrDrGroupID int64

		if o.DrGroupID != nil {
			qrDrGroupID = *o.DrGroupID
		}
		qDrGroupID := swag.FormatInt64(qrDrGroupID)
		if qDrGroupID != "" {

			if err := r.SetQueryParam("dr_group_id", qDrGroupID); err != nil {
				return err
			}
		}
	}

	if o.DrMirroringState != nil {

		// query param dr_mirroring_state
		var qrDrMirroringState string

		if o.DrMirroringState != nil {
			qrDrMirroringState = *o.DrMirroringState
		}
		qDrMirroringState := qrDrMirroringState
		if qDrMirroringState != "" {

			if err := r.SetQueryParam("dr_mirroring_state", qDrMirroringState); err != nil {
				return err
			}
		}
	}

	if o.DrOperationState != nil {

		// query param dr_operation_state
		var qrDrOperationState string

		if o.DrOperationState != nil {
			qrDrOperationState = *o.DrOperationState
		}
		qDrOperationState := qrDrOperationState
		if qDrOperationState != "" {

			if err := r.SetQueryParam("dr_operation_state", qDrOperationState); err != nil {
				return err
			}
		}
	}

	if o.DrPartnerName != nil {

		// query param dr_partner.name
		var qrDrPartnerName string

		if o.DrPartnerName != nil {
			qrDrPartnerName = *o.DrPartnerName
		}
		qDrPartnerName := qrDrPartnerName
		if qDrPartnerName != "" {

			if err := r.SetQueryParam("dr_partner.name", qDrPartnerName); err != nil {
				return err
			}
		}
	}

	if o.DrPartnerSystemID != nil {

		// query param dr_partner.system_id
		var qrDrPartnerSystemID string

		if o.DrPartnerSystemID != nil {
			qrDrPartnerSystemID = *o.DrPartnerSystemID
		}
		qDrPartnerSystemID := qrDrPartnerSystemID
		if qDrPartnerSystemID != "" {

			if err := r.SetQueryParam("dr_partner.system_id", qDrPartnerSystemID); err != nil {
				return err
			}
		}
	}

	if o.DrPartnerUUID != nil {

		// query param dr_partner.uuid
		var qrDrPartnerUUID string

		if o.DrPartnerUUID != nil {
			qrDrPartnerUUID = *o.DrPartnerUUID
		}
		qDrPartnerUUID := qrDrPartnerUUID
		if qDrPartnerUUID != "" {

			if err := r.SetQueryParam("dr_partner.uuid", qDrPartnerUUID); err != nil {
				return err
			}
		}
	}

	if o.DrPartnerClusterName != nil {

		// query param dr_partner_cluster.name
		var qrDrPartnerClusterName string

		if o.DrPartnerClusterName != nil {
			qrDrPartnerClusterName = *o.DrPartnerClusterName
		}
		qDrPartnerClusterName := qrDrPartnerClusterName
		if qDrPartnerClusterName != "" {

			if err := r.SetQueryParam("dr_partner_cluster.name", qDrPartnerClusterName); err != nil {
				return err
			}
		}
	}

	if o.DrPartnerClusterUUID != nil {

		// query param dr_partner_cluster.uuid
		var qrDrPartnerClusterUUID string

		if o.DrPartnerClusterUUID != nil {
			qrDrPartnerClusterUUID = *o.DrPartnerClusterUUID
		}
		qDrPartnerClusterUUID := qrDrPartnerClusterUUID
		if qDrPartnerClusterUUID != "" {

			if err := r.SetQueryParam("dr_partner_cluster.uuid", qDrPartnerClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.EncryptionEnabled != nil {

		// query param encryption_enabled
		var qrEncryptionEnabled bool

		if o.EncryptionEnabled != nil {
			qrEncryptionEnabled = *o.EncryptionEnabled
		}
		qEncryptionEnabled := swag.FormatBool(qrEncryptionEnabled)
		if qEncryptionEnabled != "" {

			if err := r.SetQueryParam("encryption_enabled", qEncryptionEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.HaPartnerName != nil {

		// query param ha_partner.name
		var qrHaPartnerName string

		if o.HaPartnerName != nil {
			qrHaPartnerName = *o.HaPartnerName
		}
		qHaPartnerName := qrHaPartnerName
		if qHaPartnerName != "" {

			if err := r.SetQueryParam("ha_partner.name", qHaPartnerName); err != nil {
				return err
			}
		}
	}

	if o.HaPartnerSystemID != nil {

		// query param ha_partner.system_id
		var qrHaPartnerSystemID string

		if o.HaPartnerSystemID != nil {
			qrHaPartnerSystemID = *o.HaPartnerSystemID
		}
		qHaPartnerSystemID := qrHaPartnerSystemID
		if qHaPartnerSystemID != "" {

			if err := r.SetQueryParam("ha_partner.system_id", qHaPartnerSystemID); err != nil {
				return err
			}
		}
	}

	if o.HaPartnerUUID != nil {

		// query param ha_partner.uuid
		var qrHaPartnerUUID string

		if o.HaPartnerUUID != nil {
			qrHaPartnerUUID = *o.HaPartnerUUID
		}
		qHaPartnerUUID := qrHaPartnerUUID
		if qHaPartnerUUID != "" {

			if err := r.SetQueryParam("ha_partner.uuid", qHaPartnerUUID); err != nil {
				return err
			}
		}
	}

	if o.HaPartnerClusterName != nil {

		// query param ha_partner_cluster.name
		var qrHaPartnerClusterName string

		if o.HaPartnerClusterName != nil {
			qrHaPartnerClusterName = *o.HaPartnerClusterName
		}
		qHaPartnerClusterName := qrHaPartnerClusterName
		if qHaPartnerClusterName != "" {

			if err := r.SetQueryParam("ha_partner_cluster.name", qHaPartnerClusterName); err != nil {
				return err
			}
		}
	}

	if o.HaPartnerClusterUUID != nil {

		// query param ha_partner_cluster.uuid
		var qrHaPartnerClusterUUID string

		if o.HaPartnerClusterUUID != nil {
			qrHaPartnerClusterUUID = *o.HaPartnerClusterUUID
		}
		qHaPartnerClusterUUID := qrHaPartnerClusterUUID
		if qHaPartnerClusterUUID != "" {

			if err := r.SetQueryParam("ha_partner_cluster.uuid", qHaPartnerClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.IsMccip != nil {

		// query param is_mccip
		var qrIsMccip bool

		if o.IsMccip != nil {
			qrIsMccip = *o.IsMccip
		}
		qIsMccip := swag.FormatBool(qrIsMccip)
		if qIsMccip != "" {

			if err := r.SetQueryParam("is_mccip", qIsMccip); err != nil {
				return err
			}
		}
	}

	if o.LimitEnforcement != nil {

		// query param limit_enforcement
		var qrLimitEnforcement string

		if o.LimitEnforcement != nil {
			qrLimitEnforcement = *o.LimitEnforcement
		}
		qLimitEnforcement := qrLimitEnforcement
		if qLimitEnforcement != "" {

			if err := r.SetQueryParam("limit_enforcement", qLimitEnforcement); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeSystemID != nil {

		// query param node.system_id
		var qrNodeSystemID string

		if o.NodeSystemID != nil {
			qrNodeSystemID = *o.NodeSystemID
		}
		qNodeSystemID := qrNodeSystemID
		if qNodeSystemID != "" {

			if err := r.SetQueryParam("node.system_id", qNodeSystemID); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMetroclusterNodeCollectionGet binds the parameter fields
func (o *MetroclusterNodeCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamMetroclusterNodeCollectionGet binds the parameter order_by
func (o *MetroclusterNodeCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
