// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MetroclusterNodeCollectionGetReader is a Reader for the MetroclusterNodeCollectionGet structure.
type MetroclusterNodeCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MetroclusterNodeCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMetroclusterNodeCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMetroclusterNodeCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMetroclusterNodeCollectionGetOK creates a MetroclusterNodeCollectionGetOK with default headers values
func NewMetroclusterNodeCollectionGetOK() *MetroclusterNodeCollectionGetOK {
	return &MetroclusterNodeCollectionGetOK{}
}

/*
MetroclusterNodeCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type MetroclusterNodeCollectionGetOK struct {
	Payload *models.MetroclusterNodeResponse
}

// IsSuccess returns true when this metrocluster node collection get o k response has a 2xx status code
func (o *MetroclusterNodeCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster node collection get o k response has a 3xx status code
func (o *MetroclusterNodeCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster node collection get o k response has a 4xx status code
func (o *MetroclusterNodeCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster node collection get o k response has a 5xx status code
func (o *MetroclusterNodeCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster node collection get o k response a status code equal to that given
func (o *MetroclusterNodeCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the metrocluster node collection get o k response
func (o *MetroclusterNodeCollectionGetOK) Code() int {
	return 200
}

func (o *MetroclusterNodeCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/nodes][%d] metroclusterNodeCollectionGetOK %s", 200, payload)
}

func (o *MetroclusterNodeCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/nodes][%d] metroclusterNodeCollectionGetOK %s", 200, payload)
}

func (o *MetroclusterNodeCollectionGetOK) GetPayload() *models.MetroclusterNodeResponse {
	return o.Payload
}

func (o *MetroclusterNodeCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterNodeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterNodeCollectionGetDefault creates a MetroclusterNodeCollectionGetDefault with default headers values
func NewMetroclusterNodeCollectionGetDefault(code int) *MetroclusterNodeCollectionGetDefault {
	return &MetroclusterNodeCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	MetroclusterNodeCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2425734 | An internal error occurred. Wait a few minutes, and try the operation again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MetroclusterNodeCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this metrocluster node collection get default response has a 2xx status code
func (o *MetroclusterNodeCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this metrocluster node collection get default response has a 3xx status code
func (o *MetroclusterNodeCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this metrocluster node collection get default response has a 4xx status code
func (o *MetroclusterNodeCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this metrocluster node collection get default response has a 5xx status code
func (o *MetroclusterNodeCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this metrocluster node collection get default response a status code equal to that given
func (o *MetroclusterNodeCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the metrocluster node collection get default response
func (o *MetroclusterNodeCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *MetroclusterNodeCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/nodes][%d] metrocluster_node_collection_get default %s", o._statusCode, payload)
}

func (o *MetroclusterNodeCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/nodes][%d] metrocluster_node_collection_get default %s", o._statusCode, payload)
}

func (o *MetroclusterNodeCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MetroclusterNodeCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
