// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MetroclusterOperationGetReader is a Reader for the MetroclusterOperationGet structure.
type MetroclusterOperationGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MetroclusterOperationGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMetroclusterOperationGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMetroclusterOperationGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMetroclusterOperationGetOK creates a MetroclusterOperationGetOK with default headers values
func NewMetroclusterOperationGetOK() *MetroclusterOperationGetOK {
	return &MetroclusterOperationGetOK{}
}

/*
MetroclusterOperationGetOK describes a response with status code 200, with default header values.

OK
*/
type MetroclusterOperationGetOK struct {
	Payload *models.MetroclusterOperation
}

// IsSuccess returns true when this metrocluster operation get o k response has a 2xx status code
func (o *MetroclusterOperationGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster operation get o k response has a 3xx status code
func (o *MetroclusterOperationGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster operation get o k response has a 4xx status code
func (o *MetroclusterOperationGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster operation get o k response has a 5xx status code
func (o *MetroclusterOperationGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster operation get o k response a status code equal to that given
func (o *MetroclusterOperationGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the metrocluster operation get o k response
func (o *MetroclusterOperationGetOK) Code() int {
	return 200
}

func (o *MetroclusterOperationGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/operations/{uuid}][%d] metroclusterOperationGetOK %s", 200, payload)
}

func (o *MetroclusterOperationGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/operations/{uuid}][%d] metroclusterOperationGetOK %s", 200, payload)
}

func (o *MetroclusterOperationGetOK) GetPayload() *models.MetroclusterOperation {
	return o.Payload
}

func (o *MetroclusterOperationGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterOperation)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterOperationGetDefault creates a MetroclusterOperationGetDefault with default headers values
func NewMetroclusterOperationGetDefault(code int) *MetroclusterOperationGetDefault {
	return &MetroclusterOperationGetDefault{
		_statusCode: code,
	}
}

/*
	MetroclusterOperationGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2425734 | An internal error occurred. Wait a few minutes, and try the operation again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MetroclusterOperationGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this metrocluster operation get default response has a 2xx status code
func (o *MetroclusterOperationGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this metrocluster operation get default response has a 3xx status code
func (o *MetroclusterOperationGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this metrocluster operation get default response has a 4xx status code
func (o *MetroclusterOperationGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this metrocluster operation get default response has a 5xx status code
func (o *MetroclusterOperationGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this metrocluster operation get default response a status code equal to that given
func (o *MetroclusterOperationGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the metrocluster operation get default response
func (o *MetroclusterOperationGetDefault) Code() int {
	return o._statusCode
}

func (o *MetroclusterOperationGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/operations/{uuid}][%d] metrocluster_operation_get default %s", o._statusCode, payload)
}

func (o *MetroclusterOperationGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/operations/{uuid}][%d] metrocluster_operation_get default %s", o._statusCode, payload)
}

func (o *MetroclusterOperationGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MetroclusterOperationGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
