// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMetroclusterSvmCollectionGetParams creates a new MetroclusterSvmCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMetroclusterSvmCollectionGetParams() *MetroclusterSvmCollectionGetParams {
	return &MetroclusterSvmCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMetroclusterSvmCollectionGetParamsWithTimeout creates a new MetroclusterSvmCollectionGetParams object
// with the ability to set a timeout on a request.
func NewMetroclusterSvmCollectionGetParamsWithTimeout(timeout time.Duration) *MetroclusterSvmCollectionGetParams {
	return &MetroclusterSvmCollectionGetParams{
		timeout: timeout,
	}
}

// NewMetroclusterSvmCollectionGetParamsWithContext creates a new MetroclusterSvmCollectionGetParams object
// with the ability to set a context for a request.
func NewMetroclusterSvmCollectionGetParamsWithContext(ctx context.Context) *MetroclusterSvmCollectionGetParams {
	return &MetroclusterSvmCollectionGetParams{
		Context: ctx,
	}
}

// NewMetroclusterSvmCollectionGetParamsWithHTTPClient creates a new MetroclusterSvmCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewMetroclusterSvmCollectionGetParamsWithHTTPClient(client *http.Client) *MetroclusterSvmCollectionGetParams {
	return &MetroclusterSvmCollectionGetParams{
		HTTPClient: client,
	}
}

/*
MetroclusterSvmCollectionGetParams contains all the parameters to send to the API endpoint

	for the metrocluster svm collection get operation.

	Typically these are written to a http.Request.
*/
type MetroclusterSvmCollectionGetParams struct {

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* ConfigurationState.

	   Filter by configuration_state
	*/
	ConfigurationState *string

	/* FailedReason.

	   Filter by failed_reason
	*/
	FailedReason *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PartnerSvmName.

	   Filter by partner_svm.name
	*/
	PartnerSvmName *string

	/* PartnerSvmUUID.

	   Filter by partner_svm.uuid
	*/
	PartnerSvmUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the metrocluster svm collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterSvmCollectionGetParams) WithDefaults() *MetroclusterSvmCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the metrocluster svm collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MetroclusterSvmCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := MetroclusterSvmCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithTimeout(timeout time.Duration) *MetroclusterSvmCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithContext(ctx context.Context) *MetroclusterSvmCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithHTTPClient(client *http.Client) *MetroclusterSvmCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterName adds the clusterName to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithClusterName(clusterName *string) *MetroclusterSvmCollectionGetParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithClusterUUID(clusterUUID *string) *MetroclusterSvmCollectionGetParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithConfigurationState adds the configurationState to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithConfigurationState(configurationState *string) *MetroclusterSvmCollectionGetParams {
	o.SetConfigurationState(configurationState)
	return o
}

// SetConfigurationState adds the configurationState to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetConfigurationState(configurationState *string) {
	o.ConfigurationState = configurationState
}

// WithFailedReason adds the failedReason to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithFailedReason(failedReason *string) *MetroclusterSvmCollectionGetParams {
	o.SetFailedReason(failedReason)
	return o
}

// SetFailedReason adds the failedReason to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetFailedReason(failedReason *string) {
	o.FailedReason = failedReason
}

// WithFields adds the fields to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithFields(fields []string) *MetroclusterSvmCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithMaxRecords(maxRecords *int64) *MetroclusterSvmCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithOrderBy(orderBy []string) *MetroclusterSvmCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPartnerSvmName adds the partnerSvmName to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithPartnerSvmName(partnerSvmName *string) *MetroclusterSvmCollectionGetParams {
	o.SetPartnerSvmName(partnerSvmName)
	return o
}

// SetPartnerSvmName adds the partnerSvmName to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetPartnerSvmName(partnerSvmName *string) {
	o.PartnerSvmName = partnerSvmName
}

// WithPartnerSvmUUID adds the partnerSvmUUID to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithPartnerSvmUUID(partnerSvmUUID *string) *MetroclusterSvmCollectionGetParams {
	o.SetPartnerSvmUUID(partnerSvmUUID)
	return o
}

// SetPartnerSvmUUID adds the partnerSvmUuid to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetPartnerSvmUUID(partnerSvmUUID *string) {
	o.PartnerSvmUUID = partnerSvmUUID
}

// WithReturnRecords adds the returnRecords to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithReturnRecords(returnRecords *bool) *MetroclusterSvmCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *MetroclusterSvmCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithSvmName(svmName *string) *MetroclusterSvmCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) WithSvmUUID(svmUUID *string) *MetroclusterSvmCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the metrocluster svm collection get params
func (o *MetroclusterSvmCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *MetroclusterSvmCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationState != nil {

		// query param configuration_state
		var qrConfigurationState string

		if o.ConfigurationState != nil {
			qrConfigurationState = *o.ConfigurationState
		}
		qConfigurationState := qrConfigurationState
		if qConfigurationState != "" {

			if err := r.SetQueryParam("configuration_state", qConfigurationState); err != nil {
				return err
			}
		}
	}

	if o.FailedReason != nil {

		// query param failed_reason
		var qrFailedReason string

		if o.FailedReason != nil {
			qrFailedReason = *o.FailedReason
		}
		qFailedReason := qrFailedReason
		if qFailedReason != "" {

			if err := r.SetQueryParam("failed_reason", qFailedReason); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PartnerSvmName != nil {

		// query param partner_svm.name
		var qrPartnerSvmName string

		if o.PartnerSvmName != nil {
			qrPartnerSvmName = *o.PartnerSvmName
		}
		qPartnerSvmName := qrPartnerSvmName
		if qPartnerSvmName != "" {

			if err := r.SetQueryParam("partner_svm.name", qPartnerSvmName); err != nil {
				return err
			}
		}
	}

	if o.PartnerSvmUUID != nil {

		// query param partner_svm.uuid
		var qrPartnerSvmUUID string

		if o.PartnerSvmUUID != nil {
			qrPartnerSvmUUID = *o.PartnerSvmUUID
		}
		qPartnerSvmUUID := qrPartnerSvmUUID
		if qPartnerSvmUUID != "" {

			if err := r.SetQueryParam("partner_svm.uuid", qPartnerSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMetroclusterSvmCollectionGet binds the parameter fields
func (o *MetroclusterSvmCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamMetroclusterSvmCollectionGet binds the parameter order_by
func (o *MetroclusterSvmCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
