// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MetroclusterSvmGetReader is a Reader for the MetroclusterSvmGet structure.
type MetroclusterSvmGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MetroclusterSvmGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMetroclusterSvmGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMetroclusterSvmGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMetroclusterSvmGetOK creates a MetroclusterSvmGetOK with default headers values
func NewMetroclusterSvmGetOK() *MetroclusterSvmGetOK {
	return &MetroclusterSvmGetOK{}
}

/*
MetroclusterSvmGetOK describes a response with status code 200, with default header values.

OK
*/
type MetroclusterSvmGetOK struct {
	Payload *models.MetroclusterSvm
}

// IsSuccess returns true when this metrocluster svm get o k response has a 2xx status code
func (o *MetroclusterSvmGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this metrocluster svm get o k response has a 3xx status code
func (o *MetroclusterSvmGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this metrocluster svm get o k response has a 4xx status code
func (o *MetroclusterSvmGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this metrocluster svm get o k response has a 5xx status code
func (o *MetroclusterSvmGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this metrocluster svm get o k response a status code equal to that given
func (o *MetroclusterSvmGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the metrocluster svm get o k response
func (o *MetroclusterSvmGetOK) Code() int {
	return 200
}

func (o *MetroclusterSvmGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/svms/{cluster.uuid}/{svm.uuid}][%d] metroclusterSvmGetOK %s", 200, payload)
}

func (o *MetroclusterSvmGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/svms/{cluster.uuid}/{svm.uuid}][%d] metroclusterSvmGetOK %s", 200, payload)
}

func (o *MetroclusterSvmGetOK) GetPayload() *models.MetroclusterSvm {
	return o.Payload
}

func (o *MetroclusterSvmGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MetroclusterSvm)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMetroclusterSvmGetDefault creates a MetroclusterSvmGetDefault with default headers values
func NewMetroclusterSvmGetDefault(code int) *MetroclusterSvmGetDefault {
	return &MetroclusterSvmGetDefault{
		_statusCode: code,
	}
}

/*
MetroclusterSvmGetDefault describes a response with status code -1, with default header values.

Error
*/
type MetroclusterSvmGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this metrocluster svm get default response has a 2xx status code
func (o *MetroclusterSvmGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this metrocluster svm get default response has a 3xx status code
func (o *MetroclusterSvmGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this metrocluster svm get default response has a 4xx status code
func (o *MetroclusterSvmGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this metrocluster svm get default response has a 5xx status code
func (o *MetroclusterSvmGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this metrocluster svm get default response a status code equal to that given
func (o *MetroclusterSvmGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the metrocluster svm get default response
func (o *MetroclusterSvmGetDefault) Code() int {
	return o._statusCode
}

func (o *MetroclusterSvmGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/svms/{cluster.uuid}/{svm.uuid}][%d] metrocluster_svm_get default %s", o._statusCode, payload)
}

func (o *MetroclusterSvmGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/metrocluster/svms/{cluster.uuid}/{svm.uuid}][%d] metrocluster_svm_get default %s", o._statusCode, payload)
}

func (o *MetroclusterSvmGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MetroclusterSvmGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
