// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNodeDeleteCollectionParams creates a new NodeDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNodeDeleteCollectionParams() *NodeDeleteCollectionParams {
	return &NodeDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNodeDeleteCollectionParamsWithTimeout creates a new NodeDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewNodeDeleteCollectionParamsWithTimeout(timeout time.Duration) *NodeDeleteCollectionParams {
	return &NodeDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewNodeDeleteCollectionParamsWithContext creates a new NodeDeleteCollectionParams object
// with the ability to set a context for a request.
func NewNodeDeleteCollectionParamsWithContext(ctx context.Context) *NodeDeleteCollectionParams {
	return &NodeDeleteCollectionParams{
		Context: ctx,
	}
}

// NewNodeDeleteCollectionParamsWithHTTPClient creates a new NodeDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNodeDeleteCollectionParamsWithHTTPClient(client *http.Client) *NodeDeleteCollectionParams {
	return &NodeDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
NodeDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the node delete collection operation.

	Typically these are written to a http.Request.
*/
type NodeDeleteCollectionParams struct {

	/* AntiRansomwareVersion.

	   Filter by anti_ransomware_version
	*/
	AntiRansomwareVersion *string

	/* ClusterInterfacesIPAddress.

	   Filter by cluster_interfaces.ip.address
	*/
	ClusterInterfacesIPAddress *string

	/* ClusterInterfacesName.

	   Filter by cluster_interfaces.name
	*/
	ClusterInterfacesName *string

	/* ClusterInterfacesUUID.

	   Filter by cluster_interfaces.uuid
	*/
	ClusterInterfacesUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ControllerBoard.

	   Filter by controller.board
	*/
	ControllerBoard *string

	/* ControllerCPUCount.

	   Filter by controller.cpu.count
	*/
	ControllerCPUCount *int64

	/* ControllerCPUFirmwareRelease.

	   Filter by controller.cpu.firmware_release
	*/
	ControllerCPUFirmwareRelease *string

	/* ControllerCPUProcessor.

	   Filter by controller.cpu.processor
	*/
	ControllerCPUProcessor *string

	/* ControllerFailedFanCount.

	   Filter by controller.failed_fan.count
	*/
	ControllerFailedFanCount *int64

	/* ControllerFailedFanMessageCode.

	   Filter by controller.failed_fan.message.code
	*/
	ControllerFailedFanMessageCode *string

	/* ControllerFailedFanMessageMessage.

	   Filter by controller.failed_fan.message.message
	*/
	ControllerFailedFanMessageMessage *string

	/* ControllerFailedPowerSupplyCount.

	   Filter by controller.failed_power_supply.count
	*/
	ControllerFailedPowerSupplyCount *int64

	/* ControllerFailedPowerSupplyMessageCode.

	   Filter by controller.failed_power_supply.message.code
	*/
	ControllerFailedPowerSupplyMessageCode *string

	/* ControllerFailedPowerSupplyMessageMessage.

	   Filter by controller.failed_power_supply.message.message
	*/
	ControllerFailedPowerSupplyMessageMessage *string

	/* ControllerFlashCacheCapacity.

	   Filter by controller.flash_cache.capacity
	*/
	ControllerFlashCacheCapacity *int64

	/* ControllerFlashCacheDeviceID.

	   Filter by controller.flash_cache.device_id
	*/
	ControllerFlashCacheDeviceID *int64

	/* ControllerFlashCacheFirmwareFile.

	   Filter by controller.flash_cache.firmware_file
	*/
	ControllerFlashCacheFirmwareFile *string

	/* ControllerFlashCacheFirmwareVersion.

	   Filter by controller.flash_cache.firmware_version
	*/
	ControllerFlashCacheFirmwareVersion *string

	/* ControllerFlashCacheHardwareRevision.

	   Filter by controller.flash_cache.hardware_revision
	*/
	ControllerFlashCacheHardwareRevision *string

	/* ControllerFlashCacheModel.

	   Filter by controller.flash_cache.model
	*/
	ControllerFlashCacheModel *string

	/* ControllerFlashCachePartNumber.

	   Filter by controller.flash_cache.part_number
	*/
	ControllerFlashCachePartNumber *string

	/* ControllerFlashCacheSerialNumber.

	   Filter by controller.flash_cache.serial_number
	*/
	ControllerFlashCacheSerialNumber *string

	/* ControllerFlashCacheSlot.

	   Filter by controller.flash_cache.slot
	*/
	ControllerFlashCacheSlot *string

	/* ControllerFlashCacheState.

	   Filter by controller.flash_cache.state
	*/
	ControllerFlashCacheState *string

	/* ControllerFrusID.

	   Filter by controller.frus.id
	*/
	ControllerFrusID *string

	/* ControllerFrusState.

	   Filter by controller.frus.state
	*/
	ControllerFrusState *string

	/* ControllerFrusType.

	   Filter by controller.frus.type
	*/
	ControllerFrusType *string

	/* ControllerMemorySize.

	   Filter by controller.memory_size
	*/
	ControllerMemorySize *int64

	/* ControllerOverTemperature.

	   Filter by controller.over_temperature
	*/
	ControllerOverTemperature *string

	/* Date.

	   Filter by date
	*/
	Date *string

	/* ExternalCacheIsEnabled.

	   Filter by external_cache.is_enabled
	*/
	ExternalCacheIsEnabled *bool

	/* ExternalCacheIsHyaEnabled.

	   Filter by external_cache.is_hya_enabled
	*/
	ExternalCacheIsHyaEnabled *bool

	/* ExternalCacheIsRewarmEnabled.

	   Filter by external_cache.is_rewarm_enabled
	*/
	ExternalCacheIsRewarmEnabled *bool

	/* ExternalCachePcsSize.

	   Filter by external_cache.pcs_size
	*/
	ExternalCachePcsSize *int64

	/* ExternalCacheBypassEnabled.

	   Filter by external_cache_bypass.enabled
	*/
	ExternalCacheBypassEnabled *bool

	/* ExternalCacheBypassLargeReadOpsAllowPercent.

	   Filter by external_cache_bypass.large_read_ops_allow_percent
	*/
	ExternalCacheBypassLargeReadOpsAllowPercent *int64

	/* Force.

	   Set the force flag to "true" to forcibly remove a node that is down and cannot be brought online to remove its shared resources.

	*/
	Force *bool

	/* HaAutoGiveback.

	   Filter by ha.auto_giveback
	*/
	HaAutoGiveback *bool

	/* HaAutoGivebackOf.

	   Filter by ha.auto_giveback_of
	*/
	HaAutoGivebackOf *bool

	/* HaEnableTakeoverOf.

	   Filter by ha.enable_takeover_of
	*/
	HaEnableTakeoverOf *bool

	/* HaEnabled.

	   Filter by ha.enabled
	*/
	HaEnabled *bool

	/* HaGivebackFailureCode.

	   Filter by ha.giveback.failure.code
	*/
	HaGivebackFailureCode *int64

	/* HaGivebackFailureMessage.

	   Filter by ha.giveback.failure.message
	*/
	HaGivebackFailureMessage *string

	/* HaGivebackState.

	   Filter by ha.giveback.state
	*/
	HaGivebackState *string

	/* HaGivebackStatusAggregateName.

	   Filter by ha.giveback.status.aggregate.name
	*/
	HaGivebackStatusAggregateName *string

	/* HaGivebackStatusAggregateUUID.

	   Filter by ha.giveback.status.aggregate.uuid
	*/
	HaGivebackStatusAggregateUUID *string

	/* HaGivebackStatusErrorCode.

	   Filter by ha.giveback.status.error.code
	*/
	HaGivebackStatusErrorCode *string

	/* HaGivebackStatusErrorMessage.

	   Filter by ha.giveback.status.error.message
	*/
	HaGivebackStatusErrorMessage *string

	/* HaGivebackStatusState.

	   Filter by ha.giveback.status.state
	*/
	HaGivebackStatusState *string

	/* HaInterconnectAdapter.

	   Filter by ha.interconnect.adapter
	*/
	HaInterconnectAdapter *string

	/* HaInterconnectState.

	   Filter by ha.interconnect.state
	*/
	HaInterconnectState *string

	/* HaPartnersName.

	   Filter by ha.partners.name
	*/
	HaPartnersName *string

	/* HaPartnersUUID.

	   Filter by ha.partners.uuid
	*/
	HaPartnersUUID *string

	/* HaPortsNumber.

	   Filter by ha.ports.number
	*/
	HaPortsNumber *int64

	/* HaPortsState.

	   Filter by ha.ports.state
	*/
	HaPortsState *string

	/* HaTakeoverFailureCode.

	   Filter by ha.takeover.failure.code
	*/
	HaTakeoverFailureCode *int64

	/* HaTakeoverFailureMessage.

	   Filter by ha.takeover.failure.message
	*/
	HaTakeoverFailureMessage *string

	/* HaTakeoverState.

	   Filter by ha.takeover.state
	*/
	HaTakeoverState *string

	/* HaTakeoverCheckReasons.

	   Filter by ha.takeover_check.reasons
	*/
	HaTakeoverCheckReasons *string

	/* HaTakeoverCheckTakeoverPossible.

	   Filter by ha.takeover_check.takeover_possible
	*/
	HaTakeoverCheckTakeoverPossible *bool

	/* HaType.

	   Filter by ha.type
	*/
	HaType *string

	/* HwAssistStatusEnabled.

	   Filter by hw_assist.status.enabled
	*/
	HwAssistStatusEnabled *bool

	/* HwAssistStatusLocalIP.

	   Filter by hw_assist.status.local.ip
	*/
	HwAssistStatusLocalIP *string

	/* HwAssistStatusLocalPort.

	   Filter by hw_assist.status.local.port
	*/
	HwAssistStatusLocalPort *int64

	/* HwAssistStatusLocalState.

	   Filter by hw_assist.status.local.state
	*/
	HwAssistStatusLocalState *string

	/* HwAssistStatusPartnerIP.

	   Filter by hw_assist.status.partner.ip
	*/
	HwAssistStatusPartnerIP *string

	/* HwAssistStatusPartnerPort.

	   Filter by hw_assist.status.partner.port
	*/
	HwAssistStatusPartnerPort *int64

	/* HwAssistStatusPartnerState.

	   Filter by hw_assist.status.partner.state
	*/
	HwAssistStatusPartnerState *string

	/* Info.

	   Info specification
	*/
	Info NodeDeleteCollectionBody

	/* IsSparesLow.

	   Filter by is_spares_low
	*/
	IsSparesLow *bool

	/* Location.

	   Filter by location
	*/
	Location *string

	/* ManagementInterfacesIPAddress.

	   Filter by management_interfaces.ip.address
	*/
	ManagementInterfacesIPAddress *string

	/* ManagementInterfacesName.

	   Filter by management_interfaces.name
	*/
	ManagementInterfacesName *string

	/* ManagementInterfacesUUID.

	   Filter by management_interfaces.uuid
	*/
	ManagementInterfacesUUID *string

	/* Membership.

	   Filter by membership
	*/
	Membership *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricProcessorUtilization.

	   Filter by metric.processor_utilization
	*/
	MetricProcessorUtilization *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* MetricUUID.

	   Filter by metric.uuid
	*/
	MetricUUID *string

	/* MetroclusterCustomVlanCapable.

	   Filter by metrocluster.custom_vlan_capable
	*/
	MetroclusterCustomVlanCapable *bool

	/* MetroclusterPortsName.

	   Filter by metrocluster.ports.name
	*/
	MetroclusterPortsName *string

	/* MetroclusterType.

	   Filter by metrocluster.type
	*/
	MetroclusterType *string

	/* Model.

	   Filter by model
	*/
	Model *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NvlogBackingType.

	   Filter by nvlog.backing_type
	*/
	NvlogBackingType *string

	/* NvlogSwapMode.

	   Filter by nvlog.swap_mode
	*/
	NvlogSwapMode *string

	/* NvramBatteryState.

	   Filter by nvram.battery_state
	*/
	NvramBatteryState *string

	/* NvramID.

	   Filter by nvram.id
	*/
	NvramID *int64

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ServiceProcessorAPIServiceEnabled.

	   Filter by service_processor.api_service.enabled
	*/
	ServiceProcessorAPIServiceEnabled *bool

	/* ServiceProcessorAPIServiceLimitAccess.

	   Filter by service_processor.api_service.limit_access
	*/
	ServiceProcessorAPIServiceLimitAccess *bool

	/* ServiceProcessorAPIServicePort.

	   Filter by service_processor.api_service.port
	*/
	ServiceProcessorAPIServicePort *int64

	/* ServiceProcessorAutoConfigIPV4Subnet.

	   Filter by service_processor.auto_config.ipv4_subnet
	*/
	ServiceProcessorAutoConfigIPV4Subnet *string

	/* ServiceProcessorAutoConfigIPV6Subnet.

	   Filter by service_processor.auto_config.ipv6_subnet
	*/
	ServiceProcessorAutoConfigIPV6Subnet *string

	/* ServiceProcessorAutoupdateEnabled.

	   Filter by service_processor.autoupdate_enabled
	*/
	ServiceProcessorAutoupdateEnabled *bool

	/* ServiceProcessorBackupIsCurrent.

	   Filter by service_processor.backup.is_current
	*/
	ServiceProcessorBackupIsCurrent *bool

	/* ServiceProcessorBackupState.

	   Filter by service_processor.backup.state
	*/
	ServiceProcessorBackupState *string

	/* ServiceProcessorBackupVersion.

	   Filter by service_processor.backup.version
	*/
	ServiceProcessorBackupVersion *string

	/* ServiceProcessorDhcpEnabled.

	   Filter by service_processor.dhcp_enabled
	*/
	ServiceProcessorDhcpEnabled *bool

	/* ServiceProcessorFirmwareVersion.

	   Filter by service_processor.firmware_version
	*/
	ServiceProcessorFirmwareVersion *string

	/* ServiceProcessorIPV4InterfaceAddress.

	   Filter by service_processor.ipv4_interface.address
	*/
	ServiceProcessorIPV4InterfaceAddress *string

	/* ServiceProcessorIPV4InterfaceEnabled.

	   Filter by service_processor.ipv4_interface.enabled
	*/
	ServiceProcessorIPV4InterfaceEnabled *bool

	/* ServiceProcessorIPV4InterfaceGateway.

	   Filter by service_processor.ipv4_interface.gateway
	*/
	ServiceProcessorIPV4InterfaceGateway *string

	/* ServiceProcessorIPV4InterfaceNetmask.

	   Filter by service_processor.ipv4_interface.netmask
	*/
	ServiceProcessorIPV4InterfaceNetmask *string

	/* ServiceProcessorIPV4InterfaceSetupState.

	   Filter by service_processor.ipv4_interface.setup_state
	*/
	ServiceProcessorIPV4InterfaceSetupState *string

	/* ServiceProcessorIPV6InterfaceAddress.

	   Filter by service_processor.ipv6_interface.address
	*/
	ServiceProcessorIPV6InterfaceAddress *string

	/* ServiceProcessorIPV6InterfaceEnabled.

	   Filter by service_processor.ipv6_interface.enabled
	*/
	ServiceProcessorIPV6InterfaceEnabled *bool

	/* ServiceProcessorIPV6InterfaceGateway.

	   Filter by service_processor.ipv6_interface.gateway
	*/
	ServiceProcessorIPV6InterfaceGateway *string

	/* ServiceProcessorIPV6InterfaceIsIPV6RaEnabled.

	   Filter by service_processor.ipv6_interface.is_ipv6_ra_enabled
	*/
	ServiceProcessorIPV6InterfaceIsIPV6RaEnabled *bool

	/* ServiceProcessorIPV6InterfaceLinkLocalIP.

	   Filter by service_processor.ipv6_interface.link_local_ip
	*/
	ServiceProcessorIPV6InterfaceLinkLocalIP *string

	/* ServiceProcessorIPV6InterfaceNetmask.

	   Filter by service_processor.ipv6_interface.netmask
	*/
	ServiceProcessorIPV6InterfaceNetmask *int64

	/* ServiceProcessorIPV6InterfaceRouterIP.

	   Filter by service_processor.ipv6_interface.router_ip
	*/
	ServiceProcessorIPV6InterfaceRouterIP *string

	/* ServiceProcessorIPV6InterfaceSetupState.

	   Filter by service_processor.ipv6_interface.setup_state
	*/
	ServiceProcessorIPV6InterfaceSetupState *string

	/* ServiceProcessorIsIPConfigured.

	   Filter by service_processor.is_ip_configured
	*/
	ServiceProcessorIsIPConfigured *bool

	/* ServiceProcessorLastUpdateState.

	   Filter by service_processor.last_update_state
	*/
	ServiceProcessorLastUpdateState *string

	/* ServiceProcessorLinkStatus.

	   Filter by service_processor.link_status
	*/
	ServiceProcessorLinkStatus *string

	/* ServiceProcessorMacAddress.

	   Filter by service_processor.mac_address
	*/
	ServiceProcessorMacAddress *string

	/* ServiceProcessorPrimaryIsCurrent.

	   Filter by service_processor.primary.is_current
	*/
	ServiceProcessorPrimaryIsCurrent *bool

	/* ServiceProcessorPrimaryState.

	   Filter by service_processor.primary.state
	*/
	ServiceProcessorPrimaryState *string

	/* ServiceProcessorPrimaryVersion.

	   Filter by service_processor.primary.version
	*/
	ServiceProcessorPrimaryVersion *string

	/* ServiceProcessorSSHInfoAllowedAddresses.

	   Filter by service_processor.ssh_info.allowed_addresses
	*/
	ServiceProcessorSSHInfoAllowedAddresses *string

	/* ServiceProcessorState.

	   Filter by service_processor.state
	*/
	ServiceProcessorState *string

	/* ServiceProcessorType.

	   Filter by service_processor.type
	*/
	ServiceProcessorType *string

	/* ServiceProcessorWebServiceEnabled.

	   Filter by service_processor.web_service.enabled
	*/
	ServiceProcessorWebServiceEnabled *bool

	/* ServiceProcessorWebServiceLimitAccess.

	   Filter by service_processor.web_service.limit_access
	*/
	ServiceProcessorWebServiceLimitAccess *bool

	/* SnaplockComplianceClockTime.

	   Filter by snaplock.compliance_clock_time
	*/
	SnaplockComplianceClockTime *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsProcessorUtilizationBase.

	   Filter by statistics.processor_utilization_base
	*/
	StatisticsProcessorUtilizationBase *int64

	/* StatisticsProcessorUtilizationRaw.

	   Filter by statistics.processor_utilization_raw
	*/
	StatisticsProcessorUtilizationRaw *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* StorageAvailabilityZonesName.

	   Filter by storage_availability_zones.name
	*/
	StorageAvailabilityZonesName *string

	/* StorageAvailabilityZonesUUID.

	   Filter by storage_availability_zones.uuid
	*/
	StorageAvailabilityZonesUUID *string

	/* StorageConfiguration.

	   Filter by storage_configuration
	*/
	StorageConfiguration *string

	/* SystemAggregateName.

	   Filter by system_aggregate.name
	*/
	SystemAggregateName *string

	/* SystemAggregateUUID.

	   Filter by system_aggregate.uuid
	*/
	SystemAggregateUUID *string

	/* SystemID.

	   Filter by system_id
	*/
	SystemID *string

	/* SystemMachineType.

	   Filter by system_machine_type
	*/
	SystemMachineType *string

	/* Uptime.

	   Filter by uptime
	*/
	Uptime *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VendorSerialNumber.

	   Filter by vendor_serial_number
	*/
	VendorSerialNumber *string

	/* VersionFull.

	   Filter by version.full
	*/
	VersionFull *string

	/* VersionGeneration.

	   Filter by version.generation
	*/
	VersionGeneration *int64

	/* VersionMajor.

	   Filter by version.major
	*/
	VersionMajor *int64

	/* VersionMinor.

	   Filter by version.minor
	*/
	VersionMinor *int64

	/* VMProviderType.

	   Filter by vm.provider_type
	*/
	VMProviderType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the node delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodeDeleteCollectionParams) WithDefaults() *NodeDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the node delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodeDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		forceDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NodeDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		Force:             &forceDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the node delete collection params
func (o *NodeDeleteCollectionParams) WithTimeout(timeout time.Duration) *NodeDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the node delete collection params
func (o *NodeDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the node delete collection params
func (o *NodeDeleteCollectionParams) WithContext(ctx context.Context) *NodeDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the node delete collection params
func (o *NodeDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHTTPClient(client *http.Client) *NodeDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAntiRansomwareVersion adds the antiRansomwareVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) WithAntiRansomwareVersion(antiRansomwareVersion *string) *NodeDeleteCollectionParams {
	o.SetAntiRansomwareVersion(antiRansomwareVersion)
	return o
}

// SetAntiRansomwareVersion adds the antiRansomwareVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) SetAntiRansomwareVersion(antiRansomwareVersion *string) {
	o.AntiRansomwareVersion = antiRansomwareVersion
}

// WithClusterInterfacesIPAddress adds the clusterInterfacesIPAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) WithClusterInterfacesIPAddress(clusterInterfacesIPAddress *string) *NodeDeleteCollectionParams {
	o.SetClusterInterfacesIPAddress(clusterInterfacesIPAddress)
	return o
}

// SetClusterInterfacesIPAddress adds the clusterInterfacesIpAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) SetClusterInterfacesIPAddress(clusterInterfacesIPAddress *string) {
	o.ClusterInterfacesIPAddress = clusterInterfacesIPAddress
}

// WithClusterInterfacesName adds the clusterInterfacesName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithClusterInterfacesName(clusterInterfacesName *string) *NodeDeleteCollectionParams {
	o.SetClusterInterfacesName(clusterInterfacesName)
	return o
}

// SetClusterInterfacesName adds the clusterInterfacesName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetClusterInterfacesName(clusterInterfacesName *string) {
	o.ClusterInterfacesName = clusterInterfacesName
}

// WithClusterInterfacesUUID adds the clusterInterfacesUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithClusterInterfacesUUID(clusterInterfacesUUID *string) *NodeDeleteCollectionParams {
	o.SetClusterInterfacesUUID(clusterInterfacesUUID)
	return o
}

// SetClusterInterfacesUUID adds the clusterInterfacesUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetClusterInterfacesUUID(clusterInterfacesUUID *string) {
	o.ClusterInterfacesUUID = clusterInterfacesUUID
}

// WithContinueOnFailure adds the continueOnFailure to the node delete collection params
func (o *NodeDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NodeDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the node delete collection params
func (o *NodeDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithControllerBoard adds the controllerBoard to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerBoard(controllerBoard *string) *NodeDeleteCollectionParams {
	o.SetControllerBoard(controllerBoard)
	return o
}

// SetControllerBoard adds the controllerBoard to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerBoard(controllerBoard *string) {
	o.ControllerBoard = controllerBoard
}

// WithControllerCPUCount adds the controllerCPUCount to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerCPUCount(controllerCPUCount *int64) *NodeDeleteCollectionParams {
	o.SetControllerCPUCount(controllerCPUCount)
	return o
}

// SetControllerCPUCount adds the controllerCpuCount to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerCPUCount(controllerCPUCount *int64) {
	o.ControllerCPUCount = controllerCPUCount
}

// WithControllerCPUFirmwareRelease adds the controllerCPUFirmwareRelease to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerCPUFirmwareRelease(controllerCPUFirmwareRelease *string) *NodeDeleteCollectionParams {
	o.SetControllerCPUFirmwareRelease(controllerCPUFirmwareRelease)
	return o
}

// SetControllerCPUFirmwareRelease adds the controllerCpuFirmwareRelease to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerCPUFirmwareRelease(controllerCPUFirmwareRelease *string) {
	o.ControllerCPUFirmwareRelease = controllerCPUFirmwareRelease
}

// WithControllerCPUProcessor adds the controllerCPUProcessor to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerCPUProcessor(controllerCPUProcessor *string) *NodeDeleteCollectionParams {
	o.SetControllerCPUProcessor(controllerCPUProcessor)
	return o
}

// SetControllerCPUProcessor adds the controllerCpuProcessor to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerCPUProcessor(controllerCPUProcessor *string) {
	o.ControllerCPUProcessor = controllerCPUProcessor
}

// WithControllerFailedFanCount adds the controllerFailedFanCount to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFailedFanCount(controllerFailedFanCount *int64) *NodeDeleteCollectionParams {
	o.SetControllerFailedFanCount(controllerFailedFanCount)
	return o
}

// SetControllerFailedFanCount adds the controllerFailedFanCount to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFailedFanCount(controllerFailedFanCount *int64) {
	o.ControllerFailedFanCount = controllerFailedFanCount
}

// WithControllerFailedFanMessageCode adds the controllerFailedFanMessageCode to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFailedFanMessageCode(controllerFailedFanMessageCode *string) *NodeDeleteCollectionParams {
	o.SetControllerFailedFanMessageCode(controllerFailedFanMessageCode)
	return o
}

// SetControllerFailedFanMessageCode adds the controllerFailedFanMessageCode to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFailedFanMessageCode(controllerFailedFanMessageCode *string) {
	o.ControllerFailedFanMessageCode = controllerFailedFanMessageCode
}

// WithControllerFailedFanMessageMessage adds the controllerFailedFanMessageMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFailedFanMessageMessage(controllerFailedFanMessageMessage *string) *NodeDeleteCollectionParams {
	o.SetControllerFailedFanMessageMessage(controllerFailedFanMessageMessage)
	return o
}

// SetControllerFailedFanMessageMessage adds the controllerFailedFanMessageMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFailedFanMessageMessage(controllerFailedFanMessageMessage *string) {
	o.ControllerFailedFanMessageMessage = controllerFailedFanMessageMessage
}

// WithControllerFailedPowerSupplyCount adds the controllerFailedPowerSupplyCount to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFailedPowerSupplyCount(controllerFailedPowerSupplyCount *int64) *NodeDeleteCollectionParams {
	o.SetControllerFailedPowerSupplyCount(controllerFailedPowerSupplyCount)
	return o
}

// SetControllerFailedPowerSupplyCount adds the controllerFailedPowerSupplyCount to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFailedPowerSupplyCount(controllerFailedPowerSupplyCount *int64) {
	o.ControllerFailedPowerSupplyCount = controllerFailedPowerSupplyCount
}

// WithControllerFailedPowerSupplyMessageCode adds the controllerFailedPowerSupplyMessageCode to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFailedPowerSupplyMessageCode(controllerFailedPowerSupplyMessageCode *string) *NodeDeleteCollectionParams {
	o.SetControllerFailedPowerSupplyMessageCode(controllerFailedPowerSupplyMessageCode)
	return o
}

// SetControllerFailedPowerSupplyMessageCode adds the controllerFailedPowerSupplyMessageCode to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFailedPowerSupplyMessageCode(controllerFailedPowerSupplyMessageCode *string) {
	o.ControllerFailedPowerSupplyMessageCode = controllerFailedPowerSupplyMessageCode
}

// WithControllerFailedPowerSupplyMessageMessage adds the controllerFailedPowerSupplyMessageMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFailedPowerSupplyMessageMessage(controllerFailedPowerSupplyMessageMessage *string) *NodeDeleteCollectionParams {
	o.SetControllerFailedPowerSupplyMessageMessage(controllerFailedPowerSupplyMessageMessage)
	return o
}

// SetControllerFailedPowerSupplyMessageMessage adds the controllerFailedPowerSupplyMessageMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFailedPowerSupplyMessageMessage(controllerFailedPowerSupplyMessageMessage *string) {
	o.ControllerFailedPowerSupplyMessageMessage = controllerFailedPowerSupplyMessageMessage
}

// WithControllerFlashCacheCapacity adds the controllerFlashCacheCapacity to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheCapacity(controllerFlashCacheCapacity *int64) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheCapacity(controllerFlashCacheCapacity)
	return o
}

// SetControllerFlashCacheCapacity adds the controllerFlashCacheCapacity to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheCapacity(controllerFlashCacheCapacity *int64) {
	o.ControllerFlashCacheCapacity = controllerFlashCacheCapacity
}

// WithControllerFlashCacheDeviceID adds the controllerFlashCacheDeviceID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheDeviceID(controllerFlashCacheDeviceID *int64) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheDeviceID(controllerFlashCacheDeviceID)
	return o
}

// SetControllerFlashCacheDeviceID adds the controllerFlashCacheDeviceId to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheDeviceID(controllerFlashCacheDeviceID *int64) {
	o.ControllerFlashCacheDeviceID = controllerFlashCacheDeviceID
}

// WithControllerFlashCacheFirmwareFile adds the controllerFlashCacheFirmwareFile to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheFirmwareFile(controllerFlashCacheFirmwareFile *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheFirmwareFile(controllerFlashCacheFirmwareFile)
	return o
}

// SetControllerFlashCacheFirmwareFile adds the controllerFlashCacheFirmwareFile to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheFirmwareFile(controllerFlashCacheFirmwareFile *string) {
	o.ControllerFlashCacheFirmwareFile = controllerFlashCacheFirmwareFile
}

// WithControllerFlashCacheFirmwareVersion adds the controllerFlashCacheFirmwareVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheFirmwareVersion(controllerFlashCacheFirmwareVersion *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheFirmwareVersion(controllerFlashCacheFirmwareVersion)
	return o
}

// SetControllerFlashCacheFirmwareVersion adds the controllerFlashCacheFirmwareVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheFirmwareVersion(controllerFlashCacheFirmwareVersion *string) {
	o.ControllerFlashCacheFirmwareVersion = controllerFlashCacheFirmwareVersion
}

// WithControllerFlashCacheHardwareRevision adds the controllerFlashCacheHardwareRevision to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheHardwareRevision(controllerFlashCacheHardwareRevision *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheHardwareRevision(controllerFlashCacheHardwareRevision)
	return o
}

// SetControllerFlashCacheHardwareRevision adds the controllerFlashCacheHardwareRevision to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheHardwareRevision(controllerFlashCacheHardwareRevision *string) {
	o.ControllerFlashCacheHardwareRevision = controllerFlashCacheHardwareRevision
}

// WithControllerFlashCacheModel adds the controllerFlashCacheModel to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheModel(controllerFlashCacheModel *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheModel(controllerFlashCacheModel)
	return o
}

// SetControllerFlashCacheModel adds the controllerFlashCacheModel to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheModel(controllerFlashCacheModel *string) {
	o.ControllerFlashCacheModel = controllerFlashCacheModel
}

// WithControllerFlashCachePartNumber adds the controllerFlashCachePartNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCachePartNumber(controllerFlashCachePartNumber *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCachePartNumber(controllerFlashCachePartNumber)
	return o
}

// SetControllerFlashCachePartNumber adds the controllerFlashCachePartNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCachePartNumber(controllerFlashCachePartNumber *string) {
	o.ControllerFlashCachePartNumber = controllerFlashCachePartNumber
}

// WithControllerFlashCacheSerialNumber adds the controllerFlashCacheSerialNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheSerialNumber(controllerFlashCacheSerialNumber *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheSerialNumber(controllerFlashCacheSerialNumber)
	return o
}

// SetControllerFlashCacheSerialNumber adds the controllerFlashCacheSerialNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheSerialNumber(controllerFlashCacheSerialNumber *string) {
	o.ControllerFlashCacheSerialNumber = controllerFlashCacheSerialNumber
}

// WithControllerFlashCacheSlot adds the controllerFlashCacheSlot to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheSlot(controllerFlashCacheSlot *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheSlot(controllerFlashCacheSlot)
	return o
}

// SetControllerFlashCacheSlot adds the controllerFlashCacheSlot to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheSlot(controllerFlashCacheSlot *string) {
	o.ControllerFlashCacheSlot = controllerFlashCacheSlot
}

// WithControllerFlashCacheState adds the controllerFlashCacheState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFlashCacheState(controllerFlashCacheState *string) *NodeDeleteCollectionParams {
	o.SetControllerFlashCacheState(controllerFlashCacheState)
	return o
}

// SetControllerFlashCacheState adds the controllerFlashCacheState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFlashCacheState(controllerFlashCacheState *string) {
	o.ControllerFlashCacheState = controllerFlashCacheState
}

// WithControllerFrusID adds the controllerFrusID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFrusID(controllerFrusID *string) *NodeDeleteCollectionParams {
	o.SetControllerFrusID(controllerFrusID)
	return o
}

// SetControllerFrusID adds the controllerFrusId to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFrusID(controllerFrusID *string) {
	o.ControllerFrusID = controllerFrusID
}

// WithControllerFrusState adds the controllerFrusState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFrusState(controllerFrusState *string) *NodeDeleteCollectionParams {
	o.SetControllerFrusState(controllerFrusState)
	return o
}

// SetControllerFrusState adds the controllerFrusState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFrusState(controllerFrusState *string) {
	o.ControllerFrusState = controllerFrusState
}

// WithControllerFrusType adds the controllerFrusType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerFrusType(controllerFrusType *string) *NodeDeleteCollectionParams {
	o.SetControllerFrusType(controllerFrusType)
	return o
}

// SetControllerFrusType adds the controllerFrusType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerFrusType(controllerFrusType *string) {
	o.ControllerFrusType = controllerFrusType
}

// WithControllerMemorySize adds the controllerMemorySize to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerMemorySize(controllerMemorySize *int64) *NodeDeleteCollectionParams {
	o.SetControllerMemorySize(controllerMemorySize)
	return o
}

// SetControllerMemorySize adds the controllerMemorySize to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerMemorySize(controllerMemorySize *int64) {
	o.ControllerMemorySize = controllerMemorySize
}

// WithControllerOverTemperature adds the controllerOverTemperature to the node delete collection params
func (o *NodeDeleteCollectionParams) WithControllerOverTemperature(controllerOverTemperature *string) *NodeDeleteCollectionParams {
	o.SetControllerOverTemperature(controllerOverTemperature)
	return o
}

// SetControllerOverTemperature adds the controllerOverTemperature to the node delete collection params
func (o *NodeDeleteCollectionParams) SetControllerOverTemperature(controllerOverTemperature *string) {
	o.ControllerOverTemperature = controllerOverTemperature
}

// WithDate adds the date to the node delete collection params
func (o *NodeDeleteCollectionParams) WithDate(date *string) *NodeDeleteCollectionParams {
	o.SetDate(date)
	return o
}

// SetDate adds the date to the node delete collection params
func (o *NodeDeleteCollectionParams) SetDate(date *string) {
	o.Date = date
}

// WithExternalCacheIsEnabled adds the externalCacheIsEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithExternalCacheIsEnabled(externalCacheIsEnabled *bool) *NodeDeleteCollectionParams {
	o.SetExternalCacheIsEnabled(externalCacheIsEnabled)
	return o
}

// SetExternalCacheIsEnabled adds the externalCacheIsEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetExternalCacheIsEnabled(externalCacheIsEnabled *bool) {
	o.ExternalCacheIsEnabled = externalCacheIsEnabled
}

// WithExternalCacheIsHyaEnabled adds the externalCacheIsHyaEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithExternalCacheIsHyaEnabled(externalCacheIsHyaEnabled *bool) *NodeDeleteCollectionParams {
	o.SetExternalCacheIsHyaEnabled(externalCacheIsHyaEnabled)
	return o
}

// SetExternalCacheIsHyaEnabled adds the externalCacheIsHyaEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetExternalCacheIsHyaEnabled(externalCacheIsHyaEnabled *bool) {
	o.ExternalCacheIsHyaEnabled = externalCacheIsHyaEnabled
}

// WithExternalCacheIsRewarmEnabled adds the externalCacheIsRewarmEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithExternalCacheIsRewarmEnabled(externalCacheIsRewarmEnabled *bool) *NodeDeleteCollectionParams {
	o.SetExternalCacheIsRewarmEnabled(externalCacheIsRewarmEnabled)
	return o
}

// SetExternalCacheIsRewarmEnabled adds the externalCacheIsRewarmEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetExternalCacheIsRewarmEnabled(externalCacheIsRewarmEnabled *bool) {
	o.ExternalCacheIsRewarmEnabled = externalCacheIsRewarmEnabled
}

// WithExternalCachePcsSize adds the externalCachePcsSize to the node delete collection params
func (o *NodeDeleteCollectionParams) WithExternalCachePcsSize(externalCachePcsSize *int64) *NodeDeleteCollectionParams {
	o.SetExternalCachePcsSize(externalCachePcsSize)
	return o
}

// SetExternalCachePcsSize adds the externalCachePcsSize to the node delete collection params
func (o *NodeDeleteCollectionParams) SetExternalCachePcsSize(externalCachePcsSize *int64) {
	o.ExternalCachePcsSize = externalCachePcsSize
}

// WithExternalCacheBypassEnabled adds the externalCacheBypassEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithExternalCacheBypassEnabled(externalCacheBypassEnabled *bool) *NodeDeleteCollectionParams {
	o.SetExternalCacheBypassEnabled(externalCacheBypassEnabled)
	return o
}

// SetExternalCacheBypassEnabled adds the externalCacheBypassEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetExternalCacheBypassEnabled(externalCacheBypassEnabled *bool) {
	o.ExternalCacheBypassEnabled = externalCacheBypassEnabled
}

// WithExternalCacheBypassLargeReadOpsAllowPercent adds the externalCacheBypassLargeReadOpsAllowPercent to the node delete collection params
func (o *NodeDeleteCollectionParams) WithExternalCacheBypassLargeReadOpsAllowPercent(externalCacheBypassLargeReadOpsAllowPercent *int64) *NodeDeleteCollectionParams {
	o.SetExternalCacheBypassLargeReadOpsAllowPercent(externalCacheBypassLargeReadOpsAllowPercent)
	return o
}

// SetExternalCacheBypassLargeReadOpsAllowPercent adds the externalCacheBypassLargeReadOpsAllowPercent to the node delete collection params
func (o *NodeDeleteCollectionParams) SetExternalCacheBypassLargeReadOpsAllowPercent(externalCacheBypassLargeReadOpsAllowPercent *int64) {
	o.ExternalCacheBypassLargeReadOpsAllowPercent = externalCacheBypassLargeReadOpsAllowPercent
}

// WithForce adds the force to the node delete collection params
func (o *NodeDeleteCollectionParams) WithForce(force *bool) *NodeDeleteCollectionParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the node delete collection params
func (o *NodeDeleteCollectionParams) SetForce(force *bool) {
	o.Force = force
}

// WithHaAutoGiveback adds the haAutoGiveback to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaAutoGiveback(haAutoGiveback *bool) *NodeDeleteCollectionParams {
	o.SetHaAutoGiveback(haAutoGiveback)
	return o
}

// SetHaAutoGiveback adds the haAutoGiveback to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaAutoGiveback(haAutoGiveback *bool) {
	o.HaAutoGiveback = haAutoGiveback
}

// WithHaAutoGivebackOf adds the haAutoGivebackOf to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaAutoGivebackOf(haAutoGivebackOf *bool) *NodeDeleteCollectionParams {
	o.SetHaAutoGivebackOf(haAutoGivebackOf)
	return o
}

// SetHaAutoGivebackOf adds the haAutoGivebackOf to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaAutoGivebackOf(haAutoGivebackOf *bool) {
	o.HaAutoGivebackOf = haAutoGivebackOf
}

// WithHaEnableTakeoverOf adds the haEnableTakeoverOf to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaEnableTakeoverOf(haEnableTakeoverOf *bool) *NodeDeleteCollectionParams {
	o.SetHaEnableTakeoverOf(haEnableTakeoverOf)
	return o
}

// SetHaEnableTakeoverOf adds the haEnableTakeoverOf to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaEnableTakeoverOf(haEnableTakeoverOf *bool) {
	o.HaEnableTakeoverOf = haEnableTakeoverOf
}

// WithHaEnabled adds the haEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaEnabled(haEnabled *bool) *NodeDeleteCollectionParams {
	o.SetHaEnabled(haEnabled)
	return o
}

// SetHaEnabled adds the haEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaEnabled(haEnabled *bool) {
	o.HaEnabled = haEnabled
}

// WithHaGivebackFailureCode adds the haGivebackFailureCode to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackFailureCode(haGivebackFailureCode *int64) *NodeDeleteCollectionParams {
	o.SetHaGivebackFailureCode(haGivebackFailureCode)
	return o
}

// SetHaGivebackFailureCode adds the haGivebackFailureCode to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackFailureCode(haGivebackFailureCode *int64) {
	o.HaGivebackFailureCode = haGivebackFailureCode
}

// WithHaGivebackFailureMessage adds the haGivebackFailureMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackFailureMessage(haGivebackFailureMessage *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackFailureMessage(haGivebackFailureMessage)
	return o
}

// SetHaGivebackFailureMessage adds the haGivebackFailureMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackFailureMessage(haGivebackFailureMessage *string) {
	o.HaGivebackFailureMessage = haGivebackFailureMessage
}

// WithHaGivebackState adds the haGivebackState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackState(haGivebackState *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackState(haGivebackState)
	return o
}

// SetHaGivebackState adds the haGivebackState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackState(haGivebackState *string) {
	o.HaGivebackState = haGivebackState
}

// WithHaGivebackStatusAggregateName adds the haGivebackStatusAggregateName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackStatusAggregateName(haGivebackStatusAggregateName *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackStatusAggregateName(haGivebackStatusAggregateName)
	return o
}

// SetHaGivebackStatusAggregateName adds the haGivebackStatusAggregateName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackStatusAggregateName(haGivebackStatusAggregateName *string) {
	o.HaGivebackStatusAggregateName = haGivebackStatusAggregateName
}

// WithHaGivebackStatusAggregateUUID adds the haGivebackStatusAggregateUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackStatusAggregateUUID(haGivebackStatusAggregateUUID *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackStatusAggregateUUID(haGivebackStatusAggregateUUID)
	return o
}

// SetHaGivebackStatusAggregateUUID adds the haGivebackStatusAggregateUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackStatusAggregateUUID(haGivebackStatusAggregateUUID *string) {
	o.HaGivebackStatusAggregateUUID = haGivebackStatusAggregateUUID
}

// WithHaGivebackStatusErrorCode adds the haGivebackStatusErrorCode to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackStatusErrorCode(haGivebackStatusErrorCode *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackStatusErrorCode(haGivebackStatusErrorCode)
	return o
}

// SetHaGivebackStatusErrorCode adds the haGivebackStatusErrorCode to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackStatusErrorCode(haGivebackStatusErrorCode *string) {
	o.HaGivebackStatusErrorCode = haGivebackStatusErrorCode
}

// WithHaGivebackStatusErrorMessage adds the haGivebackStatusErrorMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackStatusErrorMessage(haGivebackStatusErrorMessage *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackStatusErrorMessage(haGivebackStatusErrorMessage)
	return o
}

// SetHaGivebackStatusErrorMessage adds the haGivebackStatusErrorMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackStatusErrorMessage(haGivebackStatusErrorMessage *string) {
	o.HaGivebackStatusErrorMessage = haGivebackStatusErrorMessage
}

// WithHaGivebackStatusState adds the haGivebackStatusState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaGivebackStatusState(haGivebackStatusState *string) *NodeDeleteCollectionParams {
	o.SetHaGivebackStatusState(haGivebackStatusState)
	return o
}

// SetHaGivebackStatusState adds the haGivebackStatusState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaGivebackStatusState(haGivebackStatusState *string) {
	o.HaGivebackStatusState = haGivebackStatusState
}

// WithHaInterconnectAdapter adds the haInterconnectAdapter to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaInterconnectAdapter(haInterconnectAdapter *string) *NodeDeleteCollectionParams {
	o.SetHaInterconnectAdapter(haInterconnectAdapter)
	return o
}

// SetHaInterconnectAdapter adds the haInterconnectAdapter to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaInterconnectAdapter(haInterconnectAdapter *string) {
	o.HaInterconnectAdapter = haInterconnectAdapter
}

// WithHaInterconnectState adds the haInterconnectState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaInterconnectState(haInterconnectState *string) *NodeDeleteCollectionParams {
	o.SetHaInterconnectState(haInterconnectState)
	return o
}

// SetHaInterconnectState adds the haInterconnectState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaInterconnectState(haInterconnectState *string) {
	o.HaInterconnectState = haInterconnectState
}

// WithHaPartnersName adds the haPartnersName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaPartnersName(haPartnersName *string) *NodeDeleteCollectionParams {
	o.SetHaPartnersName(haPartnersName)
	return o
}

// SetHaPartnersName adds the haPartnersName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaPartnersName(haPartnersName *string) {
	o.HaPartnersName = haPartnersName
}

// WithHaPartnersUUID adds the haPartnersUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaPartnersUUID(haPartnersUUID *string) *NodeDeleteCollectionParams {
	o.SetHaPartnersUUID(haPartnersUUID)
	return o
}

// SetHaPartnersUUID adds the haPartnersUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaPartnersUUID(haPartnersUUID *string) {
	o.HaPartnersUUID = haPartnersUUID
}

// WithHaPortsNumber adds the haPortsNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaPortsNumber(haPortsNumber *int64) *NodeDeleteCollectionParams {
	o.SetHaPortsNumber(haPortsNumber)
	return o
}

// SetHaPortsNumber adds the haPortsNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaPortsNumber(haPortsNumber *int64) {
	o.HaPortsNumber = haPortsNumber
}

// WithHaPortsState adds the haPortsState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaPortsState(haPortsState *string) *NodeDeleteCollectionParams {
	o.SetHaPortsState(haPortsState)
	return o
}

// SetHaPortsState adds the haPortsState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaPortsState(haPortsState *string) {
	o.HaPortsState = haPortsState
}

// WithHaTakeoverFailureCode adds the haTakeoverFailureCode to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaTakeoverFailureCode(haTakeoverFailureCode *int64) *NodeDeleteCollectionParams {
	o.SetHaTakeoverFailureCode(haTakeoverFailureCode)
	return o
}

// SetHaTakeoverFailureCode adds the haTakeoverFailureCode to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaTakeoverFailureCode(haTakeoverFailureCode *int64) {
	o.HaTakeoverFailureCode = haTakeoverFailureCode
}

// WithHaTakeoverFailureMessage adds the haTakeoverFailureMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaTakeoverFailureMessage(haTakeoverFailureMessage *string) *NodeDeleteCollectionParams {
	o.SetHaTakeoverFailureMessage(haTakeoverFailureMessage)
	return o
}

// SetHaTakeoverFailureMessage adds the haTakeoverFailureMessage to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaTakeoverFailureMessage(haTakeoverFailureMessage *string) {
	o.HaTakeoverFailureMessage = haTakeoverFailureMessage
}

// WithHaTakeoverState adds the haTakeoverState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaTakeoverState(haTakeoverState *string) *NodeDeleteCollectionParams {
	o.SetHaTakeoverState(haTakeoverState)
	return o
}

// SetHaTakeoverState adds the haTakeoverState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaTakeoverState(haTakeoverState *string) {
	o.HaTakeoverState = haTakeoverState
}

// WithHaTakeoverCheckReasons adds the haTakeoverCheckReasons to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaTakeoverCheckReasons(haTakeoverCheckReasons *string) *NodeDeleteCollectionParams {
	o.SetHaTakeoverCheckReasons(haTakeoverCheckReasons)
	return o
}

// SetHaTakeoverCheckReasons adds the haTakeoverCheckReasons to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaTakeoverCheckReasons(haTakeoverCheckReasons *string) {
	o.HaTakeoverCheckReasons = haTakeoverCheckReasons
}

// WithHaTakeoverCheckTakeoverPossible adds the haTakeoverCheckTakeoverPossible to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaTakeoverCheckTakeoverPossible(haTakeoverCheckTakeoverPossible *bool) *NodeDeleteCollectionParams {
	o.SetHaTakeoverCheckTakeoverPossible(haTakeoverCheckTakeoverPossible)
	return o
}

// SetHaTakeoverCheckTakeoverPossible adds the haTakeoverCheckTakeoverPossible to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaTakeoverCheckTakeoverPossible(haTakeoverCheckTakeoverPossible *bool) {
	o.HaTakeoverCheckTakeoverPossible = haTakeoverCheckTakeoverPossible
}

// WithHaType adds the haType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHaType(haType *string) *NodeDeleteCollectionParams {
	o.SetHaType(haType)
	return o
}

// SetHaType adds the haType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHaType(haType *string) {
	o.HaType = haType
}

// WithHwAssistStatusEnabled adds the hwAssistStatusEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusEnabled(hwAssistStatusEnabled *bool) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusEnabled(hwAssistStatusEnabled)
	return o
}

// SetHwAssistStatusEnabled adds the hwAssistStatusEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusEnabled(hwAssistStatusEnabled *bool) {
	o.HwAssistStatusEnabled = hwAssistStatusEnabled
}

// WithHwAssistStatusLocalIP adds the hwAssistStatusLocalIP to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusLocalIP(hwAssistStatusLocalIP *string) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusLocalIP(hwAssistStatusLocalIP)
	return o
}

// SetHwAssistStatusLocalIP adds the hwAssistStatusLocalIp to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusLocalIP(hwAssistStatusLocalIP *string) {
	o.HwAssistStatusLocalIP = hwAssistStatusLocalIP
}

// WithHwAssistStatusLocalPort adds the hwAssistStatusLocalPort to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusLocalPort(hwAssistStatusLocalPort *int64) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusLocalPort(hwAssistStatusLocalPort)
	return o
}

// SetHwAssistStatusLocalPort adds the hwAssistStatusLocalPort to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusLocalPort(hwAssistStatusLocalPort *int64) {
	o.HwAssistStatusLocalPort = hwAssistStatusLocalPort
}

// WithHwAssistStatusLocalState adds the hwAssistStatusLocalState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusLocalState(hwAssistStatusLocalState *string) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusLocalState(hwAssistStatusLocalState)
	return o
}

// SetHwAssistStatusLocalState adds the hwAssistStatusLocalState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusLocalState(hwAssistStatusLocalState *string) {
	o.HwAssistStatusLocalState = hwAssistStatusLocalState
}

// WithHwAssistStatusPartnerIP adds the hwAssistStatusPartnerIP to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusPartnerIP(hwAssistStatusPartnerIP *string) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusPartnerIP(hwAssistStatusPartnerIP)
	return o
}

// SetHwAssistStatusPartnerIP adds the hwAssistStatusPartnerIp to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusPartnerIP(hwAssistStatusPartnerIP *string) {
	o.HwAssistStatusPartnerIP = hwAssistStatusPartnerIP
}

// WithHwAssistStatusPartnerPort adds the hwAssistStatusPartnerPort to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusPartnerPort(hwAssistStatusPartnerPort *int64) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusPartnerPort(hwAssistStatusPartnerPort)
	return o
}

// SetHwAssistStatusPartnerPort adds the hwAssistStatusPartnerPort to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusPartnerPort(hwAssistStatusPartnerPort *int64) {
	o.HwAssistStatusPartnerPort = hwAssistStatusPartnerPort
}

// WithHwAssistStatusPartnerState adds the hwAssistStatusPartnerState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithHwAssistStatusPartnerState(hwAssistStatusPartnerState *string) *NodeDeleteCollectionParams {
	o.SetHwAssistStatusPartnerState(hwAssistStatusPartnerState)
	return o
}

// SetHwAssistStatusPartnerState adds the hwAssistStatusPartnerState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetHwAssistStatusPartnerState(hwAssistStatusPartnerState *string) {
	o.HwAssistStatusPartnerState = hwAssistStatusPartnerState
}

// WithInfo adds the info to the node delete collection params
func (o *NodeDeleteCollectionParams) WithInfo(info NodeDeleteCollectionBody) *NodeDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the node delete collection params
func (o *NodeDeleteCollectionParams) SetInfo(info NodeDeleteCollectionBody) {
	o.Info = info
}

// WithIsSparesLow adds the isSparesLow to the node delete collection params
func (o *NodeDeleteCollectionParams) WithIsSparesLow(isSparesLow *bool) *NodeDeleteCollectionParams {
	o.SetIsSparesLow(isSparesLow)
	return o
}

// SetIsSparesLow adds the isSparesLow to the node delete collection params
func (o *NodeDeleteCollectionParams) SetIsSparesLow(isSparesLow *bool) {
	o.IsSparesLow = isSparesLow
}

// WithLocation adds the location to the node delete collection params
func (o *NodeDeleteCollectionParams) WithLocation(location *string) *NodeDeleteCollectionParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the node delete collection params
func (o *NodeDeleteCollectionParams) SetLocation(location *string) {
	o.Location = location
}

// WithManagementInterfacesIPAddress adds the managementInterfacesIPAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) WithManagementInterfacesIPAddress(managementInterfacesIPAddress *string) *NodeDeleteCollectionParams {
	o.SetManagementInterfacesIPAddress(managementInterfacesIPAddress)
	return o
}

// SetManagementInterfacesIPAddress adds the managementInterfacesIpAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) SetManagementInterfacesIPAddress(managementInterfacesIPAddress *string) {
	o.ManagementInterfacesIPAddress = managementInterfacesIPAddress
}

// WithManagementInterfacesName adds the managementInterfacesName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithManagementInterfacesName(managementInterfacesName *string) *NodeDeleteCollectionParams {
	o.SetManagementInterfacesName(managementInterfacesName)
	return o
}

// SetManagementInterfacesName adds the managementInterfacesName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetManagementInterfacesName(managementInterfacesName *string) {
	o.ManagementInterfacesName = managementInterfacesName
}

// WithManagementInterfacesUUID adds the managementInterfacesUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithManagementInterfacesUUID(managementInterfacesUUID *string) *NodeDeleteCollectionParams {
	o.SetManagementInterfacesUUID(managementInterfacesUUID)
	return o
}

// SetManagementInterfacesUUID adds the managementInterfacesUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetManagementInterfacesUUID(managementInterfacesUUID *string) {
	o.ManagementInterfacesUUID = managementInterfacesUUID
}

// WithMembership adds the membership to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMembership(membership *string) *NodeDeleteCollectionParams {
	o.SetMembership(membership)
	return o
}

// SetMembership adds the membership to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMembership(membership *string) {
	o.Membership = membership
}

// WithMetricDuration adds the metricDuration to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetricDuration(metricDuration *string) *NodeDeleteCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricProcessorUtilization adds the metricProcessorUtilization to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetricProcessorUtilization(metricProcessorUtilization *int64) *NodeDeleteCollectionParams {
	o.SetMetricProcessorUtilization(metricProcessorUtilization)
	return o
}

// SetMetricProcessorUtilization adds the metricProcessorUtilization to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetricProcessorUtilization(metricProcessorUtilization *int64) {
	o.MetricProcessorUtilization = metricProcessorUtilization
}

// WithMetricStatus adds the metricStatus to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetricStatus(metricStatus *string) *NodeDeleteCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricTimestamp adds the metricTimestamp to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetricTimestamp(metricTimestamp *string) *NodeDeleteCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMetricUUID adds the metricUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetricUUID(metricUUID *string) *NodeDeleteCollectionParams {
	o.SetMetricUUID(metricUUID)
	return o
}

// SetMetricUUID adds the metricUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetricUUID(metricUUID *string) {
	o.MetricUUID = metricUUID
}

// WithMetroclusterCustomVlanCapable adds the metroclusterCustomVlanCapable to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetroclusterCustomVlanCapable(metroclusterCustomVlanCapable *bool) *NodeDeleteCollectionParams {
	o.SetMetroclusterCustomVlanCapable(metroclusterCustomVlanCapable)
	return o
}

// SetMetroclusterCustomVlanCapable adds the metroclusterCustomVlanCapable to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetroclusterCustomVlanCapable(metroclusterCustomVlanCapable *bool) {
	o.MetroclusterCustomVlanCapable = metroclusterCustomVlanCapable
}

// WithMetroclusterPortsName adds the metroclusterPortsName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetroclusterPortsName(metroclusterPortsName *string) *NodeDeleteCollectionParams {
	o.SetMetroclusterPortsName(metroclusterPortsName)
	return o
}

// SetMetroclusterPortsName adds the metroclusterPortsName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetroclusterPortsName(metroclusterPortsName *string) {
	o.MetroclusterPortsName = metroclusterPortsName
}

// WithMetroclusterType adds the metroclusterType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithMetroclusterType(metroclusterType *string) *NodeDeleteCollectionParams {
	o.SetMetroclusterType(metroclusterType)
	return o
}

// SetMetroclusterType adds the metroclusterType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetMetroclusterType(metroclusterType *string) {
	o.MetroclusterType = metroclusterType
}

// WithModel adds the model to the node delete collection params
func (o *NodeDeleteCollectionParams) WithModel(model *string) *NodeDeleteCollectionParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the node delete collection params
func (o *NodeDeleteCollectionParams) SetModel(model *string) {
	o.Model = model
}

// WithName adds the name to the node delete collection params
func (o *NodeDeleteCollectionParams) WithName(name *string) *NodeDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the node delete collection params
func (o *NodeDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNvlogBackingType adds the nvlogBackingType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithNvlogBackingType(nvlogBackingType *string) *NodeDeleteCollectionParams {
	o.SetNvlogBackingType(nvlogBackingType)
	return o
}

// SetNvlogBackingType adds the nvlogBackingType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetNvlogBackingType(nvlogBackingType *string) {
	o.NvlogBackingType = nvlogBackingType
}

// WithNvlogSwapMode adds the nvlogSwapMode to the node delete collection params
func (o *NodeDeleteCollectionParams) WithNvlogSwapMode(nvlogSwapMode *string) *NodeDeleteCollectionParams {
	o.SetNvlogSwapMode(nvlogSwapMode)
	return o
}

// SetNvlogSwapMode adds the nvlogSwapMode to the node delete collection params
func (o *NodeDeleteCollectionParams) SetNvlogSwapMode(nvlogSwapMode *string) {
	o.NvlogSwapMode = nvlogSwapMode
}

// WithNvramBatteryState adds the nvramBatteryState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithNvramBatteryState(nvramBatteryState *string) *NodeDeleteCollectionParams {
	o.SetNvramBatteryState(nvramBatteryState)
	return o
}

// SetNvramBatteryState adds the nvramBatteryState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetNvramBatteryState(nvramBatteryState *string) {
	o.NvramBatteryState = nvramBatteryState
}

// WithNvramID adds the nvramID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithNvramID(nvramID *int64) *NodeDeleteCollectionParams {
	o.SetNvramID(nvramID)
	return o
}

// SetNvramID adds the nvramId to the node delete collection params
func (o *NodeDeleteCollectionParams) SetNvramID(nvramID *int64) {
	o.NvramID = nvramID
}

// WithOwner adds the owner to the node delete collection params
func (o *NodeDeleteCollectionParams) WithOwner(owner *string) *NodeDeleteCollectionParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the node delete collection params
func (o *NodeDeleteCollectionParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithReturnRecords adds the returnRecords to the node delete collection params
func (o *NodeDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *NodeDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the node delete collection params
func (o *NodeDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the node delete collection params
func (o *NodeDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *NodeDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the node delete collection params
func (o *NodeDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSerialNumber(serialNumber *string) *NodeDeleteCollectionParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithSerialRecords adds the serialRecords to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *NodeDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServiceProcessorAPIServiceEnabled adds the serviceProcessorAPIServiceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorAPIServiceEnabled(serviceProcessorAPIServiceEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorAPIServiceEnabled(serviceProcessorAPIServiceEnabled)
	return o
}

// SetServiceProcessorAPIServiceEnabled adds the serviceProcessorApiServiceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorAPIServiceEnabled(serviceProcessorAPIServiceEnabled *bool) {
	o.ServiceProcessorAPIServiceEnabled = serviceProcessorAPIServiceEnabled
}

// WithServiceProcessorAPIServiceLimitAccess adds the serviceProcessorAPIServiceLimitAccess to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorAPIServiceLimitAccess(serviceProcessorAPIServiceLimitAccess *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorAPIServiceLimitAccess(serviceProcessorAPIServiceLimitAccess)
	return o
}

// SetServiceProcessorAPIServiceLimitAccess adds the serviceProcessorApiServiceLimitAccess to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorAPIServiceLimitAccess(serviceProcessorAPIServiceLimitAccess *bool) {
	o.ServiceProcessorAPIServiceLimitAccess = serviceProcessorAPIServiceLimitAccess
}

// WithServiceProcessorAPIServicePort adds the serviceProcessorAPIServicePort to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorAPIServicePort(serviceProcessorAPIServicePort *int64) *NodeDeleteCollectionParams {
	o.SetServiceProcessorAPIServicePort(serviceProcessorAPIServicePort)
	return o
}

// SetServiceProcessorAPIServicePort adds the serviceProcessorApiServicePort to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorAPIServicePort(serviceProcessorAPIServicePort *int64) {
	o.ServiceProcessorAPIServicePort = serviceProcessorAPIServicePort
}

// WithServiceProcessorAutoConfigIPV4Subnet adds the serviceProcessorAutoConfigIPV4Subnet to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorAutoConfigIPV4Subnet(serviceProcessorAutoConfigIPV4Subnet *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorAutoConfigIPV4Subnet(serviceProcessorAutoConfigIPV4Subnet)
	return o
}

// SetServiceProcessorAutoConfigIPV4Subnet adds the serviceProcessorAutoConfigIpv4Subnet to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorAutoConfigIPV4Subnet(serviceProcessorAutoConfigIPV4Subnet *string) {
	o.ServiceProcessorAutoConfigIPV4Subnet = serviceProcessorAutoConfigIPV4Subnet
}

// WithServiceProcessorAutoConfigIPV6Subnet adds the serviceProcessorAutoConfigIPV6Subnet to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorAutoConfigIPV6Subnet(serviceProcessorAutoConfigIPV6Subnet *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorAutoConfigIPV6Subnet(serviceProcessorAutoConfigIPV6Subnet)
	return o
}

// SetServiceProcessorAutoConfigIPV6Subnet adds the serviceProcessorAutoConfigIpv6Subnet to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorAutoConfigIPV6Subnet(serviceProcessorAutoConfigIPV6Subnet *string) {
	o.ServiceProcessorAutoConfigIPV6Subnet = serviceProcessorAutoConfigIPV6Subnet
}

// WithServiceProcessorAutoupdateEnabled adds the serviceProcessorAutoupdateEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorAutoupdateEnabled(serviceProcessorAutoupdateEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorAutoupdateEnabled(serviceProcessorAutoupdateEnabled)
	return o
}

// SetServiceProcessorAutoupdateEnabled adds the serviceProcessorAutoupdateEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorAutoupdateEnabled(serviceProcessorAutoupdateEnabled *bool) {
	o.ServiceProcessorAutoupdateEnabled = serviceProcessorAutoupdateEnabled
}

// WithServiceProcessorBackupIsCurrent adds the serviceProcessorBackupIsCurrent to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorBackupIsCurrent(serviceProcessorBackupIsCurrent *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorBackupIsCurrent(serviceProcessorBackupIsCurrent)
	return o
}

// SetServiceProcessorBackupIsCurrent adds the serviceProcessorBackupIsCurrent to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorBackupIsCurrent(serviceProcessorBackupIsCurrent *bool) {
	o.ServiceProcessorBackupIsCurrent = serviceProcessorBackupIsCurrent
}

// WithServiceProcessorBackupState adds the serviceProcessorBackupState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorBackupState(serviceProcessorBackupState *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorBackupState(serviceProcessorBackupState)
	return o
}

// SetServiceProcessorBackupState adds the serviceProcessorBackupState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorBackupState(serviceProcessorBackupState *string) {
	o.ServiceProcessorBackupState = serviceProcessorBackupState
}

// WithServiceProcessorBackupVersion adds the serviceProcessorBackupVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorBackupVersion(serviceProcessorBackupVersion *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorBackupVersion(serviceProcessorBackupVersion)
	return o
}

// SetServiceProcessorBackupVersion adds the serviceProcessorBackupVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorBackupVersion(serviceProcessorBackupVersion *string) {
	o.ServiceProcessorBackupVersion = serviceProcessorBackupVersion
}

// WithServiceProcessorDhcpEnabled adds the serviceProcessorDhcpEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorDhcpEnabled(serviceProcessorDhcpEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorDhcpEnabled(serviceProcessorDhcpEnabled)
	return o
}

// SetServiceProcessorDhcpEnabled adds the serviceProcessorDhcpEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorDhcpEnabled(serviceProcessorDhcpEnabled *bool) {
	o.ServiceProcessorDhcpEnabled = serviceProcessorDhcpEnabled
}

// WithServiceProcessorFirmwareVersion adds the serviceProcessorFirmwareVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorFirmwareVersion(serviceProcessorFirmwareVersion *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorFirmwareVersion(serviceProcessorFirmwareVersion)
	return o
}

// SetServiceProcessorFirmwareVersion adds the serviceProcessorFirmwareVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorFirmwareVersion(serviceProcessorFirmwareVersion *string) {
	o.ServiceProcessorFirmwareVersion = serviceProcessorFirmwareVersion
}

// WithServiceProcessorIPV4InterfaceAddress adds the serviceProcessorIPV4InterfaceAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV4InterfaceAddress(serviceProcessorIPV4InterfaceAddress *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV4InterfaceAddress(serviceProcessorIPV4InterfaceAddress)
	return o
}

// SetServiceProcessorIPV4InterfaceAddress adds the serviceProcessorIpv4InterfaceAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV4InterfaceAddress(serviceProcessorIPV4InterfaceAddress *string) {
	o.ServiceProcessorIPV4InterfaceAddress = serviceProcessorIPV4InterfaceAddress
}

// WithServiceProcessorIPV4InterfaceEnabled adds the serviceProcessorIPV4InterfaceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV4InterfaceEnabled(serviceProcessorIPV4InterfaceEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV4InterfaceEnabled(serviceProcessorIPV4InterfaceEnabled)
	return o
}

// SetServiceProcessorIPV4InterfaceEnabled adds the serviceProcessorIpv4InterfaceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV4InterfaceEnabled(serviceProcessorIPV4InterfaceEnabled *bool) {
	o.ServiceProcessorIPV4InterfaceEnabled = serviceProcessorIPV4InterfaceEnabled
}

// WithServiceProcessorIPV4InterfaceGateway adds the serviceProcessorIPV4InterfaceGateway to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV4InterfaceGateway(serviceProcessorIPV4InterfaceGateway *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV4InterfaceGateway(serviceProcessorIPV4InterfaceGateway)
	return o
}

// SetServiceProcessorIPV4InterfaceGateway adds the serviceProcessorIpv4InterfaceGateway to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV4InterfaceGateway(serviceProcessorIPV4InterfaceGateway *string) {
	o.ServiceProcessorIPV4InterfaceGateway = serviceProcessorIPV4InterfaceGateway
}

// WithServiceProcessorIPV4InterfaceNetmask adds the serviceProcessorIPV4InterfaceNetmask to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV4InterfaceNetmask(serviceProcessorIPV4InterfaceNetmask *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV4InterfaceNetmask(serviceProcessorIPV4InterfaceNetmask)
	return o
}

// SetServiceProcessorIPV4InterfaceNetmask adds the serviceProcessorIpv4InterfaceNetmask to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV4InterfaceNetmask(serviceProcessorIPV4InterfaceNetmask *string) {
	o.ServiceProcessorIPV4InterfaceNetmask = serviceProcessorIPV4InterfaceNetmask
}

// WithServiceProcessorIPV4InterfaceSetupState adds the serviceProcessorIPV4InterfaceSetupState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV4InterfaceSetupState(serviceProcessorIPV4InterfaceSetupState *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV4InterfaceSetupState(serviceProcessorIPV4InterfaceSetupState)
	return o
}

// SetServiceProcessorIPV4InterfaceSetupState adds the serviceProcessorIpv4InterfaceSetupState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV4InterfaceSetupState(serviceProcessorIPV4InterfaceSetupState *string) {
	o.ServiceProcessorIPV4InterfaceSetupState = serviceProcessorIPV4InterfaceSetupState
}

// WithServiceProcessorIPV6InterfaceAddress adds the serviceProcessorIPV6InterfaceAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceAddress(serviceProcessorIPV6InterfaceAddress *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceAddress(serviceProcessorIPV6InterfaceAddress)
	return o
}

// SetServiceProcessorIPV6InterfaceAddress adds the serviceProcessorIpv6InterfaceAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceAddress(serviceProcessorIPV6InterfaceAddress *string) {
	o.ServiceProcessorIPV6InterfaceAddress = serviceProcessorIPV6InterfaceAddress
}

// WithServiceProcessorIPV6InterfaceEnabled adds the serviceProcessorIPV6InterfaceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceEnabled(serviceProcessorIPV6InterfaceEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceEnabled(serviceProcessorIPV6InterfaceEnabled)
	return o
}

// SetServiceProcessorIPV6InterfaceEnabled adds the serviceProcessorIpv6InterfaceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceEnabled(serviceProcessorIPV6InterfaceEnabled *bool) {
	o.ServiceProcessorIPV6InterfaceEnabled = serviceProcessorIPV6InterfaceEnabled
}

// WithServiceProcessorIPV6InterfaceGateway adds the serviceProcessorIPV6InterfaceGateway to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceGateway(serviceProcessorIPV6InterfaceGateway *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceGateway(serviceProcessorIPV6InterfaceGateway)
	return o
}

// SetServiceProcessorIPV6InterfaceGateway adds the serviceProcessorIpv6InterfaceGateway to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceGateway(serviceProcessorIPV6InterfaceGateway *string) {
	o.ServiceProcessorIPV6InterfaceGateway = serviceProcessorIPV6InterfaceGateway
}

// WithServiceProcessorIPV6InterfaceIsIPV6RaEnabled adds the serviceProcessorIPV6InterfaceIsIPV6RaEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceIsIPV6RaEnabled(serviceProcessorIPV6InterfaceIsIPV6RaEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceIsIPV6RaEnabled(serviceProcessorIPV6InterfaceIsIPV6RaEnabled)
	return o
}

// SetServiceProcessorIPV6InterfaceIsIPV6RaEnabled adds the serviceProcessorIpv6InterfaceIsIpv6RaEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceIsIPV6RaEnabled(serviceProcessorIPV6InterfaceIsIPV6RaEnabled *bool) {
	o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled = serviceProcessorIPV6InterfaceIsIPV6RaEnabled
}

// WithServiceProcessorIPV6InterfaceLinkLocalIP adds the serviceProcessorIPV6InterfaceLinkLocalIP to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceLinkLocalIP(serviceProcessorIPV6InterfaceLinkLocalIP *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceLinkLocalIP(serviceProcessorIPV6InterfaceLinkLocalIP)
	return o
}

// SetServiceProcessorIPV6InterfaceLinkLocalIP adds the serviceProcessorIpv6InterfaceLinkLocalIp to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceLinkLocalIP(serviceProcessorIPV6InterfaceLinkLocalIP *string) {
	o.ServiceProcessorIPV6InterfaceLinkLocalIP = serviceProcessorIPV6InterfaceLinkLocalIP
}

// WithServiceProcessorIPV6InterfaceNetmask adds the serviceProcessorIPV6InterfaceNetmask to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceNetmask(serviceProcessorIPV6InterfaceNetmask *int64) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceNetmask(serviceProcessorIPV6InterfaceNetmask)
	return o
}

// SetServiceProcessorIPV6InterfaceNetmask adds the serviceProcessorIpv6InterfaceNetmask to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceNetmask(serviceProcessorIPV6InterfaceNetmask *int64) {
	o.ServiceProcessorIPV6InterfaceNetmask = serviceProcessorIPV6InterfaceNetmask
}

// WithServiceProcessorIPV6InterfaceRouterIP adds the serviceProcessorIPV6InterfaceRouterIP to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceRouterIP(serviceProcessorIPV6InterfaceRouterIP *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceRouterIP(serviceProcessorIPV6InterfaceRouterIP)
	return o
}

// SetServiceProcessorIPV6InterfaceRouterIP adds the serviceProcessorIpv6InterfaceRouterIp to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceRouterIP(serviceProcessorIPV6InterfaceRouterIP *string) {
	o.ServiceProcessorIPV6InterfaceRouterIP = serviceProcessorIPV6InterfaceRouterIP
}

// WithServiceProcessorIPV6InterfaceSetupState adds the serviceProcessorIPV6InterfaceSetupState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIPV6InterfaceSetupState(serviceProcessorIPV6InterfaceSetupState *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIPV6InterfaceSetupState(serviceProcessorIPV6InterfaceSetupState)
	return o
}

// SetServiceProcessorIPV6InterfaceSetupState adds the serviceProcessorIpv6InterfaceSetupState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIPV6InterfaceSetupState(serviceProcessorIPV6InterfaceSetupState *string) {
	o.ServiceProcessorIPV6InterfaceSetupState = serviceProcessorIPV6InterfaceSetupState
}

// WithServiceProcessorIsIPConfigured adds the serviceProcessorIsIPConfigured to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorIsIPConfigured(serviceProcessorIsIPConfigured *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorIsIPConfigured(serviceProcessorIsIPConfigured)
	return o
}

// SetServiceProcessorIsIPConfigured adds the serviceProcessorIsIpConfigured to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorIsIPConfigured(serviceProcessorIsIPConfigured *bool) {
	o.ServiceProcessorIsIPConfigured = serviceProcessorIsIPConfigured
}

// WithServiceProcessorLastUpdateState adds the serviceProcessorLastUpdateState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorLastUpdateState(serviceProcessorLastUpdateState *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorLastUpdateState(serviceProcessorLastUpdateState)
	return o
}

// SetServiceProcessorLastUpdateState adds the serviceProcessorLastUpdateState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorLastUpdateState(serviceProcessorLastUpdateState *string) {
	o.ServiceProcessorLastUpdateState = serviceProcessorLastUpdateState
}

// WithServiceProcessorLinkStatus adds the serviceProcessorLinkStatus to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorLinkStatus(serviceProcessorLinkStatus *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorLinkStatus(serviceProcessorLinkStatus)
	return o
}

// SetServiceProcessorLinkStatus adds the serviceProcessorLinkStatus to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorLinkStatus(serviceProcessorLinkStatus *string) {
	o.ServiceProcessorLinkStatus = serviceProcessorLinkStatus
}

// WithServiceProcessorMacAddress adds the serviceProcessorMacAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorMacAddress(serviceProcessorMacAddress *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorMacAddress(serviceProcessorMacAddress)
	return o
}

// SetServiceProcessorMacAddress adds the serviceProcessorMacAddress to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorMacAddress(serviceProcessorMacAddress *string) {
	o.ServiceProcessorMacAddress = serviceProcessorMacAddress
}

// WithServiceProcessorPrimaryIsCurrent adds the serviceProcessorPrimaryIsCurrent to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorPrimaryIsCurrent(serviceProcessorPrimaryIsCurrent *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorPrimaryIsCurrent(serviceProcessorPrimaryIsCurrent)
	return o
}

// SetServiceProcessorPrimaryIsCurrent adds the serviceProcessorPrimaryIsCurrent to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorPrimaryIsCurrent(serviceProcessorPrimaryIsCurrent *bool) {
	o.ServiceProcessorPrimaryIsCurrent = serviceProcessorPrimaryIsCurrent
}

// WithServiceProcessorPrimaryState adds the serviceProcessorPrimaryState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorPrimaryState(serviceProcessorPrimaryState *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorPrimaryState(serviceProcessorPrimaryState)
	return o
}

// SetServiceProcessorPrimaryState adds the serviceProcessorPrimaryState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorPrimaryState(serviceProcessorPrimaryState *string) {
	o.ServiceProcessorPrimaryState = serviceProcessorPrimaryState
}

// WithServiceProcessorPrimaryVersion adds the serviceProcessorPrimaryVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorPrimaryVersion(serviceProcessorPrimaryVersion *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorPrimaryVersion(serviceProcessorPrimaryVersion)
	return o
}

// SetServiceProcessorPrimaryVersion adds the serviceProcessorPrimaryVersion to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorPrimaryVersion(serviceProcessorPrimaryVersion *string) {
	o.ServiceProcessorPrimaryVersion = serviceProcessorPrimaryVersion
}

// WithServiceProcessorSSHInfoAllowedAddresses adds the serviceProcessorSSHInfoAllowedAddresses to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorSSHInfoAllowedAddresses(serviceProcessorSSHInfoAllowedAddresses *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorSSHInfoAllowedAddresses(serviceProcessorSSHInfoAllowedAddresses)
	return o
}

// SetServiceProcessorSSHInfoAllowedAddresses adds the serviceProcessorSshInfoAllowedAddresses to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorSSHInfoAllowedAddresses(serviceProcessorSSHInfoAllowedAddresses *string) {
	o.ServiceProcessorSSHInfoAllowedAddresses = serviceProcessorSSHInfoAllowedAddresses
}

// WithServiceProcessorState adds the serviceProcessorState to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorState(serviceProcessorState *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorState(serviceProcessorState)
	return o
}

// SetServiceProcessorState adds the serviceProcessorState to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorState(serviceProcessorState *string) {
	o.ServiceProcessorState = serviceProcessorState
}

// WithServiceProcessorType adds the serviceProcessorType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorType(serviceProcessorType *string) *NodeDeleteCollectionParams {
	o.SetServiceProcessorType(serviceProcessorType)
	return o
}

// SetServiceProcessorType adds the serviceProcessorType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorType(serviceProcessorType *string) {
	o.ServiceProcessorType = serviceProcessorType
}

// WithServiceProcessorWebServiceEnabled adds the serviceProcessorWebServiceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorWebServiceEnabled(serviceProcessorWebServiceEnabled *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorWebServiceEnabled(serviceProcessorWebServiceEnabled)
	return o
}

// SetServiceProcessorWebServiceEnabled adds the serviceProcessorWebServiceEnabled to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorWebServiceEnabled(serviceProcessorWebServiceEnabled *bool) {
	o.ServiceProcessorWebServiceEnabled = serviceProcessorWebServiceEnabled
}

// WithServiceProcessorWebServiceLimitAccess adds the serviceProcessorWebServiceLimitAccess to the node delete collection params
func (o *NodeDeleteCollectionParams) WithServiceProcessorWebServiceLimitAccess(serviceProcessorWebServiceLimitAccess *bool) *NodeDeleteCollectionParams {
	o.SetServiceProcessorWebServiceLimitAccess(serviceProcessorWebServiceLimitAccess)
	return o
}

// SetServiceProcessorWebServiceLimitAccess adds the serviceProcessorWebServiceLimitAccess to the node delete collection params
func (o *NodeDeleteCollectionParams) SetServiceProcessorWebServiceLimitAccess(serviceProcessorWebServiceLimitAccess *bool) {
	o.ServiceProcessorWebServiceLimitAccess = serviceProcessorWebServiceLimitAccess
}

// WithSnaplockComplianceClockTime adds the snaplockComplianceClockTime to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSnaplockComplianceClockTime(snaplockComplianceClockTime *string) *NodeDeleteCollectionParams {
	o.SetSnaplockComplianceClockTime(snaplockComplianceClockTime)
	return o
}

// SetSnaplockComplianceClockTime adds the snaplockComplianceClockTime to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSnaplockComplianceClockTime(snaplockComplianceClockTime *string) {
	o.SnaplockComplianceClockTime = snaplockComplianceClockTime
}

// WithState adds the state to the node delete collection params
func (o *NodeDeleteCollectionParams) WithState(state *string) *NodeDeleteCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the node delete collection params
func (o *NodeDeleteCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsProcessorUtilizationBase adds the statisticsProcessorUtilizationBase to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStatisticsProcessorUtilizationBase(statisticsProcessorUtilizationBase *int64) *NodeDeleteCollectionParams {
	o.SetStatisticsProcessorUtilizationBase(statisticsProcessorUtilizationBase)
	return o
}

// SetStatisticsProcessorUtilizationBase adds the statisticsProcessorUtilizationBase to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStatisticsProcessorUtilizationBase(statisticsProcessorUtilizationBase *int64) {
	o.StatisticsProcessorUtilizationBase = statisticsProcessorUtilizationBase
}

// WithStatisticsProcessorUtilizationRaw adds the statisticsProcessorUtilizationRaw to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStatisticsProcessorUtilizationRaw(statisticsProcessorUtilizationRaw *int64) *NodeDeleteCollectionParams {
	o.SetStatisticsProcessorUtilizationRaw(statisticsProcessorUtilizationRaw)
	return o
}

// SetStatisticsProcessorUtilizationRaw adds the statisticsProcessorUtilizationRaw to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStatisticsProcessorUtilizationRaw(statisticsProcessorUtilizationRaw *int64) {
	o.StatisticsProcessorUtilizationRaw = statisticsProcessorUtilizationRaw
}

// WithStatisticsStatus adds the statisticsStatus to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStatisticsStatus(statisticsStatus *string) *NodeDeleteCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *NodeDeleteCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithStorageAvailabilityZonesName adds the storageAvailabilityZonesName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStorageAvailabilityZonesName(storageAvailabilityZonesName *string) *NodeDeleteCollectionParams {
	o.SetStorageAvailabilityZonesName(storageAvailabilityZonesName)
	return o
}

// SetStorageAvailabilityZonesName adds the storageAvailabilityZonesName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStorageAvailabilityZonesName(storageAvailabilityZonesName *string) {
	o.StorageAvailabilityZonesName = storageAvailabilityZonesName
}

// WithStorageAvailabilityZonesUUID adds the storageAvailabilityZonesUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStorageAvailabilityZonesUUID(storageAvailabilityZonesUUID *string) *NodeDeleteCollectionParams {
	o.SetStorageAvailabilityZonesUUID(storageAvailabilityZonesUUID)
	return o
}

// SetStorageAvailabilityZonesUUID adds the storageAvailabilityZonesUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStorageAvailabilityZonesUUID(storageAvailabilityZonesUUID *string) {
	o.StorageAvailabilityZonesUUID = storageAvailabilityZonesUUID
}

// WithStorageConfiguration adds the storageConfiguration to the node delete collection params
func (o *NodeDeleteCollectionParams) WithStorageConfiguration(storageConfiguration *string) *NodeDeleteCollectionParams {
	o.SetStorageConfiguration(storageConfiguration)
	return o
}

// SetStorageConfiguration adds the storageConfiguration to the node delete collection params
func (o *NodeDeleteCollectionParams) SetStorageConfiguration(storageConfiguration *string) {
	o.StorageConfiguration = storageConfiguration
}

// WithSystemAggregateName adds the systemAggregateName to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSystemAggregateName(systemAggregateName *string) *NodeDeleteCollectionParams {
	o.SetSystemAggregateName(systemAggregateName)
	return o
}

// SetSystemAggregateName adds the systemAggregateName to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSystemAggregateName(systemAggregateName *string) {
	o.SystemAggregateName = systemAggregateName
}

// WithSystemAggregateUUID adds the systemAggregateUUID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSystemAggregateUUID(systemAggregateUUID *string) *NodeDeleteCollectionParams {
	o.SetSystemAggregateUUID(systemAggregateUUID)
	return o
}

// SetSystemAggregateUUID adds the systemAggregateUuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSystemAggregateUUID(systemAggregateUUID *string) {
	o.SystemAggregateUUID = systemAggregateUUID
}

// WithSystemID adds the systemID to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSystemID(systemID *string) *NodeDeleteCollectionParams {
	o.SetSystemID(systemID)
	return o
}

// SetSystemID adds the systemId to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSystemID(systemID *string) {
	o.SystemID = systemID
}

// WithSystemMachineType adds the systemMachineType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithSystemMachineType(systemMachineType *string) *NodeDeleteCollectionParams {
	o.SetSystemMachineType(systemMachineType)
	return o
}

// SetSystemMachineType adds the systemMachineType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetSystemMachineType(systemMachineType *string) {
	o.SystemMachineType = systemMachineType
}

// WithUptime adds the uptime to the node delete collection params
func (o *NodeDeleteCollectionParams) WithUptime(uptime *int64) *NodeDeleteCollectionParams {
	o.SetUptime(uptime)
	return o
}

// SetUptime adds the uptime to the node delete collection params
func (o *NodeDeleteCollectionParams) SetUptime(uptime *int64) {
	o.Uptime = uptime
}

// WithUUID adds the uuid to the node delete collection params
func (o *NodeDeleteCollectionParams) WithUUID(uuid *string) *NodeDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the node delete collection params
func (o *NodeDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVendorSerialNumber adds the vendorSerialNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) WithVendorSerialNumber(vendorSerialNumber *string) *NodeDeleteCollectionParams {
	o.SetVendorSerialNumber(vendorSerialNumber)
	return o
}

// SetVendorSerialNumber adds the vendorSerialNumber to the node delete collection params
func (o *NodeDeleteCollectionParams) SetVendorSerialNumber(vendorSerialNumber *string) {
	o.VendorSerialNumber = vendorSerialNumber
}

// WithVersionFull adds the versionFull to the node delete collection params
func (o *NodeDeleteCollectionParams) WithVersionFull(versionFull *string) *NodeDeleteCollectionParams {
	o.SetVersionFull(versionFull)
	return o
}

// SetVersionFull adds the versionFull to the node delete collection params
func (o *NodeDeleteCollectionParams) SetVersionFull(versionFull *string) {
	o.VersionFull = versionFull
}

// WithVersionGeneration adds the versionGeneration to the node delete collection params
func (o *NodeDeleteCollectionParams) WithVersionGeneration(versionGeneration *int64) *NodeDeleteCollectionParams {
	o.SetVersionGeneration(versionGeneration)
	return o
}

// SetVersionGeneration adds the versionGeneration to the node delete collection params
func (o *NodeDeleteCollectionParams) SetVersionGeneration(versionGeneration *int64) {
	o.VersionGeneration = versionGeneration
}

// WithVersionMajor adds the versionMajor to the node delete collection params
func (o *NodeDeleteCollectionParams) WithVersionMajor(versionMajor *int64) *NodeDeleteCollectionParams {
	o.SetVersionMajor(versionMajor)
	return o
}

// SetVersionMajor adds the versionMajor to the node delete collection params
func (o *NodeDeleteCollectionParams) SetVersionMajor(versionMajor *int64) {
	o.VersionMajor = versionMajor
}

// WithVersionMinor adds the versionMinor to the node delete collection params
func (o *NodeDeleteCollectionParams) WithVersionMinor(versionMinor *int64) *NodeDeleteCollectionParams {
	o.SetVersionMinor(versionMinor)
	return o
}

// SetVersionMinor adds the versionMinor to the node delete collection params
func (o *NodeDeleteCollectionParams) SetVersionMinor(versionMinor *int64) {
	o.VersionMinor = versionMinor
}

// WithVMProviderType adds the vMProviderType to the node delete collection params
func (o *NodeDeleteCollectionParams) WithVMProviderType(vMProviderType *string) *NodeDeleteCollectionParams {
	o.SetVMProviderType(vMProviderType)
	return o
}

// SetVMProviderType adds the vmProviderType to the node delete collection params
func (o *NodeDeleteCollectionParams) SetVMProviderType(vMProviderType *string) {
	o.VMProviderType = vMProviderType
}

// WriteToRequest writes these params to a swagger request
func (o *NodeDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AntiRansomwareVersion != nil {

		// query param anti_ransomware_version
		var qrAntiRansomwareVersion string

		if o.AntiRansomwareVersion != nil {
			qrAntiRansomwareVersion = *o.AntiRansomwareVersion
		}
		qAntiRansomwareVersion := qrAntiRansomwareVersion
		if qAntiRansomwareVersion != "" {

			if err := r.SetQueryParam("anti_ransomware_version", qAntiRansomwareVersion); err != nil {
				return err
			}
		}
	}

	if o.ClusterInterfacesIPAddress != nil {

		// query param cluster_interfaces.ip.address
		var qrClusterInterfacesIPAddress string

		if o.ClusterInterfacesIPAddress != nil {
			qrClusterInterfacesIPAddress = *o.ClusterInterfacesIPAddress
		}
		qClusterInterfacesIPAddress := qrClusterInterfacesIPAddress
		if qClusterInterfacesIPAddress != "" {

			if err := r.SetQueryParam("cluster_interfaces.ip.address", qClusterInterfacesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.ClusterInterfacesName != nil {

		// query param cluster_interfaces.name
		var qrClusterInterfacesName string

		if o.ClusterInterfacesName != nil {
			qrClusterInterfacesName = *o.ClusterInterfacesName
		}
		qClusterInterfacesName := qrClusterInterfacesName
		if qClusterInterfacesName != "" {

			if err := r.SetQueryParam("cluster_interfaces.name", qClusterInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.ClusterInterfacesUUID != nil {

		// query param cluster_interfaces.uuid
		var qrClusterInterfacesUUID string

		if o.ClusterInterfacesUUID != nil {
			qrClusterInterfacesUUID = *o.ClusterInterfacesUUID
		}
		qClusterInterfacesUUID := qrClusterInterfacesUUID
		if qClusterInterfacesUUID != "" {

			if err := r.SetQueryParam("cluster_interfaces.uuid", qClusterInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ControllerBoard != nil {

		// query param controller.board
		var qrControllerBoard string

		if o.ControllerBoard != nil {
			qrControllerBoard = *o.ControllerBoard
		}
		qControllerBoard := qrControllerBoard
		if qControllerBoard != "" {

			if err := r.SetQueryParam("controller.board", qControllerBoard); err != nil {
				return err
			}
		}
	}

	if o.ControllerCPUCount != nil {

		// query param controller.cpu.count
		var qrControllerCPUCount int64

		if o.ControllerCPUCount != nil {
			qrControllerCPUCount = *o.ControllerCPUCount
		}
		qControllerCPUCount := swag.FormatInt64(qrControllerCPUCount)
		if qControllerCPUCount != "" {

			if err := r.SetQueryParam("controller.cpu.count", qControllerCPUCount); err != nil {
				return err
			}
		}
	}

	if o.ControllerCPUFirmwareRelease != nil {

		// query param controller.cpu.firmware_release
		var qrControllerCPUFirmwareRelease string

		if o.ControllerCPUFirmwareRelease != nil {
			qrControllerCPUFirmwareRelease = *o.ControllerCPUFirmwareRelease
		}
		qControllerCPUFirmwareRelease := qrControllerCPUFirmwareRelease
		if qControllerCPUFirmwareRelease != "" {

			if err := r.SetQueryParam("controller.cpu.firmware_release", qControllerCPUFirmwareRelease); err != nil {
				return err
			}
		}
	}

	if o.ControllerCPUProcessor != nil {

		// query param controller.cpu.processor
		var qrControllerCPUProcessor string

		if o.ControllerCPUProcessor != nil {
			qrControllerCPUProcessor = *o.ControllerCPUProcessor
		}
		qControllerCPUProcessor := qrControllerCPUProcessor
		if qControllerCPUProcessor != "" {

			if err := r.SetQueryParam("controller.cpu.processor", qControllerCPUProcessor); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedFanCount != nil {

		// query param controller.failed_fan.count
		var qrControllerFailedFanCount int64

		if o.ControllerFailedFanCount != nil {
			qrControllerFailedFanCount = *o.ControllerFailedFanCount
		}
		qControllerFailedFanCount := swag.FormatInt64(qrControllerFailedFanCount)
		if qControllerFailedFanCount != "" {

			if err := r.SetQueryParam("controller.failed_fan.count", qControllerFailedFanCount); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedFanMessageCode != nil {

		// query param controller.failed_fan.message.code
		var qrControllerFailedFanMessageCode string

		if o.ControllerFailedFanMessageCode != nil {
			qrControllerFailedFanMessageCode = *o.ControllerFailedFanMessageCode
		}
		qControllerFailedFanMessageCode := qrControllerFailedFanMessageCode
		if qControllerFailedFanMessageCode != "" {

			if err := r.SetQueryParam("controller.failed_fan.message.code", qControllerFailedFanMessageCode); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedFanMessageMessage != nil {

		// query param controller.failed_fan.message.message
		var qrControllerFailedFanMessageMessage string

		if o.ControllerFailedFanMessageMessage != nil {
			qrControllerFailedFanMessageMessage = *o.ControllerFailedFanMessageMessage
		}
		qControllerFailedFanMessageMessage := qrControllerFailedFanMessageMessage
		if qControllerFailedFanMessageMessage != "" {

			if err := r.SetQueryParam("controller.failed_fan.message.message", qControllerFailedFanMessageMessage); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedPowerSupplyCount != nil {

		// query param controller.failed_power_supply.count
		var qrControllerFailedPowerSupplyCount int64

		if o.ControllerFailedPowerSupplyCount != nil {
			qrControllerFailedPowerSupplyCount = *o.ControllerFailedPowerSupplyCount
		}
		qControllerFailedPowerSupplyCount := swag.FormatInt64(qrControllerFailedPowerSupplyCount)
		if qControllerFailedPowerSupplyCount != "" {

			if err := r.SetQueryParam("controller.failed_power_supply.count", qControllerFailedPowerSupplyCount); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedPowerSupplyMessageCode != nil {

		// query param controller.failed_power_supply.message.code
		var qrControllerFailedPowerSupplyMessageCode string

		if o.ControllerFailedPowerSupplyMessageCode != nil {
			qrControllerFailedPowerSupplyMessageCode = *o.ControllerFailedPowerSupplyMessageCode
		}
		qControllerFailedPowerSupplyMessageCode := qrControllerFailedPowerSupplyMessageCode
		if qControllerFailedPowerSupplyMessageCode != "" {

			if err := r.SetQueryParam("controller.failed_power_supply.message.code", qControllerFailedPowerSupplyMessageCode); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedPowerSupplyMessageMessage != nil {

		// query param controller.failed_power_supply.message.message
		var qrControllerFailedPowerSupplyMessageMessage string

		if o.ControllerFailedPowerSupplyMessageMessage != nil {
			qrControllerFailedPowerSupplyMessageMessage = *o.ControllerFailedPowerSupplyMessageMessage
		}
		qControllerFailedPowerSupplyMessageMessage := qrControllerFailedPowerSupplyMessageMessage
		if qControllerFailedPowerSupplyMessageMessage != "" {

			if err := r.SetQueryParam("controller.failed_power_supply.message.message", qControllerFailedPowerSupplyMessageMessage); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheCapacity != nil {

		// query param controller.flash_cache.capacity
		var qrControllerFlashCacheCapacity int64

		if o.ControllerFlashCacheCapacity != nil {
			qrControllerFlashCacheCapacity = *o.ControllerFlashCacheCapacity
		}
		qControllerFlashCacheCapacity := swag.FormatInt64(qrControllerFlashCacheCapacity)
		if qControllerFlashCacheCapacity != "" {

			if err := r.SetQueryParam("controller.flash_cache.capacity", qControllerFlashCacheCapacity); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheDeviceID != nil {

		// query param controller.flash_cache.device_id
		var qrControllerFlashCacheDeviceID int64

		if o.ControllerFlashCacheDeviceID != nil {
			qrControllerFlashCacheDeviceID = *o.ControllerFlashCacheDeviceID
		}
		qControllerFlashCacheDeviceID := swag.FormatInt64(qrControllerFlashCacheDeviceID)
		if qControllerFlashCacheDeviceID != "" {

			if err := r.SetQueryParam("controller.flash_cache.device_id", qControllerFlashCacheDeviceID); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheFirmwareFile != nil {

		// query param controller.flash_cache.firmware_file
		var qrControllerFlashCacheFirmwareFile string

		if o.ControllerFlashCacheFirmwareFile != nil {
			qrControllerFlashCacheFirmwareFile = *o.ControllerFlashCacheFirmwareFile
		}
		qControllerFlashCacheFirmwareFile := qrControllerFlashCacheFirmwareFile
		if qControllerFlashCacheFirmwareFile != "" {

			if err := r.SetQueryParam("controller.flash_cache.firmware_file", qControllerFlashCacheFirmwareFile); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheFirmwareVersion != nil {

		// query param controller.flash_cache.firmware_version
		var qrControllerFlashCacheFirmwareVersion string

		if o.ControllerFlashCacheFirmwareVersion != nil {
			qrControllerFlashCacheFirmwareVersion = *o.ControllerFlashCacheFirmwareVersion
		}
		qControllerFlashCacheFirmwareVersion := qrControllerFlashCacheFirmwareVersion
		if qControllerFlashCacheFirmwareVersion != "" {

			if err := r.SetQueryParam("controller.flash_cache.firmware_version", qControllerFlashCacheFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheHardwareRevision != nil {

		// query param controller.flash_cache.hardware_revision
		var qrControllerFlashCacheHardwareRevision string

		if o.ControllerFlashCacheHardwareRevision != nil {
			qrControllerFlashCacheHardwareRevision = *o.ControllerFlashCacheHardwareRevision
		}
		qControllerFlashCacheHardwareRevision := qrControllerFlashCacheHardwareRevision
		if qControllerFlashCacheHardwareRevision != "" {

			if err := r.SetQueryParam("controller.flash_cache.hardware_revision", qControllerFlashCacheHardwareRevision); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheModel != nil {

		// query param controller.flash_cache.model
		var qrControllerFlashCacheModel string

		if o.ControllerFlashCacheModel != nil {
			qrControllerFlashCacheModel = *o.ControllerFlashCacheModel
		}
		qControllerFlashCacheModel := qrControllerFlashCacheModel
		if qControllerFlashCacheModel != "" {

			if err := r.SetQueryParam("controller.flash_cache.model", qControllerFlashCacheModel); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCachePartNumber != nil {

		// query param controller.flash_cache.part_number
		var qrControllerFlashCachePartNumber string

		if o.ControllerFlashCachePartNumber != nil {
			qrControllerFlashCachePartNumber = *o.ControllerFlashCachePartNumber
		}
		qControllerFlashCachePartNumber := qrControllerFlashCachePartNumber
		if qControllerFlashCachePartNumber != "" {

			if err := r.SetQueryParam("controller.flash_cache.part_number", qControllerFlashCachePartNumber); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheSerialNumber != nil {

		// query param controller.flash_cache.serial_number
		var qrControllerFlashCacheSerialNumber string

		if o.ControllerFlashCacheSerialNumber != nil {
			qrControllerFlashCacheSerialNumber = *o.ControllerFlashCacheSerialNumber
		}
		qControllerFlashCacheSerialNumber := qrControllerFlashCacheSerialNumber
		if qControllerFlashCacheSerialNumber != "" {

			if err := r.SetQueryParam("controller.flash_cache.serial_number", qControllerFlashCacheSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheSlot != nil {

		// query param controller.flash_cache.slot
		var qrControllerFlashCacheSlot string

		if o.ControllerFlashCacheSlot != nil {
			qrControllerFlashCacheSlot = *o.ControllerFlashCacheSlot
		}
		qControllerFlashCacheSlot := qrControllerFlashCacheSlot
		if qControllerFlashCacheSlot != "" {

			if err := r.SetQueryParam("controller.flash_cache.slot", qControllerFlashCacheSlot); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheState != nil {

		// query param controller.flash_cache.state
		var qrControllerFlashCacheState string

		if o.ControllerFlashCacheState != nil {
			qrControllerFlashCacheState = *o.ControllerFlashCacheState
		}
		qControllerFlashCacheState := qrControllerFlashCacheState
		if qControllerFlashCacheState != "" {

			if err := r.SetQueryParam("controller.flash_cache.state", qControllerFlashCacheState); err != nil {
				return err
			}
		}
	}

	if o.ControllerFrusID != nil {

		// query param controller.frus.id
		var qrControllerFrusID string

		if o.ControllerFrusID != nil {
			qrControllerFrusID = *o.ControllerFrusID
		}
		qControllerFrusID := qrControllerFrusID
		if qControllerFrusID != "" {

			if err := r.SetQueryParam("controller.frus.id", qControllerFrusID); err != nil {
				return err
			}
		}
	}

	if o.ControllerFrusState != nil {

		// query param controller.frus.state
		var qrControllerFrusState string

		if o.ControllerFrusState != nil {
			qrControllerFrusState = *o.ControllerFrusState
		}
		qControllerFrusState := qrControllerFrusState
		if qControllerFrusState != "" {

			if err := r.SetQueryParam("controller.frus.state", qControllerFrusState); err != nil {
				return err
			}
		}
	}

	if o.ControllerFrusType != nil {

		// query param controller.frus.type
		var qrControllerFrusType string

		if o.ControllerFrusType != nil {
			qrControllerFrusType = *o.ControllerFrusType
		}
		qControllerFrusType := qrControllerFrusType
		if qControllerFrusType != "" {

			if err := r.SetQueryParam("controller.frus.type", qControllerFrusType); err != nil {
				return err
			}
		}
	}

	if o.ControllerMemorySize != nil {

		// query param controller.memory_size
		var qrControllerMemorySize int64

		if o.ControllerMemorySize != nil {
			qrControllerMemorySize = *o.ControllerMemorySize
		}
		qControllerMemorySize := swag.FormatInt64(qrControllerMemorySize)
		if qControllerMemorySize != "" {

			if err := r.SetQueryParam("controller.memory_size", qControllerMemorySize); err != nil {
				return err
			}
		}
	}

	if o.ControllerOverTemperature != nil {

		// query param controller.over_temperature
		var qrControllerOverTemperature string

		if o.ControllerOverTemperature != nil {
			qrControllerOverTemperature = *o.ControllerOverTemperature
		}
		qControllerOverTemperature := qrControllerOverTemperature
		if qControllerOverTemperature != "" {

			if err := r.SetQueryParam("controller.over_temperature", qControllerOverTemperature); err != nil {
				return err
			}
		}
	}

	if o.Date != nil {

		// query param date
		var qrDate string

		if o.Date != nil {
			qrDate = *o.Date
		}
		qDate := qrDate
		if qDate != "" {

			if err := r.SetQueryParam("date", qDate); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheIsEnabled != nil {

		// query param external_cache.is_enabled
		var qrExternalCacheIsEnabled bool

		if o.ExternalCacheIsEnabled != nil {
			qrExternalCacheIsEnabled = *o.ExternalCacheIsEnabled
		}
		qExternalCacheIsEnabled := swag.FormatBool(qrExternalCacheIsEnabled)
		if qExternalCacheIsEnabled != "" {

			if err := r.SetQueryParam("external_cache.is_enabled", qExternalCacheIsEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheIsHyaEnabled != nil {

		// query param external_cache.is_hya_enabled
		var qrExternalCacheIsHyaEnabled bool

		if o.ExternalCacheIsHyaEnabled != nil {
			qrExternalCacheIsHyaEnabled = *o.ExternalCacheIsHyaEnabled
		}
		qExternalCacheIsHyaEnabled := swag.FormatBool(qrExternalCacheIsHyaEnabled)
		if qExternalCacheIsHyaEnabled != "" {

			if err := r.SetQueryParam("external_cache.is_hya_enabled", qExternalCacheIsHyaEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheIsRewarmEnabled != nil {

		// query param external_cache.is_rewarm_enabled
		var qrExternalCacheIsRewarmEnabled bool

		if o.ExternalCacheIsRewarmEnabled != nil {
			qrExternalCacheIsRewarmEnabled = *o.ExternalCacheIsRewarmEnabled
		}
		qExternalCacheIsRewarmEnabled := swag.FormatBool(qrExternalCacheIsRewarmEnabled)
		if qExternalCacheIsRewarmEnabled != "" {

			if err := r.SetQueryParam("external_cache.is_rewarm_enabled", qExternalCacheIsRewarmEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCachePcsSize != nil {

		// query param external_cache.pcs_size
		var qrExternalCachePcsSize int64

		if o.ExternalCachePcsSize != nil {
			qrExternalCachePcsSize = *o.ExternalCachePcsSize
		}
		qExternalCachePcsSize := swag.FormatInt64(qrExternalCachePcsSize)
		if qExternalCachePcsSize != "" {

			if err := r.SetQueryParam("external_cache.pcs_size", qExternalCachePcsSize); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheBypassEnabled != nil {

		// query param external_cache_bypass.enabled
		var qrExternalCacheBypassEnabled bool

		if o.ExternalCacheBypassEnabled != nil {
			qrExternalCacheBypassEnabled = *o.ExternalCacheBypassEnabled
		}
		qExternalCacheBypassEnabled := swag.FormatBool(qrExternalCacheBypassEnabled)
		if qExternalCacheBypassEnabled != "" {

			if err := r.SetQueryParam("external_cache_bypass.enabled", qExternalCacheBypassEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheBypassLargeReadOpsAllowPercent != nil {

		// query param external_cache_bypass.large_read_ops_allow_percent
		var qrExternalCacheBypassLargeReadOpsAllowPercent int64

		if o.ExternalCacheBypassLargeReadOpsAllowPercent != nil {
			qrExternalCacheBypassLargeReadOpsAllowPercent = *o.ExternalCacheBypassLargeReadOpsAllowPercent
		}
		qExternalCacheBypassLargeReadOpsAllowPercent := swag.FormatInt64(qrExternalCacheBypassLargeReadOpsAllowPercent)
		if qExternalCacheBypassLargeReadOpsAllowPercent != "" {

			if err := r.SetQueryParam("external_cache_bypass.large_read_ops_allow_percent", qExternalCacheBypassLargeReadOpsAllowPercent); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.HaAutoGiveback != nil {

		// query param ha.auto_giveback
		var qrHaAutoGiveback bool

		if o.HaAutoGiveback != nil {
			qrHaAutoGiveback = *o.HaAutoGiveback
		}
		qHaAutoGiveback := swag.FormatBool(qrHaAutoGiveback)
		if qHaAutoGiveback != "" {

			if err := r.SetQueryParam("ha.auto_giveback", qHaAutoGiveback); err != nil {
				return err
			}
		}
	}

	if o.HaAutoGivebackOf != nil {

		// query param ha.auto_giveback_of
		var qrHaAutoGivebackOf bool

		if o.HaAutoGivebackOf != nil {
			qrHaAutoGivebackOf = *o.HaAutoGivebackOf
		}
		qHaAutoGivebackOf := swag.FormatBool(qrHaAutoGivebackOf)
		if qHaAutoGivebackOf != "" {

			if err := r.SetQueryParam("ha.auto_giveback_of", qHaAutoGivebackOf); err != nil {
				return err
			}
		}
	}

	if o.HaEnableTakeoverOf != nil {

		// query param ha.enable_takeover_of
		var qrHaEnableTakeoverOf bool

		if o.HaEnableTakeoverOf != nil {
			qrHaEnableTakeoverOf = *o.HaEnableTakeoverOf
		}
		qHaEnableTakeoverOf := swag.FormatBool(qrHaEnableTakeoverOf)
		if qHaEnableTakeoverOf != "" {

			if err := r.SetQueryParam("ha.enable_takeover_of", qHaEnableTakeoverOf); err != nil {
				return err
			}
		}
	}

	if o.HaEnabled != nil {

		// query param ha.enabled
		var qrHaEnabled bool

		if o.HaEnabled != nil {
			qrHaEnabled = *o.HaEnabled
		}
		qHaEnabled := swag.FormatBool(qrHaEnabled)
		if qHaEnabled != "" {

			if err := r.SetQueryParam("ha.enabled", qHaEnabled); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackFailureCode != nil {

		// query param ha.giveback.failure.code
		var qrHaGivebackFailureCode int64

		if o.HaGivebackFailureCode != nil {
			qrHaGivebackFailureCode = *o.HaGivebackFailureCode
		}
		qHaGivebackFailureCode := swag.FormatInt64(qrHaGivebackFailureCode)
		if qHaGivebackFailureCode != "" {

			if err := r.SetQueryParam("ha.giveback.failure.code", qHaGivebackFailureCode); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackFailureMessage != nil {

		// query param ha.giveback.failure.message
		var qrHaGivebackFailureMessage string

		if o.HaGivebackFailureMessage != nil {
			qrHaGivebackFailureMessage = *o.HaGivebackFailureMessage
		}
		qHaGivebackFailureMessage := qrHaGivebackFailureMessage
		if qHaGivebackFailureMessage != "" {

			if err := r.SetQueryParam("ha.giveback.failure.message", qHaGivebackFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackState != nil {

		// query param ha.giveback.state
		var qrHaGivebackState string

		if o.HaGivebackState != nil {
			qrHaGivebackState = *o.HaGivebackState
		}
		qHaGivebackState := qrHaGivebackState
		if qHaGivebackState != "" {

			if err := r.SetQueryParam("ha.giveback.state", qHaGivebackState); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusAggregateName != nil {

		// query param ha.giveback.status.aggregate.name
		var qrHaGivebackStatusAggregateName string

		if o.HaGivebackStatusAggregateName != nil {
			qrHaGivebackStatusAggregateName = *o.HaGivebackStatusAggregateName
		}
		qHaGivebackStatusAggregateName := qrHaGivebackStatusAggregateName
		if qHaGivebackStatusAggregateName != "" {

			if err := r.SetQueryParam("ha.giveback.status.aggregate.name", qHaGivebackStatusAggregateName); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusAggregateUUID != nil {

		// query param ha.giveback.status.aggregate.uuid
		var qrHaGivebackStatusAggregateUUID string

		if o.HaGivebackStatusAggregateUUID != nil {
			qrHaGivebackStatusAggregateUUID = *o.HaGivebackStatusAggregateUUID
		}
		qHaGivebackStatusAggregateUUID := qrHaGivebackStatusAggregateUUID
		if qHaGivebackStatusAggregateUUID != "" {

			if err := r.SetQueryParam("ha.giveback.status.aggregate.uuid", qHaGivebackStatusAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusErrorCode != nil {

		// query param ha.giveback.status.error.code
		var qrHaGivebackStatusErrorCode string

		if o.HaGivebackStatusErrorCode != nil {
			qrHaGivebackStatusErrorCode = *o.HaGivebackStatusErrorCode
		}
		qHaGivebackStatusErrorCode := qrHaGivebackStatusErrorCode
		if qHaGivebackStatusErrorCode != "" {

			if err := r.SetQueryParam("ha.giveback.status.error.code", qHaGivebackStatusErrorCode); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusErrorMessage != nil {

		// query param ha.giveback.status.error.message
		var qrHaGivebackStatusErrorMessage string

		if o.HaGivebackStatusErrorMessage != nil {
			qrHaGivebackStatusErrorMessage = *o.HaGivebackStatusErrorMessage
		}
		qHaGivebackStatusErrorMessage := qrHaGivebackStatusErrorMessage
		if qHaGivebackStatusErrorMessage != "" {

			if err := r.SetQueryParam("ha.giveback.status.error.message", qHaGivebackStatusErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusState != nil {

		// query param ha.giveback.status.state
		var qrHaGivebackStatusState string

		if o.HaGivebackStatusState != nil {
			qrHaGivebackStatusState = *o.HaGivebackStatusState
		}
		qHaGivebackStatusState := qrHaGivebackStatusState
		if qHaGivebackStatusState != "" {

			if err := r.SetQueryParam("ha.giveback.status.state", qHaGivebackStatusState); err != nil {
				return err
			}
		}
	}

	if o.HaInterconnectAdapter != nil {

		// query param ha.interconnect.adapter
		var qrHaInterconnectAdapter string

		if o.HaInterconnectAdapter != nil {
			qrHaInterconnectAdapter = *o.HaInterconnectAdapter
		}
		qHaInterconnectAdapter := qrHaInterconnectAdapter
		if qHaInterconnectAdapter != "" {

			if err := r.SetQueryParam("ha.interconnect.adapter", qHaInterconnectAdapter); err != nil {
				return err
			}
		}
	}

	if o.HaInterconnectState != nil {

		// query param ha.interconnect.state
		var qrHaInterconnectState string

		if o.HaInterconnectState != nil {
			qrHaInterconnectState = *o.HaInterconnectState
		}
		qHaInterconnectState := qrHaInterconnectState
		if qHaInterconnectState != "" {

			if err := r.SetQueryParam("ha.interconnect.state", qHaInterconnectState); err != nil {
				return err
			}
		}
	}

	if o.HaPartnersName != nil {

		// query param ha.partners.name
		var qrHaPartnersName string

		if o.HaPartnersName != nil {
			qrHaPartnersName = *o.HaPartnersName
		}
		qHaPartnersName := qrHaPartnersName
		if qHaPartnersName != "" {

			if err := r.SetQueryParam("ha.partners.name", qHaPartnersName); err != nil {
				return err
			}
		}
	}

	if o.HaPartnersUUID != nil {

		// query param ha.partners.uuid
		var qrHaPartnersUUID string

		if o.HaPartnersUUID != nil {
			qrHaPartnersUUID = *o.HaPartnersUUID
		}
		qHaPartnersUUID := qrHaPartnersUUID
		if qHaPartnersUUID != "" {

			if err := r.SetQueryParam("ha.partners.uuid", qHaPartnersUUID); err != nil {
				return err
			}
		}
	}

	if o.HaPortsNumber != nil {

		// query param ha.ports.number
		var qrHaPortsNumber int64

		if o.HaPortsNumber != nil {
			qrHaPortsNumber = *o.HaPortsNumber
		}
		qHaPortsNumber := swag.FormatInt64(qrHaPortsNumber)
		if qHaPortsNumber != "" {

			if err := r.SetQueryParam("ha.ports.number", qHaPortsNumber); err != nil {
				return err
			}
		}
	}

	if o.HaPortsState != nil {

		// query param ha.ports.state
		var qrHaPortsState string

		if o.HaPortsState != nil {
			qrHaPortsState = *o.HaPortsState
		}
		qHaPortsState := qrHaPortsState
		if qHaPortsState != "" {

			if err := r.SetQueryParam("ha.ports.state", qHaPortsState); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverFailureCode != nil {

		// query param ha.takeover.failure.code
		var qrHaTakeoverFailureCode int64

		if o.HaTakeoverFailureCode != nil {
			qrHaTakeoverFailureCode = *o.HaTakeoverFailureCode
		}
		qHaTakeoverFailureCode := swag.FormatInt64(qrHaTakeoverFailureCode)
		if qHaTakeoverFailureCode != "" {

			if err := r.SetQueryParam("ha.takeover.failure.code", qHaTakeoverFailureCode); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverFailureMessage != nil {

		// query param ha.takeover.failure.message
		var qrHaTakeoverFailureMessage string

		if o.HaTakeoverFailureMessage != nil {
			qrHaTakeoverFailureMessage = *o.HaTakeoverFailureMessage
		}
		qHaTakeoverFailureMessage := qrHaTakeoverFailureMessage
		if qHaTakeoverFailureMessage != "" {

			if err := r.SetQueryParam("ha.takeover.failure.message", qHaTakeoverFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverState != nil {

		// query param ha.takeover.state
		var qrHaTakeoverState string

		if o.HaTakeoverState != nil {
			qrHaTakeoverState = *o.HaTakeoverState
		}
		qHaTakeoverState := qrHaTakeoverState
		if qHaTakeoverState != "" {

			if err := r.SetQueryParam("ha.takeover.state", qHaTakeoverState); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverCheckReasons != nil {

		// query param ha.takeover_check.reasons
		var qrHaTakeoverCheckReasons string

		if o.HaTakeoverCheckReasons != nil {
			qrHaTakeoverCheckReasons = *o.HaTakeoverCheckReasons
		}
		qHaTakeoverCheckReasons := qrHaTakeoverCheckReasons
		if qHaTakeoverCheckReasons != "" {

			if err := r.SetQueryParam("ha.takeover_check.reasons", qHaTakeoverCheckReasons); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverCheckTakeoverPossible != nil {

		// query param ha.takeover_check.takeover_possible
		var qrHaTakeoverCheckTakeoverPossible bool

		if o.HaTakeoverCheckTakeoverPossible != nil {
			qrHaTakeoverCheckTakeoverPossible = *o.HaTakeoverCheckTakeoverPossible
		}
		qHaTakeoverCheckTakeoverPossible := swag.FormatBool(qrHaTakeoverCheckTakeoverPossible)
		if qHaTakeoverCheckTakeoverPossible != "" {

			if err := r.SetQueryParam("ha.takeover_check.takeover_possible", qHaTakeoverCheckTakeoverPossible); err != nil {
				return err
			}
		}
	}

	if o.HaType != nil {

		// query param ha.type
		var qrHaType string

		if o.HaType != nil {
			qrHaType = *o.HaType
		}
		qHaType := qrHaType
		if qHaType != "" {

			if err := r.SetQueryParam("ha.type", qHaType); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusEnabled != nil {

		// query param hw_assist.status.enabled
		var qrHwAssistStatusEnabled bool

		if o.HwAssistStatusEnabled != nil {
			qrHwAssistStatusEnabled = *o.HwAssistStatusEnabled
		}
		qHwAssistStatusEnabled := swag.FormatBool(qrHwAssistStatusEnabled)
		if qHwAssistStatusEnabled != "" {

			if err := r.SetQueryParam("hw_assist.status.enabled", qHwAssistStatusEnabled); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusLocalIP != nil {

		// query param hw_assist.status.local.ip
		var qrHwAssistStatusLocalIP string

		if o.HwAssistStatusLocalIP != nil {
			qrHwAssistStatusLocalIP = *o.HwAssistStatusLocalIP
		}
		qHwAssistStatusLocalIP := qrHwAssistStatusLocalIP
		if qHwAssistStatusLocalIP != "" {

			if err := r.SetQueryParam("hw_assist.status.local.ip", qHwAssistStatusLocalIP); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusLocalPort != nil {

		// query param hw_assist.status.local.port
		var qrHwAssistStatusLocalPort int64

		if o.HwAssistStatusLocalPort != nil {
			qrHwAssistStatusLocalPort = *o.HwAssistStatusLocalPort
		}
		qHwAssistStatusLocalPort := swag.FormatInt64(qrHwAssistStatusLocalPort)
		if qHwAssistStatusLocalPort != "" {

			if err := r.SetQueryParam("hw_assist.status.local.port", qHwAssistStatusLocalPort); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusLocalState != nil {

		// query param hw_assist.status.local.state
		var qrHwAssistStatusLocalState string

		if o.HwAssistStatusLocalState != nil {
			qrHwAssistStatusLocalState = *o.HwAssistStatusLocalState
		}
		qHwAssistStatusLocalState := qrHwAssistStatusLocalState
		if qHwAssistStatusLocalState != "" {

			if err := r.SetQueryParam("hw_assist.status.local.state", qHwAssistStatusLocalState); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusPartnerIP != nil {

		// query param hw_assist.status.partner.ip
		var qrHwAssistStatusPartnerIP string

		if o.HwAssistStatusPartnerIP != nil {
			qrHwAssistStatusPartnerIP = *o.HwAssistStatusPartnerIP
		}
		qHwAssistStatusPartnerIP := qrHwAssistStatusPartnerIP
		if qHwAssistStatusPartnerIP != "" {

			if err := r.SetQueryParam("hw_assist.status.partner.ip", qHwAssistStatusPartnerIP); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusPartnerPort != nil {

		// query param hw_assist.status.partner.port
		var qrHwAssistStatusPartnerPort int64

		if o.HwAssistStatusPartnerPort != nil {
			qrHwAssistStatusPartnerPort = *o.HwAssistStatusPartnerPort
		}
		qHwAssistStatusPartnerPort := swag.FormatInt64(qrHwAssistStatusPartnerPort)
		if qHwAssistStatusPartnerPort != "" {

			if err := r.SetQueryParam("hw_assist.status.partner.port", qHwAssistStatusPartnerPort); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusPartnerState != nil {

		// query param hw_assist.status.partner.state
		var qrHwAssistStatusPartnerState string

		if o.HwAssistStatusPartnerState != nil {
			qrHwAssistStatusPartnerState = *o.HwAssistStatusPartnerState
		}
		qHwAssistStatusPartnerState := qrHwAssistStatusPartnerState
		if qHwAssistStatusPartnerState != "" {

			if err := r.SetQueryParam("hw_assist.status.partner.state", qHwAssistStatusPartnerState); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsSparesLow != nil {

		// query param is_spares_low
		var qrIsSparesLow bool

		if o.IsSparesLow != nil {
			qrIsSparesLow = *o.IsSparesLow
		}
		qIsSparesLow := swag.FormatBool(qrIsSparesLow)
		if qIsSparesLow != "" {

			if err := r.SetQueryParam("is_spares_low", qIsSparesLow); err != nil {
				return err
			}
		}
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.ManagementInterfacesIPAddress != nil {

		// query param management_interfaces.ip.address
		var qrManagementInterfacesIPAddress string

		if o.ManagementInterfacesIPAddress != nil {
			qrManagementInterfacesIPAddress = *o.ManagementInterfacesIPAddress
		}
		qManagementInterfacesIPAddress := qrManagementInterfacesIPAddress
		if qManagementInterfacesIPAddress != "" {

			if err := r.SetQueryParam("management_interfaces.ip.address", qManagementInterfacesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.ManagementInterfacesName != nil {

		// query param management_interfaces.name
		var qrManagementInterfacesName string

		if o.ManagementInterfacesName != nil {
			qrManagementInterfacesName = *o.ManagementInterfacesName
		}
		qManagementInterfacesName := qrManagementInterfacesName
		if qManagementInterfacesName != "" {

			if err := r.SetQueryParam("management_interfaces.name", qManagementInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.ManagementInterfacesUUID != nil {

		// query param management_interfaces.uuid
		var qrManagementInterfacesUUID string

		if o.ManagementInterfacesUUID != nil {
			qrManagementInterfacesUUID = *o.ManagementInterfacesUUID
		}
		qManagementInterfacesUUID := qrManagementInterfacesUUID
		if qManagementInterfacesUUID != "" {

			if err := r.SetQueryParam("management_interfaces.uuid", qManagementInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.Membership != nil {

		// query param membership
		var qrMembership string

		if o.Membership != nil {
			qrMembership = *o.Membership
		}
		qMembership := qrMembership
		if qMembership != "" {

			if err := r.SetQueryParam("membership", qMembership); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricProcessorUtilization != nil {

		// query param metric.processor_utilization
		var qrMetricProcessorUtilization int64

		if o.MetricProcessorUtilization != nil {
			qrMetricProcessorUtilization = *o.MetricProcessorUtilization
		}
		qMetricProcessorUtilization := swag.FormatInt64(qrMetricProcessorUtilization)
		if qMetricProcessorUtilization != "" {

			if err := r.SetQueryParam("metric.processor_utilization", qMetricProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MetricUUID != nil {

		// query param metric.uuid
		var qrMetricUUID string

		if o.MetricUUID != nil {
			qrMetricUUID = *o.MetricUUID
		}
		qMetricUUID := qrMetricUUID
		if qMetricUUID != "" {

			if err := r.SetQueryParam("metric.uuid", qMetricUUID); err != nil {
				return err
			}
		}
	}

	if o.MetroclusterCustomVlanCapable != nil {

		// query param metrocluster.custom_vlan_capable
		var qrMetroclusterCustomVlanCapable bool

		if o.MetroclusterCustomVlanCapable != nil {
			qrMetroclusterCustomVlanCapable = *o.MetroclusterCustomVlanCapable
		}
		qMetroclusterCustomVlanCapable := swag.FormatBool(qrMetroclusterCustomVlanCapable)
		if qMetroclusterCustomVlanCapable != "" {

			if err := r.SetQueryParam("metrocluster.custom_vlan_capable", qMetroclusterCustomVlanCapable); err != nil {
				return err
			}
		}
	}

	if o.MetroclusterPortsName != nil {

		// query param metrocluster.ports.name
		var qrMetroclusterPortsName string

		if o.MetroclusterPortsName != nil {
			qrMetroclusterPortsName = *o.MetroclusterPortsName
		}
		qMetroclusterPortsName := qrMetroclusterPortsName
		if qMetroclusterPortsName != "" {

			if err := r.SetQueryParam("metrocluster.ports.name", qMetroclusterPortsName); err != nil {
				return err
			}
		}
	}

	if o.MetroclusterType != nil {

		// query param metrocluster.type
		var qrMetroclusterType string

		if o.MetroclusterType != nil {
			qrMetroclusterType = *o.MetroclusterType
		}
		qMetroclusterType := qrMetroclusterType
		if qMetroclusterType != "" {

			if err := r.SetQueryParam("metrocluster.type", qMetroclusterType); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NvlogBackingType != nil {

		// query param nvlog.backing_type
		var qrNvlogBackingType string

		if o.NvlogBackingType != nil {
			qrNvlogBackingType = *o.NvlogBackingType
		}
		qNvlogBackingType := qrNvlogBackingType
		if qNvlogBackingType != "" {

			if err := r.SetQueryParam("nvlog.backing_type", qNvlogBackingType); err != nil {
				return err
			}
		}
	}

	if o.NvlogSwapMode != nil {

		// query param nvlog.swap_mode
		var qrNvlogSwapMode string

		if o.NvlogSwapMode != nil {
			qrNvlogSwapMode = *o.NvlogSwapMode
		}
		qNvlogSwapMode := qrNvlogSwapMode
		if qNvlogSwapMode != "" {

			if err := r.SetQueryParam("nvlog.swap_mode", qNvlogSwapMode); err != nil {
				return err
			}
		}
	}

	if o.NvramBatteryState != nil {

		// query param nvram.battery_state
		var qrNvramBatteryState string

		if o.NvramBatteryState != nil {
			qrNvramBatteryState = *o.NvramBatteryState
		}
		qNvramBatteryState := qrNvramBatteryState
		if qNvramBatteryState != "" {

			if err := r.SetQueryParam("nvram.battery_state", qNvramBatteryState); err != nil {
				return err
			}
		}
	}

	if o.NvramID != nil {

		// query param nvram.id
		var qrNvramID int64

		if o.NvramID != nil {
			qrNvramID = *o.NvramID
		}
		qNvramID := swag.FormatInt64(qrNvramID)
		if qNvramID != "" {

			if err := r.SetQueryParam("nvram.id", qNvramID); err != nil {
				return err
			}
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAPIServiceEnabled != nil {

		// query param service_processor.api_service.enabled
		var qrServiceProcessorAPIServiceEnabled bool

		if o.ServiceProcessorAPIServiceEnabled != nil {
			qrServiceProcessorAPIServiceEnabled = *o.ServiceProcessorAPIServiceEnabled
		}
		qServiceProcessorAPIServiceEnabled := swag.FormatBool(qrServiceProcessorAPIServiceEnabled)
		if qServiceProcessorAPIServiceEnabled != "" {

			if err := r.SetQueryParam("service_processor.api_service.enabled", qServiceProcessorAPIServiceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAPIServiceLimitAccess != nil {

		// query param service_processor.api_service.limit_access
		var qrServiceProcessorAPIServiceLimitAccess bool

		if o.ServiceProcessorAPIServiceLimitAccess != nil {
			qrServiceProcessorAPIServiceLimitAccess = *o.ServiceProcessorAPIServiceLimitAccess
		}
		qServiceProcessorAPIServiceLimitAccess := swag.FormatBool(qrServiceProcessorAPIServiceLimitAccess)
		if qServiceProcessorAPIServiceLimitAccess != "" {

			if err := r.SetQueryParam("service_processor.api_service.limit_access", qServiceProcessorAPIServiceLimitAccess); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAPIServicePort != nil {

		// query param service_processor.api_service.port
		var qrServiceProcessorAPIServicePort int64

		if o.ServiceProcessorAPIServicePort != nil {
			qrServiceProcessorAPIServicePort = *o.ServiceProcessorAPIServicePort
		}
		qServiceProcessorAPIServicePort := swag.FormatInt64(qrServiceProcessorAPIServicePort)
		if qServiceProcessorAPIServicePort != "" {

			if err := r.SetQueryParam("service_processor.api_service.port", qServiceProcessorAPIServicePort); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAutoConfigIPV4Subnet != nil {

		// query param service_processor.auto_config.ipv4_subnet
		var qrServiceProcessorAutoConfigIPV4Subnet string

		if o.ServiceProcessorAutoConfigIPV4Subnet != nil {
			qrServiceProcessorAutoConfigIPV4Subnet = *o.ServiceProcessorAutoConfigIPV4Subnet
		}
		qServiceProcessorAutoConfigIPV4Subnet := qrServiceProcessorAutoConfigIPV4Subnet
		if qServiceProcessorAutoConfigIPV4Subnet != "" {

			if err := r.SetQueryParam("service_processor.auto_config.ipv4_subnet", qServiceProcessorAutoConfigIPV4Subnet); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAutoConfigIPV6Subnet != nil {

		// query param service_processor.auto_config.ipv6_subnet
		var qrServiceProcessorAutoConfigIPV6Subnet string

		if o.ServiceProcessorAutoConfigIPV6Subnet != nil {
			qrServiceProcessorAutoConfigIPV6Subnet = *o.ServiceProcessorAutoConfigIPV6Subnet
		}
		qServiceProcessorAutoConfigIPV6Subnet := qrServiceProcessorAutoConfigIPV6Subnet
		if qServiceProcessorAutoConfigIPV6Subnet != "" {

			if err := r.SetQueryParam("service_processor.auto_config.ipv6_subnet", qServiceProcessorAutoConfigIPV6Subnet); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAutoupdateEnabled != nil {

		// query param service_processor.autoupdate_enabled
		var qrServiceProcessorAutoupdateEnabled bool

		if o.ServiceProcessorAutoupdateEnabled != nil {
			qrServiceProcessorAutoupdateEnabled = *o.ServiceProcessorAutoupdateEnabled
		}
		qServiceProcessorAutoupdateEnabled := swag.FormatBool(qrServiceProcessorAutoupdateEnabled)
		if qServiceProcessorAutoupdateEnabled != "" {

			if err := r.SetQueryParam("service_processor.autoupdate_enabled", qServiceProcessorAutoupdateEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorBackupIsCurrent != nil {

		// query param service_processor.backup.is_current
		var qrServiceProcessorBackupIsCurrent bool

		if o.ServiceProcessorBackupIsCurrent != nil {
			qrServiceProcessorBackupIsCurrent = *o.ServiceProcessorBackupIsCurrent
		}
		qServiceProcessorBackupIsCurrent := swag.FormatBool(qrServiceProcessorBackupIsCurrent)
		if qServiceProcessorBackupIsCurrent != "" {

			if err := r.SetQueryParam("service_processor.backup.is_current", qServiceProcessorBackupIsCurrent); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorBackupState != nil {

		// query param service_processor.backup.state
		var qrServiceProcessorBackupState string

		if o.ServiceProcessorBackupState != nil {
			qrServiceProcessorBackupState = *o.ServiceProcessorBackupState
		}
		qServiceProcessorBackupState := qrServiceProcessorBackupState
		if qServiceProcessorBackupState != "" {

			if err := r.SetQueryParam("service_processor.backup.state", qServiceProcessorBackupState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorBackupVersion != nil {

		// query param service_processor.backup.version
		var qrServiceProcessorBackupVersion string

		if o.ServiceProcessorBackupVersion != nil {
			qrServiceProcessorBackupVersion = *o.ServiceProcessorBackupVersion
		}
		qServiceProcessorBackupVersion := qrServiceProcessorBackupVersion
		if qServiceProcessorBackupVersion != "" {

			if err := r.SetQueryParam("service_processor.backup.version", qServiceProcessorBackupVersion); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorDhcpEnabled != nil {

		// query param service_processor.dhcp_enabled
		var qrServiceProcessorDhcpEnabled bool

		if o.ServiceProcessorDhcpEnabled != nil {
			qrServiceProcessorDhcpEnabled = *o.ServiceProcessorDhcpEnabled
		}
		qServiceProcessorDhcpEnabled := swag.FormatBool(qrServiceProcessorDhcpEnabled)
		if qServiceProcessorDhcpEnabled != "" {

			if err := r.SetQueryParam("service_processor.dhcp_enabled", qServiceProcessorDhcpEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorFirmwareVersion != nil {

		// query param service_processor.firmware_version
		var qrServiceProcessorFirmwareVersion string

		if o.ServiceProcessorFirmwareVersion != nil {
			qrServiceProcessorFirmwareVersion = *o.ServiceProcessorFirmwareVersion
		}
		qServiceProcessorFirmwareVersion := qrServiceProcessorFirmwareVersion
		if qServiceProcessorFirmwareVersion != "" {

			if err := r.SetQueryParam("service_processor.firmware_version", qServiceProcessorFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceAddress != nil {

		// query param service_processor.ipv4_interface.address
		var qrServiceProcessorIPV4InterfaceAddress string

		if o.ServiceProcessorIPV4InterfaceAddress != nil {
			qrServiceProcessorIPV4InterfaceAddress = *o.ServiceProcessorIPV4InterfaceAddress
		}
		qServiceProcessorIPV4InterfaceAddress := qrServiceProcessorIPV4InterfaceAddress
		if qServiceProcessorIPV4InterfaceAddress != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.address", qServiceProcessorIPV4InterfaceAddress); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceEnabled != nil {

		// query param service_processor.ipv4_interface.enabled
		var qrServiceProcessorIPV4InterfaceEnabled bool

		if o.ServiceProcessorIPV4InterfaceEnabled != nil {
			qrServiceProcessorIPV4InterfaceEnabled = *o.ServiceProcessorIPV4InterfaceEnabled
		}
		qServiceProcessorIPV4InterfaceEnabled := swag.FormatBool(qrServiceProcessorIPV4InterfaceEnabled)
		if qServiceProcessorIPV4InterfaceEnabled != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.enabled", qServiceProcessorIPV4InterfaceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceGateway != nil {

		// query param service_processor.ipv4_interface.gateway
		var qrServiceProcessorIPV4InterfaceGateway string

		if o.ServiceProcessorIPV4InterfaceGateway != nil {
			qrServiceProcessorIPV4InterfaceGateway = *o.ServiceProcessorIPV4InterfaceGateway
		}
		qServiceProcessorIPV4InterfaceGateway := qrServiceProcessorIPV4InterfaceGateway
		if qServiceProcessorIPV4InterfaceGateway != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.gateway", qServiceProcessorIPV4InterfaceGateway); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceNetmask != nil {

		// query param service_processor.ipv4_interface.netmask
		var qrServiceProcessorIPV4InterfaceNetmask string

		if o.ServiceProcessorIPV4InterfaceNetmask != nil {
			qrServiceProcessorIPV4InterfaceNetmask = *o.ServiceProcessorIPV4InterfaceNetmask
		}
		qServiceProcessorIPV4InterfaceNetmask := qrServiceProcessorIPV4InterfaceNetmask
		if qServiceProcessorIPV4InterfaceNetmask != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.netmask", qServiceProcessorIPV4InterfaceNetmask); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceSetupState != nil {

		// query param service_processor.ipv4_interface.setup_state
		var qrServiceProcessorIPV4InterfaceSetupState string

		if o.ServiceProcessorIPV4InterfaceSetupState != nil {
			qrServiceProcessorIPV4InterfaceSetupState = *o.ServiceProcessorIPV4InterfaceSetupState
		}
		qServiceProcessorIPV4InterfaceSetupState := qrServiceProcessorIPV4InterfaceSetupState
		if qServiceProcessorIPV4InterfaceSetupState != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.setup_state", qServiceProcessorIPV4InterfaceSetupState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceAddress != nil {

		// query param service_processor.ipv6_interface.address
		var qrServiceProcessorIPV6InterfaceAddress string

		if o.ServiceProcessorIPV6InterfaceAddress != nil {
			qrServiceProcessorIPV6InterfaceAddress = *o.ServiceProcessorIPV6InterfaceAddress
		}
		qServiceProcessorIPV6InterfaceAddress := qrServiceProcessorIPV6InterfaceAddress
		if qServiceProcessorIPV6InterfaceAddress != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.address", qServiceProcessorIPV6InterfaceAddress); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceEnabled != nil {

		// query param service_processor.ipv6_interface.enabled
		var qrServiceProcessorIPV6InterfaceEnabled bool

		if o.ServiceProcessorIPV6InterfaceEnabled != nil {
			qrServiceProcessorIPV6InterfaceEnabled = *o.ServiceProcessorIPV6InterfaceEnabled
		}
		qServiceProcessorIPV6InterfaceEnabled := swag.FormatBool(qrServiceProcessorIPV6InterfaceEnabled)
		if qServiceProcessorIPV6InterfaceEnabled != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.enabled", qServiceProcessorIPV6InterfaceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceGateway != nil {

		// query param service_processor.ipv6_interface.gateway
		var qrServiceProcessorIPV6InterfaceGateway string

		if o.ServiceProcessorIPV6InterfaceGateway != nil {
			qrServiceProcessorIPV6InterfaceGateway = *o.ServiceProcessorIPV6InterfaceGateway
		}
		qServiceProcessorIPV6InterfaceGateway := qrServiceProcessorIPV6InterfaceGateway
		if qServiceProcessorIPV6InterfaceGateway != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.gateway", qServiceProcessorIPV6InterfaceGateway); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled != nil {

		// query param service_processor.ipv6_interface.is_ipv6_ra_enabled
		var qrServiceProcessorIPV6InterfaceIsIPV6RaEnabled bool

		if o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled != nil {
			qrServiceProcessorIPV6InterfaceIsIPV6RaEnabled = *o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled
		}
		qServiceProcessorIPV6InterfaceIsIPV6RaEnabled := swag.FormatBool(qrServiceProcessorIPV6InterfaceIsIPV6RaEnabled)
		if qServiceProcessorIPV6InterfaceIsIPV6RaEnabled != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.is_ipv6_ra_enabled", qServiceProcessorIPV6InterfaceIsIPV6RaEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceLinkLocalIP != nil {

		// query param service_processor.ipv6_interface.link_local_ip
		var qrServiceProcessorIPV6InterfaceLinkLocalIP string

		if o.ServiceProcessorIPV6InterfaceLinkLocalIP != nil {
			qrServiceProcessorIPV6InterfaceLinkLocalIP = *o.ServiceProcessorIPV6InterfaceLinkLocalIP
		}
		qServiceProcessorIPV6InterfaceLinkLocalIP := qrServiceProcessorIPV6InterfaceLinkLocalIP
		if qServiceProcessorIPV6InterfaceLinkLocalIP != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.link_local_ip", qServiceProcessorIPV6InterfaceLinkLocalIP); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceNetmask != nil {

		// query param service_processor.ipv6_interface.netmask
		var qrServiceProcessorIPV6InterfaceNetmask int64

		if o.ServiceProcessorIPV6InterfaceNetmask != nil {
			qrServiceProcessorIPV6InterfaceNetmask = *o.ServiceProcessorIPV6InterfaceNetmask
		}
		qServiceProcessorIPV6InterfaceNetmask := swag.FormatInt64(qrServiceProcessorIPV6InterfaceNetmask)
		if qServiceProcessorIPV6InterfaceNetmask != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.netmask", qServiceProcessorIPV6InterfaceNetmask); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceRouterIP != nil {

		// query param service_processor.ipv6_interface.router_ip
		var qrServiceProcessorIPV6InterfaceRouterIP string

		if o.ServiceProcessorIPV6InterfaceRouterIP != nil {
			qrServiceProcessorIPV6InterfaceRouterIP = *o.ServiceProcessorIPV6InterfaceRouterIP
		}
		qServiceProcessorIPV6InterfaceRouterIP := qrServiceProcessorIPV6InterfaceRouterIP
		if qServiceProcessorIPV6InterfaceRouterIP != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.router_ip", qServiceProcessorIPV6InterfaceRouterIP); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceSetupState != nil {

		// query param service_processor.ipv6_interface.setup_state
		var qrServiceProcessorIPV6InterfaceSetupState string

		if o.ServiceProcessorIPV6InterfaceSetupState != nil {
			qrServiceProcessorIPV6InterfaceSetupState = *o.ServiceProcessorIPV6InterfaceSetupState
		}
		qServiceProcessorIPV6InterfaceSetupState := qrServiceProcessorIPV6InterfaceSetupState
		if qServiceProcessorIPV6InterfaceSetupState != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.setup_state", qServiceProcessorIPV6InterfaceSetupState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIsIPConfigured != nil {

		// query param service_processor.is_ip_configured
		var qrServiceProcessorIsIPConfigured bool

		if o.ServiceProcessorIsIPConfigured != nil {
			qrServiceProcessorIsIPConfigured = *o.ServiceProcessorIsIPConfigured
		}
		qServiceProcessorIsIPConfigured := swag.FormatBool(qrServiceProcessorIsIPConfigured)
		if qServiceProcessorIsIPConfigured != "" {

			if err := r.SetQueryParam("service_processor.is_ip_configured", qServiceProcessorIsIPConfigured); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorLastUpdateState != nil {

		// query param service_processor.last_update_state
		var qrServiceProcessorLastUpdateState string

		if o.ServiceProcessorLastUpdateState != nil {
			qrServiceProcessorLastUpdateState = *o.ServiceProcessorLastUpdateState
		}
		qServiceProcessorLastUpdateState := qrServiceProcessorLastUpdateState
		if qServiceProcessorLastUpdateState != "" {

			if err := r.SetQueryParam("service_processor.last_update_state", qServiceProcessorLastUpdateState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorLinkStatus != nil {

		// query param service_processor.link_status
		var qrServiceProcessorLinkStatus string

		if o.ServiceProcessorLinkStatus != nil {
			qrServiceProcessorLinkStatus = *o.ServiceProcessorLinkStatus
		}
		qServiceProcessorLinkStatus := qrServiceProcessorLinkStatus
		if qServiceProcessorLinkStatus != "" {

			if err := r.SetQueryParam("service_processor.link_status", qServiceProcessorLinkStatus); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorMacAddress != nil {

		// query param service_processor.mac_address
		var qrServiceProcessorMacAddress string

		if o.ServiceProcessorMacAddress != nil {
			qrServiceProcessorMacAddress = *o.ServiceProcessorMacAddress
		}
		qServiceProcessorMacAddress := qrServiceProcessorMacAddress
		if qServiceProcessorMacAddress != "" {

			if err := r.SetQueryParam("service_processor.mac_address", qServiceProcessorMacAddress); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorPrimaryIsCurrent != nil {

		// query param service_processor.primary.is_current
		var qrServiceProcessorPrimaryIsCurrent bool

		if o.ServiceProcessorPrimaryIsCurrent != nil {
			qrServiceProcessorPrimaryIsCurrent = *o.ServiceProcessorPrimaryIsCurrent
		}
		qServiceProcessorPrimaryIsCurrent := swag.FormatBool(qrServiceProcessorPrimaryIsCurrent)
		if qServiceProcessorPrimaryIsCurrent != "" {

			if err := r.SetQueryParam("service_processor.primary.is_current", qServiceProcessorPrimaryIsCurrent); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorPrimaryState != nil {

		// query param service_processor.primary.state
		var qrServiceProcessorPrimaryState string

		if o.ServiceProcessorPrimaryState != nil {
			qrServiceProcessorPrimaryState = *o.ServiceProcessorPrimaryState
		}
		qServiceProcessorPrimaryState := qrServiceProcessorPrimaryState
		if qServiceProcessorPrimaryState != "" {

			if err := r.SetQueryParam("service_processor.primary.state", qServiceProcessorPrimaryState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorPrimaryVersion != nil {

		// query param service_processor.primary.version
		var qrServiceProcessorPrimaryVersion string

		if o.ServiceProcessorPrimaryVersion != nil {
			qrServiceProcessorPrimaryVersion = *o.ServiceProcessorPrimaryVersion
		}
		qServiceProcessorPrimaryVersion := qrServiceProcessorPrimaryVersion
		if qServiceProcessorPrimaryVersion != "" {

			if err := r.SetQueryParam("service_processor.primary.version", qServiceProcessorPrimaryVersion); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorSSHInfoAllowedAddresses != nil {

		// query param service_processor.ssh_info.allowed_addresses
		var qrServiceProcessorSSHInfoAllowedAddresses string

		if o.ServiceProcessorSSHInfoAllowedAddresses != nil {
			qrServiceProcessorSSHInfoAllowedAddresses = *o.ServiceProcessorSSHInfoAllowedAddresses
		}
		qServiceProcessorSSHInfoAllowedAddresses := qrServiceProcessorSSHInfoAllowedAddresses
		if qServiceProcessorSSHInfoAllowedAddresses != "" {

			if err := r.SetQueryParam("service_processor.ssh_info.allowed_addresses", qServiceProcessorSSHInfoAllowedAddresses); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorState != nil {

		// query param service_processor.state
		var qrServiceProcessorState string

		if o.ServiceProcessorState != nil {
			qrServiceProcessorState = *o.ServiceProcessorState
		}
		qServiceProcessorState := qrServiceProcessorState
		if qServiceProcessorState != "" {

			if err := r.SetQueryParam("service_processor.state", qServiceProcessorState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorType != nil {

		// query param service_processor.type
		var qrServiceProcessorType string

		if o.ServiceProcessorType != nil {
			qrServiceProcessorType = *o.ServiceProcessorType
		}
		qServiceProcessorType := qrServiceProcessorType
		if qServiceProcessorType != "" {

			if err := r.SetQueryParam("service_processor.type", qServiceProcessorType); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorWebServiceEnabled != nil {

		// query param service_processor.web_service.enabled
		var qrServiceProcessorWebServiceEnabled bool

		if o.ServiceProcessorWebServiceEnabled != nil {
			qrServiceProcessorWebServiceEnabled = *o.ServiceProcessorWebServiceEnabled
		}
		qServiceProcessorWebServiceEnabled := swag.FormatBool(qrServiceProcessorWebServiceEnabled)
		if qServiceProcessorWebServiceEnabled != "" {

			if err := r.SetQueryParam("service_processor.web_service.enabled", qServiceProcessorWebServiceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorWebServiceLimitAccess != nil {

		// query param service_processor.web_service.limit_access
		var qrServiceProcessorWebServiceLimitAccess bool

		if o.ServiceProcessorWebServiceLimitAccess != nil {
			qrServiceProcessorWebServiceLimitAccess = *o.ServiceProcessorWebServiceLimitAccess
		}
		qServiceProcessorWebServiceLimitAccess := swag.FormatBool(qrServiceProcessorWebServiceLimitAccess)
		if qServiceProcessorWebServiceLimitAccess != "" {

			if err := r.SetQueryParam("service_processor.web_service.limit_access", qServiceProcessorWebServiceLimitAccess); err != nil {
				return err
			}
		}
	}

	if o.SnaplockComplianceClockTime != nil {

		// query param snaplock.compliance_clock_time
		var qrSnaplockComplianceClockTime string

		if o.SnaplockComplianceClockTime != nil {
			qrSnaplockComplianceClockTime = *o.SnaplockComplianceClockTime
		}
		qSnaplockComplianceClockTime := qrSnaplockComplianceClockTime
		if qSnaplockComplianceClockTime != "" {

			if err := r.SetQueryParam("snaplock.compliance_clock_time", qSnaplockComplianceClockTime); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsProcessorUtilizationBase != nil {

		// query param statistics.processor_utilization_base
		var qrStatisticsProcessorUtilizationBase int64

		if o.StatisticsProcessorUtilizationBase != nil {
			qrStatisticsProcessorUtilizationBase = *o.StatisticsProcessorUtilizationBase
		}
		qStatisticsProcessorUtilizationBase := swag.FormatInt64(qrStatisticsProcessorUtilizationBase)
		if qStatisticsProcessorUtilizationBase != "" {

			if err := r.SetQueryParam("statistics.processor_utilization_base", qStatisticsProcessorUtilizationBase); err != nil {
				return err
			}
		}
	}

	if o.StatisticsProcessorUtilizationRaw != nil {

		// query param statistics.processor_utilization_raw
		var qrStatisticsProcessorUtilizationRaw int64

		if o.StatisticsProcessorUtilizationRaw != nil {
			qrStatisticsProcessorUtilizationRaw = *o.StatisticsProcessorUtilizationRaw
		}
		qStatisticsProcessorUtilizationRaw := swag.FormatInt64(qrStatisticsProcessorUtilizationRaw)
		if qStatisticsProcessorUtilizationRaw != "" {

			if err := r.SetQueryParam("statistics.processor_utilization_raw", qStatisticsProcessorUtilizationRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailabilityZonesName != nil {

		// query param storage_availability_zones.name
		var qrStorageAvailabilityZonesName string

		if o.StorageAvailabilityZonesName != nil {
			qrStorageAvailabilityZonesName = *o.StorageAvailabilityZonesName
		}
		qStorageAvailabilityZonesName := qrStorageAvailabilityZonesName
		if qStorageAvailabilityZonesName != "" {

			if err := r.SetQueryParam("storage_availability_zones.name", qStorageAvailabilityZonesName); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailabilityZonesUUID != nil {

		// query param storage_availability_zones.uuid
		var qrStorageAvailabilityZonesUUID string

		if o.StorageAvailabilityZonesUUID != nil {
			qrStorageAvailabilityZonesUUID = *o.StorageAvailabilityZonesUUID
		}
		qStorageAvailabilityZonesUUID := qrStorageAvailabilityZonesUUID
		if qStorageAvailabilityZonesUUID != "" {

			if err := r.SetQueryParam("storage_availability_zones.uuid", qStorageAvailabilityZonesUUID); err != nil {
				return err
			}
		}
	}

	if o.StorageConfiguration != nil {

		// query param storage_configuration
		var qrStorageConfiguration string

		if o.StorageConfiguration != nil {
			qrStorageConfiguration = *o.StorageConfiguration
		}
		qStorageConfiguration := qrStorageConfiguration
		if qStorageConfiguration != "" {

			if err := r.SetQueryParam("storage_configuration", qStorageConfiguration); err != nil {
				return err
			}
		}
	}

	if o.SystemAggregateName != nil {

		// query param system_aggregate.name
		var qrSystemAggregateName string

		if o.SystemAggregateName != nil {
			qrSystemAggregateName = *o.SystemAggregateName
		}
		qSystemAggregateName := qrSystemAggregateName
		if qSystemAggregateName != "" {

			if err := r.SetQueryParam("system_aggregate.name", qSystemAggregateName); err != nil {
				return err
			}
		}
	}

	if o.SystemAggregateUUID != nil {

		// query param system_aggregate.uuid
		var qrSystemAggregateUUID string

		if o.SystemAggregateUUID != nil {
			qrSystemAggregateUUID = *o.SystemAggregateUUID
		}
		qSystemAggregateUUID := qrSystemAggregateUUID
		if qSystemAggregateUUID != "" {

			if err := r.SetQueryParam("system_aggregate.uuid", qSystemAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.SystemID != nil {

		// query param system_id
		var qrSystemID string

		if o.SystemID != nil {
			qrSystemID = *o.SystemID
		}
		qSystemID := qrSystemID
		if qSystemID != "" {

			if err := r.SetQueryParam("system_id", qSystemID); err != nil {
				return err
			}
		}
	}

	if o.SystemMachineType != nil {

		// query param system_machine_type
		var qrSystemMachineType string

		if o.SystemMachineType != nil {
			qrSystemMachineType = *o.SystemMachineType
		}
		qSystemMachineType := qrSystemMachineType
		if qSystemMachineType != "" {

			if err := r.SetQueryParam("system_machine_type", qSystemMachineType); err != nil {
				return err
			}
		}
	}

	if o.Uptime != nil {

		// query param uptime
		var qrUptime int64

		if o.Uptime != nil {
			qrUptime = *o.Uptime
		}
		qUptime := swag.FormatInt64(qrUptime)
		if qUptime != "" {

			if err := r.SetQueryParam("uptime", qUptime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VendorSerialNumber != nil {

		// query param vendor_serial_number
		var qrVendorSerialNumber string

		if o.VendorSerialNumber != nil {
			qrVendorSerialNumber = *o.VendorSerialNumber
		}
		qVendorSerialNumber := qrVendorSerialNumber
		if qVendorSerialNumber != "" {

			if err := r.SetQueryParam("vendor_serial_number", qVendorSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.VersionFull != nil {

		// query param version.full
		var qrVersionFull string

		if o.VersionFull != nil {
			qrVersionFull = *o.VersionFull
		}
		qVersionFull := qrVersionFull
		if qVersionFull != "" {

			if err := r.SetQueryParam("version.full", qVersionFull); err != nil {
				return err
			}
		}
	}

	if o.VersionGeneration != nil {

		// query param version.generation
		var qrVersionGeneration int64

		if o.VersionGeneration != nil {
			qrVersionGeneration = *o.VersionGeneration
		}
		qVersionGeneration := swag.FormatInt64(qrVersionGeneration)
		if qVersionGeneration != "" {

			if err := r.SetQueryParam("version.generation", qVersionGeneration); err != nil {
				return err
			}
		}
	}

	if o.VersionMajor != nil {

		// query param version.major
		var qrVersionMajor int64

		if o.VersionMajor != nil {
			qrVersionMajor = *o.VersionMajor
		}
		qVersionMajor := swag.FormatInt64(qrVersionMajor)
		if qVersionMajor != "" {

			if err := r.SetQueryParam("version.major", qVersionMajor); err != nil {
				return err
			}
		}
	}

	if o.VersionMinor != nil {

		// query param version.minor
		var qrVersionMinor int64

		if o.VersionMinor != nil {
			qrVersionMinor = *o.VersionMinor
		}
		qVersionMinor := swag.FormatInt64(qrVersionMinor)
		if qVersionMinor != "" {

			if err := r.SetQueryParam("version.minor", qVersionMinor); err != nil {
				return err
			}
		}
	}

	if o.VMProviderType != nil {

		// query param vm.provider_type
		var qrVMProviderType string

		if o.VMProviderType != nil {
			qrVMProviderType = *o.VMProviderType
		}
		qVMProviderType := qrVMProviderType
		if qVMProviderType != "" {

			if err := r.SetQueryParam("vm.provider_type", qVMProviderType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
