// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNodeMetricsCollectionGetParams creates a new NodeMetricsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNodeMetricsCollectionGetParams() *NodeMetricsCollectionGetParams {
	return &NodeMetricsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNodeMetricsCollectionGetParamsWithTimeout creates a new NodeMetricsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewNodeMetricsCollectionGetParamsWithTimeout(timeout time.Duration) *NodeMetricsCollectionGetParams {
	return &NodeMetricsCollectionGetParams{
		timeout: timeout,
	}
}

// NewNodeMetricsCollectionGetParamsWithContext creates a new NodeMetricsCollectionGetParams object
// with the ability to set a context for a request.
func NewNodeMetricsCollectionGetParamsWithContext(ctx context.Context) *NodeMetricsCollectionGetParams {
	return &NodeMetricsCollectionGetParams{
		Context: ctx,
	}
}

// NewNodeMetricsCollectionGetParamsWithHTTPClient creates a new NodeMetricsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNodeMetricsCollectionGetParamsWithHTTPClient(client *http.Client) *NodeMetricsCollectionGetParams {
	return &NodeMetricsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
NodeMetricsCollectionGetParams contains all the parameters to send to the API endpoint

	for the node metrics collection get operation.

	Typically these are written to a http.Request.
*/
type NodeMetricsCollectionGetParams struct {

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ProcessorUtilization.

	   Filter by processor_utilization
	*/
	ProcessorUtilization *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* UUID.

	   Unique identifier of the node.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the node metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodeMetricsCollectionGetParams) WithDefaults() *NodeMetricsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the node metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodeMetricsCollectionGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NodeMetricsCollectionGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithTimeout(timeout time.Duration) *NodeMetricsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithContext(ctx context.Context) *NodeMetricsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithHTTPClient(client *http.Client) *NodeMetricsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDuration adds the duration to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithDuration(duration *string) *NodeMetricsCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFields adds the fields to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithFields(fields []string) *NodeMetricsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithInterval(interval *string) *NodeMetricsCollectionGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithMaxRecords adds the maxRecords to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithMaxRecords(maxRecords *int64) *NodeMetricsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithOrderBy(orderBy []string) *NodeMetricsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProcessorUtilization adds the processorUtilization to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithProcessorUtilization(processorUtilization *int64) *NodeMetricsCollectionGetParams {
	o.SetProcessorUtilization(processorUtilization)
	return o
}

// SetProcessorUtilization adds the processorUtilization to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetProcessorUtilization(processorUtilization *int64) {
	o.ProcessorUtilization = processorUtilization
}

// WithReturnRecords adds the returnRecords to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithReturnRecords(returnRecords *bool) *NodeMetricsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *NodeMetricsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithStatus(status *string) *NodeMetricsCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithTimestamp adds the timestamp to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithTimestamp(timestamp *string) *NodeMetricsCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithUUID adds the uuid to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) WithUUID(uuid string) *NodeMetricsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the node metrics collection get params
func (o *NodeMetricsCollectionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NodeMetricsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ProcessorUtilization != nil {

		// query param processor_utilization
		var qrProcessorUtilization int64

		if o.ProcessorUtilization != nil {
			qrProcessorUtilization = *o.ProcessorUtilization
		}
		qProcessorUtilization := swag.FormatInt64(qrProcessorUtilization)
		if qProcessorUtilization != "" {

			if err := r.SetQueryParam("processor_utilization", qProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNodeMetricsCollectionGet binds the parameter fields
func (o *NodeMetricsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNodeMetricsCollectionGet binds the parameter order_by
func (o *NodeMetricsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
