// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NodeModifyCollectionReader is a Reader for the NodeModifyCollection structure.
type NodeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NodeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNodeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewNodeModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNodeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNodeModifyCollectionOK creates a NodeModifyCollectionOK with default headers values
func NewNodeModifyCollectionOK() *NodeModifyCollectionOK {
	return &NodeModifyCollectionOK{}
}

/*
NodeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NodeModifyCollectionOK struct {
	Payload *models.NodeJobLinkResponse
}

// IsSuccess returns true when this node modify collection o k response has a 2xx status code
func (o *NodeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this node modify collection o k response has a 3xx status code
func (o *NodeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this node modify collection o k response has a 4xx status code
func (o *NodeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this node modify collection o k response has a 5xx status code
func (o *NodeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this node modify collection o k response a status code equal to that given
func (o *NodeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the node modify collection o k response
func (o *NodeModifyCollectionOK) Code() int {
	return 200
}

func (o *NodeModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/nodes][%d] nodeModifyCollectionOK %s", 200, payload)
}

func (o *NodeModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/nodes][%d] nodeModifyCollectionOK %s", 200, payload)
}

func (o *NodeModifyCollectionOK) GetPayload() *models.NodeJobLinkResponse {
	return o.Payload
}

func (o *NodeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodeModifyCollectionAccepted creates a NodeModifyCollectionAccepted with default headers values
func NewNodeModifyCollectionAccepted() *NodeModifyCollectionAccepted {
	return &NodeModifyCollectionAccepted{}
}

/*
NodeModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type NodeModifyCollectionAccepted struct {
	Payload *models.NodeJobLinkResponse
}

// IsSuccess returns true when this node modify collection accepted response has a 2xx status code
func (o *NodeModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this node modify collection accepted response has a 3xx status code
func (o *NodeModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this node modify collection accepted response has a 4xx status code
func (o *NodeModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this node modify collection accepted response has a 5xx status code
func (o *NodeModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this node modify collection accepted response a status code equal to that given
func (o *NodeModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the node modify collection accepted response
func (o *NodeModifyCollectionAccepted) Code() int {
	return 202
}

func (o *NodeModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/nodes][%d] nodeModifyCollectionAccepted %s", 202, payload)
}

func (o *NodeModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/nodes][%d] nodeModifyCollectionAccepted %s", 202, payload)
}

func (o *NodeModifyCollectionAccepted) GetPayload() *models.NodeJobLinkResponse {
	return o.Payload
}

func (o *NodeModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NodeJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodeModifyCollectionDefault creates a NodeModifyCollectionDefault with default headers values
func NewNodeModifyCollectionDefault(code int) *NodeModifyCollectionDefault {
	return &NodeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NodeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 852046 | HA partner node is not running to do takeover. |
| 852115 | The reboot/shutdown is prevented because LIFs cannot be moved away from the node. |
| 852269 | This operation is not supported on this platform. |
| 3604514 | A reboot or shutdown request is already in progress. |
| 3604515 | Reboot or shutdown of all nodes results in data service failure and client disruption for the entire cluster. Use "allow-data-outage=true" to bypass this check. |
| 9240591 | The name is not valid. The name is already in use by a cluster node, SVM, or it is the name of the local cluster. |
| 9240606 | The reboot/shutdown is prevented due to quorum warnings. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NodeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this node modify collection default response has a 2xx status code
func (o *NodeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this node modify collection default response has a 3xx status code
func (o *NodeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this node modify collection default response has a 4xx status code
func (o *NodeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this node modify collection default response has a 5xx status code
func (o *NodeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this node modify collection default response a status code equal to that given
func (o *NodeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the node modify collection default response
func (o *NodeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NodeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/nodes][%d] node_modify_collection default %s", o._statusCode, payload)
}

func (o *NodeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/nodes][%d] node_modify_collection default %s", o._statusCode, payload)
}

func (o *NodeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NodeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NodeModifyCollectionBody node modify collection body
swagger:model NodeModifyCollectionBody
*/
type NodeModifyCollectionBody struct {

	// links
	Links *models.NodeResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Anti ransomware version.
	// Example: 1.0
	// Read Only: true
	AntiRansomwareVersion *string `json:"anti_ransomware_version,omitempty"`

	// cluster interface
	ClusterInterface *models.NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface `json:"cluster_interface,omitempty"`

	// cluster interfaces
	// Read Only: true
	ClusterInterfaces []*NodeModifyCollectionParamsBodyClusterInterfacesItems0 `json:"cluster_interfaces"`

	// controller
	Controller *models.NodeResponseInlineRecordsInlineArrayItemInlineController `json:"controller,omitempty"`

	// The current or "wall clock" time of the node in ISO-8601 date, time, and time zone format.
	// The ISO-8601 date and time are localized based on the ONTAP cluster's timezone setting.
	//
	// Example: 2019-04-17 11:49:26-04:00
	// Read Only: true
	// Format: date-time
	Date *strfmt.DateTime `json:"date,omitempty"`

	// external cache
	ExternalCache *models.NodeResponseInlineRecordsInlineArrayItemInlineExternalCache `json:"external_cache,omitempty"`

	// external cache bypass
	ExternalCacheBypass *models.NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass `json:"external_cache_bypass,omitempty"`

	// ha
	Ha *models.NodeResponseInlineRecordsInlineArrayItemInlineHa `json:"ha,omitempty"`

	// hw assist
	HwAssist *models.NodeResponseInlineRecordsInlineArrayItemInlineHwAssist `json:"hw_assist,omitempty"`

	// Specifies whether or not the node is in spares low condition.
	// Read Only: true
	IsSparesLow *bool `json:"is_spares_low,omitempty"`

	// location
	// Example: rack 2 row 5
	Location *string `json:"location,omitempty"`

	// management interface
	ManagementInterface *models.NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface `json:"management_interface,omitempty"`

	// management interfaces
	// Read Only: true
	ManagementInterfaces []*NodeModifyCollectionParamsBodyManagementInterfacesItems0 `json:"management_interfaces"`

	// Possible values:
	// * <i>available</i> - A node is detected on the internal cluster network and can be added to the cluster.  Nodes that have a membership of "available" are not returned when a GET request is called when the cluster exists. Provide a query on the "membership" property for <i>available</i> to scan for nodes on the cluster network. Nodes that have a membership of "available" are returned automatically before a cluster is created.
	// * <i>joining</i> - Joining nodes are in the process of being added to the cluster. The node might be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.
	// * <i>member</i> - Nodes that are members have successfully joined the cluster.
	//
	// Read Only: true
	// Enum: ["available","joining","member"]
	Membership *string `json:"membership,omitempty"`

	// metric
	Metric *models.NodeResponseInlineRecordsInlineArrayItemInlineMetric `json:"metric,omitempty"`

	// metrocluster
	Metrocluster *models.NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster `json:"metrocluster,omitempty"`

	// model
	// Example: FAS3070
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// name
	// Example: node-01
	Name *string `json:"name,omitempty"`

	// node response inline records
	NodeResponseInlineRecords []*models.NodeResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// nvlog
	Nvlog *models.NodeResponseInlineRecordsInlineArrayItemInlineNvlog `json:"nvlog,omitempty"`

	// nvram
	Nvram *models.NodeResponseInlineRecordsInlineArrayItemInlineNvram `json:"nvram,omitempty"`

	// Owner of the node.
	// Example: Example Corp
	Owner *string `json:"owner,omitempty"`

	// serial number
	// Example: 4048820-60-9
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// service processor
	ServiceProcessor *models.NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor `json:"service_processor,omitempty"`

	// snaplock
	Snaplock *models.NodeResponseInlineRecordsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// State of the node:
	// * <i>up</i> - Node is up and operational.
	// * <i>booting</i> - Node is booting up.
	// * <i>down</i> - Node has stopped or is dumping core.
	// * <i>taken_over</i> - Node has been taken over by its HA partner and is not yet waiting for giveback.
	// * <i>waiting_for_giveback</i> - Node has been taken over by its HA partner and is waiting for the HA partner to giveback disks.
	// * <i>degraded</i> - Node has one or more critical services offline.
	// * <i>unknown</i> - Node or its HA partner cannot be contacted and there is no information on the node's state.
	//
	// Read Only: true
	// Enum: ["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.NodeResponseInlineRecordsInlineArrayItemInlineStatistics `json:"statistics,omitempty"`

	// Storage availability zones associated with the node.
	// Read Only: true
	StorageAvailabilityZones []*models.StorageAvailabilityZoneReference `json:"storage_availability_zones"`

	// The storage configuration in the system. Possible values:
	// * <i>mixed_path</i>
	// * <i>single_path</i>
	// * <i>multi_path</i>
	// * <i>tri_path</i>
	// * <i>quad_path</i>
	// * <i>mixed_path_ha</i>
	// * <i>single_path_ha</i>
	// * <i>multi_path_ha</i>
	// * <i>tri_path_ha</i>
	// * <i>quad_path_ha</i>
	// * <i>unknown</i>
	// * <i>virtual</i>
	//
	// Read Only: true
	// Enum: ["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]
	StorageConfiguration *string `json:"storage_configuration,omitempty"`

	// system aggregate
	SystemAggregate *models.NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate `json:"system_aggregate,omitempty"`

	// system id
	// Example: 92027651
	// Read Only: true
	SystemID *string `json:"system_id,omitempty"`

	// OEM system machine type.
	// Example: 7Y56-CTOWW1
	// Read Only: true
	SystemMachineType *string `json:"system_machine_type,omitempty"`

	// The total time, in seconds, that the node has been up.
	// Example: 300536
	// Read Only: true
	Uptime *int64 `json:"uptime,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// OEM vendor serial number.
	// Example: 791603000068
	// Read Only: true
	VendorSerialNumber *string `json:"vendor_serial_number,omitempty"`

	// version
	Version *models.NodeResponseInlineRecordsInlineArrayItemInlineVersion `json:"version,omitempty"`

	// vm
	VM *models.NodeResponseInlineRecordsInlineArrayItemInlineVM `json:"vm,omitempty"`
}

// Validate validates this node modify collection body
func (o *NodeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClusterInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClusterInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateController(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExternalCache(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExternalCacheBypass(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHa(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHwAssist(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateManagementInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateManagementInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetrocluster(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNodeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvlog(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvram(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServiceProcessor(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageAvailabilityZones(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSystemAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVM(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateClusterInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.ClusterInterface) { // not required
		return nil
	}

	if o.ClusterInterface != nil {
		if err := o.ClusterInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateClusterInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.ClusterInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(o.ClusterInterfaces); i++ {
		if swag.IsZero(o.ClusterInterfaces[i]) { // not required
			continue
		}

		if o.ClusterInterfaces[i] != nil {
			if err := o.ClusterInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NodeModifyCollectionBody) validateController(formats strfmt.Registry) error {
	if swag.IsZero(o.Controller) { // not required
		return nil
	}

	if o.Controller != nil {
		if err := o.Controller.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "controller")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateDate(formats strfmt.Registry) error {
	if swag.IsZero(o.Date) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"date", "body", "date-time", o.Date.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateExternalCache(formats strfmt.Registry) error {
	if swag.IsZero(o.ExternalCache) { // not required
		return nil
	}

	if o.ExternalCache != nil {
		if err := o.ExternalCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external_cache")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateExternalCacheBypass(formats strfmt.Registry) error {
	if swag.IsZero(o.ExternalCacheBypass) { // not required
		return nil
	}

	if o.ExternalCacheBypass != nil {
		if err := o.ExternalCacheBypass.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateHa(formats strfmt.Registry) error {
	if swag.IsZero(o.Ha) { // not required
		return nil
	}

	if o.Ha != nil {
		if err := o.Ha.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ha")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateHwAssist(formats strfmt.Registry) error {
	if swag.IsZero(o.HwAssist) { // not required
		return nil
	}

	if o.HwAssist != nil {
		if err := o.HwAssist.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "hw_assist")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateManagementInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.ManagementInterface) { // not required
		return nil
	}

	if o.ManagementInterface != nil {
		if err := o.ManagementInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "management_interface")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateManagementInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.ManagementInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(o.ManagementInterfaces); i++ {
		if swag.IsZero(o.ManagementInterfaces[i]) { // not required
			continue
		}

		if o.ManagementInterfaces[i] != nil {
			if err := o.ManagementInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeModifyCollectionBodyTypeMembershipPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","joining","member"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionBodyTypeMembershipPropEnum = append(nodeModifyCollectionBodyTypeMembershipPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// membership
	// Membership
	// available
	// END DEBUGGING
	// NodeModifyCollectionBodyMembershipAvailable captures enum value "available"
	NodeModifyCollectionBodyMembershipAvailable string = "available"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// membership
	// Membership
	// joining
	// END DEBUGGING
	// NodeModifyCollectionBodyMembershipJoining captures enum value "joining"
	NodeModifyCollectionBodyMembershipJoining string = "joining"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// membership
	// Membership
	// member
	// END DEBUGGING
	// NodeModifyCollectionBodyMembershipMember captures enum value "member"
	NodeModifyCollectionBodyMembershipMember string = "member"
)

// prop value enum
func (o *NodeModifyCollectionBody) validateMembershipEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionBodyTypeMembershipPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionBody) validateMembership(formats strfmt.Registry) error {
	if swag.IsZero(o.Membership) { // not required
		return nil
	}

	// value enum
	if err := o.validateMembershipEnum("info"+"."+"membership", "body", *o.Membership); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateMetrocluster(formats strfmt.Registry) error {
	if swag.IsZero(o.Metrocluster) { // not required
		return nil
	}

	if o.Metrocluster != nil {
		if err := o.Metrocluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metrocluster")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateNodeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NodeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NodeResponseInlineRecords); i++ {
		if swag.IsZero(o.NodeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NodeResponseInlineRecords[i] != nil {
			if err := o.NodeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NodeModifyCollectionBody) validateNvlog(formats strfmt.Registry) error {
	if swag.IsZero(o.Nvlog) { // not required
		return nil
	}

	if o.Nvlog != nil {
		if err := o.Nvlog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvlog")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateNvram(formats strfmt.Registry) error {
	if swag.IsZero(o.Nvram) { // not required
		return nil
	}

	if o.Nvram != nil {
		if err := o.Nvram.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvram")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateServiceProcessor(formats strfmt.Registry) error {
	if swag.IsZero(o.ServiceProcessor) { // not required
		return nil
	}

	if o.ServiceProcessor != nil {
		if err := o.ServiceProcessor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_processor")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

var nodeModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionBodyTypeStatePropEnum = append(nodeModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// up
	// END DEBUGGING
	// NodeModifyCollectionBodyStateUp captures enum value "up"
	NodeModifyCollectionBodyStateUp string = "up"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// booting
	// END DEBUGGING
	// NodeModifyCollectionBodyStateBooting captures enum value "booting"
	NodeModifyCollectionBodyStateBooting string = "booting"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// down
	// END DEBUGGING
	// NodeModifyCollectionBodyStateDown captures enum value "down"
	NodeModifyCollectionBodyStateDown string = "down"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// taken_over
	// END DEBUGGING
	// NodeModifyCollectionBodyStateTakenOver captures enum value "taken_over"
	NodeModifyCollectionBodyStateTakenOver string = "taken_over"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// waiting_for_giveback
	// END DEBUGGING
	// NodeModifyCollectionBodyStateWaitingForGiveback captures enum value "waiting_for_giveback"
	NodeModifyCollectionBodyStateWaitingForGiveback string = "waiting_for_giveback"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// degraded
	// END DEBUGGING
	// NodeModifyCollectionBodyStateDegraded captures enum value "degraded"
	NodeModifyCollectionBodyStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// state
	// State
	// unknown
	// END DEBUGGING
	// NodeModifyCollectionBodyStateUnknown captures enum value "unknown"
	NodeModifyCollectionBodyStateUnknown string = "unknown"
)

// prop value enum
func (o *NodeModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateStorageAvailabilityZones(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZones) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageAvailabilityZones); i++ {
		if swag.IsZero(o.StorageAvailabilityZones[i]) { // not required
			continue
		}

		if o.StorageAvailabilityZones[i] != nil {
			if err := o.StorageAvailabilityZones[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeModifyCollectionBodyTypeStorageConfigurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionBodyTypeStorageConfigurationPropEnum = append(nodeModifyCollectionBodyTypeStorageConfigurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// unknown
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationUnknown captures enum value "unknown"
	NodeModifyCollectionBodyStorageConfigurationUnknown string = "unknown"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// single_path
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationSinglePath captures enum value "single_path"
	NodeModifyCollectionBodyStorageConfigurationSinglePath string = "single_path"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// multi_path
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationMultiPath captures enum value "multi_path"
	NodeModifyCollectionBodyStorageConfigurationMultiPath string = "multi_path"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// mixed_path
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationMixedPath captures enum value "mixed_path"
	NodeModifyCollectionBodyStorageConfigurationMixedPath string = "mixed_path"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// quad_path
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationQuadPath captures enum value "quad_path"
	NodeModifyCollectionBodyStorageConfigurationQuadPath string = "quad_path"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// single_path_ha
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationSinglePathHa captures enum value "single_path_ha"
	NodeModifyCollectionBodyStorageConfigurationSinglePathHa string = "single_path_ha"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// multi_path_ha
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationMultiPathHa captures enum value "multi_path_ha"
	NodeModifyCollectionBodyStorageConfigurationMultiPathHa string = "multi_path_ha"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// mixed_path_ha
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationMixedPathHa captures enum value "mixed_path_ha"
	NodeModifyCollectionBodyStorageConfigurationMixedPathHa string = "mixed_path_ha"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// quad_path_ha
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationQuadPathHa captures enum value "quad_path_ha"
	NodeModifyCollectionBodyStorageConfigurationQuadPathHa string = "quad_path_ha"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// tri_path
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationTriPath captures enum value "tri_path"
	NodeModifyCollectionBodyStorageConfigurationTriPath string = "tri_path"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// tri_path_ha
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationTriPathHa captures enum value "tri_path_ha"
	NodeModifyCollectionBodyStorageConfigurationTriPathHa string = "tri_path_ha"

	// BEGIN DEBUGGING
	// NodeModifyCollectionBody
	// NodeModifyCollectionBody
	// storage_configuration
	// StorageConfiguration
	// virtual
	// END DEBUGGING
	// NodeModifyCollectionBodyStorageConfigurationVirtual captures enum value "virtual"
	NodeModifyCollectionBodyStorageConfigurationVirtual string = "virtual"
)

// prop value enum
func (o *NodeModifyCollectionBody) validateStorageConfigurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionBodyTypeStorageConfigurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionBody) validateStorageConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageConfiguration) { // not required
		return nil
	}

	// value enum
	if err := o.validateStorageConfigurationEnum("info"+"."+"storage_configuration", "body", *o.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateSystemAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.SystemAggregate) { // not required
		return nil
	}

	if o.SystemAggregate != nil {
		if err := o.SystemAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) validateVM(formats strfmt.Registry) error {
	if swag.IsZero(o.VM) { // not required
		return nil
	}

	if o.VM != nil {
		if err := o.VM.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection body based on the context it is used
func (o *NodeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAntiRansomwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClusterInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClusterInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateController(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExternalCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExternalCacheBypass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHa(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHwAssist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSparesLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateManagementInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateManagementInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetrocluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNodeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvlog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvram(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServiceProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageAvailabilityZones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemMachineType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUptime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVendorSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVM(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateAntiRansomwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware_version", "body", o.AntiRansomwareVersion); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateClusterInterface(ctx context.Context, formats strfmt.Registry) error {

	if o.ClusterInterface != nil {
		if err := o.ClusterInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateClusterInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"cluster_interfaces", "body", []*NodeModifyCollectionParamsBodyClusterInterfacesItems0(o.ClusterInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(o.ClusterInterfaces); i++ {

		if o.ClusterInterfaces[i] != nil {
			if err := o.ClusterInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateController(ctx context.Context, formats strfmt.Registry) error {

	if o.Controller != nil {
		if err := o.Controller.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "controller")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateDate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"date", "body", o.Date); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateExternalCache(ctx context.Context, formats strfmt.Registry) error {

	if o.ExternalCache != nil {
		if err := o.ExternalCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external_cache")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateExternalCacheBypass(ctx context.Context, formats strfmt.Registry) error {

	if o.ExternalCacheBypass != nil {
		if err := o.ExternalCacheBypass.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateHa(ctx context.Context, formats strfmt.Registry) error {

	if o.Ha != nil {
		if err := o.Ha.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ha")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateHwAssist(ctx context.Context, formats strfmt.Registry) error {

	if o.HwAssist != nil {
		if err := o.HwAssist.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "hw_assist")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateIsSparesLow(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_spares_low", "body", o.IsSparesLow); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateManagementInterface(ctx context.Context, formats strfmt.Registry) error {

	if o.ManagementInterface != nil {
		if err := o.ManagementInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "management_interface")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateManagementInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"management_interfaces", "body", []*NodeModifyCollectionParamsBodyManagementInterfacesItems0(o.ManagementInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(o.ManagementInterfaces); i++ {

		if o.ManagementInterfaces[i] != nil {
			if err := o.ManagementInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"membership", "body", o.Membership); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateMetrocluster(ctx context.Context, formats strfmt.Registry) error {

	if o.Metrocluster != nil {
		if err := o.Metrocluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metrocluster")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"model", "body", o.Model); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateNodeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NodeResponseInlineRecords); i++ {

		if o.NodeResponseInlineRecords[i] != nil {
			if err := o.NodeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateNvlog(ctx context.Context, formats strfmt.Registry) error {

	if o.Nvlog != nil {
		if err := o.Nvlog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvlog")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateNvram(ctx context.Context, formats strfmt.Registry) error {

	if o.Nvram != nil {
		if err := o.Nvram.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvram")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateServiceProcessor(ctx context.Context, formats strfmt.Registry) error {

	if o.ServiceProcessor != nil {
		if err := o.ServiceProcessor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "service_processor")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateStorageAvailabilityZones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage_availability_zones", "body", []*models.StorageAvailabilityZoneReference(o.StorageAvailabilityZones)); err != nil {
		return err
	}

	for i := 0; i < len(o.StorageAvailabilityZones); i++ {

		if o.StorageAvailabilityZones[i] != nil {
			if err := o.StorageAvailabilityZones[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateStorageConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage_configuration", "body", o.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateSystemAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.SystemAggregate != nil {
		if err := o.SystemAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateSystemID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"system_id", "body", o.SystemID); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateSystemMachineType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"system_machine_type", "body", o.SystemMachineType); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateUptime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uptime", "body", o.Uptime); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateVendorSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"vendor_serial_number", "body", o.VendorSerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionBody) contextValidateVM(ctx context.Context, formats strfmt.Registry) error {

	if o.VM != nil {
		if err := o.VM.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyClusterInterfacesItems0 Network interface
swagger:model NodeModifyCollectionParamsBodyClusterInterfacesItems0
*/
type NodeModifyCollectionParamsBodyClusterInterfacesItems0 struct {

	// links
	Links *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body cluster interfaces items0
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body cluster interfaces items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyClusterInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyClusterInterfacesItems0IP IP information
swagger:model NodeModifyCollectionParamsBodyClusterInterfacesItems0IP
*/
type NodeModifyCollectionParamsBodyClusterInterfacesItems0IP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node modify collection params body cluster interfaces items0 IP
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body cluster interfaces items0 IP based on the context it is used
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyClusterInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyClusterInterfacesItems0Links node modify collection params body cluster interfaces items0 links
swagger:model NodeModifyCollectionParamsBodyClusterInterfacesItems0Links
*/
type NodeModifyCollectionParamsBodyClusterInterfacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body cluster interfaces items0 links
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body cluster interfaces items0 links based on the context it is used
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyClusterInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyClusterInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyControllerFlashCacheItems0 node modify collection params body controller flash cache items0
swagger:model NodeModifyCollectionParamsBodyControllerFlashCacheItems0
*/
type NodeModifyCollectionParamsBodyControllerFlashCacheItems0 struct {

	// Size in bytes
	// Example: 1024000000000
	// Read Only: true
	Capacity *int64 `json:"capacity,omitempty"`

	// device id
	// Example: 0
	// Read Only: true
	DeviceID *int64 `json:"device_id,omitempty"`

	// firmware file
	// Example: X9170_O000Z6300NVM
	// Read Only: true
	FirmwareFile *string `json:"firmware_file,omitempty"`

	// firmware version
	// Example: NA05
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// hardware revision
	// Example: A1
	// Read Only: true
	HardwareRevision *string `json:"hardware_revision,omitempty"`

	// model
	// Example: X1970A
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// part number
	// Example: 119-00207
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: A22P5061550000187
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// slot
	// Example: 6-1
	// Read Only: true
	Slot *string `json:"slot,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","erasing","erased","failed","removed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node modify collection params body controller flash cache items0
func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyControllerFlashCacheItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","erasing","erased","failed","removed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyControllerFlashCacheItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyControllerFlashCacheItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateOk captures enum value "ok"
	NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// state
	// State
	// erasing
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateErasing captures enum value "erasing"
	NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateErasing string = "erasing"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// state
	// State
	// erased
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateErased captures enum value "erased"
	NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateErased string = "erased"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateFailed captures enum value "failed"
	NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	// state
	// State
	// removed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateRemoved captures enum value "removed"
	NodeModifyCollectionParamsBodyControllerFlashCacheItems0StateRemoved string = "removed"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyControllerFlashCacheItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body controller flash cache items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDeviceID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFirmwareFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHardwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSlot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity", "body", o.Capacity); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateDeviceID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "device_id", "body", o.DeviceID); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateFirmwareFile(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_file", "body", o.FirmwareFile); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", o.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateHardwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hardware_revision", "body", o.HardwareRevision); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", o.Model); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "part_number", "body", o.PartNumber); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateSlot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "slot", "body", o.Slot); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyControllerFlashCacheItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyControllerFlashCacheItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyControllerFrusItems0 node modify collection params body controller frus items0
swagger:model NodeModifyCollectionParamsBodyControllerFrusItems0
*/
type NodeModifyCollectionParamsBodyControllerFrusItems0 struct {

	// id
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["fan","psu","pcie","disk","nvs","dimm","controller"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node modify collection params body controller frus items0
func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyControllerFrusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyControllerFrusItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyControllerFrusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0StateOk captures enum value "ok"
	NodeModifyCollectionParamsBodyControllerFrusItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// state
	// State
	// error
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0StateError captures enum value "error"
	NodeModifyCollectionParamsBodyControllerFrusItems0StateError string = "error"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyControllerFrusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var nodeModifyCollectionParamsBodyControllerFrusItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fan","psu","pcie","disk","nvs","dimm","controller"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyControllerFrusItems0TypeTypePropEnum = append(nodeModifyCollectionParamsBodyControllerFrusItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// fan
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypeFan captures enum value "fan"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypeFan string = "fan"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// psu
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypePsu captures enum value "psu"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypePsu string = "psu"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// pcie
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypePcie captures enum value "pcie"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypePcie string = "pcie"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// disk
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypeDisk captures enum value "disk"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypeDisk string = "disk"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// nvs
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypeNvs captures enum value "nvs"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypeNvs string = "nvs"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// dimm
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypeDimm captures enum value "dimm"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypeDimm string = "dimm"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// NodeModifyCollectionParamsBodyControllerFrusItems0
	// type
	// Type
	// controller
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyControllerFrusItems0TypeController captures enum value "controller"
	NodeModifyCollectionParamsBodyControllerFrusItems0TypeController string = "controller"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyControllerFrusItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body controller frus items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyControllerFrusItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyControllerFrusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaGivebackStatusItems0 node modify collection params body ha giveback status items0
swagger:model NodeModifyCollectionParamsBodyHaGivebackStatusItems0
*/
type NodeModifyCollectionParamsBodyHaGivebackStatusItems0 struct {

	// aggregate
	Aggregate *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate `json:"aggregate,omitempty"`

	// error
	Error *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error `json:"error,omitempty"`

	// Giveback state of the aggregate. <br/>
	// Possible values include no aggregates to giveback(nothing_to_giveback), failed to disable background disk firmware update(BDFU) on source node(failed_bdfu_source), <br/>
	// giveback delayed as disk firmware update is in progress on source node(delayed_bdfu_source), performing veto checks(running_checks). <br/>
	//
	// Enum: ["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node modify collection params body ha giveback status items0
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.Aggregate) { // not required
		return nil
	}

	if o.Aggregate != nil {
		if err := o.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

var nodeModifyCollectionParamsBodyHaGivebackStatusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyHaGivebackStatusItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyHaGivebackStatusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// done
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateDone captures enum value "done"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateDone string = "done"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateFailed captures enum value "failed"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateInProgress captures enum value "in_progress"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// not_started
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateNotStarted captures enum value "not_started"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateNotStarted string = "not_started"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateNothingToGiveback captures enum value "nothing_to_giveback"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_source
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateFailedBdfuSource captures enum value "failed_bdfu_source"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateFailedBdfuSource string = "failed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_dest
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateFailedBdfuDest captures enum value "failed_bdfu_dest"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateFailedBdfuDest string = "failed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_source
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateDelayedBdfuSource captures enum value "delayed_bdfu_source"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateDelayedBdfuSource string = "delayed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_dest
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateDelayedBdfuDest captures enum value "delayed_bdfu_dest"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateDelayedBdfuDest string = "delayed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	// state
	// State
	// running_checks
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateRunningChecks captures enum value "running_checks"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0StateRunningChecks string = "running_checks"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyHaGivebackStatusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha giveback status items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.Aggregate != nil {
		if err := o.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaGivebackStatusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate Aggregate name and UUID.
swagger:model NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate
*/
type NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate struct {

	// links
	Links *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body ha giveback status items0 aggregate
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha giveback status items0 aggregate based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaGivebackStatusItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks node modify collection params body ha giveback status items0 aggregate links
swagger:model NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks
*/
type NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body ha giveback status items0 aggregate links
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha giveback status items0 aggregate links based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaGivebackStatusItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error Indicates the failed aggregate giveback code and message.
swagger:model NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
*/
type NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error struct {

	// Message code.
	// Example: 852126
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Detailed message based on the state.
	// Read Only: true
	// Enum: ["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]
	Message *string `json:"message,omitempty"`
}

// Validate validates this node modify collection params body ha giveback status items0 error
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorTypeMessagePropEnum = append(nodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// shutdown
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageShutdown captures enum value "shutdown"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageShutdown string = "shutdown"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// not_homes_partner
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageNotHomesPartner captures enum value "not_homes_partner"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageNotHomesPartner string = "not_homes_partner"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// not_sfo
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageNotSfo captures enum value "not_sfo"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageNotSfo string = "not_sfo"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// failed_limbo
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageFailedLimbo captures enum value "failed_limbo"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageFailedLimbo string = "failed_limbo"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// offline_failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageOfflineFailed captures enum value "offline_failed"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageOfflineFailed string = "offline_failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// migrating
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageMigrating captures enum value "migrating"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageMigrating string = "migrating"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// veto
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageVeto captures enum value "veto"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageVeto string = "veto"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// communication_err
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageCommunicationErr captures enum value "communication_err"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageCommunicationErr string = "communication_err"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// online_timeout
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageOnlineTimeout captures enum value "online_timeout"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageOnlineTimeout string = "online_timeout"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// online_failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageOnlineFailed captures enum value "online_failed"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageOnlineFailed string = "online_failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	// message
	// Message
	// hdd_to_aff_dest
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageHddToAffDest captures enum value "hdd_to_aff_dest"
	NodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorMessageHddToAffDest string = "hdd_to_aff_dest"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyHaGivebackStatusItems0ErrorTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	// value enum
	if err := o.validateMessageEnum("error"+"."+"message", "body", *o.Message); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha giveback status items0 error based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaGivebackStatusItems0Error
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaPartnersItems0 node modify collection params body ha partners items0
swagger:model NodeModifyCollectionParamsBodyHaPartnersItems0
*/
type NodeModifyCollectionParamsBodyHaPartnersItems0 struct {

	// links
	Links *NodeModifyCollectionParamsBodyHaPartnersItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body ha partners items0
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPartnersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha partners items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPartnersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaPartnersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaPartnersItems0Links node modify collection params body ha partners items0 links
swagger:model NodeModifyCollectionParamsBodyHaPartnersItems0Links
*/
type NodeModifyCollectionParamsBodyHaPartnersItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body ha partners items0 links
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPartnersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha partners items0 links based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPartnersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaPartnersItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaPartnersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyHaPortsItems0 node modify collection params body ha ports items0
swagger:model NodeModifyCollectionParamsBodyHaPortsItems0
*/
type NodeModifyCollectionParamsBodyHaPortsItems0 struct {

	// HA port number
	// Example: 0
	// Read Only: true
	Number *int64 `json:"number,omitempty"`

	// HA port state:
	// * <i>down</i> - Logical HA link is down.
	// * <i>initialized</i> - Logical HA link is initialized. The physical link is up, but the subnet manager hasn't started to configure the port.
	// * <i>armed</i> - Logical HA link is armed. The physical link is up and the subnet manager started but did not yet complete configuring the port.
	// * <i>active</i> - Logical HA link is active.
	// * <i>reserved</i> - Logical HA link is active, but the physical link is down.
	//
	// Example: active
	// Read Only: true
	// Enum: ["down","initialized","armed","active","reserved"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node modify collection params body ha ports items0
func (o *NodeModifyCollectionParamsBodyHaPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyHaPortsItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","initialized","armed","active","reserved"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyHaPortsItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyHaPortsItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// state
	// State
	// down
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0StateDown captures enum value "down"
	NodeModifyCollectionParamsBodyHaPortsItems0StateDown string = "down"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// state
	// State
	// initialized
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0StateInitialized captures enum value "initialized"
	NodeModifyCollectionParamsBodyHaPortsItems0StateInitialized string = "initialized"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// state
	// State
	// armed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0StateArmed captures enum value "armed"
	NodeModifyCollectionParamsBodyHaPortsItems0StateArmed string = "armed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// state
	// State
	// active
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0StateActive captures enum value "active"
	NodeModifyCollectionParamsBodyHaPortsItems0StateActive string = "active"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// NodeModifyCollectionParamsBodyHaPortsItems0
	// state
	// State
	// reserved
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyHaPortsItems0StateReserved captures enum value "reserved"
	NodeModifyCollectionParamsBodyHaPortsItems0StateReserved string = "reserved"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyHaPortsItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyHaPortsItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPortsItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body ha ports items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyHaPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPortsItems0) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "number", "body", o.Number); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyHaPortsItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaPortsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyHaPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyHaPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyManagementInterfacesItems0 Network interface
swagger:model NodeModifyCollectionParamsBodyManagementInterfacesItems0
*/
type NodeModifyCollectionParamsBodyManagementInterfacesItems0 struct {

	// links
	Links *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body management interfaces items0
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body management interfaces items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyManagementInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyManagementInterfacesItems0IP IP information
swagger:model NodeModifyCollectionParamsBodyManagementInterfacesItems0IP
*/
type NodeModifyCollectionParamsBodyManagementInterfacesItems0IP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node modify collection params body management interfaces items0 IP
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body management interfaces items0 IP based on the context it is used
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyManagementInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyManagementInterfacesItems0Links node modify collection params body management interfaces items0 links
swagger:model NodeModifyCollectionParamsBodyManagementInterfacesItems0Links
*/
type NodeModifyCollectionParamsBodyManagementInterfacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body management interfaces items0 links
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body management interfaces items0 links based on the context it is used
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyManagementInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyManagementInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyMetroclusterPortsItems0 node modify collection params body metrocluster ports items0
swagger:model NodeModifyCollectionParamsBodyMetroclusterPortsItems0
*/
type NodeModifyCollectionParamsBodyMetroclusterPortsItems0 struct {

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`
}

// Validate validates this node modify collection params body metrocluster ports items0
func (o *NodeModifyCollectionParamsBodyMetroclusterPortsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node modify collection params body metrocluster ports items0 based on context it is used
func (o *NodeModifyCollectionParamsBodyMetroclusterPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyMetroclusterPortsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyMetroclusterPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyMetroclusterPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0 Network interface
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0 struct {

	// links
	Links *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body records items0 cluster interfaces items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 cluster interfaces items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP IP information
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP
*/
type NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node modify collection params body records items0 cluster interfaces items0 IP
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 cluster interfaces items0 IP based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links node modify collection params body records items0 cluster interfaces items0 links
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links
*/
type NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body records items0 cluster interfaces items0 links
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 cluster interfaces items0 links based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ClusterInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0 node modify collection params body records items0 controller flash cache items0
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0 struct {

	// Size in bytes
	// Example: 1024000000000
	// Read Only: true
	Capacity *int64 `json:"capacity,omitempty"`

	// device id
	// Example: 0
	// Read Only: true
	DeviceID *int64 `json:"device_id,omitempty"`

	// firmware file
	// Example: X9170_O000Z6300NVM
	// Read Only: true
	FirmwareFile *string `json:"firmware_file,omitempty"`

	// firmware version
	// Example: NA05
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// hardware revision
	// Example: A1
	// Read Only: true
	HardwareRevision *string `json:"hardware_revision,omitempty"`

	// model
	// Example: X1970A
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// part number
	// Example: 119-00207
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: A22P5061550000187
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// slot
	// Example: 6-1
	// Read Only: true
	Slot *string `json:"slot,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","erasing","erased","failed","removed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node modify collection params body records items0 controller flash cache items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","erasing","erased","failed","removed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateOk captures enum value "ok"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// erasing
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateErasing captures enum value "erasing"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateErasing string = "erasing"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// erased
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateErased captures enum value "erased"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateErased string = "erased"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateFailed captures enum value "failed"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// removed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateRemoved captures enum value "removed"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0StateRemoved string = "removed"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 controller flash cache items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDeviceID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFirmwareFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHardwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSlot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity", "body", o.Capacity); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateDeviceID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "device_id", "body", o.DeviceID); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateFirmwareFile(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_file", "body", o.FirmwareFile); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", o.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateHardwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hardware_revision", "body", o.HardwareRevision); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", o.Model); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "part_number", "body", o.PartNumber); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateSlot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "slot", "body", o.Slot); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ControllerFlashCacheItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0 node modify collection params body records items0 controller frus items0
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0 struct {

	// id
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["fan","psu","pcie","disk","nvs","dimm","controller"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node modify collection params body records items0 controller frus items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0StateOk captures enum value "ok"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// state
	// State
	// error
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0StateError captures enum value "error"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0StateError string = "error"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fan","psu","pcie","disk","nvs","dimm","controller"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeTypePropEnum = append(nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// fan
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeFan captures enum value "fan"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeFan string = "fan"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// psu
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypePsu captures enum value "psu"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypePsu string = "psu"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// pcie
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypePcie captures enum value "pcie"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypePcie string = "pcie"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// disk
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeDisk captures enum value "disk"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeDisk string = "disk"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// nvs
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeNvs captures enum value "nvs"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeNvs string = "nvs"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// dimm
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeDimm captures enum value "dimm"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeDimm string = "dimm"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	// type
	// Type
	// controller
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeController captures enum value "controller"
	NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeController string = "controller"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 controller frus items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ControllerFrusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0 node modify collection params body records items0 ha giveback status items0
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0 struct {

	// aggregate
	Aggregate *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate `json:"aggregate,omitempty"`

	// error
	Error *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error `json:"error,omitempty"`

	// Giveback state of the aggregate. <br/>
	// Possible values include no aggregates to giveback(nothing_to_giveback), failed to disable background disk firmware update(BDFU) on source node(failed_bdfu_source), <br/>
	// giveback delayed as disk firmware update is in progress on source node(delayed_bdfu_source), performing veto checks(running_checks). <br/>
	//
	// Enum: ["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha giveback status items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.Aggregate) { // not required
		return nil
	}

	if o.Aggregate != nil {
		if err := o.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

var nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// done
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateDone captures enum value "done"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateDone string = "done"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateFailed captures enum value "failed"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateInProgress captures enum value "in_progress"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// not_started
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateNotStarted captures enum value "not_started"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateNotStarted string = "not_started"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateNothingToGiveback captures enum value "nothing_to_giveback"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_source
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateFailedBdfuSource captures enum value "failed_bdfu_source"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateFailedBdfuSource string = "failed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_dest
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateFailedBdfuDest captures enum value "failed_bdfu_dest"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateFailedBdfuDest string = "failed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_source
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateDelayedBdfuSource captures enum value "delayed_bdfu_source"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateDelayedBdfuSource string = "delayed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_dest
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateDelayedBdfuDest captures enum value "delayed_bdfu_dest"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateDelayedBdfuDest string = "delayed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// running_checks
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateRunningChecks captures enum value "running_checks"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0StateRunningChecks string = "running_checks"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha giveback status items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.Aggregate != nil {
		if err := o.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate Aggregate name and UUID.
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate struct {

	// links
	Links *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha giveback status items0 aggregate
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha giveback status items0 aggregate based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks node modify collection params body records items0 ha giveback status items0 aggregate links
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha giveback status items0 aggregate links
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha giveback status items0 aggregate links based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error Indicates the failed aggregate giveback code and message.
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error struct {

	// Message code.
	// Example: 852126
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Detailed message based on the state.
	// Read Only: true
	// Enum: ["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]
	Message *string `json:"message,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha giveback status items0 error
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum = append(nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// shutdown
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageShutdown captures enum value "shutdown"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageShutdown string = "shutdown"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// not_homes_partner
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageNotHomesPartner captures enum value "not_homes_partner"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageNotHomesPartner string = "not_homes_partner"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// not_sfo
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageNotSfo captures enum value "not_sfo"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageNotSfo string = "not_sfo"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// failed_limbo
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageFailedLimbo captures enum value "failed_limbo"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageFailedLimbo string = "failed_limbo"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// offline_failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageOfflineFailed captures enum value "offline_failed"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageOfflineFailed string = "offline_failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// migrating
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageMigrating captures enum value "migrating"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageMigrating string = "migrating"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// veto
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageVeto captures enum value "veto"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageVeto string = "veto"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// communication_err
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageCommunicationErr captures enum value "communication_err"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageCommunicationErr string = "communication_err"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// online_timeout
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineTimeout captures enum value "online_timeout"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineTimeout string = "online_timeout"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// online_failed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineFailed captures enum value "online_failed"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineFailed string = "online_failed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// hdd_to_aff_dest
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageHddToAffDest captures enum value "hdd_to_aff_dest"
	NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorMessageHddToAffDest string = "hdd_to_aff_dest"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	// value enum
	if err := o.validateMessageEnum("error"+"."+"message", "body", *o.Message); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha giveback status items0 error based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaGivebackStatusItems0Error
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0 node modify collection params body records items0 ha partners items0
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0 struct {

	// links
	Links *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha partners items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha partners items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links node modify collection params body records items0 ha partners items0 links
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha partners items0 links
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha partners items0 links based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaPartnersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0 node modify collection params body records items0 ha ports items0
swagger:model NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0 struct {

	// HA port number
	// Example: 0
	// Read Only: true
	Number *int64 `json:"number,omitempty"`

	// HA port state:
	// * <i>down</i> - Logical HA link is down.
	// * <i>initialized</i> - Logical HA link is initialized. The physical link is up, but the subnet manager hasn't started to configure the port.
	// * <i>armed</i> - Logical HA link is armed. The physical link is up and the subnet manager started but did not yet complete configuring the port.
	// * <i>active</i> - Logical HA link is active.
	// * <i>reserved</i> - Logical HA link is active, but the physical link is down.
	//
	// Example: active
	// Read Only: true
	// Enum: ["down","initialized","armed","active","reserved"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node modify collection params body records items0 ha ports items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","initialized","armed","active","reserved"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0TypeStatePropEnum = append(nodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// state
	// State
	// down
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateDown captures enum value "down"
	NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateDown string = "down"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// state
	// State
	// initialized
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateInitialized captures enum value "initialized"
	NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateInitialized string = "initialized"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// state
	// State
	// armed
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateArmed captures enum value "armed"
	NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateArmed string = "armed"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// state
	// State
	// active
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateActive captures enum value "active"
	NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateActive string = "active"

	// BEGIN DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	// state
	// State
	// reserved
	// END DEBUGGING
	// NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateReserved captures enum value "reserved"
	NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0StateReserved string = "reserved"
)

// prop value enum
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 ha ports items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "number", "body", o.Number); err != nil {
		return err
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0HaPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0 Network interface
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0 struct {

	// links
	Links *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node modify collection params body records items0 management interfaces items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 management interfaces items0 based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP IP information
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP
*/
type NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node modify collection params body records items0 management interfaces items0 IP
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 management interfaces items0 IP based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links node modify collection params body records items0 management interfaces items0 links
swagger:model NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links
*/
type NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this node modify collection params body records items0 management interfaces items0 links
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node modify collection params body records items0 management interfaces items0 links based on the context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0ManagementInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0 node modify collection params body records items0 metrocluster ports items0
swagger:model NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0
*/
type NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0 struct {

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`
}

// Validate validates this node modify collection params body records items0 metrocluster ports items0
func (o *NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node modify collection params body records items0 metrocluster ports items0 based on context it is used
func (o *NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeModifyCollectionParamsBodyRecordsItems0MetroclusterPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
