// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewNodeModifyParams creates a new NodeModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNodeModifyParams() *NodeModifyParams {
	return &NodeModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNodeModifyParamsWithTimeout creates a new NodeModifyParams object
// with the ability to set a timeout on a request.
func NewNodeModifyParamsWithTimeout(timeout time.Duration) *NodeModifyParams {
	return &NodeModifyParams{
		timeout: timeout,
	}
}

// NewNodeModifyParamsWithContext creates a new NodeModifyParams object
// with the ability to set a context for a request.
func NewNodeModifyParamsWithContext(ctx context.Context) *NodeModifyParams {
	return &NodeModifyParams{
		Context: ctx,
	}
}

// NewNodeModifyParamsWithHTTPClient creates a new NodeModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewNodeModifyParamsWithHTTPClient(client *http.Client) *NodeModifyParams {
	return &NodeModifyParams{
		HTTPClient: client,
	}
}

/*
NodeModifyParams contains all the parameters to send to the API endpoint

	for the node modify operation.

	Typically these are written to a http.Request.
*/
type NodeModifyParams struct {

	/* Action.

	     The shutdown action shuts the node down and transfers storage control to its HA group if storage failover is enabled.
	The reboot action reboots the node and transfers storage control to its HA group if storage failover is enabled.
	The giveback action transfers storage control back to the owner from its HA group.
	The "power_off" action shuts the node down with the assistance of the service processor.
	The "power_on" action restores power to the node with the assistance of the service processor.
	<personalities supports=aiml>
	The takeover_check action is not supported on this platform.
	</personalities>

	*/
	Action *string

	/* AllowDataOutage.

	   This only applies when an action of reboot or shutdown is provided. It allows storage failover to be bypassed along with any failures related to maintaining quorum in the cluster.

	*/
	AllowDataOutage *bool

	/* AllowVersionMismatch.

	   Applies only when a reboot action is provided. It allows storage failover to be bypassed along with any failures related to software version mismatch.

	*/
	AllowVersionMismatch *bool

	// Info.
	Info *models.Node

	/* OverrideVetoes.

	   Applies only when a giveback action is provided. If giveback is vetoed, you must check the EMS messages to determine the cause. Depending on the reason or reasons, you can decide whether you can safely override the vetoes.

	*/
	OverrideVetoes *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* ServiceProcessorAction.

	   Action used to reboot the service processor (SP).

	*/
	ServiceProcessorAction *string

	/* ServiceProcessorFirmwareImage.

	   Service processor image to boot with after a reboot.

	*/
	ServiceProcessorFirmwareImage *string

	/* ShutdownRebootReason.

	   Indicates the reason for the reboot or shutdown. This only applies when an action of reboot or shutdown is provided.

	*/
	ShutdownRebootReason *string

	// UUID.
	//
	// Format: uuid
	UUID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the node modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodeModifyParams) WithDefaults() *NodeModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the node modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodeModifyParams) SetDefaults() {
	var (
		allowDataOutageDefault = bool(false)

		allowVersionMismatchDefault = bool(false)

		overrideVetoesDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := NodeModifyParams{
		AllowDataOutage:      &allowDataOutageDefault,
		AllowVersionMismatch: &allowVersionMismatchDefault,
		OverrideVetoes:       &overrideVetoesDefault,
		ReturnTimeout:        &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the node modify params
func (o *NodeModifyParams) WithTimeout(timeout time.Duration) *NodeModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the node modify params
func (o *NodeModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the node modify params
func (o *NodeModifyParams) WithContext(ctx context.Context) *NodeModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the node modify params
func (o *NodeModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the node modify params
func (o *NodeModifyParams) WithHTTPClient(client *http.Client) *NodeModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the node modify params
func (o *NodeModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the node modify params
func (o *NodeModifyParams) WithAction(action *string) *NodeModifyParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the node modify params
func (o *NodeModifyParams) SetAction(action *string) {
	o.Action = action
}

// WithAllowDataOutage adds the allowDataOutage to the node modify params
func (o *NodeModifyParams) WithAllowDataOutage(allowDataOutage *bool) *NodeModifyParams {
	o.SetAllowDataOutage(allowDataOutage)
	return o
}

// SetAllowDataOutage adds the allowDataOutage to the node modify params
func (o *NodeModifyParams) SetAllowDataOutage(allowDataOutage *bool) {
	o.AllowDataOutage = allowDataOutage
}

// WithAllowVersionMismatch adds the allowVersionMismatch to the node modify params
func (o *NodeModifyParams) WithAllowVersionMismatch(allowVersionMismatch *bool) *NodeModifyParams {
	o.SetAllowVersionMismatch(allowVersionMismatch)
	return o
}

// SetAllowVersionMismatch adds the allowVersionMismatch to the node modify params
func (o *NodeModifyParams) SetAllowVersionMismatch(allowVersionMismatch *bool) {
	o.AllowVersionMismatch = allowVersionMismatch
}

// WithInfo adds the info to the node modify params
func (o *NodeModifyParams) WithInfo(info *models.Node) *NodeModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the node modify params
func (o *NodeModifyParams) SetInfo(info *models.Node) {
	o.Info = info
}

// WithOverrideVetoes adds the overrideVetoes to the node modify params
func (o *NodeModifyParams) WithOverrideVetoes(overrideVetoes *bool) *NodeModifyParams {
	o.SetOverrideVetoes(overrideVetoes)
	return o
}

// SetOverrideVetoes adds the overrideVetoes to the node modify params
func (o *NodeModifyParams) SetOverrideVetoes(overrideVetoes *bool) {
	o.OverrideVetoes = overrideVetoes
}

// WithReturnTimeout adds the returnTimeout to the node modify params
func (o *NodeModifyParams) WithReturnTimeout(returnTimeout *int64) *NodeModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the node modify params
func (o *NodeModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServiceProcessorAction adds the serviceProcessorAction to the node modify params
func (o *NodeModifyParams) WithServiceProcessorAction(serviceProcessorAction *string) *NodeModifyParams {
	o.SetServiceProcessorAction(serviceProcessorAction)
	return o
}

// SetServiceProcessorAction adds the serviceProcessorAction to the node modify params
func (o *NodeModifyParams) SetServiceProcessorAction(serviceProcessorAction *string) {
	o.ServiceProcessorAction = serviceProcessorAction
}

// WithServiceProcessorFirmwareImage adds the serviceProcessorFirmwareImage to the node modify params
func (o *NodeModifyParams) WithServiceProcessorFirmwareImage(serviceProcessorFirmwareImage *string) *NodeModifyParams {
	o.SetServiceProcessorFirmwareImage(serviceProcessorFirmwareImage)
	return o
}

// SetServiceProcessorFirmwareImage adds the serviceProcessorFirmwareImage to the node modify params
func (o *NodeModifyParams) SetServiceProcessorFirmwareImage(serviceProcessorFirmwareImage *string) {
	o.ServiceProcessorFirmwareImage = serviceProcessorFirmwareImage
}

// WithShutdownRebootReason adds the shutdownRebootReason to the node modify params
func (o *NodeModifyParams) WithShutdownRebootReason(shutdownRebootReason *string) *NodeModifyParams {
	o.SetShutdownRebootReason(shutdownRebootReason)
	return o
}

// SetShutdownRebootReason adds the shutdownRebootReason to the node modify params
func (o *NodeModifyParams) SetShutdownRebootReason(shutdownRebootReason *string) {
	o.ShutdownRebootReason = shutdownRebootReason
}

// WithUUID adds the uuid to the node modify params
func (o *NodeModifyParams) WithUUID(uuid strfmt.UUID) *NodeModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the node modify params
func (o *NodeModifyParams) SetUUID(uuid strfmt.UUID) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NodeModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.AllowDataOutage != nil {

		// query param allow_data_outage
		var qrAllowDataOutage bool

		if o.AllowDataOutage != nil {
			qrAllowDataOutage = *o.AllowDataOutage
		}
		qAllowDataOutage := swag.FormatBool(qrAllowDataOutage)
		if qAllowDataOutage != "" {

			if err := r.SetQueryParam("allow_data_outage", qAllowDataOutage); err != nil {
				return err
			}
		}
	}

	if o.AllowVersionMismatch != nil {

		// query param allow_version_mismatch
		var qrAllowVersionMismatch bool

		if o.AllowVersionMismatch != nil {
			qrAllowVersionMismatch = *o.AllowVersionMismatch
		}
		qAllowVersionMismatch := swag.FormatBool(qrAllowVersionMismatch)
		if qAllowVersionMismatch != "" {

			if err := r.SetQueryParam("allow_version_mismatch", qAllowVersionMismatch); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.OverrideVetoes != nil {

		// query param override_vetoes
		var qrOverrideVetoes bool

		if o.OverrideVetoes != nil {
			qrOverrideVetoes = *o.OverrideVetoes
		}
		qOverrideVetoes := swag.FormatBool(qrOverrideVetoes)
		if qOverrideVetoes != "" {

			if err := r.SetQueryParam("override_vetoes", qOverrideVetoes); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAction != nil {

		// query param service_processor.action
		var qrServiceProcessorAction string

		if o.ServiceProcessorAction != nil {
			qrServiceProcessorAction = *o.ServiceProcessorAction
		}
		qServiceProcessorAction := qrServiceProcessorAction
		if qServiceProcessorAction != "" {

			if err := r.SetQueryParam("service_processor.action", qServiceProcessorAction); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorFirmwareImage != nil {

		// query param service_processor.firmware_image
		var qrServiceProcessorFirmwareImage string

		if o.ServiceProcessorFirmwareImage != nil {
			qrServiceProcessorFirmwareImage = *o.ServiceProcessorFirmwareImage
		}
		qServiceProcessorFirmwareImage := qrServiceProcessorFirmwareImage
		if qServiceProcessorFirmwareImage != "" {

			if err := r.SetQueryParam("service_processor.firmware_image", qServiceProcessorFirmwareImage); err != nil {
				return err
			}
		}
	}

	if o.ShutdownRebootReason != nil {

		// query param shutdown_reboot_reason
		var qrShutdownRebootReason string

		if o.ShutdownRebootReason != nil {
			qrShutdownRebootReason = *o.ShutdownRebootReason
		}
		qShutdownRebootReason := qrShutdownRebootReason
		if qShutdownRebootReason != "" {

			if err := r.SetQueryParam("shutdown_reboot_reason", qShutdownRebootReason); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
