// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNodesGetParams creates a new NodesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNodesGetParams() *NodesGetParams {
	return &NodesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNodesGetParamsWithTimeout creates a new NodesGetParams object
// with the ability to set a timeout on a request.
func NewNodesGetParamsWithTimeout(timeout time.Duration) *NodesGetParams {
	return &NodesGetParams{
		timeout: timeout,
	}
}

// NewNodesGetParamsWithContext creates a new NodesGetParams object
// with the ability to set a context for a request.
func NewNodesGetParamsWithContext(ctx context.Context) *NodesGetParams {
	return &NodesGetParams{
		Context: ctx,
	}
}

// NewNodesGetParamsWithHTTPClient creates a new NodesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNodesGetParamsWithHTTPClient(client *http.Client) *NodesGetParams {
	return &NodesGetParams{
		HTTPClient: client,
	}
}

/*
NodesGetParams contains all the parameters to send to the API endpoint

	for the nodes get operation.

	Typically these are written to a http.Request.
*/
type NodesGetParams struct {

	/* AntiRansomwareVersion.

	   Filter by anti_ransomware_version
	*/
	AntiRansomwareVersion *string

	/* ClusterInterfacesIPAddress.

	   Filter by cluster_interfaces.ip.address
	*/
	ClusterInterfacesIPAddress *string

	/* ClusterInterfacesName.

	   Filter by cluster_interfaces.name
	*/
	ClusterInterfacesName *string

	/* ClusterInterfacesUUID.

	   Filter by cluster_interfaces.uuid
	*/
	ClusterInterfacesUUID *string

	/* ControllerBoard.

	   Filter by controller.board
	*/
	ControllerBoard *string

	/* ControllerCPUCount.

	   Filter by controller.cpu.count
	*/
	ControllerCPUCount *int64

	/* ControllerCPUFirmwareRelease.

	   Filter by controller.cpu.firmware_release
	*/
	ControllerCPUFirmwareRelease *string

	/* ControllerCPUProcessor.

	   Filter by controller.cpu.processor
	*/
	ControllerCPUProcessor *string

	/* ControllerFailedFanCount.

	   Filter by controller.failed_fan.count
	*/
	ControllerFailedFanCount *int64

	/* ControllerFailedFanMessageCode.

	   Filter by controller.failed_fan.message.code
	*/
	ControllerFailedFanMessageCode *string

	/* ControllerFailedFanMessageMessage.

	   Filter by controller.failed_fan.message.message
	*/
	ControllerFailedFanMessageMessage *string

	/* ControllerFailedPowerSupplyCount.

	   Filter by controller.failed_power_supply.count
	*/
	ControllerFailedPowerSupplyCount *int64

	/* ControllerFailedPowerSupplyMessageCode.

	   Filter by controller.failed_power_supply.message.code
	*/
	ControllerFailedPowerSupplyMessageCode *string

	/* ControllerFailedPowerSupplyMessageMessage.

	   Filter by controller.failed_power_supply.message.message
	*/
	ControllerFailedPowerSupplyMessageMessage *string

	/* ControllerFlashCacheCapacity.

	   Filter by controller.flash_cache.capacity
	*/
	ControllerFlashCacheCapacity *int64

	/* ControllerFlashCacheDeviceID.

	   Filter by controller.flash_cache.device_id
	*/
	ControllerFlashCacheDeviceID *int64

	/* ControllerFlashCacheFirmwareFile.

	   Filter by controller.flash_cache.firmware_file
	*/
	ControllerFlashCacheFirmwareFile *string

	/* ControllerFlashCacheFirmwareVersion.

	   Filter by controller.flash_cache.firmware_version
	*/
	ControllerFlashCacheFirmwareVersion *string

	/* ControllerFlashCacheHardwareRevision.

	   Filter by controller.flash_cache.hardware_revision
	*/
	ControllerFlashCacheHardwareRevision *string

	/* ControllerFlashCacheModel.

	   Filter by controller.flash_cache.model
	*/
	ControllerFlashCacheModel *string

	/* ControllerFlashCachePartNumber.

	   Filter by controller.flash_cache.part_number
	*/
	ControllerFlashCachePartNumber *string

	/* ControllerFlashCacheSerialNumber.

	   Filter by controller.flash_cache.serial_number
	*/
	ControllerFlashCacheSerialNumber *string

	/* ControllerFlashCacheSlot.

	   Filter by controller.flash_cache.slot
	*/
	ControllerFlashCacheSlot *string

	/* ControllerFlashCacheState.

	   Filter by controller.flash_cache.state
	*/
	ControllerFlashCacheState *string

	/* ControllerFrusID.

	   Filter by controller.frus.id
	*/
	ControllerFrusID *string

	/* ControllerFrusState.

	   Filter by controller.frus.state
	*/
	ControllerFrusState *string

	/* ControllerFrusType.

	   Filter by controller.frus.type
	*/
	ControllerFrusType *string

	/* ControllerMemorySize.

	   Filter by controller.memory_size
	*/
	ControllerMemorySize *int64

	/* ControllerOverTemperature.

	   Filter by controller.over_temperature
	*/
	ControllerOverTemperature *string

	/* Date.

	   Filter by date
	*/
	Date *string

	/* ExternalCacheIsEnabled.

	   Filter by external_cache.is_enabled
	*/
	ExternalCacheIsEnabled *bool

	/* ExternalCacheIsHyaEnabled.

	   Filter by external_cache.is_hya_enabled
	*/
	ExternalCacheIsHyaEnabled *bool

	/* ExternalCacheIsRewarmEnabled.

	   Filter by external_cache.is_rewarm_enabled
	*/
	ExternalCacheIsRewarmEnabled *bool

	/* ExternalCachePcsSize.

	   Filter by external_cache.pcs_size
	*/
	ExternalCachePcsSize *int64

	/* ExternalCacheBypassEnabled.

	   Filter by external_cache_bypass.enabled
	*/
	ExternalCacheBypassEnabled *bool

	/* ExternalCacheBypassLargeReadOpsAllowPercent.

	   Filter by external_cache_bypass.large_read_ops_allow_percent
	*/
	ExternalCacheBypassLargeReadOpsAllowPercent *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* HaAutoGiveback.

	   Filter by ha.auto_giveback
	*/
	HaAutoGiveback *bool

	/* HaAutoGivebackOf.

	   Filter by ha.auto_giveback_of
	*/
	HaAutoGivebackOf *bool

	/* HaEnableTakeoverOf.

	   Filter by ha.enable_takeover_of
	*/
	HaEnableTakeoverOf *bool

	/* HaEnabled.

	   Filter by ha.enabled
	*/
	HaEnabled *bool

	/* HaGivebackFailureCode.

	   Filter by ha.giveback.failure.code
	*/
	HaGivebackFailureCode *int64

	/* HaGivebackFailureMessage.

	   Filter by ha.giveback.failure.message
	*/
	HaGivebackFailureMessage *string

	/* HaGivebackState.

	   Filter by ha.giveback.state
	*/
	HaGivebackState *string

	/* HaGivebackStatusAggregateName.

	   Filter by ha.giveback.status.aggregate.name
	*/
	HaGivebackStatusAggregateName *string

	/* HaGivebackStatusAggregateUUID.

	   Filter by ha.giveback.status.aggregate.uuid
	*/
	HaGivebackStatusAggregateUUID *string

	/* HaGivebackStatusErrorCode.

	   Filter by ha.giveback.status.error.code
	*/
	HaGivebackStatusErrorCode *string

	/* HaGivebackStatusErrorMessage.

	   Filter by ha.giveback.status.error.message
	*/
	HaGivebackStatusErrorMessage *string

	/* HaGivebackStatusState.

	   Filter by ha.giveback.status.state
	*/
	HaGivebackStatusState *string

	/* HaInterconnectAdapter.

	   Filter by ha.interconnect.adapter
	*/
	HaInterconnectAdapter *string

	/* HaInterconnectState.

	   Filter by ha.interconnect.state
	*/
	HaInterconnectState *string

	/* HaPartnersName.

	   Filter by ha.partners.name
	*/
	HaPartnersName *string

	/* HaPartnersUUID.

	   Filter by ha.partners.uuid
	*/
	HaPartnersUUID *string

	/* HaPortsNumber.

	   Filter by ha.ports.number
	*/
	HaPortsNumber *int64

	/* HaPortsState.

	   Filter by ha.ports.state
	*/
	HaPortsState *string

	/* HaTakeoverFailureCode.

	   Filter by ha.takeover.failure.code
	*/
	HaTakeoverFailureCode *int64

	/* HaTakeoverFailureMessage.

	   Filter by ha.takeover.failure.message
	*/
	HaTakeoverFailureMessage *string

	/* HaTakeoverState.

	   Filter by ha.takeover.state
	*/
	HaTakeoverState *string

	/* HaTakeoverCheckReasons.

	   Filter by ha.takeover_check.reasons
	*/
	HaTakeoverCheckReasons *string

	/* HaTakeoverCheckTakeoverPossible.

	   Filter by ha.takeover_check.takeover_possible
	*/
	HaTakeoverCheckTakeoverPossible *bool

	/* HaType.

	   Filter by ha.type
	*/
	HaType *string

	/* HwAssistStatusEnabled.

	   Filter by hw_assist.status.enabled
	*/
	HwAssistStatusEnabled *bool

	/* HwAssistStatusLocalIP.

	   Filter by hw_assist.status.local.ip
	*/
	HwAssistStatusLocalIP *string

	/* HwAssistStatusLocalPort.

	   Filter by hw_assist.status.local.port
	*/
	HwAssistStatusLocalPort *int64

	/* HwAssistStatusLocalState.

	   Filter by hw_assist.status.local.state
	*/
	HwAssistStatusLocalState *string

	/* HwAssistStatusPartnerIP.

	   Filter by hw_assist.status.partner.ip
	*/
	HwAssistStatusPartnerIP *string

	/* HwAssistStatusPartnerPort.

	   Filter by hw_assist.status.partner.port
	*/
	HwAssistStatusPartnerPort *int64

	/* HwAssistStatusPartnerState.

	   Filter by hw_assist.status.partner.state
	*/
	HwAssistStatusPartnerState *string

	/* IsSparesLow.

	   Filter by is_spares_low
	*/
	IsSparesLow *bool

	/* Location.

	   Filter by location
	*/
	Location *string

	/* ManagementInterfacesIPAddress.

	   Filter by management_interfaces.ip.address
	*/
	ManagementInterfacesIPAddress *string

	/* ManagementInterfacesName.

	   Filter by management_interfaces.name
	*/
	ManagementInterfacesName *string

	/* ManagementInterfacesUUID.

	   Filter by management_interfaces.uuid
	*/
	ManagementInterfacesUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Membership.

	   Filter by membership
	*/
	Membership *string

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricProcessorUtilization.

	   Filter by metric.processor_utilization
	*/
	MetricProcessorUtilization *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* MetricUUID.

	   Filter by metric.uuid
	*/
	MetricUUID *string

	/* MetroclusterCustomVlanCapable.

	   Filter by metrocluster.custom_vlan_capable
	*/
	MetroclusterCustomVlanCapable *bool

	/* MetroclusterPortsName.

	   Filter by metrocluster.ports.name
	*/
	MetroclusterPortsName *string

	/* MetroclusterType.

	   Filter by metrocluster.type
	*/
	MetroclusterType *string

	/* Model.

	   Filter by model
	*/
	Model *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NvlogBackingType.

	   Filter by nvlog.backing_type
	*/
	NvlogBackingType *string

	/* NvlogSwapMode.

	   Filter by nvlog.swap_mode
	*/
	NvlogSwapMode *string

	/* NvramBatteryState.

	   Filter by nvram.battery_state
	*/
	NvramBatteryState *string

	/* NvramID.

	   Filter by nvram.id
	*/
	NvramID *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* ServiceProcessorAPIServiceEnabled.

	   Filter by service_processor.api_service.enabled
	*/
	ServiceProcessorAPIServiceEnabled *bool

	/* ServiceProcessorAPIServiceLimitAccess.

	   Filter by service_processor.api_service.limit_access
	*/
	ServiceProcessorAPIServiceLimitAccess *bool

	/* ServiceProcessorAPIServicePort.

	   Filter by service_processor.api_service.port
	*/
	ServiceProcessorAPIServicePort *int64

	/* ServiceProcessorAutoConfigIPV4Subnet.

	   Filter by service_processor.auto_config.ipv4_subnet
	*/
	ServiceProcessorAutoConfigIPV4Subnet *string

	/* ServiceProcessorAutoConfigIPV6Subnet.

	   Filter by service_processor.auto_config.ipv6_subnet
	*/
	ServiceProcessorAutoConfigIPV6Subnet *string

	/* ServiceProcessorAutoupdateEnabled.

	   Filter by service_processor.autoupdate_enabled
	*/
	ServiceProcessorAutoupdateEnabled *bool

	/* ServiceProcessorBackupIsCurrent.

	   Filter by service_processor.backup.is_current
	*/
	ServiceProcessorBackupIsCurrent *bool

	/* ServiceProcessorBackupState.

	   Filter by service_processor.backup.state
	*/
	ServiceProcessorBackupState *string

	/* ServiceProcessorBackupVersion.

	   Filter by service_processor.backup.version
	*/
	ServiceProcessorBackupVersion *string

	/* ServiceProcessorDhcpEnabled.

	   Filter by service_processor.dhcp_enabled
	*/
	ServiceProcessorDhcpEnabled *bool

	/* ServiceProcessorFirmwareVersion.

	   Filter by service_processor.firmware_version
	*/
	ServiceProcessorFirmwareVersion *string

	/* ServiceProcessorIPV4InterfaceAddress.

	   Filter by service_processor.ipv4_interface.address
	*/
	ServiceProcessorIPV4InterfaceAddress *string

	/* ServiceProcessorIPV4InterfaceEnabled.

	   Filter by service_processor.ipv4_interface.enabled
	*/
	ServiceProcessorIPV4InterfaceEnabled *bool

	/* ServiceProcessorIPV4InterfaceGateway.

	   Filter by service_processor.ipv4_interface.gateway
	*/
	ServiceProcessorIPV4InterfaceGateway *string

	/* ServiceProcessorIPV4InterfaceNetmask.

	   Filter by service_processor.ipv4_interface.netmask
	*/
	ServiceProcessorIPV4InterfaceNetmask *string

	/* ServiceProcessorIPV4InterfaceSetupState.

	   Filter by service_processor.ipv4_interface.setup_state
	*/
	ServiceProcessorIPV4InterfaceSetupState *string

	/* ServiceProcessorIPV6InterfaceAddress.

	   Filter by service_processor.ipv6_interface.address
	*/
	ServiceProcessorIPV6InterfaceAddress *string

	/* ServiceProcessorIPV6InterfaceEnabled.

	   Filter by service_processor.ipv6_interface.enabled
	*/
	ServiceProcessorIPV6InterfaceEnabled *bool

	/* ServiceProcessorIPV6InterfaceGateway.

	   Filter by service_processor.ipv6_interface.gateway
	*/
	ServiceProcessorIPV6InterfaceGateway *string

	/* ServiceProcessorIPV6InterfaceIsIPV6RaEnabled.

	   Filter by service_processor.ipv6_interface.is_ipv6_ra_enabled
	*/
	ServiceProcessorIPV6InterfaceIsIPV6RaEnabled *bool

	/* ServiceProcessorIPV6InterfaceLinkLocalIP.

	   Filter by service_processor.ipv6_interface.link_local_ip
	*/
	ServiceProcessorIPV6InterfaceLinkLocalIP *string

	/* ServiceProcessorIPV6InterfaceNetmask.

	   Filter by service_processor.ipv6_interface.netmask
	*/
	ServiceProcessorIPV6InterfaceNetmask *int64

	/* ServiceProcessorIPV6InterfaceRouterIP.

	   Filter by service_processor.ipv6_interface.router_ip
	*/
	ServiceProcessorIPV6InterfaceRouterIP *string

	/* ServiceProcessorIPV6InterfaceSetupState.

	   Filter by service_processor.ipv6_interface.setup_state
	*/
	ServiceProcessorIPV6InterfaceSetupState *string

	/* ServiceProcessorIsIPConfigured.

	   Filter by service_processor.is_ip_configured
	*/
	ServiceProcessorIsIPConfigured *bool

	/* ServiceProcessorLastUpdateState.

	   Filter by service_processor.last_update_state
	*/
	ServiceProcessorLastUpdateState *string

	/* ServiceProcessorLinkStatus.

	   Filter by service_processor.link_status
	*/
	ServiceProcessorLinkStatus *string

	/* ServiceProcessorMacAddress.

	   Filter by service_processor.mac_address
	*/
	ServiceProcessorMacAddress *string

	/* ServiceProcessorPrimaryIsCurrent.

	   Filter by service_processor.primary.is_current
	*/
	ServiceProcessorPrimaryIsCurrent *bool

	/* ServiceProcessorPrimaryState.

	   Filter by service_processor.primary.state
	*/
	ServiceProcessorPrimaryState *string

	/* ServiceProcessorPrimaryVersion.

	   Filter by service_processor.primary.version
	*/
	ServiceProcessorPrimaryVersion *string

	/* ServiceProcessorSSHInfoAllowedAddresses.

	   Filter by service_processor.ssh_info.allowed_addresses
	*/
	ServiceProcessorSSHInfoAllowedAddresses *string

	/* ServiceProcessorState.

	   Filter by service_processor.state
	*/
	ServiceProcessorState *string

	/* ServiceProcessorType.

	   Filter by service_processor.type
	*/
	ServiceProcessorType *string

	/* ServiceProcessorWebServiceEnabled.

	   Filter by service_processor.web_service.enabled
	*/
	ServiceProcessorWebServiceEnabled *bool

	/* ServiceProcessorWebServiceLimitAccess.

	   Filter by service_processor.web_service.limit_access
	*/
	ServiceProcessorWebServiceLimitAccess *bool

	/* SnaplockComplianceClockTime.

	   Filter by snaplock.compliance_clock_time
	*/
	SnaplockComplianceClockTime *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsProcessorUtilizationBase.

	   Filter by statistics.processor_utilization_base
	*/
	StatisticsProcessorUtilizationBase *int64

	/* StatisticsProcessorUtilizationRaw.

	   Filter by statistics.processor_utilization_raw
	*/
	StatisticsProcessorUtilizationRaw *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* StorageAvailabilityZonesName.

	   Filter by storage_availability_zones.name
	*/
	StorageAvailabilityZonesName *string

	/* StorageAvailabilityZonesUUID.

	   Filter by storage_availability_zones.uuid
	*/
	StorageAvailabilityZonesUUID *string

	/* StorageConfiguration.

	   Filter by storage_configuration
	*/
	StorageConfiguration *string

	/* SystemAggregateName.

	   Filter by system_aggregate.name
	*/
	SystemAggregateName *string

	/* SystemAggregateUUID.

	   Filter by system_aggregate.uuid
	*/
	SystemAggregateUUID *string

	/* SystemID.

	   Filter by system_id
	*/
	SystemID *string

	/* SystemMachineType.

	   Filter by system_machine_type
	*/
	SystemMachineType *string

	/* Uptime.

	   Filter by uptime
	*/
	Uptime *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VendorSerialNumber.

	   Filter by vendor_serial_number
	*/
	VendorSerialNumber *string

	/* VersionFull.

	   Filter by version.full
	*/
	VersionFull *string

	/* VersionGeneration.

	   Filter by version.generation
	*/
	VersionGeneration *int64

	/* VersionMajor.

	   Filter by version.major
	*/
	VersionMajor *int64

	/* VersionMinor.

	   Filter by version.minor
	*/
	VersionMinor *int64

	/* VMProviderType.

	   Filter by vm.provider_type
	*/
	VMProviderType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nodes get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodesGetParams) WithDefaults() *NodesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nodes get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodesGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NodesGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nodes get params
func (o *NodesGetParams) WithTimeout(timeout time.Duration) *NodesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nodes get params
func (o *NodesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nodes get params
func (o *NodesGetParams) WithContext(ctx context.Context) *NodesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nodes get params
func (o *NodesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nodes get params
func (o *NodesGetParams) WithHTTPClient(client *http.Client) *NodesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nodes get params
func (o *NodesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAntiRansomwareVersion adds the antiRansomwareVersion to the nodes get params
func (o *NodesGetParams) WithAntiRansomwareVersion(antiRansomwareVersion *string) *NodesGetParams {
	o.SetAntiRansomwareVersion(antiRansomwareVersion)
	return o
}

// SetAntiRansomwareVersion adds the antiRansomwareVersion to the nodes get params
func (o *NodesGetParams) SetAntiRansomwareVersion(antiRansomwareVersion *string) {
	o.AntiRansomwareVersion = antiRansomwareVersion
}

// WithClusterInterfacesIPAddress adds the clusterInterfacesIPAddress to the nodes get params
func (o *NodesGetParams) WithClusterInterfacesIPAddress(clusterInterfacesIPAddress *string) *NodesGetParams {
	o.SetClusterInterfacesIPAddress(clusterInterfacesIPAddress)
	return o
}

// SetClusterInterfacesIPAddress adds the clusterInterfacesIpAddress to the nodes get params
func (o *NodesGetParams) SetClusterInterfacesIPAddress(clusterInterfacesIPAddress *string) {
	o.ClusterInterfacesIPAddress = clusterInterfacesIPAddress
}

// WithClusterInterfacesName adds the clusterInterfacesName to the nodes get params
func (o *NodesGetParams) WithClusterInterfacesName(clusterInterfacesName *string) *NodesGetParams {
	o.SetClusterInterfacesName(clusterInterfacesName)
	return o
}

// SetClusterInterfacesName adds the clusterInterfacesName to the nodes get params
func (o *NodesGetParams) SetClusterInterfacesName(clusterInterfacesName *string) {
	o.ClusterInterfacesName = clusterInterfacesName
}

// WithClusterInterfacesUUID adds the clusterInterfacesUUID to the nodes get params
func (o *NodesGetParams) WithClusterInterfacesUUID(clusterInterfacesUUID *string) *NodesGetParams {
	o.SetClusterInterfacesUUID(clusterInterfacesUUID)
	return o
}

// SetClusterInterfacesUUID adds the clusterInterfacesUuid to the nodes get params
func (o *NodesGetParams) SetClusterInterfacesUUID(clusterInterfacesUUID *string) {
	o.ClusterInterfacesUUID = clusterInterfacesUUID
}

// WithControllerBoard adds the controllerBoard to the nodes get params
func (o *NodesGetParams) WithControllerBoard(controllerBoard *string) *NodesGetParams {
	o.SetControllerBoard(controllerBoard)
	return o
}

// SetControllerBoard adds the controllerBoard to the nodes get params
func (o *NodesGetParams) SetControllerBoard(controllerBoard *string) {
	o.ControllerBoard = controllerBoard
}

// WithControllerCPUCount adds the controllerCPUCount to the nodes get params
func (o *NodesGetParams) WithControllerCPUCount(controllerCPUCount *int64) *NodesGetParams {
	o.SetControllerCPUCount(controllerCPUCount)
	return o
}

// SetControllerCPUCount adds the controllerCpuCount to the nodes get params
func (o *NodesGetParams) SetControllerCPUCount(controllerCPUCount *int64) {
	o.ControllerCPUCount = controllerCPUCount
}

// WithControllerCPUFirmwareRelease adds the controllerCPUFirmwareRelease to the nodes get params
func (o *NodesGetParams) WithControllerCPUFirmwareRelease(controllerCPUFirmwareRelease *string) *NodesGetParams {
	o.SetControllerCPUFirmwareRelease(controllerCPUFirmwareRelease)
	return o
}

// SetControllerCPUFirmwareRelease adds the controllerCpuFirmwareRelease to the nodes get params
func (o *NodesGetParams) SetControllerCPUFirmwareRelease(controllerCPUFirmwareRelease *string) {
	o.ControllerCPUFirmwareRelease = controllerCPUFirmwareRelease
}

// WithControllerCPUProcessor adds the controllerCPUProcessor to the nodes get params
func (o *NodesGetParams) WithControllerCPUProcessor(controllerCPUProcessor *string) *NodesGetParams {
	o.SetControllerCPUProcessor(controllerCPUProcessor)
	return o
}

// SetControllerCPUProcessor adds the controllerCpuProcessor to the nodes get params
func (o *NodesGetParams) SetControllerCPUProcessor(controllerCPUProcessor *string) {
	o.ControllerCPUProcessor = controllerCPUProcessor
}

// WithControllerFailedFanCount adds the controllerFailedFanCount to the nodes get params
func (o *NodesGetParams) WithControllerFailedFanCount(controllerFailedFanCount *int64) *NodesGetParams {
	o.SetControllerFailedFanCount(controllerFailedFanCount)
	return o
}

// SetControllerFailedFanCount adds the controllerFailedFanCount to the nodes get params
func (o *NodesGetParams) SetControllerFailedFanCount(controllerFailedFanCount *int64) {
	o.ControllerFailedFanCount = controllerFailedFanCount
}

// WithControllerFailedFanMessageCode adds the controllerFailedFanMessageCode to the nodes get params
func (o *NodesGetParams) WithControllerFailedFanMessageCode(controllerFailedFanMessageCode *string) *NodesGetParams {
	o.SetControllerFailedFanMessageCode(controllerFailedFanMessageCode)
	return o
}

// SetControllerFailedFanMessageCode adds the controllerFailedFanMessageCode to the nodes get params
func (o *NodesGetParams) SetControllerFailedFanMessageCode(controllerFailedFanMessageCode *string) {
	o.ControllerFailedFanMessageCode = controllerFailedFanMessageCode
}

// WithControllerFailedFanMessageMessage adds the controllerFailedFanMessageMessage to the nodes get params
func (o *NodesGetParams) WithControllerFailedFanMessageMessage(controllerFailedFanMessageMessage *string) *NodesGetParams {
	o.SetControllerFailedFanMessageMessage(controllerFailedFanMessageMessage)
	return o
}

// SetControllerFailedFanMessageMessage adds the controllerFailedFanMessageMessage to the nodes get params
func (o *NodesGetParams) SetControllerFailedFanMessageMessage(controllerFailedFanMessageMessage *string) {
	o.ControllerFailedFanMessageMessage = controllerFailedFanMessageMessage
}

// WithControllerFailedPowerSupplyCount adds the controllerFailedPowerSupplyCount to the nodes get params
func (o *NodesGetParams) WithControllerFailedPowerSupplyCount(controllerFailedPowerSupplyCount *int64) *NodesGetParams {
	o.SetControllerFailedPowerSupplyCount(controllerFailedPowerSupplyCount)
	return o
}

// SetControllerFailedPowerSupplyCount adds the controllerFailedPowerSupplyCount to the nodes get params
func (o *NodesGetParams) SetControllerFailedPowerSupplyCount(controllerFailedPowerSupplyCount *int64) {
	o.ControllerFailedPowerSupplyCount = controllerFailedPowerSupplyCount
}

// WithControllerFailedPowerSupplyMessageCode adds the controllerFailedPowerSupplyMessageCode to the nodes get params
func (o *NodesGetParams) WithControllerFailedPowerSupplyMessageCode(controllerFailedPowerSupplyMessageCode *string) *NodesGetParams {
	o.SetControllerFailedPowerSupplyMessageCode(controllerFailedPowerSupplyMessageCode)
	return o
}

// SetControllerFailedPowerSupplyMessageCode adds the controllerFailedPowerSupplyMessageCode to the nodes get params
func (o *NodesGetParams) SetControllerFailedPowerSupplyMessageCode(controllerFailedPowerSupplyMessageCode *string) {
	o.ControllerFailedPowerSupplyMessageCode = controllerFailedPowerSupplyMessageCode
}

// WithControllerFailedPowerSupplyMessageMessage adds the controllerFailedPowerSupplyMessageMessage to the nodes get params
func (o *NodesGetParams) WithControllerFailedPowerSupplyMessageMessage(controllerFailedPowerSupplyMessageMessage *string) *NodesGetParams {
	o.SetControllerFailedPowerSupplyMessageMessage(controllerFailedPowerSupplyMessageMessage)
	return o
}

// SetControllerFailedPowerSupplyMessageMessage adds the controllerFailedPowerSupplyMessageMessage to the nodes get params
func (o *NodesGetParams) SetControllerFailedPowerSupplyMessageMessage(controllerFailedPowerSupplyMessageMessage *string) {
	o.ControllerFailedPowerSupplyMessageMessage = controllerFailedPowerSupplyMessageMessage
}

// WithControllerFlashCacheCapacity adds the controllerFlashCacheCapacity to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheCapacity(controllerFlashCacheCapacity *int64) *NodesGetParams {
	o.SetControllerFlashCacheCapacity(controllerFlashCacheCapacity)
	return o
}

// SetControllerFlashCacheCapacity adds the controllerFlashCacheCapacity to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheCapacity(controllerFlashCacheCapacity *int64) {
	o.ControllerFlashCacheCapacity = controllerFlashCacheCapacity
}

// WithControllerFlashCacheDeviceID adds the controllerFlashCacheDeviceID to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheDeviceID(controllerFlashCacheDeviceID *int64) *NodesGetParams {
	o.SetControllerFlashCacheDeviceID(controllerFlashCacheDeviceID)
	return o
}

// SetControllerFlashCacheDeviceID adds the controllerFlashCacheDeviceId to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheDeviceID(controllerFlashCacheDeviceID *int64) {
	o.ControllerFlashCacheDeviceID = controllerFlashCacheDeviceID
}

// WithControllerFlashCacheFirmwareFile adds the controllerFlashCacheFirmwareFile to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheFirmwareFile(controllerFlashCacheFirmwareFile *string) *NodesGetParams {
	o.SetControllerFlashCacheFirmwareFile(controllerFlashCacheFirmwareFile)
	return o
}

// SetControllerFlashCacheFirmwareFile adds the controllerFlashCacheFirmwareFile to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheFirmwareFile(controllerFlashCacheFirmwareFile *string) {
	o.ControllerFlashCacheFirmwareFile = controllerFlashCacheFirmwareFile
}

// WithControllerFlashCacheFirmwareVersion adds the controllerFlashCacheFirmwareVersion to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheFirmwareVersion(controllerFlashCacheFirmwareVersion *string) *NodesGetParams {
	o.SetControllerFlashCacheFirmwareVersion(controllerFlashCacheFirmwareVersion)
	return o
}

// SetControllerFlashCacheFirmwareVersion adds the controllerFlashCacheFirmwareVersion to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheFirmwareVersion(controllerFlashCacheFirmwareVersion *string) {
	o.ControllerFlashCacheFirmwareVersion = controllerFlashCacheFirmwareVersion
}

// WithControllerFlashCacheHardwareRevision adds the controllerFlashCacheHardwareRevision to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheHardwareRevision(controllerFlashCacheHardwareRevision *string) *NodesGetParams {
	o.SetControllerFlashCacheHardwareRevision(controllerFlashCacheHardwareRevision)
	return o
}

// SetControllerFlashCacheHardwareRevision adds the controllerFlashCacheHardwareRevision to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheHardwareRevision(controllerFlashCacheHardwareRevision *string) {
	o.ControllerFlashCacheHardwareRevision = controllerFlashCacheHardwareRevision
}

// WithControllerFlashCacheModel adds the controllerFlashCacheModel to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheModel(controllerFlashCacheModel *string) *NodesGetParams {
	o.SetControllerFlashCacheModel(controllerFlashCacheModel)
	return o
}

// SetControllerFlashCacheModel adds the controllerFlashCacheModel to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheModel(controllerFlashCacheModel *string) {
	o.ControllerFlashCacheModel = controllerFlashCacheModel
}

// WithControllerFlashCachePartNumber adds the controllerFlashCachePartNumber to the nodes get params
func (o *NodesGetParams) WithControllerFlashCachePartNumber(controllerFlashCachePartNumber *string) *NodesGetParams {
	o.SetControllerFlashCachePartNumber(controllerFlashCachePartNumber)
	return o
}

// SetControllerFlashCachePartNumber adds the controllerFlashCachePartNumber to the nodes get params
func (o *NodesGetParams) SetControllerFlashCachePartNumber(controllerFlashCachePartNumber *string) {
	o.ControllerFlashCachePartNumber = controllerFlashCachePartNumber
}

// WithControllerFlashCacheSerialNumber adds the controllerFlashCacheSerialNumber to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheSerialNumber(controllerFlashCacheSerialNumber *string) *NodesGetParams {
	o.SetControllerFlashCacheSerialNumber(controllerFlashCacheSerialNumber)
	return o
}

// SetControllerFlashCacheSerialNumber adds the controllerFlashCacheSerialNumber to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheSerialNumber(controllerFlashCacheSerialNumber *string) {
	o.ControllerFlashCacheSerialNumber = controllerFlashCacheSerialNumber
}

// WithControllerFlashCacheSlot adds the controllerFlashCacheSlot to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheSlot(controllerFlashCacheSlot *string) *NodesGetParams {
	o.SetControllerFlashCacheSlot(controllerFlashCacheSlot)
	return o
}

// SetControllerFlashCacheSlot adds the controllerFlashCacheSlot to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheSlot(controllerFlashCacheSlot *string) {
	o.ControllerFlashCacheSlot = controllerFlashCacheSlot
}

// WithControllerFlashCacheState adds the controllerFlashCacheState to the nodes get params
func (o *NodesGetParams) WithControllerFlashCacheState(controllerFlashCacheState *string) *NodesGetParams {
	o.SetControllerFlashCacheState(controllerFlashCacheState)
	return o
}

// SetControllerFlashCacheState adds the controllerFlashCacheState to the nodes get params
func (o *NodesGetParams) SetControllerFlashCacheState(controllerFlashCacheState *string) {
	o.ControllerFlashCacheState = controllerFlashCacheState
}

// WithControllerFrusID adds the controllerFrusID to the nodes get params
func (o *NodesGetParams) WithControllerFrusID(controllerFrusID *string) *NodesGetParams {
	o.SetControllerFrusID(controllerFrusID)
	return o
}

// SetControllerFrusID adds the controllerFrusId to the nodes get params
func (o *NodesGetParams) SetControllerFrusID(controllerFrusID *string) {
	o.ControllerFrusID = controllerFrusID
}

// WithControllerFrusState adds the controllerFrusState to the nodes get params
func (o *NodesGetParams) WithControllerFrusState(controllerFrusState *string) *NodesGetParams {
	o.SetControllerFrusState(controllerFrusState)
	return o
}

// SetControllerFrusState adds the controllerFrusState to the nodes get params
func (o *NodesGetParams) SetControllerFrusState(controllerFrusState *string) {
	o.ControllerFrusState = controllerFrusState
}

// WithControllerFrusType adds the controllerFrusType to the nodes get params
func (o *NodesGetParams) WithControllerFrusType(controllerFrusType *string) *NodesGetParams {
	o.SetControllerFrusType(controllerFrusType)
	return o
}

// SetControllerFrusType adds the controllerFrusType to the nodes get params
func (o *NodesGetParams) SetControllerFrusType(controllerFrusType *string) {
	o.ControllerFrusType = controllerFrusType
}

// WithControllerMemorySize adds the controllerMemorySize to the nodes get params
func (o *NodesGetParams) WithControllerMemorySize(controllerMemorySize *int64) *NodesGetParams {
	o.SetControllerMemorySize(controllerMemorySize)
	return o
}

// SetControllerMemorySize adds the controllerMemorySize to the nodes get params
func (o *NodesGetParams) SetControllerMemorySize(controllerMemorySize *int64) {
	o.ControllerMemorySize = controllerMemorySize
}

// WithControllerOverTemperature adds the controllerOverTemperature to the nodes get params
func (o *NodesGetParams) WithControllerOverTemperature(controllerOverTemperature *string) *NodesGetParams {
	o.SetControllerOverTemperature(controllerOverTemperature)
	return o
}

// SetControllerOverTemperature adds the controllerOverTemperature to the nodes get params
func (o *NodesGetParams) SetControllerOverTemperature(controllerOverTemperature *string) {
	o.ControllerOverTemperature = controllerOverTemperature
}

// WithDate adds the date to the nodes get params
func (o *NodesGetParams) WithDate(date *string) *NodesGetParams {
	o.SetDate(date)
	return o
}

// SetDate adds the date to the nodes get params
func (o *NodesGetParams) SetDate(date *string) {
	o.Date = date
}

// WithExternalCacheIsEnabled adds the externalCacheIsEnabled to the nodes get params
func (o *NodesGetParams) WithExternalCacheIsEnabled(externalCacheIsEnabled *bool) *NodesGetParams {
	o.SetExternalCacheIsEnabled(externalCacheIsEnabled)
	return o
}

// SetExternalCacheIsEnabled adds the externalCacheIsEnabled to the nodes get params
func (o *NodesGetParams) SetExternalCacheIsEnabled(externalCacheIsEnabled *bool) {
	o.ExternalCacheIsEnabled = externalCacheIsEnabled
}

// WithExternalCacheIsHyaEnabled adds the externalCacheIsHyaEnabled to the nodes get params
func (o *NodesGetParams) WithExternalCacheIsHyaEnabled(externalCacheIsHyaEnabled *bool) *NodesGetParams {
	o.SetExternalCacheIsHyaEnabled(externalCacheIsHyaEnabled)
	return o
}

// SetExternalCacheIsHyaEnabled adds the externalCacheIsHyaEnabled to the nodes get params
func (o *NodesGetParams) SetExternalCacheIsHyaEnabled(externalCacheIsHyaEnabled *bool) {
	o.ExternalCacheIsHyaEnabled = externalCacheIsHyaEnabled
}

// WithExternalCacheIsRewarmEnabled adds the externalCacheIsRewarmEnabled to the nodes get params
func (o *NodesGetParams) WithExternalCacheIsRewarmEnabled(externalCacheIsRewarmEnabled *bool) *NodesGetParams {
	o.SetExternalCacheIsRewarmEnabled(externalCacheIsRewarmEnabled)
	return o
}

// SetExternalCacheIsRewarmEnabled adds the externalCacheIsRewarmEnabled to the nodes get params
func (o *NodesGetParams) SetExternalCacheIsRewarmEnabled(externalCacheIsRewarmEnabled *bool) {
	o.ExternalCacheIsRewarmEnabled = externalCacheIsRewarmEnabled
}

// WithExternalCachePcsSize adds the externalCachePcsSize to the nodes get params
func (o *NodesGetParams) WithExternalCachePcsSize(externalCachePcsSize *int64) *NodesGetParams {
	o.SetExternalCachePcsSize(externalCachePcsSize)
	return o
}

// SetExternalCachePcsSize adds the externalCachePcsSize to the nodes get params
func (o *NodesGetParams) SetExternalCachePcsSize(externalCachePcsSize *int64) {
	o.ExternalCachePcsSize = externalCachePcsSize
}

// WithExternalCacheBypassEnabled adds the externalCacheBypassEnabled to the nodes get params
func (o *NodesGetParams) WithExternalCacheBypassEnabled(externalCacheBypassEnabled *bool) *NodesGetParams {
	o.SetExternalCacheBypassEnabled(externalCacheBypassEnabled)
	return o
}

// SetExternalCacheBypassEnabled adds the externalCacheBypassEnabled to the nodes get params
func (o *NodesGetParams) SetExternalCacheBypassEnabled(externalCacheBypassEnabled *bool) {
	o.ExternalCacheBypassEnabled = externalCacheBypassEnabled
}

// WithExternalCacheBypassLargeReadOpsAllowPercent adds the externalCacheBypassLargeReadOpsAllowPercent to the nodes get params
func (o *NodesGetParams) WithExternalCacheBypassLargeReadOpsAllowPercent(externalCacheBypassLargeReadOpsAllowPercent *int64) *NodesGetParams {
	o.SetExternalCacheBypassLargeReadOpsAllowPercent(externalCacheBypassLargeReadOpsAllowPercent)
	return o
}

// SetExternalCacheBypassLargeReadOpsAllowPercent adds the externalCacheBypassLargeReadOpsAllowPercent to the nodes get params
func (o *NodesGetParams) SetExternalCacheBypassLargeReadOpsAllowPercent(externalCacheBypassLargeReadOpsAllowPercent *int64) {
	o.ExternalCacheBypassLargeReadOpsAllowPercent = externalCacheBypassLargeReadOpsAllowPercent
}

// WithFields adds the fields to the nodes get params
func (o *NodesGetParams) WithFields(fields []string) *NodesGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nodes get params
func (o *NodesGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHaAutoGiveback adds the haAutoGiveback to the nodes get params
func (o *NodesGetParams) WithHaAutoGiveback(haAutoGiveback *bool) *NodesGetParams {
	o.SetHaAutoGiveback(haAutoGiveback)
	return o
}

// SetHaAutoGiveback adds the haAutoGiveback to the nodes get params
func (o *NodesGetParams) SetHaAutoGiveback(haAutoGiveback *bool) {
	o.HaAutoGiveback = haAutoGiveback
}

// WithHaAutoGivebackOf adds the haAutoGivebackOf to the nodes get params
func (o *NodesGetParams) WithHaAutoGivebackOf(haAutoGivebackOf *bool) *NodesGetParams {
	o.SetHaAutoGivebackOf(haAutoGivebackOf)
	return o
}

// SetHaAutoGivebackOf adds the haAutoGivebackOf to the nodes get params
func (o *NodesGetParams) SetHaAutoGivebackOf(haAutoGivebackOf *bool) {
	o.HaAutoGivebackOf = haAutoGivebackOf
}

// WithHaEnableTakeoverOf adds the haEnableTakeoverOf to the nodes get params
func (o *NodesGetParams) WithHaEnableTakeoverOf(haEnableTakeoverOf *bool) *NodesGetParams {
	o.SetHaEnableTakeoverOf(haEnableTakeoverOf)
	return o
}

// SetHaEnableTakeoverOf adds the haEnableTakeoverOf to the nodes get params
func (o *NodesGetParams) SetHaEnableTakeoverOf(haEnableTakeoverOf *bool) {
	o.HaEnableTakeoverOf = haEnableTakeoverOf
}

// WithHaEnabled adds the haEnabled to the nodes get params
func (o *NodesGetParams) WithHaEnabled(haEnabled *bool) *NodesGetParams {
	o.SetHaEnabled(haEnabled)
	return o
}

// SetHaEnabled adds the haEnabled to the nodes get params
func (o *NodesGetParams) SetHaEnabled(haEnabled *bool) {
	o.HaEnabled = haEnabled
}

// WithHaGivebackFailureCode adds the haGivebackFailureCode to the nodes get params
func (o *NodesGetParams) WithHaGivebackFailureCode(haGivebackFailureCode *int64) *NodesGetParams {
	o.SetHaGivebackFailureCode(haGivebackFailureCode)
	return o
}

// SetHaGivebackFailureCode adds the haGivebackFailureCode to the nodes get params
func (o *NodesGetParams) SetHaGivebackFailureCode(haGivebackFailureCode *int64) {
	o.HaGivebackFailureCode = haGivebackFailureCode
}

// WithHaGivebackFailureMessage adds the haGivebackFailureMessage to the nodes get params
func (o *NodesGetParams) WithHaGivebackFailureMessage(haGivebackFailureMessage *string) *NodesGetParams {
	o.SetHaGivebackFailureMessage(haGivebackFailureMessage)
	return o
}

// SetHaGivebackFailureMessage adds the haGivebackFailureMessage to the nodes get params
func (o *NodesGetParams) SetHaGivebackFailureMessage(haGivebackFailureMessage *string) {
	o.HaGivebackFailureMessage = haGivebackFailureMessage
}

// WithHaGivebackState adds the haGivebackState to the nodes get params
func (o *NodesGetParams) WithHaGivebackState(haGivebackState *string) *NodesGetParams {
	o.SetHaGivebackState(haGivebackState)
	return o
}

// SetHaGivebackState adds the haGivebackState to the nodes get params
func (o *NodesGetParams) SetHaGivebackState(haGivebackState *string) {
	o.HaGivebackState = haGivebackState
}

// WithHaGivebackStatusAggregateName adds the haGivebackStatusAggregateName to the nodes get params
func (o *NodesGetParams) WithHaGivebackStatusAggregateName(haGivebackStatusAggregateName *string) *NodesGetParams {
	o.SetHaGivebackStatusAggregateName(haGivebackStatusAggregateName)
	return o
}

// SetHaGivebackStatusAggregateName adds the haGivebackStatusAggregateName to the nodes get params
func (o *NodesGetParams) SetHaGivebackStatusAggregateName(haGivebackStatusAggregateName *string) {
	o.HaGivebackStatusAggregateName = haGivebackStatusAggregateName
}

// WithHaGivebackStatusAggregateUUID adds the haGivebackStatusAggregateUUID to the nodes get params
func (o *NodesGetParams) WithHaGivebackStatusAggregateUUID(haGivebackStatusAggregateUUID *string) *NodesGetParams {
	o.SetHaGivebackStatusAggregateUUID(haGivebackStatusAggregateUUID)
	return o
}

// SetHaGivebackStatusAggregateUUID adds the haGivebackStatusAggregateUuid to the nodes get params
func (o *NodesGetParams) SetHaGivebackStatusAggregateUUID(haGivebackStatusAggregateUUID *string) {
	o.HaGivebackStatusAggregateUUID = haGivebackStatusAggregateUUID
}

// WithHaGivebackStatusErrorCode adds the haGivebackStatusErrorCode to the nodes get params
func (o *NodesGetParams) WithHaGivebackStatusErrorCode(haGivebackStatusErrorCode *string) *NodesGetParams {
	o.SetHaGivebackStatusErrorCode(haGivebackStatusErrorCode)
	return o
}

// SetHaGivebackStatusErrorCode adds the haGivebackStatusErrorCode to the nodes get params
func (o *NodesGetParams) SetHaGivebackStatusErrorCode(haGivebackStatusErrorCode *string) {
	o.HaGivebackStatusErrorCode = haGivebackStatusErrorCode
}

// WithHaGivebackStatusErrorMessage adds the haGivebackStatusErrorMessage to the nodes get params
func (o *NodesGetParams) WithHaGivebackStatusErrorMessage(haGivebackStatusErrorMessage *string) *NodesGetParams {
	o.SetHaGivebackStatusErrorMessage(haGivebackStatusErrorMessage)
	return o
}

// SetHaGivebackStatusErrorMessage adds the haGivebackStatusErrorMessage to the nodes get params
func (o *NodesGetParams) SetHaGivebackStatusErrorMessage(haGivebackStatusErrorMessage *string) {
	o.HaGivebackStatusErrorMessage = haGivebackStatusErrorMessage
}

// WithHaGivebackStatusState adds the haGivebackStatusState to the nodes get params
func (o *NodesGetParams) WithHaGivebackStatusState(haGivebackStatusState *string) *NodesGetParams {
	o.SetHaGivebackStatusState(haGivebackStatusState)
	return o
}

// SetHaGivebackStatusState adds the haGivebackStatusState to the nodes get params
func (o *NodesGetParams) SetHaGivebackStatusState(haGivebackStatusState *string) {
	o.HaGivebackStatusState = haGivebackStatusState
}

// WithHaInterconnectAdapter adds the haInterconnectAdapter to the nodes get params
func (o *NodesGetParams) WithHaInterconnectAdapter(haInterconnectAdapter *string) *NodesGetParams {
	o.SetHaInterconnectAdapter(haInterconnectAdapter)
	return o
}

// SetHaInterconnectAdapter adds the haInterconnectAdapter to the nodes get params
func (o *NodesGetParams) SetHaInterconnectAdapter(haInterconnectAdapter *string) {
	o.HaInterconnectAdapter = haInterconnectAdapter
}

// WithHaInterconnectState adds the haInterconnectState to the nodes get params
func (o *NodesGetParams) WithHaInterconnectState(haInterconnectState *string) *NodesGetParams {
	o.SetHaInterconnectState(haInterconnectState)
	return o
}

// SetHaInterconnectState adds the haInterconnectState to the nodes get params
func (o *NodesGetParams) SetHaInterconnectState(haInterconnectState *string) {
	o.HaInterconnectState = haInterconnectState
}

// WithHaPartnersName adds the haPartnersName to the nodes get params
func (o *NodesGetParams) WithHaPartnersName(haPartnersName *string) *NodesGetParams {
	o.SetHaPartnersName(haPartnersName)
	return o
}

// SetHaPartnersName adds the haPartnersName to the nodes get params
func (o *NodesGetParams) SetHaPartnersName(haPartnersName *string) {
	o.HaPartnersName = haPartnersName
}

// WithHaPartnersUUID adds the haPartnersUUID to the nodes get params
func (o *NodesGetParams) WithHaPartnersUUID(haPartnersUUID *string) *NodesGetParams {
	o.SetHaPartnersUUID(haPartnersUUID)
	return o
}

// SetHaPartnersUUID adds the haPartnersUuid to the nodes get params
func (o *NodesGetParams) SetHaPartnersUUID(haPartnersUUID *string) {
	o.HaPartnersUUID = haPartnersUUID
}

// WithHaPortsNumber adds the haPortsNumber to the nodes get params
func (o *NodesGetParams) WithHaPortsNumber(haPortsNumber *int64) *NodesGetParams {
	o.SetHaPortsNumber(haPortsNumber)
	return o
}

// SetHaPortsNumber adds the haPortsNumber to the nodes get params
func (o *NodesGetParams) SetHaPortsNumber(haPortsNumber *int64) {
	o.HaPortsNumber = haPortsNumber
}

// WithHaPortsState adds the haPortsState to the nodes get params
func (o *NodesGetParams) WithHaPortsState(haPortsState *string) *NodesGetParams {
	o.SetHaPortsState(haPortsState)
	return o
}

// SetHaPortsState adds the haPortsState to the nodes get params
func (o *NodesGetParams) SetHaPortsState(haPortsState *string) {
	o.HaPortsState = haPortsState
}

// WithHaTakeoverFailureCode adds the haTakeoverFailureCode to the nodes get params
func (o *NodesGetParams) WithHaTakeoverFailureCode(haTakeoverFailureCode *int64) *NodesGetParams {
	o.SetHaTakeoverFailureCode(haTakeoverFailureCode)
	return o
}

// SetHaTakeoverFailureCode adds the haTakeoverFailureCode to the nodes get params
func (o *NodesGetParams) SetHaTakeoverFailureCode(haTakeoverFailureCode *int64) {
	o.HaTakeoverFailureCode = haTakeoverFailureCode
}

// WithHaTakeoverFailureMessage adds the haTakeoverFailureMessage to the nodes get params
func (o *NodesGetParams) WithHaTakeoverFailureMessage(haTakeoverFailureMessage *string) *NodesGetParams {
	o.SetHaTakeoverFailureMessage(haTakeoverFailureMessage)
	return o
}

// SetHaTakeoverFailureMessage adds the haTakeoverFailureMessage to the nodes get params
func (o *NodesGetParams) SetHaTakeoverFailureMessage(haTakeoverFailureMessage *string) {
	o.HaTakeoverFailureMessage = haTakeoverFailureMessage
}

// WithHaTakeoverState adds the haTakeoverState to the nodes get params
func (o *NodesGetParams) WithHaTakeoverState(haTakeoverState *string) *NodesGetParams {
	o.SetHaTakeoverState(haTakeoverState)
	return o
}

// SetHaTakeoverState adds the haTakeoverState to the nodes get params
func (o *NodesGetParams) SetHaTakeoverState(haTakeoverState *string) {
	o.HaTakeoverState = haTakeoverState
}

// WithHaTakeoverCheckReasons adds the haTakeoverCheckReasons to the nodes get params
func (o *NodesGetParams) WithHaTakeoverCheckReasons(haTakeoverCheckReasons *string) *NodesGetParams {
	o.SetHaTakeoverCheckReasons(haTakeoverCheckReasons)
	return o
}

// SetHaTakeoverCheckReasons adds the haTakeoverCheckReasons to the nodes get params
func (o *NodesGetParams) SetHaTakeoverCheckReasons(haTakeoverCheckReasons *string) {
	o.HaTakeoverCheckReasons = haTakeoverCheckReasons
}

// WithHaTakeoverCheckTakeoverPossible adds the haTakeoverCheckTakeoverPossible to the nodes get params
func (o *NodesGetParams) WithHaTakeoverCheckTakeoverPossible(haTakeoverCheckTakeoverPossible *bool) *NodesGetParams {
	o.SetHaTakeoverCheckTakeoverPossible(haTakeoverCheckTakeoverPossible)
	return o
}

// SetHaTakeoverCheckTakeoverPossible adds the haTakeoverCheckTakeoverPossible to the nodes get params
func (o *NodesGetParams) SetHaTakeoverCheckTakeoverPossible(haTakeoverCheckTakeoverPossible *bool) {
	o.HaTakeoverCheckTakeoverPossible = haTakeoverCheckTakeoverPossible
}

// WithHaType adds the haType to the nodes get params
func (o *NodesGetParams) WithHaType(haType *string) *NodesGetParams {
	o.SetHaType(haType)
	return o
}

// SetHaType adds the haType to the nodes get params
func (o *NodesGetParams) SetHaType(haType *string) {
	o.HaType = haType
}

// WithHwAssistStatusEnabled adds the hwAssistStatusEnabled to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusEnabled(hwAssistStatusEnabled *bool) *NodesGetParams {
	o.SetHwAssistStatusEnabled(hwAssistStatusEnabled)
	return o
}

// SetHwAssistStatusEnabled adds the hwAssistStatusEnabled to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusEnabled(hwAssistStatusEnabled *bool) {
	o.HwAssistStatusEnabled = hwAssistStatusEnabled
}

// WithHwAssistStatusLocalIP adds the hwAssistStatusLocalIP to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusLocalIP(hwAssistStatusLocalIP *string) *NodesGetParams {
	o.SetHwAssistStatusLocalIP(hwAssistStatusLocalIP)
	return o
}

// SetHwAssistStatusLocalIP adds the hwAssistStatusLocalIp to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusLocalIP(hwAssistStatusLocalIP *string) {
	o.HwAssistStatusLocalIP = hwAssistStatusLocalIP
}

// WithHwAssistStatusLocalPort adds the hwAssistStatusLocalPort to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusLocalPort(hwAssistStatusLocalPort *int64) *NodesGetParams {
	o.SetHwAssistStatusLocalPort(hwAssistStatusLocalPort)
	return o
}

// SetHwAssistStatusLocalPort adds the hwAssistStatusLocalPort to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusLocalPort(hwAssistStatusLocalPort *int64) {
	o.HwAssistStatusLocalPort = hwAssistStatusLocalPort
}

// WithHwAssistStatusLocalState adds the hwAssistStatusLocalState to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusLocalState(hwAssistStatusLocalState *string) *NodesGetParams {
	o.SetHwAssistStatusLocalState(hwAssistStatusLocalState)
	return o
}

// SetHwAssistStatusLocalState adds the hwAssistStatusLocalState to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusLocalState(hwAssistStatusLocalState *string) {
	o.HwAssistStatusLocalState = hwAssistStatusLocalState
}

// WithHwAssistStatusPartnerIP adds the hwAssistStatusPartnerIP to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusPartnerIP(hwAssistStatusPartnerIP *string) *NodesGetParams {
	o.SetHwAssistStatusPartnerIP(hwAssistStatusPartnerIP)
	return o
}

// SetHwAssistStatusPartnerIP adds the hwAssistStatusPartnerIp to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusPartnerIP(hwAssistStatusPartnerIP *string) {
	o.HwAssistStatusPartnerIP = hwAssistStatusPartnerIP
}

// WithHwAssistStatusPartnerPort adds the hwAssistStatusPartnerPort to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusPartnerPort(hwAssistStatusPartnerPort *int64) *NodesGetParams {
	o.SetHwAssistStatusPartnerPort(hwAssistStatusPartnerPort)
	return o
}

// SetHwAssistStatusPartnerPort adds the hwAssistStatusPartnerPort to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusPartnerPort(hwAssistStatusPartnerPort *int64) {
	o.HwAssistStatusPartnerPort = hwAssistStatusPartnerPort
}

// WithHwAssistStatusPartnerState adds the hwAssistStatusPartnerState to the nodes get params
func (o *NodesGetParams) WithHwAssistStatusPartnerState(hwAssistStatusPartnerState *string) *NodesGetParams {
	o.SetHwAssistStatusPartnerState(hwAssistStatusPartnerState)
	return o
}

// SetHwAssistStatusPartnerState adds the hwAssistStatusPartnerState to the nodes get params
func (o *NodesGetParams) SetHwAssistStatusPartnerState(hwAssistStatusPartnerState *string) {
	o.HwAssistStatusPartnerState = hwAssistStatusPartnerState
}

// WithIsSparesLow adds the isSparesLow to the nodes get params
func (o *NodesGetParams) WithIsSparesLow(isSparesLow *bool) *NodesGetParams {
	o.SetIsSparesLow(isSparesLow)
	return o
}

// SetIsSparesLow adds the isSparesLow to the nodes get params
func (o *NodesGetParams) SetIsSparesLow(isSparesLow *bool) {
	o.IsSparesLow = isSparesLow
}

// WithLocation adds the location to the nodes get params
func (o *NodesGetParams) WithLocation(location *string) *NodesGetParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the nodes get params
func (o *NodesGetParams) SetLocation(location *string) {
	o.Location = location
}

// WithManagementInterfacesIPAddress adds the managementInterfacesIPAddress to the nodes get params
func (o *NodesGetParams) WithManagementInterfacesIPAddress(managementInterfacesIPAddress *string) *NodesGetParams {
	o.SetManagementInterfacesIPAddress(managementInterfacesIPAddress)
	return o
}

// SetManagementInterfacesIPAddress adds the managementInterfacesIpAddress to the nodes get params
func (o *NodesGetParams) SetManagementInterfacesIPAddress(managementInterfacesIPAddress *string) {
	o.ManagementInterfacesIPAddress = managementInterfacesIPAddress
}

// WithManagementInterfacesName adds the managementInterfacesName to the nodes get params
func (o *NodesGetParams) WithManagementInterfacesName(managementInterfacesName *string) *NodesGetParams {
	o.SetManagementInterfacesName(managementInterfacesName)
	return o
}

// SetManagementInterfacesName adds the managementInterfacesName to the nodes get params
func (o *NodesGetParams) SetManagementInterfacesName(managementInterfacesName *string) {
	o.ManagementInterfacesName = managementInterfacesName
}

// WithManagementInterfacesUUID adds the managementInterfacesUUID to the nodes get params
func (o *NodesGetParams) WithManagementInterfacesUUID(managementInterfacesUUID *string) *NodesGetParams {
	o.SetManagementInterfacesUUID(managementInterfacesUUID)
	return o
}

// SetManagementInterfacesUUID adds the managementInterfacesUuid to the nodes get params
func (o *NodesGetParams) SetManagementInterfacesUUID(managementInterfacesUUID *string) {
	o.ManagementInterfacesUUID = managementInterfacesUUID
}

// WithMaxRecords adds the maxRecords to the nodes get params
func (o *NodesGetParams) WithMaxRecords(maxRecords *int64) *NodesGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nodes get params
func (o *NodesGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMembership adds the membership to the nodes get params
func (o *NodesGetParams) WithMembership(membership *string) *NodesGetParams {
	o.SetMembership(membership)
	return o
}

// SetMembership adds the membership to the nodes get params
func (o *NodesGetParams) SetMembership(membership *string) {
	o.Membership = membership
}

// WithMetricDuration adds the metricDuration to the nodes get params
func (o *NodesGetParams) WithMetricDuration(metricDuration *string) *NodesGetParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the nodes get params
func (o *NodesGetParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricProcessorUtilization adds the metricProcessorUtilization to the nodes get params
func (o *NodesGetParams) WithMetricProcessorUtilization(metricProcessorUtilization *int64) *NodesGetParams {
	o.SetMetricProcessorUtilization(metricProcessorUtilization)
	return o
}

// SetMetricProcessorUtilization adds the metricProcessorUtilization to the nodes get params
func (o *NodesGetParams) SetMetricProcessorUtilization(metricProcessorUtilization *int64) {
	o.MetricProcessorUtilization = metricProcessorUtilization
}

// WithMetricStatus adds the metricStatus to the nodes get params
func (o *NodesGetParams) WithMetricStatus(metricStatus *string) *NodesGetParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the nodes get params
func (o *NodesGetParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricTimestamp adds the metricTimestamp to the nodes get params
func (o *NodesGetParams) WithMetricTimestamp(metricTimestamp *string) *NodesGetParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the nodes get params
func (o *NodesGetParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMetricUUID adds the metricUUID to the nodes get params
func (o *NodesGetParams) WithMetricUUID(metricUUID *string) *NodesGetParams {
	o.SetMetricUUID(metricUUID)
	return o
}

// SetMetricUUID adds the metricUuid to the nodes get params
func (o *NodesGetParams) SetMetricUUID(metricUUID *string) {
	o.MetricUUID = metricUUID
}

// WithMetroclusterCustomVlanCapable adds the metroclusterCustomVlanCapable to the nodes get params
func (o *NodesGetParams) WithMetroclusterCustomVlanCapable(metroclusterCustomVlanCapable *bool) *NodesGetParams {
	o.SetMetroclusterCustomVlanCapable(metroclusterCustomVlanCapable)
	return o
}

// SetMetroclusterCustomVlanCapable adds the metroclusterCustomVlanCapable to the nodes get params
func (o *NodesGetParams) SetMetroclusterCustomVlanCapable(metroclusterCustomVlanCapable *bool) {
	o.MetroclusterCustomVlanCapable = metroclusterCustomVlanCapable
}

// WithMetroclusterPortsName adds the metroclusterPortsName to the nodes get params
func (o *NodesGetParams) WithMetroclusterPortsName(metroclusterPortsName *string) *NodesGetParams {
	o.SetMetroclusterPortsName(metroclusterPortsName)
	return o
}

// SetMetroclusterPortsName adds the metroclusterPortsName to the nodes get params
func (o *NodesGetParams) SetMetroclusterPortsName(metroclusterPortsName *string) {
	o.MetroclusterPortsName = metroclusterPortsName
}

// WithMetroclusterType adds the metroclusterType to the nodes get params
func (o *NodesGetParams) WithMetroclusterType(metroclusterType *string) *NodesGetParams {
	o.SetMetroclusterType(metroclusterType)
	return o
}

// SetMetroclusterType adds the metroclusterType to the nodes get params
func (o *NodesGetParams) SetMetroclusterType(metroclusterType *string) {
	o.MetroclusterType = metroclusterType
}

// WithModel adds the model to the nodes get params
func (o *NodesGetParams) WithModel(model *string) *NodesGetParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the nodes get params
func (o *NodesGetParams) SetModel(model *string) {
	o.Model = model
}

// WithName adds the name to the nodes get params
func (o *NodesGetParams) WithName(name *string) *NodesGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the nodes get params
func (o *NodesGetParams) SetName(name *string) {
	o.Name = name
}

// WithNvlogBackingType adds the nvlogBackingType to the nodes get params
func (o *NodesGetParams) WithNvlogBackingType(nvlogBackingType *string) *NodesGetParams {
	o.SetNvlogBackingType(nvlogBackingType)
	return o
}

// SetNvlogBackingType adds the nvlogBackingType to the nodes get params
func (o *NodesGetParams) SetNvlogBackingType(nvlogBackingType *string) {
	o.NvlogBackingType = nvlogBackingType
}

// WithNvlogSwapMode adds the nvlogSwapMode to the nodes get params
func (o *NodesGetParams) WithNvlogSwapMode(nvlogSwapMode *string) *NodesGetParams {
	o.SetNvlogSwapMode(nvlogSwapMode)
	return o
}

// SetNvlogSwapMode adds the nvlogSwapMode to the nodes get params
func (o *NodesGetParams) SetNvlogSwapMode(nvlogSwapMode *string) {
	o.NvlogSwapMode = nvlogSwapMode
}

// WithNvramBatteryState adds the nvramBatteryState to the nodes get params
func (o *NodesGetParams) WithNvramBatteryState(nvramBatteryState *string) *NodesGetParams {
	o.SetNvramBatteryState(nvramBatteryState)
	return o
}

// SetNvramBatteryState adds the nvramBatteryState to the nodes get params
func (o *NodesGetParams) SetNvramBatteryState(nvramBatteryState *string) {
	o.NvramBatteryState = nvramBatteryState
}

// WithNvramID adds the nvramID to the nodes get params
func (o *NodesGetParams) WithNvramID(nvramID *int64) *NodesGetParams {
	o.SetNvramID(nvramID)
	return o
}

// SetNvramID adds the nvramId to the nodes get params
func (o *NodesGetParams) SetNvramID(nvramID *int64) {
	o.NvramID = nvramID
}

// WithOrderBy adds the orderBy to the nodes get params
func (o *NodesGetParams) WithOrderBy(orderBy []string) *NodesGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nodes get params
func (o *NodesGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwner adds the owner to the nodes get params
func (o *NodesGetParams) WithOwner(owner *string) *NodesGetParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the nodes get params
func (o *NodesGetParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithReturnRecords adds the returnRecords to the nodes get params
func (o *NodesGetParams) WithReturnRecords(returnRecords *bool) *NodesGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nodes get params
func (o *NodesGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nodes get params
func (o *NodesGetParams) WithReturnTimeout(returnTimeout *int64) *NodesGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nodes get params
func (o *NodesGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the nodes get params
func (o *NodesGetParams) WithSerialNumber(serialNumber *string) *NodesGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the nodes get params
func (o *NodesGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithServiceProcessorAPIServiceEnabled adds the serviceProcessorAPIServiceEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorAPIServiceEnabled(serviceProcessorAPIServiceEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorAPIServiceEnabled(serviceProcessorAPIServiceEnabled)
	return o
}

// SetServiceProcessorAPIServiceEnabled adds the serviceProcessorApiServiceEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorAPIServiceEnabled(serviceProcessorAPIServiceEnabled *bool) {
	o.ServiceProcessorAPIServiceEnabled = serviceProcessorAPIServiceEnabled
}

// WithServiceProcessorAPIServiceLimitAccess adds the serviceProcessorAPIServiceLimitAccess to the nodes get params
func (o *NodesGetParams) WithServiceProcessorAPIServiceLimitAccess(serviceProcessorAPIServiceLimitAccess *bool) *NodesGetParams {
	o.SetServiceProcessorAPIServiceLimitAccess(serviceProcessorAPIServiceLimitAccess)
	return o
}

// SetServiceProcessorAPIServiceLimitAccess adds the serviceProcessorApiServiceLimitAccess to the nodes get params
func (o *NodesGetParams) SetServiceProcessorAPIServiceLimitAccess(serviceProcessorAPIServiceLimitAccess *bool) {
	o.ServiceProcessorAPIServiceLimitAccess = serviceProcessorAPIServiceLimitAccess
}

// WithServiceProcessorAPIServicePort adds the serviceProcessorAPIServicePort to the nodes get params
func (o *NodesGetParams) WithServiceProcessorAPIServicePort(serviceProcessorAPIServicePort *int64) *NodesGetParams {
	o.SetServiceProcessorAPIServicePort(serviceProcessorAPIServicePort)
	return o
}

// SetServiceProcessorAPIServicePort adds the serviceProcessorApiServicePort to the nodes get params
func (o *NodesGetParams) SetServiceProcessorAPIServicePort(serviceProcessorAPIServicePort *int64) {
	o.ServiceProcessorAPIServicePort = serviceProcessorAPIServicePort
}

// WithServiceProcessorAutoConfigIPV4Subnet adds the serviceProcessorAutoConfigIPV4Subnet to the nodes get params
func (o *NodesGetParams) WithServiceProcessorAutoConfigIPV4Subnet(serviceProcessorAutoConfigIPV4Subnet *string) *NodesGetParams {
	o.SetServiceProcessorAutoConfigIPV4Subnet(serviceProcessorAutoConfigIPV4Subnet)
	return o
}

// SetServiceProcessorAutoConfigIPV4Subnet adds the serviceProcessorAutoConfigIpv4Subnet to the nodes get params
func (o *NodesGetParams) SetServiceProcessorAutoConfigIPV4Subnet(serviceProcessorAutoConfigIPV4Subnet *string) {
	o.ServiceProcessorAutoConfigIPV4Subnet = serviceProcessorAutoConfigIPV4Subnet
}

// WithServiceProcessorAutoConfigIPV6Subnet adds the serviceProcessorAutoConfigIPV6Subnet to the nodes get params
func (o *NodesGetParams) WithServiceProcessorAutoConfigIPV6Subnet(serviceProcessorAutoConfigIPV6Subnet *string) *NodesGetParams {
	o.SetServiceProcessorAutoConfigIPV6Subnet(serviceProcessorAutoConfigIPV6Subnet)
	return o
}

// SetServiceProcessorAutoConfigIPV6Subnet adds the serviceProcessorAutoConfigIpv6Subnet to the nodes get params
func (o *NodesGetParams) SetServiceProcessorAutoConfigIPV6Subnet(serviceProcessorAutoConfigIPV6Subnet *string) {
	o.ServiceProcessorAutoConfigIPV6Subnet = serviceProcessorAutoConfigIPV6Subnet
}

// WithServiceProcessorAutoupdateEnabled adds the serviceProcessorAutoupdateEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorAutoupdateEnabled(serviceProcessorAutoupdateEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorAutoupdateEnabled(serviceProcessorAutoupdateEnabled)
	return o
}

// SetServiceProcessorAutoupdateEnabled adds the serviceProcessorAutoupdateEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorAutoupdateEnabled(serviceProcessorAutoupdateEnabled *bool) {
	o.ServiceProcessorAutoupdateEnabled = serviceProcessorAutoupdateEnabled
}

// WithServiceProcessorBackupIsCurrent adds the serviceProcessorBackupIsCurrent to the nodes get params
func (o *NodesGetParams) WithServiceProcessorBackupIsCurrent(serviceProcessorBackupIsCurrent *bool) *NodesGetParams {
	o.SetServiceProcessorBackupIsCurrent(serviceProcessorBackupIsCurrent)
	return o
}

// SetServiceProcessorBackupIsCurrent adds the serviceProcessorBackupIsCurrent to the nodes get params
func (o *NodesGetParams) SetServiceProcessorBackupIsCurrent(serviceProcessorBackupIsCurrent *bool) {
	o.ServiceProcessorBackupIsCurrent = serviceProcessorBackupIsCurrent
}

// WithServiceProcessorBackupState adds the serviceProcessorBackupState to the nodes get params
func (o *NodesGetParams) WithServiceProcessorBackupState(serviceProcessorBackupState *string) *NodesGetParams {
	o.SetServiceProcessorBackupState(serviceProcessorBackupState)
	return o
}

// SetServiceProcessorBackupState adds the serviceProcessorBackupState to the nodes get params
func (o *NodesGetParams) SetServiceProcessorBackupState(serviceProcessorBackupState *string) {
	o.ServiceProcessorBackupState = serviceProcessorBackupState
}

// WithServiceProcessorBackupVersion adds the serviceProcessorBackupVersion to the nodes get params
func (o *NodesGetParams) WithServiceProcessorBackupVersion(serviceProcessorBackupVersion *string) *NodesGetParams {
	o.SetServiceProcessorBackupVersion(serviceProcessorBackupVersion)
	return o
}

// SetServiceProcessorBackupVersion adds the serviceProcessorBackupVersion to the nodes get params
func (o *NodesGetParams) SetServiceProcessorBackupVersion(serviceProcessorBackupVersion *string) {
	o.ServiceProcessorBackupVersion = serviceProcessorBackupVersion
}

// WithServiceProcessorDhcpEnabled adds the serviceProcessorDhcpEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorDhcpEnabled(serviceProcessorDhcpEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorDhcpEnabled(serviceProcessorDhcpEnabled)
	return o
}

// SetServiceProcessorDhcpEnabled adds the serviceProcessorDhcpEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorDhcpEnabled(serviceProcessorDhcpEnabled *bool) {
	o.ServiceProcessorDhcpEnabled = serviceProcessorDhcpEnabled
}

// WithServiceProcessorFirmwareVersion adds the serviceProcessorFirmwareVersion to the nodes get params
func (o *NodesGetParams) WithServiceProcessorFirmwareVersion(serviceProcessorFirmwareVersion *string) *NodesGetParams {
	o.SetServiceProcessorFirmwareVersion(serviceProcessorFirmwareVersion)
	return o
}

// SetServiceProcessorFirmwareVersion adds the serviceProcessorFirmwareVersion to the nodes get params
func (o *NodesGetParams) SetServiceProcessorFirmwareVersion(serviceProcessorFirmwareVersion *string) {
	o.ServiceProcessorFirmwareVersion = serviceProcessorFirmwareVersion
}

// WithServiceProcessorIPV4InterfaceAddress adds the serviceProcessorIPV4InterfaceAddress to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV4InterfaceAddress(serviceProcessorIPV4InterfaceAddress *string) *NodesGetParams {
	o.SetServiceProcessorIPV4InterfaceAddress(serviceProcessorIPV4InterfaceAddress)
	return o
}

// SetServiceProcessorIPV4InterfaceAddress adds the serviceProcessorIpv4InterfaceAddress to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV4InterfaceAddress(serviceProcessorIPV4InterfaceAddress *string) {
	o.ServiceProcessorIPV4InterfaceAddress = serviceProcessorIPV4InterfaceAddress
}

// WithServiceProcessorIPV4InterfaceEnabled adds the serviceProcessorIPV4InterfaceEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV4InterfaceEnabled(serviceProcessorIPV4InterfaceEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorIPV4InterfaceEnabled(serviceProcessorIPV4InterfaceEnabled)
	return o
}

// SetServiceProcessorIPV4InterfaceEnabled adds the serviceProcessorIpv4InterfaceEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV4InterfaceEnabled(serviceProcessorIPV4InterfaceEnabled *bool) {
	o.ServiceProcessorIPV4InterfaceEnabled = serviceProcessorIPV4InterfaceEnabled
}

// WithServiceProcessorIPV4InterfaceGateway adds the serviceProcessorIPV4InterfaceGateway to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV4InterfaceGateway(serviceProcessorIPV4InterfaceGateway *string) *NodesGetParams {
	o.SetServiceProcessorIPV4InterfaceGateway(serviceProcessorIPV4InterfaceGateway)
	return o
}

// SetServiceProcessorIPV4InterfaceGateway adds the serviceProcessorIpv4InterfaceGateway to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV4InterfaceGateway(serviceProcessorIPV4InterfaceGateway *string) {
	o.ServiceProcessorIPV4InterfaceGateway = serviceProcessorIPV4InterfaceGateway
}

// WithServiceProcessorIPV4InterfaceNetmask adds the serviceProcessorIPV4InterfaceNetmask to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV4InterfaceNetmask(serviceProcessorIPV4InterfaceNetmask *string) *NodesGetParams {
	o.SetServiceProcessorIPV4InterfaceNetmask(serviceProcessorIPV4InterfaceNetmask)
	return o
}

// SetServiceProcessorIPV4InterfaceNetmask adds the serviceProcessorIpv4InterfaceNetmask to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV4InterfaceNetmask(serviceProcessorIPV4InterfaceNetmask *string) {
	o.ServiceProcessorIPV4InterfaceNetmask = serviceProcessorIPV4InterfaceNetmask
}

// WithServiceProcessorIPV4InterfaceSetupState adds the serviceProcessorIPV4InterfaceSetupState to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV4InterfaceSetupState(serviceProcessorIPV4InterfaceSetupState *string) *NodesGetParams {
	o.SetServiceProcessorIPV4InterfaceSetupState(serviceProcessorIPV4InterfaceSetupState)
	return o
}

// SetServiceProcessorIPV4InterfaceSetupState adds the serviceProcessorIpv4InterfaceSetupState to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV4InterfaceSetupState(serviceProcessorIPV4InterfaceSetupState *string) {
	o.ServiceProcessorIPV4InterfaceSetupState = serviceProcessorIPV4InterfaceSetupState
}

// WithServiceProcessorIPV6InterfaceAddress adds the serviceProcessorIPV6InterfaceAddress to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceAddress(serviceProcessorIPV6InterfaceAddress *string) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceAddress(serviceProcessorIPV6InterfaceAddress)
	return o
}

// SetServiceProcessorIPV6InterfaceAddress adds the serviceProcessorIpv6InterfaceAddress to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceAddress(serviceProcessorIPV6InterfaceAddress *string) {
	o.ServiceProcessorIPV6InterfaceAddress = serviceProcessorIPV6InterfaceAddress
}

// WithServiceProcessorIPV6InterfaceEnabled adds the serviceProcessorIPV6InterfaceEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceEnabled(serviceProcessorIPV6InterfaceEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceEnabled(serviceProcessorIPV6InterfaceEnabled)
	return o
}

// SetServiceProcessorIPV6InterfaceEnabled adds the serviceProcessorIpv6InterfaceEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceEnabled(serviceProcessorIPV6InterfaceEnabled *bool) {
	o.ServiceProcessorIPV6InterfaceEnabled = serviceProcessorIPV6InterfaceEnabled
}

// WithServiceProcessorIPV6InterfaceGateway adds the serviceProcessorIPV6InterfaceGateway to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceGateway(serviceProcessorIPV6InterfaceGateway *string) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceGateway(serviceProcessorIPV6InterfaceGateway)
	return o
}

// SetServiceProcessorIPV6InterfaceGateway adds the serviceProcessorIpv6InterfaceGateway to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceGateway(serviceProcessorIPV6InterfaceGateway *string) {
	o.ServiceProcessorIPV6InterfaceGateway = serviceProcessorIPV6InterfaceGateway
}

// WithServiceProcessorIPV6InterfaceIsIPV6RaEnabled adds the serviceProcessorIPV6InterfaceIsIPV6RaEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceIsIPV6RaEnabled(serviceProcessorIPV6InterfaceIsIPV6RaEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceIsIPV6RaEnabled(serviceProcessorIPV6InterfaceIsIPV6RaEnabled)
	return o
}

// SetServiceProcessorIPV6InterfaceIsIPV6RaEnabled adds the serviceProcessorIpv6InterfaceIsIpv6RaEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceIsIPV6RaEnabled(serviceProcessorIPV6InterfaceIsIPV6RaEnabled *bool) {
	o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled = serviceProcessorIPV6InterfaceIsIPV6RaEnabled
}

// WithServiceProcessorIPV6InterfaceLinkLocalIP adds the serviceProcessorIPV6InterfaceLinkLocalIP to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceLinkLocalIP(serviceProcessorIPV6InterfaceLinkLocalIP *string) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceLinkLocalIP(serviceProcessorIPV6InterfaceLinkLocalIP)
	return o
}

// SetServiceProcessorIPV6InterfaceLinkLocalIP adds the serviceProcessorIpv6InterfaceLinkLocalIp to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceLinkLocalIP(serviceProcessorIPV6InterfaceLinkLocalIP *string) {
	o.ServiceProcessorIPV6InterfaceLinkLocalIP = serviceProcessorIPV6InterfaceLinkLocalIP
}

// WithServiceProcessorIPV6InterfaceNetmask adds the serviceProcessorIPV6InterfaceNetmask to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceNetmask(serviceProcessorIPV6InterfaceNetmask *int64) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceNetmask(serviceProcessorIPV6InterfaceNetmask)
	return o
}

// SetServiceProcessorIPV6InterfaceNetmask adds the serviceProcessorIpv6InterfaceNetmask to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceNetmask(serviceProcessorIPV6InterfaceNetmask *int64) {
	o.ServiceProcessorIPV6InterfaceNetmask = serviceProcessorIPV6InterfaceNetmask
}

// WithServiceProcessorIPV6InterfaceRouterIP adds the serviceProcessorIPV6InterfaceRouterIP to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceRouterIP(serviceProcessorIPV6InterfaceRouterIP *string) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceRouterIP(serviceProcessorIPV6InterfaceRouterIP)
	return o
}

// SetServiceProcessorIPV6InterfaceRouterIP adds the serviceProcessorIpv6InterfaceRouterIp to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceRouterIP(serviceProcessorIPV6InterfaceRouterIP *string) {
	o.ServiceProcessorIPV6InterfaceRouterIP = serviceProcessorIPV6InterfaceRouterIP
}

// WithServiceProcessorIPV6InterfaceSetupState adds the serviceProcessorIPV6InterfaceSetupState to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIPV6InterfaceSetupState(serviceProcessorIPV6InterfaceSetupState *string) *NodesGetParams {
	o.SetServiceProcessorIPV6InterfaceSetupState(serviceProcessorIPV6InterfaceSetupState)
	return o
}

// SetServiceProcessorIPV6InterfaceSetupState adds the serviceProcessorIpv6InterfaceSetupState to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIPV6InterfaceSetupState(serviceProcessorIPV6InterfaceSetupState *string) {
	o.ServiceProcessorIPV6InterfaceSetupState = serviceProcessorIPV6InterfaceSetupState
}

// WithServiceProcessorIsIPConfigured adds the serviceProcessorIsIPConfigured to the nodes get params
func (o *NodesGetParams) WithServiceProcessorIsIPConfigured(serviceProcessorIsIPConfigured *bool) *NodesGetParams {
	o.SetServiceProcessorIsIPConfigured(serviceProcessorIsIPConfigured)
	return o
}

// SetServiceProcessorIsIPConfigured adds the serviceProcessorIsIpConfigured to the nodes get params
func (o *NodesGetParams) SetServiceProcessorIsIPConfigured(serviceProcessorIsIPConfigured *bool) {
	o.ServiceProcessorIsIPConfigured = serviceProcessorIsIPConfigured
}

// WithServiceProcessorLastUpdateState adds the serviceProcessorLastUpdateState to the nodes get params
func (o *NodesGetParams) WithServiceProcessorLastUpdateState(serviceProcessorLastUpdateState *string) *NodesGetParams {
	o.SetServiceProcessorLastUpdateState(serviceProcessorLastUpdateState)
	return o
}

// SetServiceProcessorLastUpdateState adds the serviceProcessorLastUpdateState to the nodes get params
func (o *NodesGetParams) SetServiceProcessorLastUpdateState(serviceProcessorLastUpdateState *string) {
	o.ServiceProcessorLastUpdateState = serviceProcessorLastUpdateState
}

// WithServiceProcessorLinkStatus adds the serviceProcessorLinkStatus to the nodes get params
func (o *NodesGetParams) WithServiceProcessorLinkStatus(serviceProcessorLinkStatus *string) *NodesGetParams {
	o.SetServiceProcessorLinkStatus(serviceProcessorLinkStatus)
	return o
}

// SetServiceProcessorLinkStatus adds the serviceProcessorLinkStatus to the nodes get params
func (o *NodesGetParams) SetServiceProcessorLinkStatus(serviceProcessorLinkStatus *string) {
	o.ServiceProcessorLinkStatus = serviceProcessorLinkStatus
}

// WithServiceProcessorMacAddress adds the serviceProcessorMacAddress to the nodes get params
func (o *NodesGetParams) WithServiceProcessorMacAddress(serviceProcessorMacAddress *string) *NodesGetParams {
	o.SetServiceProcessorMacAddress(serviceProcessorMacAddress)
	return o
}

// SetServiceProcessorMacAddress adds the serviceProcessorMacAddress to the nodes get params
func (o *NodesGetParams) SetServiceProcessorMacAddress(serviceProcessorMacAddress *string) {
	o.ServiceProcessorMacAddress = serviceProcessorMacAddress
}

// WithServiceProcessorPrimaryIsCurrent adds the serviceProcessorPrimaryIsCurrent to the nodes get params
func (o *NodesGetParams) WithServiceProcessorPrimaryIsCurrent(serviceProcessorPrimaryIsCurrent *bool) *NodesGetParams {
	o.SetServiceProcessorPrimaryIsCurrent(serviceProcessorPrimaryIsCurrent)
	return o
}

// SetServiceProcessorPrimaryIsCurrent adds the serviceProcessorPrimaryIsCurrent to the nodes get params
func (o *NodesGetParams) SetServiceProcessorPrimaryIsCurrent(serviceProcessorPrimaryIsCurrent *bool) {
	o.ServiceProcessorPrimaryIsCurrent = serviceProcessorPrimaryIsCurrent
}

// WithServiceProcessorPrimaryState adds the serviceProcessorPrimaryState to the nodes get params
func (o *NodesGetParams) WithServiceProcessorPrimaryState(serviceProcessorPrimaryState *string) *NodesGetParams {
	o.SetServiceProcessorPrimaryState(serviceProcessorPrimaryState)
	return o
}

// SetServiceProcessorPrimaryState adds the serviceProcessorPrimaryState to the nodes get params
func (o *NodesGetParams) SetServiceProcessorPrimaryState(serviceProcessorPrimaryState *string) {
	o.ServiceProcessorPrimaryState = serviceProcessorPrimaryState
}

// WithServiceProcessorPrimaryVersion adds the serviceProcessorPrimaryVersion to the nodes get params
func (o *NodesGetParams) WithServiceProcessorPrimaryVersion(serviceProcessorPrimaryVersion *string) *NodesGetParams {
	o.SetServiceProcessorPrimaryVersion(serviceProcessorPrimaryVersion)
	return o
}

// SetServiceProcessorPrimaryVersion adds the serviceProcessorPrimaryVersion to the nodes get params
func (o *NodesGetParams) SetServiceProcessorPrimaryVersion(serviceProcessorPrimaryVersion *string) {
	o.ServiceProcessorPrimaryVersion = serviceProcessorPrimaryVersion
}

// WithServiceProcessorSSHInfoAllowedAddresses adds the serviceProcessorSSHInfoAllowedAddresses to the nodes get params
func (o *NodesGetParams) WithServiceProcessorSSHInfoAllowedAddresses(serviceProcessorSSHInfoAllowedAddresses *string) *NodesGetParams {
	o.SetServiceProcessorSSHInfoAllowedAddresses(serviceProcessorSSHInfoAllowedAddresses)
	return o
}

// SetServiceProcessorSSHInfoAllowedAddresses adds the serviceProcessorSshInfoAllowedAddresses to the nodes get params
func (o *NodesGetParams) SetServiceProcessorSSHInfoAllowedAddresses(serviceProcessorSSHInfoAllowedAddresses *string) {
	o.ServiceProcessorSSHInfoAllowedAddresses = serviceProcessorSSHInfoAllowedAddresses
}

// WithServiceProcessorState adds the serviceProcessorState to the nodes get params
func (o *NodesGetParams) WithServiceProcessorState(serviceProcessorState *string) *NodesGetParams {
	o.SetServiceProcessorState(serviceProcessorState)
	return o
}

// SetServiceProcessorState adds the serviceProcessorState to the nodes get params
func (o *NodesGetParams) SetServiceProcessorState(serviceProcessorState *string) {
	o.ServiceProcessorState = serviceProcessorState
}

// WithServiceProcessorType adds the serviceProcessorType to the nodes get params
func (o *NodesGetParams) WithServiceProcessorType(serviceProcessorType *string) *NodesGetParams {
	o.SetServiceProcessorType(serviceProcessorType)
	return o
}

// SetServiceProcessorType adds the serviceProcessorType to the nodes get params
func (o *NodesGetParams) SetServiceProcessorType(serviceProcessorType *string) {
	o.ServiceProcessorType = serviceProcessorType
}

// WithServiceProcessorWebServiceEnabled adds the serviceProcessorWebServiceEnabled to the nodes get params
func (o *NodesGetParams) WithServiceProcessorWebServiceEnabled(serviceProcessorWebServiceEnabled *bool) *NodesGetParams {
	o.SetServiceProcessorWebServiceEnabled(serviceProcessorWebServiceEnabled)
	return o
}

// SetServiceProcessorWebServiceEnabled adds the serviceProcessorWebServiceEnabled to the nodes get params
func (o *NodesGetParams) SetServiceProcessorWebServiceEnabled(serviceProcessorWebServiceEnabled *bool) {
	o.ServiceProcessorWebServiceEnabled = serviceProcessorWebServiceEnabled
}

// WithServiceProcessorWebServiceLimitAccess adds the serviceProcessorWebServiceLimitAccess to the nodes get params
func (o *NodesGetParams) WithServiceProcessorWebServiceLimitAccess(serviceProcessorWebServiceLimitAccess *bool) *NodesGetParams {
	o.SetServiceProcessorWebServiceLimitAccess(serviceProcessorWebServiceLimitAccess)
	return o
}

// SetServiceProcessorWebServiceLimitAccess adds the serviceProcessorWebServiceLimitAccess to the nodes get params
func (o *NodesGetParams) SetServiceProcessorWebServiceLimitAccess(serviceProcessorWebServiceLimitAccess *bool) {
	o.ServiceProcessorWebServiceLimitAccess = serviceProcessorWebServiceLimitAccess
}

// WithSnaplockComplianceClockTime adds the snaplockComplianceClockTime to the nodes get params
func (o *NodesGetParams) WithSnaplockComplianceClockTime(snaplockComplianceClockTime *string) *NodesGetParams {
	o.SetSnaplockComplianceClockTime(snaplockComplianceClockTime)
	return o
}

// SetSnaplockComplianceClockTime adds the snaplockComplianceClockTime to the nodes get params
func (o *NodesGetParams) SetSnaplockComplianceClockTime(snaplockComplianceClockTime *string) {
	o.SnaplockComplianceClockTime = snaplockComplianceClockTime
}

// WithState adds the state to the nodes get params
func (o *NodesGetParams) WithState(state *string) *NodesGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the nodes get params
func (o *NodesGetParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsProcessorUtilizationBase adds the statisticsProcessorUtilizationBase to the nodes get params
func (o *NodesGetParams) WithStatisticsProcessorUtilizationBase(statisticsProcessorUtilizationBase *int64) *NodesGetParams {
	o.SetStatisticsProcessorUtilizationBase(statisticsProcessorUtilizationBase)
	return o
}

// SetStatisticsProcessorUtilizationBase adds the statisticsProcessorUtilizationBase to the nodes get params
func (o *NodesGetParams) SetStatisticsProcessorUtilizationBase(statisticsProcessorUtilizationBase *int64) {
	o.StatisticsProcessorUtilizationBase = statisticsProcessorUtilizationBase
}

// WithStatisticsProcessorUtilizationRaw adds the statisticsProcessorUtilizationRaw to the nodes get params
func (o *NodesGetParams) WithStatisticsProcessorUtilizationRaw(statisticsProcessorUtilizationRaw *int64) *NodesGetParams {
	o.SetStatisticsProcessorUtilizationRaw(statisticsProcessorUtilizationRaw)
	return o
}

// SetStatisticsProcessorUtilizationRaw adds the statisticsProcessorUtilizationRaw to the nodes get params
func (o *NodesGetParams) SetStatisticsProcessorUtilizationRaw(statisticsProcessorUtilizationRaw *int64) {
	o.StatisticsProcessorUtilizationRaw = statisticsProcessorUtilizationRaw
}

// WithStatisticsStatus adds the statisticsStatus to the nodes get params
func (o *NodesGetParams) WithStatisticsStatus(statisticsStatus *string) *NodesGetParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the nodes get params
func (o *NodesGetParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the nodes get params
func (o *NodesGetParams) WithStatisticsTimestamp(statisticsTimestamp *string) *NodesGetParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the nodes get params
func (o *NodesGetParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithStorageAvailabilityZonesName adds the storageAvailabilityZonesName to the nodes get params
func (o *NodesGetParams) WithStorageAvailabilityZonesName(storageAvailabilityZonesName *string) *NodesGetParams {
	o.SetStorageAvailabilityZonesName(storageAvailabilityZonesName)
	return o
}

// SetStorageAvailabilityZonesName adds the storageAvailabilityZonesName to the nodes get params
func (o *NodesGetParams) SetStorageAvailabilityZonesName(storageAvailabilityZonesName *string) {
	o.StorageAvailabilityZonesName = storageAvailabilityZonesName
}

// WithStorageAvailabilityZonesUUID adds the storageAvailabilityZonesUUID to the nodes get params
func (o *NodesGetParams) WithStorageAvailabilityZonesUUID(storageAvailabilityZonesUUID *string) *NodesGetParams {
	o.SetStorageAvailabilityZonesUUID(storageAvailabilityZonesUUID)
	return o
}

// SetStorageAvailabilityZonesUUID adds the storageAvailabilityZonesUuid to the nodes get params
func (o *NodesGetParams) SetStorageAvailabilityZonesUUID(storageAvailabilityZonesUUID *string) {
	o.StorageAvailabilityZonesUUID = storageAvailabilityZonesUUID
}

// WithStorageConfiguration adds the storageConfiguration to the nodes get params
func (o *NodesGetParams) WithStorageConfiguration(storageConfiguration *string) *NodesGetParams {
	o.SetStorageConfiguration(storageConfiguration)
	return o
}

// SetStorageConfiguration adds the storageConfiguration to the nodes get params
func (o *NodesGetParams) SetStorageConfiguration(storageConfiguration *string) {
	o.StorageConfiguration = storageConfiguration
}

// WithSystemAggregateName adds the systemAggregateName to the nodes get params
func (o *NodesGetParams) WithSystemAggregateName(systemAggregateName *string) *NodesGetParams {
	o.SetSystemAggregateName(systemAggregateName)
	return o
}

// SetSystemAggregateName adds the systemAggregateName to the nodes get params
func (o *NodesGetParams) SetSystemAggregateName(systemAggregateName *string) {
	o.SystemAggregateName = systemAggregateName
}

// WithSystemAggregateUUID adds the systemAggregateUUID to the nodes get params
func (o *NodesGetParams) WithSystemAggregateUUID(systemAggregateUUID *string) *NodesGetParams {
	o.SetSystemAggregateUUID(systemAggregateUUID)
	return o
}

// SetSystemAggregateUUID adds the systemAggregateUuid to the nodes get params
func (o *NodesGetParams) SetSystemAggregateUUID(systemAggregateUUID *string) {
	o.SystemAggregateUUID = systemAggregateUUID
}

// WithSystemID adds the systemID to the nodes get params
func (o *NodesGetParams) WithSystemID(systemID *string) *NodesGetParams {
	o.SetSystemID(systemID)
	return o
}

// SetSystemID adds the systemId to the nodes get params
func (o *NodesGetParams) SetSystemID(systemID *string) {
	o.SystemID = systemID
}

// WithSystemMachineType adds the systemMachineType to the nodes get params
func (o *NodesGetParams) WithSystemMachineType(systemMachineType *string) *NodesGetParams {
	o.SetSystemMachineType(systemMachineType)
	return o
}

// SetSystemMachineType adds the systemMachineType to the nodes get params
func (o *NodesGetParams) SetSystemMachineType(systemMachineType *string) {
	o.SystemMachineType = systemMachineType
}

// WithUptime adds the uptime to the nodes get params
func (o *NodesGetParams) WithUptime(uptime *int64) *NodesGetParams {
	o.SetUptime(uptime)
	return o
}

// SetUptime adds the uptime to the nodes get params
func (o *NodesGetParams) SetUptime(uptime *int64) {
	o.Uptime = uptime
}

// WithUUID adds the uuid to the nodes get params
func (o *NodesGetParams) WithUUID(uuid *string) *NodesGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the nodes get params
func (o *NodesGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVendorSerialNumber adds the vendorSerialNumber to the nodes get params
func (o *NodesGetParams) WithVendorSerialNumber(vendorSerialNumber *string) *NodesGetParams {
	o.SetVendorSerialNumber(vendorSerialNumber)
	return o
}

// SetVendorSerialNumber adds the vendorSerialNumber to the nodes get params
func (o *NodesGetParams) SetVendorSerialNumber(vendorSerialNumber *string) {
	o.VendorSerialNumber = vendorSerialNumber
}

// WithVersionFull adds the versionFull to the nodes get params
func (o *NodesGetParams) WithVersionFull(versionFull *string) *NodesGetParams {
	o.SetVersionFull(versionFull)
	return o
}

// SetVersionFull adds the versionFull to the nodes get params
func (o *NodesGetParams) SetVersionFull(versionFull *string) {
	o.VersionFull = versionFull
}

// WithVersionGeneration adds the versionGeneration to the nodes get params
func (o *NodesGetParams) WithVersionGeneration(versionGeneration *int64) *NodesGetParams {
	o.SetVersionGeneration(versionGeneration)
	return o
}

// SetVersionGeneration adds the versionGeneration to the nodes get params
func (o *NodesGetParams) SetVersionGeneration(versionGeneration *int64) {
	o.VersionGeneration = versionGeneration
}

// WithVersionMajor adds the versionMajor to the nodes get params
func (o *NodesGetParams) WithVersionMajor(versionMajor *int64) *NodesGetParams {
	o.SetVersionMajor(versionMajor)
	return o
}

// SetVersionMajor adds the versionMajor to the nodes get params
func (o *NodesGetParams) SetVersionMajor(versionMajor *int64) {
	o.VersionMajor = versionMajor
}

// WithVersionMinor adds the versionMinor to the nodes get params
func (o *NodesGetParams) WithVersionMinor(versionMinor *int64) *NodesGetParams {
	o.SetVersionMinor(versionMinor)
	return o
}

// SetVersionMinor adds the versionMinor to the nodes get params
func (o *NodesGetParams) SetVersionMinor(versionMinor *int64) {
	o.VersionMinor = versionMinor
}

// WithVMProviderType adds the vMProviderType to the nodes get params
func (o *NodesGetParams) WithVMProviderType(vMProviderType *string) *NodesGetParams {
	o.SetVMProviderType(vMProviderType)
	return o
}

// SetVMProviderType adds the vmProviderType to the nodes get params
func (o *NodesGetParams) SetVMProviderType(vMProviderType *string) {
	o.VMProviderType = vMProviderType
}

// WriteToRequest writes these params to a swagger request
func (o *NodesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AntiRansomwareVersion != nil {

		// query param anti_ransomware_version
		var qrAntiRansomwareVersion string

		if o.AntiRansomwareVersion != nil {
			qrAntiRansomwareVersion = *o.AntiRansomwareVersion
		}
		qAntiRansomwareVersion := qrAntiRansomwareVersion
		if qAntiRansomwareVersion != "" {

			if err := r.SetQueryParam("anti_ransomware_version", qAntiRansomwareVersion); err != nil {
				return err
			}
		}
	}

	if o.ClusterInterfacesIPAddress != nil {

		// query param cluster_interfaces.ip.address
		var qrClusterInterfacesIPAddress string

		if o.ClusterInterfacesIPAddress != nil {
			qrClusterInterfacesIPAddress = *o.ClusterInterfacesIPAddress
		}
		qClusterInterfacesIPAddress := qrClusterInterfacesIPAddress
		if qClusterInterfacesIPAddress != "" {

			if err := r.SetQueryParam("cluster_interfaces.ip.address", qClusterInterfacesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.ClusterInterfacesName != nil {

		// query param cluster_interfaces.name
		var qrClusterInterfacesName string

		if o.ClusterInterfacesName != nil {
			qrClusterInterfacesName = *o.ClusterInterfacesName
		}
		qClusterInterfacesName := qrClusterInterfacesName
		if qClusterInterfacesName != "" {

			if err := r.SetQueryParam("cluster_interfaces.name", qClusterInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.ClusterInterfacesUUID != nil {

		// query param cluster_interfaces.uuid
		var qrClusterInterfacesUUID string

		if o.ClusterInterfacesUUID != nil {
			qrClusterInterfacesUUID = *o.ClusterInterfacesUUID
		}
		qClusterInterfacesUUID := qrClusterInterfacesUUID
		if qClusterInterfacesUUID != "" {

			if err := r.SetQueryParam("cluster_interfaces.uuid", qClusterInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.ControllerBoard != nil {

		// query param controller.board
		var qrControllerBoard string

		if o.ControllerBoard != nil {
			qrControllerBoard = *o.ControllerBoard
		}
		qControllerBoard := qrControllerBoard
		if qControllerBoard != "" {

			if err := r.SetQueryParam("controller.board", qControllerBoard); err != nil {
				return err
			}
		}
	}

	if o.ControllerCPUCount != nil {

		// query param controller.cpu.count
		var qrControllerCPUCount int64

		if o.ControllerCPUCount != nil {
			qrControllerCPUCount = *o.ControllerCPUCount
		}
		qControllerCPUCount := swag.FormatInt64(qrControllerCPUCount)
		if qControllerCPUCount != "" {

			if err := r.SetQueryParam("controller.cpu.count", qControllerCPUCount); err != nil {
				return err
			}
		}
	}

	if o.ControllerCPUFirmwareRelease != nil {

		// query param controller.cpu.firmware_release
		var qrControllerCPUFirmwareRelease string

		if o.ControllerCPUFirmwareRelease != nil {
			qrControllerCPUFirmwareRelease = *o.ControllerCPUFirmwareRelease
		}
		qControllerCPUFirmwareRelease := qrControllerCPUFirmwareRelease
		if qControllerCPUFirmwareRelease != "" {

			if err := r.SetQueryParam("controller.cpu.firmware_release", qControllerCPUFirmwareRelease); err != nil {
				return err
			}
		}
	}

	if o.ControllerCPUProcessor != nil {

		// query param controller.cpu.processor
		var qrControllerCPUProcessor string

		if o.ControllerCPUProcessor != nil {
			qrControllerCPUProcessor = *o.ControllerCPUProcessor
		}
		qControllerCPUProcessor := qrControllerCPUProcessor
		if qControllerCPUProcessor != "" {

			if err := r.SetQueryParam("controller.cpu.processor", qControllerCPUProcessor); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedFanCount != nil {

		// query param controller.failed_fan.count
		var qrControllerFailedFanCount int64

		if o.ControllerFailedFanCount != nil {
			qrControllerFailedFanCount = *o.ControllerFailedFanCount
		}
		qControllerFailedFanCount := swag.FormatInt64(qrControllerFailedFanCount)
		if qControllerFailedFanCount != "" {

			if err := r.SetQueryParam("controller.failed_fan.count", qControllerFailedFanCount); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedFanMessageCode != nil {

		// query param controller.failed_fan.message.code
		var qrControllerFailedFanMessageCode string

		if o.ControllerFailedFanMessageCode != nil {
			qrControllerFailedFanMessageCode = *o.ControllerFailedFanMessageCode
		}
		qControllerFailedFanMessageCode := qrControllerFailedFanMessageCode
		if qControllerFailedFanMessageCode != "" {

			if err := r.SetQueryParam("controller.failed_fan.message.code", qControllerFailedFanMessageCode); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedFanMessageMessage != nil {

		// query param controller.failed_fan.message.message
		var qrControllerFailedFanMessageMessage string

		if o.ControllerFailedFanMessageMessage != nil {
			qrControllerFailedFanMessageMessage = *o.ControllerFailedFanMessageMessage
		}
		qControllerFailedFanMessageMessage := qrControllerFailedFanMessageMessage
		if qControllerFailedFanMessageMessage != "" {

			if err := r.SetQueryParam("controller.failed_fan.message.message", qControllerFailedFanMessageMessage); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedPowerSupplyCount != nil {

		// query param controller.failed_power_supply.count
		var qrControllerFailedPowerSupplyCount int64

		if o.ControllerFailedPowerSupplyCount != nil {
			qrControllerFailedPowerSupplyCount = *o.ControllerFailedPowerSupplyCount
		}
		qControllerFailedPowerSupplyCount := swag.FormatInt64(qrControllerFailedPowerSupplyCount)
		if qControllerFailedPowerSupplyCount != "" {

			if err := r.SetQueryParam("controller.failed_power_supply.count", qControllerFailedPowerSupplyCount); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedPowerSupplyMessageCode != nil {

		// query param controller.failed_power_supply.message.code
		var qrControllerFailedPowerSupplyMessageCode string

		if o.ControllerFailedPowerSupplyMessageCode != nil {
			qrControllerFailedPowerSupplyMessageCode = *o.ControllerFailedPowerSupplyMessageCode
		}
		qControllerFailedPowerSupplyMessageCode := qrControllerFailedPowerSupplyMessageCode
		if qControllerFailedPowerSupplyMessageCode != "" {

			if err := r.SetQueryParam("controller.failed_power_supply.message.code", qControllerFailedPowerSupplyMessageCode); err != nil {
				return err
			}
		}
	}

	if o.ControllerFailedPowerSupplyMessageMessage != nil {

		// query param controller.failed_power_supply.message.message
		var qrControllerFailedPowerSupplyMessageMessage string

		if o.ControllerFailedPowerSupplyMessageMessage != nil {
			qrControllerFailedPowerSupplyMessageMessage = *o.ControllerFailedPowerSupplyMessageMessage
		}
		qControllerFailedPowerSupplyMessageMessage := qrControllerFailedPowerSupplyMessageMessage
		if qControllerFailedPowerSupplyMessageMessage != "" {

			if err := r.SetQueryParam("controller.failed_power_supply.message.message", qControllerFailedPowerSupplyMessageMessage); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheCapacity != nil {

		// query param controller.flash_cache.capacity
		var qrControllerFlashCacheCapacity int64

		if o.ControllerFlashCacheCapacity != nil {
			qrControllerFlashCacheCapacity = *o.ControllerFlashCacheCapacity
		}
		qControllerFlashCacheCapacity := swag.FormatInt64(qrControllerFlashCacheCapacity)
		if qControllerFlashCacheCapacity != "" {

			if err := r.SetQueryParam("controller.flash_cache.capacity", qControllerFlashCacheCapacity); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheDeviceID != nil {

		// query param controller.flash_cache.device_id
		var qrControllerFlashCacheDeviceID int64

		if o.ControllerFlashCacheDeviceID != nil {
			qrControllerFlashCacheDeviceID = *o.ControllerFlashCacheDeviceID
		}
		qControllerFlashCacheDeviceID := swag.FormatInt64(qrControllerFlashCacheDeviceID)
		if qControllerFlashCacheDeviceID != "" {

			if err := r.SetQueryParam("controller.flash_cache.device_id", qControllerFlashCacheDeviceID); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheFirmwareFile != nil {

		// query param controller.flash_cache.firmware_file
		var qrControllerFlashCacheFirmwareFile string

		if o.ControllerFlashCacheFirmwareFile != nil {
			qrControllerFlashCacheFirmwareFile = *o.ControllerFlashCacheFirmwareFile
		}
		qControllerFlashCacheFirmwareFile := qrControllerFlashCacheFirmwareFile
		if qControllerFlashCacheFirmwareFile != "" {

			if err := r.SetQueryParam("controller.flash_cache.firmware_file", qControllerFlashCacheFirmwareFile); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheFirmwareVersion != nil {

		// query param controller.flash_cache.firmware_version
		var qrControllerFlashCacheFirmwareVersion string

		if o.ControllerFlashCacheFirmwareVersion != nil {
			qrControllerFlashCacheFirmwareVersion = *o.ControllerFlashCacheFirmwareVersion
		}
		qControllerFlashCacheFirmwareVersion := qrControllerFlashCacheFirmwareVersion
		if qControllerFlashCacheFirmwareVersion != "" {

			if err := r.SetQueryParam("controller.flash_cache.firmware_version", qControllerFlashCacheFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheHardwareRevision != nil {

		// query param controller.flash_cache.hardware_revision
		var qrControllerFlashCacheHardwareRevision string

		if o.ControllerFlashCacheHardwareRevision != nil {
			qrControllerFlashCacheHardwareRevision = *o.ControllerFlashCacheHardwareRevision
		}
		qControllerFlashCacheHardwareRevision := qrControllerFlashCacheHardwareRevision
		if qControllerFlashCacheHardwareRevision != "" {

			if err := r.SetQueryParam("controller.flash_cache.hardware_revision", qControllerFlashCacheHardwareRevision); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheModel != nil {

		// query param controller.flash_cache.model
		var qrControllerFlashCacheModel string

		if o.ControllerFlashCacheModel != nil {
			qrControllerFlashCacheModel = *o.ControllerFlashCacheModel
		}
		qControllerFlashCacheModel := qrControllerFlashCacheModel
		if qControllerFlashCacheModel != "" {

			if err := r.SetQueryParam("controller.flash_cache.model", qControllerFlashCacheModel); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCachePartNumber != nil {

		// query param controller.flash_cache.part_number
		var qrControllerFlashCachePartNumber string

		if o.ControllerFlashCachePartNumber != nil {
			qrControllerFlashCachePartNumber = *o.ControllerFlashCachePartNumber
		}
		qControllerFlashCachePartNumber := qrControllerFlashCachePartNumber
		if qControllerFlashCachePartNumber != "" {

			if err := r.SetQueryParam("controller.flash_cache.part_number", qControllerFlashCachePartNumber); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheSerialNumber != nil {

		// query param controller.flash_cache.serial_number
		var qrControllerFlashCacheSerialNumber string

		if o.ControllerFlashCacheSerialNumber != nil {
			qrControllerFlashCacheSerialNumber = *o.ControllerFlashCacheSerialNumber
		}
		qControllerFlashCacheSerialNumber := qrControllerFlashCacheSerialNumber
		if qControllerFlashCacheSerialNumber != "" {

			if err := r.SetQueryParam("controller.flash_cache.serial_number", qControllerFlashCacheSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheSlot != nil {

		// query param controller.flash_cache.slot
		var qrControllerFlashCacheSlot string

		if o.ControllerFlashCacheSlot != nil {
			qrControllerFlashCacheSlot = *o.ControllerFlashCacheSlot
		}
		qControllerFlashCacheSlot := qrControllerFlashCacheSlot
		if qControllerFlashCacheSlot != "" {

			if err := r.SetQueryParam("controller.flash_cache.slot", qControllerFlashCacheSlot); err != nil {
				return err
			}
		}
	}

	if o.ControllerFlashCacheState != nil {

		// query param controller.flash_cache.state
		var qrControllerFlashCacheState string

		if o.ControllerFlashCacheState != nil {
			qrControllerFlashCacheState = *o.ControllerFlashCacheState
		}
		qControllerFlashCacheState := qrControllerFlashCacheState
		if qControllerFlashCacheState != "" {

			if err := r.SetQueryParam("controller.flash_cache.state", qControllerFlashCacheState); err != nil {
				return err
			}
		}
	}

	if o.ControllerFrusID != nil {

		// query param controller.frus.id
		var qrControllerFrusID string

		if o.ControllerFrusID != nil {
			qrControllerFrusID = *o.ControllerFrusID
		}
		qControllerFrusID := qrControllerFrusID
		if qControllerFrusID != "" {

			if err := r.SetQueryParam("controller.frus.id", qControllerFrusID); err != nil {
				return err
			}
		}
	}

	if o.ControllerFrusState != nil {

		// query param controller.frus.state
		var qrControllerFrusState string

		if o.ControllerFrusState != nil {
			qrControllerFrusState = *o.ControllerFrusState
		}
		qControllerFrusState := qrControllerFrusState
		if qControllerFrusState != "" {

			if err := r.SetQueryParam("controller.frus.state", qControllerFrusState); err != nil {
				return err
			}
		}
	}

	if o.ControllerFrusType != nil {

		// query param controller.frus.type
		var qrControllerFrusType string

		if o.ControllerFrusType != nil {
			qrControllerFrusType = *o.ControllerFrusType
		}
		qControllerFrusType := qrControllerFrusType
		if qControllerFrusType != "" {

			if err := r.SetQueryParam("controller.frus.type", qControllerFrusType); err != nil {
				return err
			}
		}
	}

	if o.ControllerMemorySize != nil {

		// query param controller.memory_size
		var qrControllerMemorySize int64

		if o.ControllerMemorySize != nil {
			qrControllerMemorySize = *o.ControllerMemorySize
		}
		qControllerMemorySize := swag.FormatInt64(qrControllerMemorySize)
		if qControllerMemorySize != "" {

			if err := r.SetQueryParam("controller.memory_size", qControllerMemorySize); err != nil {
				return err
			}
		}
	}

	if o.ControllerOverTemperature != nil {

		// query param controller.over_temperature
		var qrControllerOverTemperature string

		if o.ControllerOverTemperature != nil {
			qrControllerOverTemperature = *o.ControllerOverTemperature
		}
		qControllerOverTemperature := qrControllerOverTemperature
		if qControllerOverTemperature != "" {

			if err := r.SetQueryParam("controller.over_temperature", qControllerOverTemperature); err != nil {
				return err
			}
		}
	}

	if o.Date != nil {

		// query param date
		var qrDate string

		if o.Date != nil {
			qrDate = *o.Date
		}
		qDate := qrDate
		if qDate != "" {

			if err := r.SetQueryParam("date", qDate); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheIsEnabled != nil {

		// query param external_cache.is_enabled
		var qrExternalCacheIsEnabled bool

		if o.ExternalCacheIsEnabled != nil {
			qrExternalCacheIsEnabled = *o.ExternalCacheIsEnabled
		}
		qExternalCacheIsEnabled := swag.FormatBool(qrExternalCacheIsEnabled)
		if qExternalCacheIsEnabled != "" {

			if err := r.SetQueryParam("external_cache.is_enabled", qExternalCacheIsEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheIsHyaEnabled != nil {

		// query param external_cache.is_hya_enabled
		var qrExternalCacheIsHyaEnabled bool

		if o.ExternalCacheIsHyaEnabled != nil {
			qrExternalCacheIsHyaEnabled = *o.ExternalCacheIsHyaEnabled
		}
		qExternalCacheIsHyaEnabled := swag.FormatBool(qrExternalCacheIsHyaEnabled)
		if qExternalCacheIsHyaEnabled != "" {

			if err := r.SetQueryParam("external_cache.is_hya_enabled", qExternalCacheIsHyaEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheIsRewarmEnabled != nil {

		// query param external_cache.is_rewarm_enabled
		var qrExternalCacheIsRewarmEnabled bool

		if o.ExternalCacheIsRewarmEnabled != nil {
			qrExternalCacheIsRewarmEnabled = *o.ExternalCacheIsRewarmEnabled
		}
		qExternalCacheIsRewarmEnabled := swag.FormatBool(qrExternalCacheIsRewarmEnabled)
		if qExternalCacheIsRewarmEnabled != "" {

			if err := r.SetQueryParam("external_cache.is_rewarm_enabled", qExternalCacheIsRewarmEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCachePcsSize != nil {

		// query param external_cache.pcs_size
		var qrExternalCachePcsSize int64

		if o.ExternalCachePcsSize != nil {
			qrExternalCachePcsSize = *o.ExternalCachePcsSize
		}
		qExternalCachePcsSize := swag.FormatInt64(qrExternalCachePcsSize)
		if qExternalCachePcsSize != "" {

			if err := r.SetQueryParam("external_cache.pcs_size", qExternalCachePcsSize); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheBypassEnabled != nil {

		// query param external_cache_bypass.enabled
		var qrExternalCacheBypassEnabled bool

		if o.ExternalCacheBypassEnabled != nil {
			qrExternalCacheBypassEnabled = *o.ExternalCacheBypassEnabled
		}
		qExternalCacheBypassEnabled := swag.FormatBool(qrExternalCacheBypassEnabled)
		if qExternalCacheBypassEnabled != "" {

			if err := r.SetQueryParam("external_cache_bypass.enabled", qExternalCacheBypassEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalCacheBypassLargeReadOpsAllowPercent != nil {

		// query param external_cache_bypass.large_read_ops_allow_percent
		var qrExternalCacheBypassLargeReadOpsAllowPercent int64

		if o.ExternalCacheBypassLargeReadOpsAllowPercent != nil {
			qrExternalCacheBypassLargeReadOpsAllowPercent = *o.ExternalCacheBypassLargeReadOpsAllowPercent
		}
		qExternalCacheBypassLargeReadOpsAllowPercent := swag.FormatInt64(qrExternalCacheBypassLargeReadOpsAllowPercent)
		if qExternalCacheBypassLargeReadOpsAllowPercent != "" {

			if err := r.SetQueryParam("external_cache_bypass.large_read_ops_allow_percent", qExternalCacheBypassLargeReadOpsAllowPercent); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.HaAutoGiveback != nil {

		// query param ha.auto_giveback
		var qrHaAutoGiveback bool

		if o.HaAutoGiveback != nil {
			qrHaAutoGiveback = *o.HaAutoGiveback
		}
		qHaAutoGiveback := swag.FormatBool(qrHaAutoGiveback)
		if qHaAutoGiveback != "" {

			if err := r.SetQueryParam("ha.auto_giveback", qHaAutoGiveback); err != nil {
				return err
			}
		}
	}

	if o.HaAutoGivebackOf != nil {

		// query param ha.auto_giveback_of
		var qrHaAutoGivebackOf bool

		if o.HaAutoGivebackOf != nil {
			qrHaAutoGivebackOf = *o.HaAutoGivebackOf
		}
		qHaAutoGivebackOf := swag.FormatBool(qrHaAutoGivebackOf)
		if qHaAutoGivebackOf != "" {

			if err := r.SetQueryParam("ha.auto_giveback_of", qHaAutoGivebackOf); err != nil {
				return err
			}
		}
	}

	if o.HaEnableTakeoverOf != nil {

		// query param ha.enable_takeover_of
		var qrHaEnableTakeoverOf bool

		if o.HaEnableTakeoverOf != nil {
			qrHaEnableTakeoverOf = *o.HaEnableTakeoverOf
		}
		qHaEnableTakeoverOf := swag.FormatBool(qrHaEnableTakeoverOf)
		if qHaEnableTakeoverOf != "" {

			if err := r.SetQueryParam("ha.enable_takeover_of", qHaEnableTakeoverOf); err != nil {
				return err
			}
		}
	}

	if o.HaEnabled != nil {

		// query param ha.enabled
		var qrHaEnabled bool

		if o.HaEnabled != nil {
			qrHaEnabled = *o.HaEnabled
		}
		qHaEnabled := swag.FormatBool(qrHaEnabled)
		if qHaEnabled != "" {

			if err := r.SetQueryParam("ha.enabled", qHaEnabled); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackFailureCode != nil {

		// query param ha.giveback.failure.code
		var qrHaGivebackFailureCode int64

		if o.HaGivebackFailureCode != nil {
			qrHaGivebackFailureCode = *o.HaGivebackFailureCode
		}
		qHaGivebackFailureCode := swag.FormatInt64(qrHaGivebackFailureCode)
		if qHaGivebackFailureCode != "" {

			if err := r.SetQueryParam("ha.giveback.failure.code", qHaGivebackFailureCode); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackFailureMessage != nil {

		// query param ha.giveback.failure.message
		var qrHaGivebackFailureMessage string

		if o.HaGivebackFailureMessage != nil {
			qrHaGivebackFailureMessage = *o.HaGivebackFailureMessage
		}
		qHaGivebackFailureMessage := qrHaGivebackFailureMessage
		if qHaGivebackFailureMessage != "" {

			if err := r.SetQueryParam("ha.giveback.failure.message", qHaGivebackFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackState != nil {

		// query param ha.giveback.state
		var qrHaGivebackState string

		if o.HaGivebackState != nil {
			qrHaGivebackState = *o.HaGivebackState
		}
		qHaGivebackState := qrHaGivebackState
		if qHaGivebackState != "" {

			if err := r.SetQueryParam("ha.giveback.state", qHaGivebackState); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusAggregateName != nil {

		// query param ha.giveback.status.aggregate.name
		var qrHaGivebackStatusAggregateName string

		if o.HaGivebackStatusAggregateName != nil {
			qrHaGivebackStatusAggregateName = *o.HaGivebackStatusAggregateName
		}
		qHaGivebackStatusAggregateName := qrHaGivebackStatusAggregateName
		if qHaGivebackStatusAggregateName != "" {

			if err := r.SetQueryParam("ha.giveback.status.aggregate.name", qHaGivebackStatusAggregateName); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusAggregateUUID != nil {

		// query param ha.giveback.status.aggregate.uuid
		var qrHaGivebackStatusAggregateUUID string

		if o.HaGivebackStatusAggregateUUID != nil {
			qrHaGivebackStatusAggregateUUID = *o.HaGivebackStatusAggregateUUID
		}
		qHaGivebackStatusAggregateUUID := qrHaGivebackStatusAggregateUUID
		if qHaGivebackStatusAggregateUUID != "" {

			if err := r.SetQueryParam("ha.giveback.status.aggregate.uuid", qHaGivebackStatusAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusErrorCode != nil {

		// query param ha.giveback.status.error.code
		var qrHaGivebackStatusErrorCode string

		if o.HaGivebackStatusErrorCode != nil {
			qrHaGivebackStatusErrorCode = *o.HaGivebackStatusErrorCode
		}
		qHaGivebackStatusErrorCode := qrHaGivebackStatusErrorCode
		if qHaGivebackStatusErrorCode != "" {

			if err := r.SetQueryParam("ha.giveback.status.error.code", qHaGivebackStatusErrorCode); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusErrorMessage != nil {

		// query param ha.giveback.status.error.message
		var qrHaGivebackStatusErrorMessage string

		if o.HaGivebackStatusErrorMessage != nil {
			qrHaGivebackStatusErrorMessage = *o.HaGivebackStatusErrorMessage
		}
		qHaGivebackStatusErrorMessage := qrHaGivebackStatusErrorMessage
		if qHaGivebackStatusErrorMessage != "" {

			if err := r.SetQueryParam("ha.giveback.status.error.message", qHaGivebackStatusErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.HaGivebackStatusState != nil {

		// query param ha.giveback.status.state
		var qrHaGivebackStatusState string

		if o.HaGivebackStatusState != nil {
			qrHaGivebackStatusState = *o.HaGivebackStatusState
		}
		qHaGivebackStatusState := qrHaGivebackStatusState
		if qHaGivebackStatusState != "" {

			if err := r.SetQueryParam("ha.giveback.status.state", qHaGivebackStatusState); err != nil {
				return err
			}
		}
	}

	if o.HaInterconnectAdapter != nil {

		// query param ha.interconnect.adapter
		var qrHaInterconnectAdapter string

		if o.HaInterconnectAdapter != nil {
			qrHaInterconnectAdapter = *o.HaInterconnectAdapter
		}
		qHaInterconnectAdapter := qrHaInterconnectAdapter
		if qHaInterconnectAdapter != "" {

			if err := r.SetQueryParam("ha.interconnect.adapter", qHaInterconnectAdapter); err != nil {
				return err
			}
		}
	}

	if o.HaInterconnectState != nil {

		// query param ha.interconnect.state
		var qrHaInterconnectState string

		if o.HaInterconnectState != nil {
			qrHaInterconnectState = *o.HaInterconnectState
		}
		qHaInterconnectState := qrHaInterconnectState
		if qHaInterconnectState != "" {

			if err := r.SetQueryParam("ha.interconnect.state", qHaInterconnectState); err != nil {
				return err
			}
		}
	}

	if o.HaPartnersName != nil {

		// query param ha.partners.name
		var qrHaPartnersName string

		if o.HaPartnersName != nil {
			qrHaPartnersName = *o.HaPartnersName
		}
		qHaPartnersName := qrHaPartnersName
		if qHaPartnersName != "" {

			if err := r.SetQueryParam("ha.partners.name", qHaPartnersName); err != nil {
				return err
			}
		}
	}

	if o.HaPartnersUUID != nil {

		// query param ha.partners.uuid
		var qrHaPartnersUUID string

		if o.HaPartnersUUID != nil {
			qrHaPartnersUUID = *o.HaPartnersUUID
		}
		qHaPartnersUUID := qrHaPartnersUUID
		if qHaPartnersUUID != "" {

			if err := r.SetQueryParam("ha.partners.uuid", qHaPartnersUUID); err != nil {
				return err
			}
		}
	}

	if o.HaPortsNumber != nil {

		// query param ha.ports.number
		var qrHaPortsNumber int64

		if o.HaPortsNumber != nil {
			qrHaPortsNumber = *o.HaPortsNumber
		}
		qHaPortsNumber := swag.FormatInt64(qrHaPortsNumber)
		if qHaPortsNumber != "" {

			if err := r.SetQueryParam("ha.ports.number", qHaPortsNumber); err != nil {
				return err
			}
		}
	}

	if o.HaPortsState != nil {

		// query param ha.ports.state
		var qrHaPortsState string

		if o.HaPortsState != nil {
			qrHaPortsState = *o.HaPortsState
		}
		qHaPortsState := qrHaPortsState
		if qHaPortsState != "" {

			if err := r.SetQueryParam("ha.ports.state", qHaPortsState); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverFailureCode != nil {

		// query param ha.takeover.failure.code
		var qrHaTakeoverFailureCode int64

		if o.HaTakeoverFailureCode != nil {
			qrHaTakeoverFailureCode = *o.HaTakeoverFailureCode
		}
		qHaTakeoverFailureCode := swag.FormatInt64(qrHaTakeoverFailureCode)
		if qHaTakeoverFailureCode != "" {

			if err := r.SetQueryParam("ha.takeover.failure.code", qHaTakeoverFailureCode); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverFailureMessage != nil {

		// query param ha.takeover.failure.message
		var qrHaTakeoverFailureMessage string

		if o.HaTakeoverFailureMessage != nil {
			qrHaTakeoverFailureMessage = *o.HaTakeoverFailureMessage
		}
		qHaTakeoverFailureMessage := qrHaTakeoverFailureMessage
		if qHaTakeoverFailureMessage != "" {

			if err := r.SetQueryParam("ha.takeover.failure.message", qHaTakeoverFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverState != nil {

		// query param ha.takeover.state
		var qrHaTakeoverState string

		if o.HaTakeoverState != nil {
			qrHaTakeoverState = *o.HaTakeoverState
		}
		qHaTakeoverState := qrHaTakeoverState
		if qHaTakeoverState != "" {

			if err := r.SetQueryParam("ha.takeover.state", qHaTakeoverState); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverCheckReasons != nil {

		// query param ha.takeover_check.reasons
		var qrHaTakeoverCheckReasons string

		if o.HaTakeoverCheckReasons != nil {
			qrHaTakeoverCheckReasons = *o.HaTakeoverCheckReasons
		}
		qHaTakeoverCheckReasons := qrHaTakeoverCheckReasons
		if qHaTakeoverCheckReasons != "" {

			if err := r.SetQueryParam("ha.takeover_check.reasons", qHaTakeoverCheckReasons); err != nil {
				return err
			}
		}
	}

	if o.HaTakeoverCheckTakeoverPossible != nil {

		// query param ha.takeover_check.takeover_possible
		var qrHaTakeoverCheckTakeoverPossible bool

		if o.HaTakeoverCheckTakeoverPossible != nil {
			qrHaTakeoverCheckTakeoverPossible = *o.HaTakeoverCheckTakeoverPossible
		}
		qHaTakeoverCheckTakeoverPossible := swag.FormatBool(qrHaTakeoverCheckTakeoverPossible)
		if qHaTakeoverCheckTakeoverPossible != "" {

			if err := r.SetQueryParam("ha.takeover_check.takeover_possible", qHaTakeoverCheckTakeoverPossible); err != nil {
				return err
			}
		}
	}

	if o.HaType != nil {

		// query param ha.type
		var qrHaType string

		if o.HaType != nil {
			qrHaType = *o.HaType
		}
		qHaType := qrHaType
		if qHaType != "" {

			if err := r.SetQueryParam("ha.type", qHaType); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusEnabled != nil {

		// query param hw_assist.status.enabled
		var qrHwAssistStatusEnabled bool

		if o.HwAssistStatusEnabled != nil {
			qrHwAssistStatusEnabled = *o.HwAssistStatusEnabled
		}
		qHwAssistStatusEnabled := swag.FormatBool(qrHwAssistStatusEnabled)
		if qHwAssistStatusEnabled != "" {

			if err := r.SetQueryParam("hw_assist.status.enabled", qHwAssistStatusEnabled); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusLocalIP != nil {

		// query param hw_assist.status.local.ip
		var qrHwAssistStatusLocalIP string

		if o.HwAssistStatusLocalIP != nil {
			qrHwAssistStatusLocalIP = *o.HwAssistStatusLocalIP
		}
		qHwAssistStatusLocalIP := qrHwAssistStatusLocalIP
		if qHwAssistStatusLocalIP != "" {

			if err := r.SetQueryParam("hw_assist.status.local.ip", qHwAssistStatusLocalIP); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusLocalPort != nil {

		// query param hw_assist.status.local.port
		var qrHwAssistStatusLocalPort int64

		if o.HwAssistStatusLocalPort != nil {
			qrHwAssistStatusLocalPort = *o.HwAssistStatusLocalPort
		}
		qHwAssistStatusLocalPort := swag.FormatInt64(qrHwAssistStatusLocalPort)
		if qHwAssistStatusLocalPort != "" {

			if err := r.SetQueryParam("hw_assist.status.local.port", qHwAssistStatusLocalPort); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusLocalState != nil {

		// query param hw_assist.status.local.state
		var qrHwAssistStatusLocalState string

		if o.HwAssistStatusLocalState != nil {
			qrHwAssistStatusLocalState = *o.HwAssistStatusLocalState
		}
		qHwAssistStatusLocalState := qrHwAssistStatusLocalState
		if qHwAssistStatusLocalState != "" {

			if err := r.SetQueryParam("hw_assist.status.local.state", qHwAssistStatusLocalState); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusPartnerIP != nil {

		// query param hw_assist.status.partner.ip
		var qrHwAssistStatusPartnerIP string

		if o.HwAssistStatusPartnerIP != nil {
			qrHwAssistStatusPartnerIP = *o.HwAssistStatusPartnerIP
		}
		qHwAssistStatusPartnerIP := qrHwAssistStatusPartnerIP
		if qHwAssistStatusPartnerIP != "" {

			if err := r.SetQueryParam("hw_assist.status.partner.ip", qHwAssistStatusPartnerIP); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusPartnerPort != nil {

		// query param hw_assist.status.partner.port
		var qrHwAssistStatusPartnerPort int64

		if o.HwAssistStatusPartnerPort != nil {
			qrHwAssistStatusPartnerPort = *o.HwAssistStatusPartnerPort
		}
		qHwAssistStatusPartnerPort := swag.FormatInt64(qrHwAssistStatusPartnerPort)
		if qHwAssistStatusPartnerPort != "" {

			if err := r.SetQueryParam("hw_assist.status.partner.port", qHwAssistStatusPartnerPort); err != nil {
				return err
			}
		}
	}

	if o.HwAssistStatusPartnerState != nil {

		// query param hw_assist.status.partner.state
		var qrHwAssistStatusPartnerState string

		if o.HwAssistStatusPartnerState != nil {
			qrHwAssistStatusPartnerState = *o.HwAssistStatusPartnerState
		}
		qHwAssistStatusPartnerState := qrHwAssistStatusPartnerState
		if qHwAssistStatusPartnerState != "" {

			if err := r.SetQueryParam("hw_assist.status.partner.state", qHwAssistStatusPartnerState); err != nil {
				return err
			}
		}
	}

	if o.IsSparesLow != nil {

		// query param is_spares_low
		var qrIsSparesLow bool

		if o.IsSparesLow != nil {
			qrIsSparesLow = *o.IsSparesLow
		}
		qIsSparesLow := swag.FormatBool(qrIsSparesLow)
		if qIsSparesLow != "" {

			if err := r.SetQueryParam("is_spares_low", qIsSparesLow); err != nil {
				return err
			}
		}
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.ManagementInterfacesIPAddress != nil {

		// query param management_interfaces.ip.address
		var qrManagementInterfacesIPAddress string

		if o.ManagementInterfacesIPAddress != nil {
			qrManagementInterfacesIPAddress = *o.ManagementInterfacesIPAddress
		}
		qManagementInterfacesIPAddress := qrManagementInterfacesIPAddress
		if qManagementInterfacesIPAddress != "" {

			if err := r.SetQueryParam("management_interfaces.ip.address", qManagementInterfacesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.ManagementInterfacesName != nil {

		// query param management_interfaces.name
		var qrManagementInterfacesName string

		if o.ManagementInterfacesName != nil {
			qrManagementInterfacesName = *o.ManagementInterfacesName
		}
		qManagementInterfacesName := qrManagementInterfacesName
		if qManagementInterfacesName != "" {

			if err := r.SetQueryParam("management_interfaces.name", qManagementInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.ManagementInterfacesUUID != nil {

		// query param management_interfaces.uuid
		var qrManagementInterfacesUUID string

		if o.ManagementInterfacesUUID != nil {
			qrManagementInterfacesUUID = *o.ManagementInterfacesUUID
		}
		qManagementInterfacesUUID := qrManagementInterfacesUUID
		if qManagementInterfacesUUID != "" {

			if err := r.SetQueryParam("management_interfaces.uuid", qManagementInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Membership != nil {

		// query param membership
		var qrMembership string

		if o.Membership != nil {
			qrMembership = *o.Membership
		}
		qMembership := qrMembership
		if qMembership != "" {

			if err := r.SetQueryParam("membership", qMembership); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricProcessorUtilization != nil {

		// query param metric.processor_utilization
		var qrMetricProcessorUtilization int64

		if o.MetricProcessorUtilization != nil {
			qrMetricProcessorUtilization = *o.MetricProcessorUtilization
		}
		qMetricProcessorUtilization := swag.FormatInt64(qrMetricProcessorUtilization)
		if qMetricProcessorUtilization != "" {

			if err := r.SetQueryParam("metric.processor_utilization", qMetricProcessorUtilization); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MetricUUID != nil {

		// query param metric.uuid
		var qrMetricUUID string

		if o.MetricUUID != nil {
			qrMetricUUID = *o.MetricUUID
		}
		qMetricUUID := qrMetricUUID
		if qMetricUUID != "" {

			if err := r.SetQueryParam("metric.uuid", qMetricUUID); err != nil {
				return err
			}
		}
	}

	if o.MetroclusterCustomVlanCapable != nil {

		// query param metrocluster.custom_vlan_capable
		var qrMetroclusterCustomVlanCapable bool

		if o.MetroclusterCustomVlanCapable != nil {
			qrMetroclusterCustomVlanCapable = *o.MetroclusterCustomVlanCapable
		}
		qMetroclusterCustomVlanCapable := swag.FormatBool(qrMetroclusterCustomVlanCapable)
		if qMetroclusterCustomVlanCapable != "" {

			if err := r.SetQueryParam("metrocluster.custom_vlan_capable", qMetroclusterCustomVlanCapable); err != nil {
				return err
			}
		}
	}

	if o.MetroclusterPortsName != nil {

		// query param metrocluster.ports.name
		var qrMetroclusterPortsName string

		if o.MetroclusterPortsName != nil {
			qrMetroclusterPortsName = *o.MetroclusterPortsName
		}
		qMetroclusterPortsName := qrMetroclusterPortsName
		if qMetroclusterPortsName != "" {

			if err := r.SetQueryParam("metrocluster.ports.name", qMetroclusterPortsName); err != nil {
				return err
			}
		}
	}

	if o.MetroclusterType != nil {

		// query param metrocluster.type
		var qrMetroclusterType string

		if o.MetroclusterType != nil {
			qrMetroclusterType = *o.MetroclusterType
		}
		qMetroclusterType := qrMetroclusterType
		if qMetroclusterType != "" {

			if err := r.SetQueryParam("metrocluster.type", qMetroclusterType); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NvlogBackingType != nil {

		// query param nvlog.backing_type
		var qrNvlogBackingType string

		if o.NvlogBackingType != nil {
			qrNvlogBackingType = *o.NvlogBackingType
		}
		qNvlogBackingType := qrNvlogBackingType
		if qNvlogBackingType != "" {

			if err := r.SetQueryParam("nvlog.backing_type", qNvlogBackingType); err != nil {
				return err
			}
		}
	}

	if o.NvlogSwapMode != nil {

		// query param nvlog.swap_mode
		var qrNvlogSwapMode string

		if o.NvlogSwapMode != nil {
			qrNvlogSwapMode = *o.NvlogSwapMode
		}
		qNvlogSwapMode := qrNvlogSwapMode
		if qNvlogSwapMode != "" {

			if err := r.SetQueryParam("nvlog.swap_mode", qNvlogSwapMode); err != nil {
				return err
			}
		}
	}

	if o.NvramBatteryState != nil {

		// query param nvram.battery_state
		var qrNvramBatteryState string

		if o.NvramBatteryState != nil {
			qrNvramBatteryState = *o.NvramBatteryState
		}
		qNvramBatteryState := qrNvramBatteryState
		if qNvramBatteryState != "" {

			if err := r.SetQueryParam("nvram.battery_state", qNvramBatteryState); err != nil {
				return err
			}
		}
	}

	if o.NvramID != nil {

		// query param nvram.id
		var qrNvramID int64

		if o.NvramID != nil {
			qrNvramID = *o.NvramID
		}
		qNvramID := swag.FormatInt64(qrNvramID)
		if qNvramID != "" {

			if err := r.SetQueryParam("nvram.id", qNvramID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAPIServiceEnabled != nil {

		// query param service_processor.api_service.enabled
		var qrServiceProcessorAPIServiceEnabled bool

		if o.ServiceProcessorAPIServiceEnabled != nil {
			qrServiceProcessorAPIServiceEnabled = *o.ServiceProcessorAPIServiceEnabled
		}
		qServiceProcessorAPIServiceEnabled := swag.FormatBool(qrServiceProcessorAPIServiceEnabled)
		if qServiceProcessorAPIServiceEnabled != "" {

			if err := r.SetQueryParam("service_processor.api_service.enabled", qServiceProcessorAPIServiceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAPIServiceLimitAccess != nil {

		// query param service_processor.api_service.limit_access
		var qrServiceProcessorAPIServiceLimitAccess bool

		if o.ServiceProcessorAPIServiceLimitAccess != nil {
			qrServiceProcessorAPIServiceLimitAccess = *o.ServiceProcessorAPIServiceLimitAccess
		}
		qServiceProcessorAPIServiceLimitAccess := swag.FormatBool(qrServiceProcessorAPIServiceLimitAccess)
		if qServiceProcessorAPIServiceLimitAccess != "" {

			if err := r.SetQueryParam("service_processor.api_service.limit_access", qServiceProcessorAPIServiceLimitAccess); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAPIServicePort != nil {

		// query param service_processor.api_service.port
		var qrServiceProcessorAPIServicePort int64

		if o.ServiceProcessorAPIServicePort != nil {
			qrServiceProcessorAPIServicePort = *o.ServiceProcessorAPIServicePort
		}
		qServiceProcessorAPIServicePort := swag.FormatInt64(qrServiceProcessorAPIServicePort)
		if qServiceProcessorAPIServicePort != "" {

			if err := r.SetQueryParam("service_processor.api_service.port", qServiceProcessorAPIServicePort); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAutoConfigIPV4Subnet != nil {

		// query param service_processor.auto_config.ipv4_subnet
		var qrServiceProcessorAutoConfigIPV4Subnet string

		if o.ServiceProcessorAutoConfigIPV4Subnet != nil {
			qrServiceProcessorAutoConfigIPV4Subnet = *o.ServiceProcessorAutoConfigIPV4Subnet
		}
		qServiceProcessorAutoConfigIPV4Subnet := qrServiceProcessorAutoConfigIPV4Subnet
		if qServiceProcessorAutoConfigIPV4Subnet != "" {

			if err := r.SetQueryParam("service_processor.auto_config.ipv4_subnet", qServiceProcessorAutoConfigIPV4Subnet); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAutoConfigIPV6Subnet != nil {

		// query param service_processor.auto_config.ipv6_subnet
		var qrServiceProcessorAutoConfigIPV6Subnet string

		if o.ServiceProcessorAutoConfigIPV6Subnet != nil {
			qrServiceProcessorAutoConfigIPV6Subnet = *o.ServiceProcessorAutoConfigIPV6Subnet
		}
		qServiceProcessorAutoConfigIPV6Subnet := qrServiceProcessorAutoConfigIPV6Subnet
		if qServiceProcessorAutoConfigIPV6Subnet != "" {

			if err := r.SetQueryParam("service_processor.auto_config.ipv6_subnet", qServiceProcessorAutoConfigIPV6Subnet); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorAutoupdateEnabled != nil {

		// query param service_processor.autoupdate_enabled
		var qrServiceProcessorAutoupdateEnabled bool

		if o.ServiceProcessorAutoupdateEnabled != nil {
			qrServiceProcessorAutoupdateEnabled = *o.ServiceProcessorAutoupdateEnabled
		}
		qServiceProcessorAutoupdateEnabled := swag.FormatBool(qrServiceProcessorAutoupdateEnabled)
		if qServiceProcessorAutoupdateEnabled != "" {

			if err := r.SetQueryParam("service_processor.autoupdate_enabled", qServiceProcessorAutoupdateEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorBackupIsCurrent != nil {

		// query param service_processor.backup.is_current
		var qrServiceProcessorBackupIsCurrent bool

		if o.ServiceProcessorBackupIsCurrent != nil {
			qrServiceProcessorBackupIsCurrent = *o.ServiceProcessorBackupIsCurrent
		}
		qServiceProcessorBackupIsCurrent := swag.FormatBool(qrServiceProcessorBackupIsCurrent)
		if qServiceProcessorBackupIsCurrent != "" {

			if err := r.SetQueryParam("service_processor.backup.is_current", qServiceProcessorBackupIsCurrent); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorBackupState != nil {

		// query param service_processor.backup.state
		var qrServiceProcessorBackupState string

		if o.ServiceProcessorBackupState != nil {
			qrServiceProcessorBackupState = *o.ServiceProcessorBackupState
		}
		qServiceProcessorBackupState := qrServiceProcessorBackupState
		if qServiceProcessorBackupState != "" {

			if err := r.SetQueryParam("service_processor.backup.state", qServiceProcessorBackupState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorBackupVersion != nil {

		// query param service_processor.backup.version
		var qrServiceProcessorBackupVersion string

		if o.ServiceProcessorBackupVersion != nil {
			qrServiceProcessorBackupVersion = *o.ServiceProcessorBackupVersion
		}
		qServiceProcessorBackupVersion := qrServiceProcessorBackupVersion
		if qServiceProcessorBackupVersion != "" {

			if err := r.SetQueryParam("service_processor.backup.version", qServiceProcessorBackupVersion); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorDhcpEnabled != nil {

		// query param service_processor.dhcp_enabled
		var qrServiceProcessorDhcpEnabled bool

		if o.ServiceProcessorDhcpEnabled != nil {
			qrServiceProcessorDhcpEnabled = *o.ServiceProcessorDhcpEnabled
		}
		qServiceProcessorDhcpEnabled := swag.FormatBool(qrServiceProcessorDhcpEnabled)
		if qServiceProcessorDhcpEnabled != "" {

			if err := r.SetQueryParam("service_processor.dhcp_enabled", qServiceProcessorDhcpEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorFirmwareVersion != nil {

		// query param service_processor.firmware_version
		var qrServiceProcessorFirmwareVersion string

		if o.ServiceProcessorFirmwareVersion != nil {
			qrServiceProcessorFirmwareVersion = *o.ServiceProcessorFirmwareVersion
		}
		qServiceProcessorFirmwareVersion := qrServiceProcessorFirmwareVersion
		if qServiceProcessorFirmwareVersion != "" {

			if err := r.SetQueryParam("service_processor.firmware_version", qServiceProcessorFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceAddress != nil {

		// query param service_processor.ipv4_interface.address
		var qrServiceProcessorIPV4InterfaceAddress string

		if o.ServiceProcessorIPV4InterfaceAddress != nil {
			qrServiceProcessorIPV4InterfaceAddress = *o.ServiceProcessorIPV4InterfaceAddress
		}
		qServiceProcessorIPV4InterfaceAddress := qrServiceProcessorIPV4InterfaceAddress
		if qServiceProcessorIPV4InterfaceAddress != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.address", qServiceProcessorIPV4InterfaceAddress); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceEnabled != nil {

		// query param service_processor.ipv4_interface.enabled
		var qrServiceProcessorIPV4InterfaceEnabled bool

		if o.ServiceProcessorIPV4InterfaceEnabled != nil {
			qrServiceProcessorIPV4InterfaceEnabled = *o.ServiceProcessorIPV4InterfaceEnabled
		}
		qServiceProcessorIPV4InterfaceEnabled := swag.FormatBool(qrServiceProcessorIPV4InterfaceEnabled)
		if qServiceProcessorIPV4InterfaceEnabled != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.enabled", qServiceProcessorIPV4InterfaceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceGateway != nil {

		// query param service_processor.ipv4_interface.gateway
		var qrServiceProcessorIPV4InterfaceGateway string

		if o.ServiceProcessorIPV4InterfaceGateway != nil {
			qrServiceProcessorIPV4InterfaceGateway = *o.ServiceProcessorIPV4InterfaceGateway
		}
		qServiceProcessorIPV4InterfaceGateway := qrServiceProcessorIPV4InterfaceGateway
		if qServiceProcessorIPV4InterfaceGateway != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.gateway", qServiceProcessorIPV4InterfaceGateway); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceNetmask != nil {

		// query param service_processor.ipv4_interface.netmask
		var qrServiceProcessorIPV4InterfaceNetmask string

		if o.ServiceProcessorIPV4InterfaceNetmask != nil {
			qrServiceProcessorIPV4InterfaceNetmask = *o.ServiceProcessorIPV4InterfaceNetmask
		}
		qServiceProcessorIPV4InterfaceNetmask := qrServiceProcessorIPV4InterfaceNetmask
		if qServiceProcessorIPV4InterfaceNetmask != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.netmask", qServiceProcessorIPV4InterfaceNetmask); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV4InterfaceSetupState != nil {

		// query param service_processor.ipv4_interface.setup_state
		var qrServiceProcessorIPV4InterfaceSetupState string

		if o.ServiceProcessorIPV4InterfaceSetupState != nil {
			qrServiceProcessorIPV4InterfaceSetupState = *o.ServiceProcessorIPV4InterfaceSetupState
		}
		qServiceProcessorIPV4InterfaceSetupState := qrServiceProcessorIPV4InterfaceSetupState
		if qServiceProcessorIPV4InterfaceSetupState != "" {

			if err := r.SetQueryParam("service_processor.ipv4_interface.setup_state", qServiceProcessorIPV4InterfaceSetupState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceAddress != nil {

		// query param service_processor.ipv6_interface.address
		var qrServiceProcessorIPV6InterfaceAddress string

		if o.ServiceProcessorIPV6InterfaceAddress != nil {
			qrServiceProcessorIPV6InterfaceAddress = *o.ServiceProcessorIPV6InterfaceAddress
		}
		qServiceProcessorIPV6InterfaceAddress := qrServiceProcessorIPV6InterfaceAddress
		if qServiceProcessorIPV6InterfaceAddress != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.address", qServiceProcessorIPV6InterfaceAddress); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceEnabled != nil {

		// query param service_processor.ipv6_interface.enabled
		var qrServiceProcessorIPV6InterfaceEnabled bool

		if o.ServiceProcessorIPV6InterfaceEnabled != nil {
			qrServiceProcessorIPV6InterfaceEnabled = *o.ServiceProcessorIPV6InterfaceEnabled
		}
		qServiceProcessorIPV6InterfaceEnabled := swag.FormatBool(qrServiceProcessorIPV6InterfaceEnabled)
		if qServiceProcessorIPV6InterfaceEnabled != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.enabled", qServiceProcessorIPV6InterfaceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceGateway != nil {

		// query param service_processor.ipv6_interface.gateway
		var qrServiceProcessorIPV6InterfaceGateway string

		if o.ServiceProcessorIPV6InterfaceGateway != nil {
			qrServiceProcessorIPV6InterfaceGateway = *o.ServiceProcessorIPV6InterfaceGateway
		}
		qServiceProcessorIPV6InterfaceGateway := qrServiceProcessorIPV6InterfaceGateway
		if qServiceProcessorIPV6InterfaceGateway != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.gateway", qServiceProcessorIPV6InterfaceGateway); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled != nil {

		// query param service_processor.ipv6_interface.is_ipv6_ra_enabled
		var qrServiceProcessorIPV6InterfaceIsIPV6RaEnabled bool

		if o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled != nil {
			qrServiceProcessorIPV6InterfaceIsIPV6RaEnabled = *o.ServiceProcessorIPV6InterfaceIsIPV6RaEnabled
		}
		qServiceProcessorIPV6InterfaceIsIPV6RaEnabled := swag.FormatBool(qrServiceProcessorIPV6InterfaceIsIPV6RaEnabled)
		if qServiceProcessorIPV6InterfaceIsIPV6RaEnabled != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.is_ipv6_ra_enabled", qServiceProcessorIPV6InterfaceIsIPV6RaEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceLinkLocalIP != nil {

		// query param service_processor.ipv6_interface.link_local_ip
		var qrServiceProcessorIPV6InterfaceLinkLocalIP string

		if o.ServiceProcessorIPV6InterfaceLinkLocalIP != nil {
			qrServiceProcessorIPV6InterfaceLinkLocalIP = *o.ServiceProcessorIPV6InterfaceLinkLocalIP
		}
		qServiceProcessorIPV6InterfaceLinkLocalIP := qrServiceProcessorIPV6InterfaceLinkLocalIP
		if qServiceProcessorIPV6InterfaceLinkLocalIP != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.link_local_ip", qServiceProcessorIPV6InterfaceLinkLocalIP); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceNetmask != nil {

		// query param service_processor.ipv6_interface.netmask
		var qrServiceProcessorIPV6InterfaceNetmask int64

		if o.ServiceProcessorIPV6InterfaceNetmask != nil {
			qrServiceProcessorIPV6InterfaceNetmask = *o.ServiceProcessorIPV6InterfaceNetmask
		}
		qServiceProcessorIPV6InterfaceNetmask := swag.FormatInt64(qrServiceProcessorIPV6InterfaceNetmask)
		if qServiceProcessorIPV6InterfaceNetmask != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.netmask", qServiceProcessorIPV6InterfaceNetmask); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceRouterIP != nil {

		// query param service_processor.ipv6_interface.router_ip
		var qrServiceProcessorIPV6InterfaceRouterIP string

		if o.ServiceProcessorIPV6InterfaceRouterIP != nil {
			qrServiceProcessorIPV6InterfaceRouterIP = *o.ServiceProcessorIPV6InterfaceRouterIP
		}
		qServiceProcessorIPV6InterfaceRouterIP := qrServiceProcessorIPV6InterfaceRouterIP
		if qServiceProcessorIPV6InterfaceRouterIP != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.router_ip", qServiceProcessorIPV6InterfaceRouterIP); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIPV6InterfaceSetupState != nil {

		// query param service_processor.ipv6_interface.setup_state
		var qrServiceProcessorIPV6InterfaceSetupState string

		if o.ServiceProcessorIPV6InterfaceSetupState != nil {
			qrServiceProcessorIPV6InterfaceSetupState = *o.ServiceProcessorIPV6InterfaceSetupState
		}
		qServiceProcessorIPV6InterfaceSetupState := qrServiceProcessorIPV6InterfaceSetupState
		if qServiceProcessorIPV6InterfaceSetupState != "" {

			if err := r.SetQueryParam("service_processor.ipv6_interface.setup_state", qServiceProcessorIPV6InterfaceSetupState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorIsIPConfigured != nil {

		// query param service_processor.is_ip_configured
		var qrServiceProcessorIsIPConfigured bool

		if o.ServiceProcessorIsIPConfigured != nil {
			qrServiceProcessorIsIPConfigured = *o.ServiceProcessorIsIPConfigured
		}
		qServiceProcessorIsIPConfigured := swag.FormatBool(qrServiceProcessorIsIPConfigured)
		if qServiceProcessorIsIPConfigured != "" {

			if err := r.SetQueryParam("service_processor.is_ip_configured", qServiceProcessorIsIPConfigured); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorLastUpdateState != nil {

		// query param service_processor.last_update_state
		var qrServiceProcessorLastUpdateState string

		if o.ServiceProcessorLastUpdateState != nil {
			qrServiceProcessorLastUpdateState = *o.ServiceProcessorLastUpdateState
		}
		qServiceProcessorLastUpdateState := qrServiceProcessorLastUpdateState
		if qServiceProcessorLastUpdateState != "" {

			if err := r.SetQueryParam("service_processor.last_update_state", qServiceProcessorLastUpdateState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorLinkStatus != nil {

		// query param service_processor.link_status
		var qrServiceProcessorLinkStatus string

		if o.ServiceProcessorLinkStatus != nil {
			qrServiceProcessorLinkStatus = *o.ServiceProcessorLinkStatus
		}
		qServiceProcessorLinkStatus := qrServiceProcessorLinkStatus
		if qServiceProcessorLinkStatus != "" {

			if err := r.SetQueryParam("service_processor.link_status", qServiceProcessorLinkStatus); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorMacAddress != nil {

		// query param service_processor.mac_address
		var qrServiceProcessorMacAddress string

		if o.ServiceProcessorMacAddress != nil {
			qrServiceProcessorMacAddress = *o.ServiceProcessorMacAddress
		}
		qServiceProcessorMacAddress := qrServiceProcessorMacAddress
		if qServiceProcessorMacAddress != "" {

			if err := r.SetQueryParam("service_processor.mac_address", qServiceProcessorMacAddress); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorPrimaryIsCurrent != nil {

		// query param service_processor.primary.is_current
		var qrServiceProcessorPrimaryIsCurrent bool

		if o.ServiceProcessorPrimaryIsCurrent != nil {
			qrServiceProcessorPrimaryIsCurrent = *o.ServiceProcessorPrimaryIsCurrent
		}
		qServiceProcessorPrimaryIsCurrent := swag.FormatBool(qrServiceProcessorPrimaryIsCurrent)
		if qServiceProcessorPrimaryIsCurrent != "" {

			if err := r.SetQueryParam("service_processor.primary.is_current", qServiceProcessorPrimaryIsCurrent); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorPrimaryState != nil {

		// query param service_processor.primary.state
		var qrServiceProcessorPrimaryState string

		if o.ServiceProcessorPrimaryState != nil {
			qrServiceProcessorPrimaryState = *o.ServiceProcessorPrimaryState
		}
		qServiceProcessorPrimaryState := qrServiceProcessorPrimaryState
		if qServiceProcessorPrimaryState != "" {

			if err := r.SetQueryParam("service_processor.primary.state", qServiceProcessorPrimaryState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorPrimaryVersion != nil {

		// query param service_processor.primary.version
		var qrServiceProcessorPrimaryVersion string

		if o.ServiceProcessorPrimaryVersion != nil {
			qrServiceProcessorPrimaryVersion = *o.ServiceProcessorPrimaryVersion
		}
		qServiceProcessorPrimaryVersion := qrServiceProcessorPrimaryVersion
		if qServiceProcessorPrimaryVersion != "" {

			if err := r.SetQueryParam("service_processor.primary.version", qServiceProcessorPrimaryVersion); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorSSHInfoAllowedAddresses != nil {

		// query param service_processor.ssh_info.allowed_addresses
		var qrServiceProcessorSSHInfoAllowedAddresses string

		if o.ServiceProcessorSSHInfoAllowedAddresses != nil {
			qrServiceProcessorSSHInfoAllowedAddresses = *o.ServiceProcessorSSHInfoAllowedAddresses
		}
		qServiceProcessorSSHInfoAllowedAddresses := qrServiceProcessorSSHInfoAllowedAddresses
		if qServiceProcessorSSHInfoAllowedAddresses != "" {

			if err := r.SetQueryParam("service_processor.ssh_info.allowed_addresses", qServiceProcessorSSHInfoAllowedAddresses); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorState != nil {

		// query param service_processor.state
		var qrServiceProcessorState string

		if o.ServiceProcessorState != nil {
			qrServiceProcessorState = *o.ServiceProcessorState
		}
		qServiceProcessorState := qrServiceProcessorState
		if qServiceProcessorState != "" {

			if err := r.SetQueryParam("service_processor.state", qServiceProcessorState); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorType != nil {

		// query param service_processor.type
		var qrServiceProcessorType string

		if o.ServiceProcessorType != nil {
			qrServiceProcessorType = *o.ServiceProcessorType
		}
		qServiceProcessorType := qrServiceProcessorType
		if qServiceProcessorType != "" {

			if err := r.SetQueryParam("service_processor.type", qServiceProcessorType); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorWebServiceEnabled != nil {

		// query param service_processor.web_service.enabled
		var qrServiceProcessorWebServiceEnabled bool

		if o.ServiceProcessorWebServiceEnabled != nil {
			qrServiceProcessorWebServiceEnabled = *o.ServiceProcessorWebServiceEnabled
		}
		qServiceProcessorWebServiceEnabled := swag.FormatBool(qrServiceProcessorWebServiceEnabled)
		if qServiceProcessorWebServiceEnabled != "" {

			if err := r.SetQueryParam("service_processor.web_service.enabled", qServiceProcessorWebServiceEnabled); err != nil {
				return err
			}
		}
	}

	if o.ServiceProcessorWebServiceLimitAccess != nil {

		// query param service_processor.web_service.limit_access
		var qrServiceProcessorWebServiceLimitAccess bool

		if o.ServiceProcessorWebServiceLimitAccess != nil {
			qrServiceProcessorWebServiceLimitAccess = *o.ServiceProcessorWebServiceLimitAccess
		}
		qServiceProcessorWebServiceLimitAccess := swag.FormatBool(qrServiceProcessorWebServiceLimitAccess)
		if qServiceProcessorWebServiceLimitAccess != "" {

			if err := r.SetQueryParam("service_processor.web_service.limit_access", qServiceProcessorWebServiceLimitAccess); err != nil {
				return err
			}
		}
	}

	if o.SnaplockComplianceClockTime != nil {

		// query param snaplock.compliance_clock_time
		var qrSnaplockComplianceClockTime string

		if o.SnaplockComplianceClockTime != nil {
			qrSnaplockComplianceClockTime = *o.SnaplockComplianceClockTime
		}
		qSnaplockComplianceClockTime := qrSnaplockComplianceClockTime
		if qSnaplockComplianceClockTime != "" {

			if err := r.SetQueryParam("snaplock.compliance_clock_time", qSnaplockComplianceClockTime); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsProcessorUtilizationBase != nil {

		// query param statistics.processor_utilization_base
		var qrStatisticsProcessorUtilizationBase int64

		if o.StatisticsProcessorUtilizationBase != nil {
			qrStatisticsProcessorUtilizationBase = *o.StatisticsProcessorUtilizationBase
		}
		qStatisticsProcessorUtilizationBase := swag.FormatInt64(qrStatisticsProcessorUtilizationBase)
		if qStatisticsProcessorUtilizationBase != "" {

			if err := r.SetQueryParam("statistics.processor_utilization_base", qStatisticsProcessorUtilizationBase); err != nil {
				return err
			}
		}
	}

	if o.StatisticsProcessorUtilizationRaw != nil {

		// query param statistics.processor_utilization_raw
		var qrStatisticsProcessorUtilizationRaw int64

		if o.StatisticsProcessorUtilizationRaw != nil {
			qrStatisticsProcessorUtilizationRaw = *o.StatisticsProcessorUtilizationRaw
		}
		qStatisticsProcessorUtilizationRaw := swag.FormatInt64(qrStatisticsProcessorUtilizationRaw)
		if qStatisticsProcessorUtilizationRaw != "" {

			if err := r.SetQueryParam("statistics.processor_utilization_raw", qStatisticsProcessorUtilizationRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailabilityZonesName != nil {

		// query param storage_availability_zones.name
		var qrStorageAvailabilityZonesName string

		if o.StorageAvailabilityZonesName != nil {
			qrStorageAvailabilityZonesName = *o.StorageAvailabilityZonesName
		}
		qStorageAvailabilityZonesName := qrStorageAvailabilityZonesName
		if qStorageAvailabilityZonesName != "" {

			if err := r.SetQueryParam("storage_availability_zones.name", qStorageAvailabilityZonesName); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailabilityZonesUUID != nil {

		// query param storage_availability_zones.uuid
		var qrStorageAvailabilityZonesUUID string

		if o.StorageAvailabilityZonesUUID != nil {
			qrStorageAvailabilityZonesUUID = *o.StorageAvailabilityZonesUUID
		}
		qStorageAvailabilityZonesUUID := qrStorageAvailabilityZonesUUID
		if qStorageAvailabilityZonesUUID != "" {

			if err := r.SetQueryParam("storage_availability_zones.uuid", qStorageAvailabilityZonesUUID); err != nil {
				return err
			}
		}
	}

	if o.StorageConfiguration != nil {

		// query param storage_configuration
		var qrStorageConfiguration string

		if o.StorageConfiguration != nil {
			qrStorageConfiguration = *o.StorageConfiguration
		}
		qStorageConfiguration := qrStorageConfiguration
		if qStorageConfiguration != "" {

			if err := r.SetQueryParam("storage_configuration", qStorageConfiguration); err != nil {
				return err
			}
		}
	}

	if o.SystemAggregateName != nil {

		// query param system_aggregate.name
		var qrSystemAggregateName string

		if o.SystemAggregateName != nil {
			qrSystemAggregateName = *o.SystemAggregateName
		}
		qSystemAggregateName := qrSystemAggregateName
		if qSystemAggregateName != "" {

			if err := r.SetQueryParam("system_aggregate.name", qSystemAggregateName); err != nil {
				return err
			}
		}
	}

	if o.SystemAggregateUUID != nil {

		// query param system_aggregate.uuid
		var qrSystemAggregateUUID string

		if o.SystemAggregateUUID != nil {
			qrSystemAggregateUUID = *o.SystemAggregateUUID
		}
		qSystemAggregateUUID := qrSystemAggregateUUID
		if qSystemAggregateUUID != "" {

			if err := r.SetQueryParam("system_aggregate.uuid", qSystemAggregateUUID); err != nil {
				return err
			}
		}
	}

	if o.SystemID != nil {

		// query param system_id
		var qrSystemID string

		if o.SystemID != nil {
			qrSystemID = *o.SystemID
		}
		qSystemID := qrSystemID
		if qSystemID != "" {

			if err := r.SetQueryParam("system_id", qSystemID); err != nil {
				return err
			}
		}
	}

	if o.SystemMachineType != nil {

		// query param system_machine_type
		var qrSystemMachineType string

		if o.SystemMachineType != nil {
			qrSystemMachineType = *o.SystemMachineType
		}
		qSystemMachineType := qrSystemMachineType
		if qSystemMachineType != "" {

			if err := r.SetQueryParam("system_machine_type", qSystemMachineType); err != nil {
				return err
			}
		}
	}

	if o.Uptime != nil {

		// query param uptime
		var qrUptime int64

		if o.Uptime != nil {
			qrUptime = *o.Uptime
		}
		qUptime := swag.FormatInt64(qrUptime)
		if qUptime != "" {

			if err := r.SetQueryParam("uptime", qUptime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VendorSerialNumber != nil {

		// query param vendor_serial_number
		var qrVendorSerialNumber string

		if o.VendorSerialNumber != nil {
			qrVendorSerialNumber = *o.VendorSerialNumber
		}
		qVendorSerialNumber := qrVendorSerialNumber
		if qVendorSerialNumber != "" {

			if err := r.SetQueryParam("vendor_serial_number", qVendorSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.VersionFull != nil {

		// query param version.full
		var qrVersionFull string

		if o.VersionFull != nil {
			qrVersionFull = *o.VersionFull
		}
		qVersionFull := qrVersionFull
		if qVersionFull != "" {

			if err := r.SetQueryParam("version.full", qVersionFull); err != nil {
				return err
			}
		}
	}

	if o.VersionGeneration != nil {

		// query param version.generation
		var qrVersionGeneration int64

		if o.VersionGeneration != nil {
			qrVersionGeneration = *o.VersionGeneration
		}
		qVersionGeneration := swag.FormatInt64(qrVersionGeneration)
		if qVersionGeneration != "" {

			if err := r.SetQueryParam("version.generation", qVersionGeneration); err != nil {
				return err
			}
		}
	}

	if o.VersionMajor != nil {

		// query param version.major
		var qrVersionMajor int64

		if o.VersionMajor != nil {
			qrVersionMajor = *o.VersionMajor
		}
		qVersionMajor := swag.FormatInt64(qrVersionMajor)
		if qVersionMajor != "" {

			if err := r.SetQueryParam("version.major", qVersionMajor); err != nil {
				return err
			}
		}
	}

	if o.VersionMinor != nil {

		// query param version.minor
		var qrVersionMinor int64

		if o.VersionMinor != nil {
			qrVersionMinor = *o.VersionMinor
		}
		qVersionMinor := swag.FormatInt64(qrVersionMinor)
		if qVersionMinor != "" {

			if err := r.SetQueryParam("version.minor", qVersionMinor); err != nil {
				return err
			}
		}
	}

	if o.VMProviderType != nil {

		// query param vm.provider_type
		var qrVMProviderType string

		if o.VMProviderType != nil {
			qrVMProviderType = *o.VMProviderType
		}
		qVMProviderType := qrVMProviderType
		if qVMProviderType != "" {

			if err := r.SetQueryParam("vm.provider_type", qVMProviderType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNodesGet binds the parameter fields
func (o *NodesGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNodesGet binds the parameter order_by
func (o *NodesGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
