// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NodesGetReader is a Reader for the NodesGet structure.
type NodesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NodesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNodesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNodesGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNodesGetOK creates a NodesGetOK with default headers values
func NewNodesGetOK() *NodesGetOK {
	return &NodesGetOK{}
}

/*
NodesGetOK describes a response with status code 200, with default header values.

OK
*/
type NodesGetOK struct {
	Payload *models.NodeResponse
}

// IsSuccess returns true when this nodes get o k response has a 2xx status code
func (o *NodesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nodes get o k response has a 3xx status code
func (o *NodesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get o k response has a 4xx status code
func (o *NodesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nodes get o k response has a 5xx status code
func (o *NodesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nodes get o k response a status code equal to that given
func (o *NodesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nodes get o k response
func (o *NodesGetOK) Code() int {
	return 200
}

func (o *NodesGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/nodes][%d] nodesGetOK %s", 200, payload)
}

func (o *NodesGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/nodes][%d] nodesGetOK %s", 200, payload)
}

func (o *NodesGetOK) GetPayload() *models.NodeResponse {
	return o.Payload
}

func (o *NodesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NodeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodesGetDefault creates a NodesGetDefault with default headers values
func NewNodesGetDefault(code int) *NodesGetDefault {
	return &NodesGetDefault{
		_statusCode: code,
	}
}

/*
NodesGetDefault describes a response with status code -1, with default header values.

Error
*/
type NodesGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nodes get default response has a 2xx status code
func (o *NodesGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nodes get default response has a 3xx status code
func (o *NodesGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nodes get default response has a 4xx status code
func (o *NodesGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nodes get default response has a 5xx status code
func (o *NodesGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nodes get default response a status code equal to that given
func (o *NodesGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nodes get default response
func (o *NodesGetDefault) Code() int {
	return o._statusCode
}

func (o *NodesGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/nodes][%d] nodes_get default %s", o._statusCode, payload)
}

func (o *NodesGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/nodes][%d] nodes_get default %s", o._statusCode, payload)
}

func (o *NodesGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NodesGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
