// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewResourceTagCollectionGetParams creates a new ResourceTagCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceTagCollectionGetParams() *ResourceTagCollectionGetParams {
	return &ResourceTagCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceTagCollectionGetParamsWithTimeout creates a new ResourceTagCollectionGetParams object
// with the ability to set a timeout on a request.
func NewResourceTagCollectionGetParamsWithTimeout(timeout time.Duration) *ResourceTagCollectionGetParams {
	return &ResourceTagCollectionGetParams{
		timeout: timeout,
	}
}

// NewResourceTagCollectionGetParamsWithContext creates a new ResourceTagCollectionGetParams object
// with the ability to set a context for a request.
func NewResourceTagCollectionGetParamsWithContext(ctx context.Context) *ResourceTagCollectionGetParams {
	return &ResourceTagCollectionGetParams{
		Context: ctx,
	}
}

// NewResourceTagCollectionGetParamsWithHTTPClient creates a new ResourceTagCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceTagCollectionGetParamsWithHTTPClient(client *http.Client) *ResourceTagCollectionGetParams {
	return &ResourceTagCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ResourceTagCollectionGetParams contains all the parameters to send to the API endpoint

	for the resource tag collection get operation.

	Typically these are written to a http.Request.
*/
type ResourceTagCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NumResources.

	   Filter by num_resources
	*/
	NumResources *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Value.

	   Filter by value
	*/
	Value *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource tag collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagCollectionGetParams) WithDefaults() *ResourceTagCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource tag collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ResourceTagCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithTimeout(timeout time.Duration) *ResourceTagCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithContext(ctx context.Context) *ResourceTagCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithHTTPClient(client *http.Client) *ResourceTagCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithFields(fields []string) *ResourceTagCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithMaxRecords(maxRecords *int64) *ResourceTagCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNumResources adds the numResources to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithNumResources(numResources *int64) *ResourceTagCollectionGetParams {
	o.SetNumResources(numResources)
	return o
}

// SetNumResources adds the numResources to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetNumResources(numResources *int64) {
	o.NumResources = numResources
}

// WithOrderBy adds the orderBy to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithOrderBy(orderBy []string) *ResourceTagCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithReturnRecords(returnRecords *bool) *ResourceTagCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ResourceTagCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithValue adds the value to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) WithValue(value *string) *ResourceTagCollectionGetParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the resource tag collection get params
func (o *ResourceTagCollectionGetParams) SetValue(value *string) {
	o.Value = value
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceTagCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NumResources != nil {

		// query param num_resources
		var qrNumResources int64

		if o.NumResources != nil {
			qrNumResources = *o.NumResources
		}
		qNumResources := swag.FormatInt64(qrNumResources)
		if qNumResources != "" {

			if err := r.SetQueryParam("num_resources", qNumResources); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamResourceTagCollectionGet binds the parameter fields
func (o *ResourceTagCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamResourceTagCollectionGet binds the parameter order_by
func (o *ResourceTagCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
