// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ResourceTagCollectionGetReader is a Reader for the ResourceTagCollectionGet structure.
type ResourceTagCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceTagCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceTagCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceTagCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceTagCollectionGetOK creates a ResourceTagCollectionGetOK with default headers values
func NewResourceTagCollectionGetOK() *ResourceTagCollectionGetOK {
	return &ResourceTagCollectionGetOK{}
}

/*
ResourceTagCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ResourceTagCollectionGetOK struct {
	Payload *models.ResourceTagResponse
}

// IsSuccess returns true when this resource tag collection get o k response has a 2xx status code
func (o *ResourceTagCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource tag collection get o k response has a 3xx status code
func (o *ResourceTagCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource tag collection get o k response has a 4xx status code
func (o *ResourceTagCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource tag collection get o k response has a 5xx status code
func (o *ResourceTagCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource tag collection get o k response a status code equal to that given
func (o *ResourceTagCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource tag collection get o k response
func (o *ResourceTagCollectionGetOK) Code() int {
	return 200
}

func (o *ResourceTagCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags][%d] resourceTagCollectionGetOK %s", 200, payload)
}

func (o *ResourceTagCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags][%d] resourceTagCollectionGetOK %s", 200, payload)
}

func (o *ResourceTagCollectionGetOK) GetPayload() *models.ResourceTagResponse {
	return o.Payload
}

func (o *ResourceTagCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ResourceTagResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceTagCollectionGetDefault creates a ResourceTagCollectionGetDefault with default headers values
func NewResourceTagCollectionGetDefault(code int) *ResourceTagCollectionGetDefault {
	return &ResourceTagCollectionGetDefault{
		_statusCode: code,
	}
}

/*
ResourceTagCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type ResourceTagCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this resource tag collection get default response has a 2xx status code
func (o *ResourceTagCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource tag collection get default response has a 3xx status code
func (o *ResourceTagCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource tag collection get default response has a 4xx status code
func (o *ResourceTagCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource tag collection get default response has a 5xx status code
func (o *ResourceTagCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource tag collection get default response a status code equal to that given
func (o *ResourceTagCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource tag collection get default response
func (o *ResourceTagCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ResourceTagCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags][%d] resource_tag_collection_get default %s", o._statusCode, payload)
}

func (o *ResourceTagCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags][%d] resource_tag_collection_get default %s", o._statusCode, payload)
}

func (o *ResourceTagCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ResourceTagCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
