// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewResourceTagGetParams creates a new ResourceTagGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceTagGetParams() *ResourceTagGetParams {
	return &ResourceTagGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceTagGetParamsWithTimeout creates a new ResourceTagGetParams object
// with the ability to set a timeout on a request.
func NewResourceTagGetParamsWithTimeout(timeout time.Duration) *ResourceTagGetParams {
	return &ResourceTagGetParams{
		timeout: timeout,
	}
}

// NewResourceTagGetParamsWithContext creates a new ResourceTagGetParams object
// with the ability to set a context for a request.
func NewResourceTagGetParamsWithContext(ctx context.Context) *ResourceTagGetParams {
	return &ResourceTagGetParams{
		Context: ctx,
	}
}

// NewResourceTagGetParamsWithHTTPClient creates a new ResourceTagGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceTagGetParamsWithHTTPClient(client *http.Client) *ResourceTagGetParams {
	return &ResourceTagGetParams{
		HTTPClient: client,
	}
}

/*
ResourceTagGetParams contains all the parameters to send to the API endpoint

	for the resource tag get operation.

	Typically these are written to a http.Request.
*/
type ResourceTagGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	// Value.
	//
	// Format: key:value
	Value string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource tag get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagGetParams) WithDefaults() *ResourceTagGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource tag get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the resource tag get params
func (o *ResourceTagGetParams) WithTimeout(timeout time.Duration) *ResourceTagGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource tag get params
func (o *ResourceTagGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource tag get params
func (o *ResourceTagGetParams) WithContext(ctx context.Context) *ResourceTagGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource tag get params
func (o *ResourceTagGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource tag get params
func (o *ResourceTagGetParams) WithHTTPClient(client *http.Client) *ResourceTagGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource tag get params
func (o *ResourceTagGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the resource tag get params
func (o *ResourceTagGetParams) WithFields(fields []string) *ResourceTagGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the resource tag get params
func (o *ResourceTagGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithValue adds the value to the resource tag get params
func (o *ResourceTagGetParams) WithValue(value string) *ResourceTagGetParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the resource tag get params
func (o *ResourceTagGetParams) SetValue(value string) {
	o.Value = value
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceTagGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param value
	if err := r.SetPathParam("value", o.Value); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamResourceTagGet binds the parameter fields
func (o *ResourceTagGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
