// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ResourceTagGetReader is a Reader for the ResourceTagGet structure.
type ResourceTagGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceTagGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceTagGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceTagGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceTagGetOK creates a ResourceTagGetOK with default headers values
func NewResourceTagGetOK() *ResourceTagGetOK {
	return &ResourceTagGetOK{}
}

/*
ResourceTagGetOK describes a response with status code 200, with default header values.

OK
*/
type ResourceTagGetOK struct {
	Payload *models.ResourceTag
}

// IsSuccess returns true when this resource tag get o k response has a 2xx status code
func (o *ResourceTagGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource tag get o k response has a 3xx status code
func (o *ResourceTagGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource tag get o k response has a 4xx status code
func (o *ResourceTagGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource tag get o k response has a 5xx status code
func (o *ResourceTagGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource tag get o k response a status code equal to that given
func (o *ResourceTagGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource tag get o k response
func (o *ResourceTagGetOK) Code() int {
	return 200
}

func (o *ResourceTagGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{value}][%d] resourceTagGetOK %s", 200, payload)
}

func (o *ResourceTagGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{value}][%d] resourceTagGetOK %s", 200, payload)
}

func (o *ResourceTagGetOK) GetPayload() *models.ResourceTag {
	return o.Payload
}

func (o *ResourceTagGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ResourceTag)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceTagGetDefault creates a ResourceTagGetDefault with default headers values
func NewResourceTagGetDefault(code int) *ResourceTagGetDefault {
	return &ResourceTagGetDefault{
		_statusCode: code,
	}
}

/*
ResourceTagGetDefault describes a response with status code -1, with default header values.

Error
*/
type ResourceTagGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this resource tag get default response has a 2xx status code
func (o *ResourceTagGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource tag get default response has a 3xx status code
func (o *ResourceTagGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource tag get default response has a 4xx status code
func (o *ResourceTagGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource tag get default response has a 5xx status code
func (o *ResourceTagGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource tag get default response a status code equal to that given
func (o *ResourceTagGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource tag get default response
func (o *ResourceTagGetDefault) Code() int {
	return o._statusCode
}

func (o *ResourceTagGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{value}][%d] resource_tag_get default %s", o._statusCode, payload)
}

func (o *ResourceTagGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{value}][%d] resource_tag_get default %s", o._statusCode, payload)
}

func (o *ResourceTagGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ResourceTagGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
