// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ResourceTagResourceCollectionGetReader is a Reader for the ResourceTagResourceCollectionGet structure.
type ResourceTagResourceCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceTagResourceCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceTagResourceCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceTagResourceCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceTagResourceCollectionGetOK creates a ResourceTagResourceCollectionGetOK with default headers values
func NewResourceTagResourceCollectionGetOK() *ResourceTagResourceCollectionGetOK {
	return &ResourceTagResourceCollectionGetOK{}
}

/*
ResourceTagResourceCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ResourceTagResourceCollectionGetOK struct {
	Payload *models.ResourceTagResourceResponse
}

// IsSuccess returns true when this resource tag resource collection get o k response has a 2xx status code
func (o *ResourceTagResourceCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource tag resource collection get o k response has a 3xx status code
func (o *ResourceTagResourceCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource tag resource collection get o k response has a 4xx status code
func (o *ResourceTagResourceCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource tag resource collection get o k response has a 5xx status code
func (o *ResourceTagResourceCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource tag resource collection get o k response a status code equal to that given
func (o *ResourceTagResourceCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource tag resource collection get o k response
func (o *ResourceTagResourceCollectionGetOK) Code() int {
	return 200
}

func (o *ResourceTagResourceCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{resource_tag.value}/resources][%d] resourceTagResourceCollectionGetOK %s", 200, payload)
}

func (o *ResourceTagResourceCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{resource_tag.value}/resources][%d] resourceTagResourceCollectionGetOK %s", 200, payload)
}

func (o *ResourceTagResourceCollectionGetOK) GetPayload() *models.ResourceTagResourceResponse {
	return o.Payload
}

func (o *ResourceTagResourceCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ResourceTagResourceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceTagResourceCollectionGetDefault creates a ResourceTagResourceCollectionGetDefault with default headers values
func NewResourceTagResourceCollectionGetDefault(code int) *ResourceTagResourceCollectionGetDefault {
	return &ResourceTagResourceCollectionGetDefault{
		_statusCode: code,
	}
}

/*
ResourceTagResourceCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type ResourceTagResourceCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this resource tag resource collection get default response has a 2xx status code
func (o *ResourceTagResourceCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource tag resource collection get default response has a 3xx status code
func (o *ResourceTagResourceCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource tag resource collection get default response has a 4xx status code
func (o *ResourceTagResourceCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource tag resource collection get default response has a 5xx status code
func (o *ResourceTagResourceCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource tag resource collection get default response a status code equal to that given
func (o *ResourceTagResourceCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource tag resource collection get default response
func (o *ResourceTagResourceCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ResourceTagResourceCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{resource_tag.value}/resources][%d] resource_tag_resource_collection_get default %s", o._statusCode, payload)
}

func (o *ResourceTagResourceCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-tags/{resource_tag.value}/resources][%d] resource_tag_resource_collection_get default %s", o._statusCode, payload)
}

func (o *ResourceTagResourceCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ResourceTagResourceCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
