// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewResourceTagResourceCreateParams creates a new ResourceTagResourceCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceTagResourceCreateParams() *ResourceTagResourceCreateParams {
	return &ResourceTagResourceCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceTagResourceCreateParamsWithTimeout creates a new ResourceTagResourceCreateParams object
// with the ability to set a timeout on a request.
func NewResourceTagResourceCreateParamsWithTimeout(timeout time.Duration) *ResourceTagResourceCreateParams {
	return &ResourceTagResourceCreateParams{
		timeout: timeout,
	}
}

// NewResourceTagResourceCreateParamsWithContext creates a new ResourceTagResourceCreateParams object
// with the ability to set a context for a request.
func NewResourceTagResourceCreateParamsWithContext(ctx context.Context) *ResourceTagResourceCreateParams {
	return &ResourceTagResourceCreateParams{
		Context: ctx,
	}
}

// NewResourceTagResourceCreateParamsWithHTTPClient creates a new ResourceTagResourceCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceTagResourceCreateParamsWithHTTPClient(client *http.Client) *ResourceTagResourceCreateParams {
	return &ResourceTagResourceCreateParams{
		HTTPClient: client,
	}
}

/*
ResourceTagResourceCreateParams contains all the parameters to send to the API endpoint

	for the resource tag resource create operation.

	Typically these are written to a http.Request.
*/
type ResourceTagResourceCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.ResourceTagResource

	// ResourceTagValue.
	//
	// Format: key:value
	ResourceTagValue string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource tag resource create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagResourceCreateParams) WithDefaults() *ResourceTagResourceCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource tag resource create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagResourceCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := ResourceTagResourceCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) WithTimeout(timeout time.Duration) *ResourceTagResourceCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) WithContext(ctx context.Context) *ResourceTagResourceCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) WithHTTPClient(client *http.Client) *ResourceTagResourceCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) WithInfo(info *models.ResourceTagResource) *ResourceTagResourceCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) SetInfo(info *models.ResourceTagResource) {
	o.Info = info
}

// WithResourceTagValue adds the resourceTagValue to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) WithResourceTagValue(resourceTagValue string) *ResourceTagResourceCreateParams {
	o.SetResourceTagValue(resourceTagValue)
	return o
}

// SetResourceTagValue adds the resourceTagValue to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) SetResourceTagValue(resourceTagValue string) {
	o.ResourceTagValue = resourceTagValue
}

// WithReturnRecords adds the returnRecords to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) WithReturnRecords(returnRecords *bool) *ResourceTagResourceCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the resource tag resource create params
func (o *ResourceTagResourceCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceTagResourceCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param resource_tag.value
	if err := r.SetPathParam("resource_tag.value", o.ResourceTagValue); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
