// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewResourceTagResourceDeleteCollectionParams creates a new ResourceTagResourceDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceTagResourceDeleteCollectionParams() *ResourceTagResourceDeleteCollectionParams {
	return &ResourceTagResourceDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceTagResourceDeleteCollectionParamsWithTimeout creates a new ResourceTagResourceDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewResourceTagResourceDeleteCollectionParamsWithTimeout(timeout time.Duration) *ResourceTagResourceDeleteCollectionParams {
	return &ResourceTagResourceDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewResourceTagResourceDeleteCollectionParamsWithContext creates a new ResourceTagResourceDeleteCollectionParams object
// with the ability to set a context for a request.
func NewResourceTagResourceDeleteCollectionParamsWithContext(ctx context.Context) *ResourceTagResourceDeleteCollectionParams {
	return &ResourceTagResourceDeleteCollectionParams{
		Context: ctx,
	}
}

// NewResourceTagResourceDeleteCollectionParamsWithHTTPClient creates a new ResourceTagResourceDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceTagResourceDeleteCollectionParamsWithHTTPClient(client *http.Client) *ResourceTagResourceDeleteCollectionParams {
	return &ResourceTagResourceDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ResourceTagResourceDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the resource tag resource delete collection operation.

	Typically these are written to a http.Request.
*/
type ResourceTagResourceDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Href.

	   Filter by href
	*/
	Href *string

	/* Info.

	   Info specification
	*/
	Info ResourceTagResourceDeleteCollectionBody

	/* Label.

	   Filter by label
	*/
	Label *string

	// ResourceTagValue.
	//
	// Format: key:value
	ResourceTagValue string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Value.

	   Filter by value
	*/
	Value *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource tag resource delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagResourceDeleteCollectionParams) WithDefaults() *ResourceTagResourceDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource tag resource delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagResourceDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ResourceTagResourceDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithTimeout(timeout time.Duration) *ResourceTagResourceDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithContext(ctx context.Context) *ResourceTagResourceDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithHTTPClient(client *http.Client) *ResourceTagResourceDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ResourceTagResourceDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithHref adds the href to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithHref(href *string) *ResourceTagResourceDeleteCollectionParams {
	o.SetHref(href)
	return o
}

// SetHref adds the href to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetHref(href *string) {
	o.Href = href
}

// WithInfo adds the info to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithInfo(info ResourceTagResourceDeleteCollectionBody) *ResourceTagResourceDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetInfo(info ResourceTagResourceDeleteCollectionBody) {
	o.Info = info
}

// WithLabel adds the label to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithLabel(label *string) *ResourceTagResourceDeleteCollectionParams {
	o.SetLabel(label)
	return o
}

// SetLabel adds the label to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetLabel(label *string) {
	o.Label = label
}

// WithResourceTagValue adds the resourceTagValue to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithResourceTagValue(resourceTagValue string) *ResourceTagResourceDeleteCollectionParams {
	o.SetResourceTagValue(resourceTagValue)
	return o
}

// SetResourceTagValue adds the resourceTagValue to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetResourceTagValue(resourceTagValue string) {
	o.ResourceTagValue = resourceTagValue
}

// WithReturnRecords adds the returnRecords to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ResourceTagResourceDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ResourceTagResourceDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ResourceTagResourceDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithSvmName(svmName *string) *ResourceTagResourceDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithSvmUUID(svmUUID *string) *ResourceTagResourceDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithValue adds the value to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) WithValue(value *string) *ResourceTagResourceDeleteCollectionParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the resource tag resource delete collection params
func (o *ResourceTagResourceDeleteCollectionParams) SetValue(value *string) {
	o.Value = value
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceTagResourceDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Href != nil {

		// query param href
		var qrHref string

		if o.Href != nil {
			qrHref = *o.Href
		}
		qHref := qrHref
		if qHref != "" {

			if err := r.SetQueryParam("href", qHref); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Label != nil {

		// query param label
		var qrLabel string

		if o.Label != nil {
			qrLabel = *o.Label
		}
		qLabel := qrLabel
		if qLabel != "" {

			if err := r.SetQueryParam("label", qLabel); err != nil {
				return err
			}
		}
	}

	// path param resource_tag.value
	if err := r.SetPathParam("resource_tag.value", o.ResourceTagValue); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
