// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ResourceTagResourceDeleteCollectionReader is a Reader for the ResourceTagResourceDeleteCollection structure.
type ResourceTagResourceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceTagResourceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceTagResourceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceTagResourceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceTagResourceDeleteCollectionOK creates a ResourceTagResourceDeleteCollectionOK with default headers values
func NewResourceTagResourceDeleteCollectionOK() *ResourceTagResourceDeleteCollectionOK {
	return &ResourceTagResourceDeleteCollectionOK{}
}

/*
ResourceTagResourceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ResourceTagResourceDeleteCollectionOK struct {
}

// IsSuccess returns true when this resource tag resource delete collection o k response has a 2xx status code
func (o *ResourceTagResourceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource tag resource delete collection o k response has a 3xx status code
func (o *ResourceTagResourceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource tag resource delete collection o k response has a 4xx status code
func (o *ResourceTagResourceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource tag resource delete collection o k response has a 5xx status code
func (o *ResourceTagResourceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource tag resource delete collection o k response a status code equal to that given
func (o *ResourceTagResourceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource tag resource delete collection o k response
func (o *ResourceTagResourceDeleteCollectionOK) Code() int {
	return 200
}

func (o *ResourceTagResourceDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources][%d] resourceTagResourceDeleteCollectionOK", 200)
}

func (o *ResourceTagResourceDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources][%d] resourceTagResourceDeleteCollectionOK", 200)
}

func (o *ResourceTagResourceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewResourceTagResourceDeleteCollectionDefault creates a ResourceTagResourceDeleteCollectionDefault with default headers values
func NewResourceTagResourceDeleteCollectionDefault(code int) *ResourceTagResourceDeleteCollectionDefault {
	return &ResourceTagResourceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
ResourceTagResourceDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type ResourceTagResourceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this resource tag resource delete collection default response has a 2xx status code
func (o *ResourceTagResourceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource tag resource delete collection default response has a 3xx status code
func (o *ResourceTagResourceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource tag resource delete collection default response has a 4xx status code
func (o *ResourceTagResourceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource tag resource delete collection default response has a 5xx status code
func (o *ResourceTagResourceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource tag resource delete collection default response a status code equal to that given
func (o *ResourceTagResourceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource tag resource delete collection default response
func (o *ResourceTagResourceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ResourceTagResourceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources][%d] resource_tag_resource_delete_collection default %s", o._statusCode, payload)
}

func (o *ResourceTagResourceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources][%d] resource_tag_resource_delete_collection default %s", o._statusCode, payload)
}

func (o *ResourceTagResourceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ResourceTagResourceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ResourceTagResourceDeleteCollectionBody resource tag resource delete collection body
swagger:model ResourceTagResourceDeleteCollectionBody
*/
type ResourceTagResourceDeleteCollectionBody struct {

	// resource tag resource response inline records
	ResourceTagResourceResponseInlineRecords []*models.ResourceTagResource `json:"records,omitempty"`
}

// Validate validates this resource tag resource delete collection body
func (o *ResourceTagResourceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateResourceTagResourceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ResourceTagResourceDeleteCollectionBody) validateResourceTagResourceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ResourceTagResourceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ResourceTagResourceResponseInlineRecords); i++ {
		if swag.IsZero(o.ResourceTagResourceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ResourceTagResourceResponseInlineRecords[i] != nil {
			if err := o.ResourceTagResourceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this resource tag resource delete collection body based on the context it is used
func (o *ResourceTagResourceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateResourceTagResourceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ResourceTagResourceDeleteCollectionBody) contextValidateResourceTagResourceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ResourceTagResourceResponseInlineRecords); i++ {

		if o.ResourceTagResourceResponseInlineRecords[i] != nil {
			if err := o.ResourceTagResourceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ResourceTagResourceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ResourceTagResourceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ResourceTagResourceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
