// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ResourceTagResourceDeleteReader is a Reader for the ResourceTagResourceDelete structure.
type ResourceTagResourceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceTagResourceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceTagResourceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceTagResourceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceTagResourceDeleteOK creates a ResourceTagResourceDeleteOK with default headers values
func NewResourceTagResourceDeleteOK() *ResourceTagResourceDeleteOK {
	return &ResourceTagResourceDeleteOK{}
}

/*
ResourceTagResourceDeleteOK describes a response with status code 200, with default header values.

OK
*/
type ResourceTagResourceDeleteOK struct {
}

// IsSuccess returns true when this resource tag resource delete o k response has a 2xx status code
func (o *ResourceTagResourceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource tag resource delete o k response has a 3xx status code
func (o *ResourceTagResourceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource tag resource delete o k response has a 4xx status code
func (o *ResourceTagResourceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource tag resource delete o k response has a 5xx status code
func (o *ResourceTagResourceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource tag resource delete o k response a status code equal to that given
func (o *ResourceTagResourceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource tag resource delete o k response
func (o *ResourceTagResourceDeleteOK) Code() int {
	return 200
}

func (o *ResourceTagResourceDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources/{href}][%d] resourceTagResourceDeleteOK", 200)
}

func (o *ResourceTagResourceDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources/{href}][%d] resourceTagResourceDeleteOK", 200)
}

func (o *ResourceTagResourceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewResourceTagResourceDeleteDefault creates a ResourceTagResourceDeleteDefault with default headers values
func NewResourceTagResourceDeleteDefault(code int) *ResourceTagResourceDeleteDefault {
	return &ResourceTagResourceDeleteDefault{
		_statusCode: code,
	}
}

/*
ResourceTagResourceDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type ResourceTagResourceDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this resource tag resource delete default response has a 2xx status code
func (o *ResourceTagResourceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource tag resource delete default response has a 3xx status code
func (o *ResourceTagResourceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource tag resource delete default response has a 4xx status code
func (o *ResourceTagResourceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource tag resource delete default response has a 5xx status code
func (o *ResourceTagResourceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource tag resource delete default response a status code equal to that given
func (o *ResourceTagResourceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource tag resource delete default response
func (o *ResourceTagResourceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *ResourceTagResourceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources/{href}][%d] resource_tag_resource_delete default %s", o._statusCode, payload)
}

func (o *ResourceTagResourceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /resource-tags/{resource_tag.value}/resources/{href}][%d] resource_tag_resource_delete default %s", o._statusCode, payload)
}

func (o *ResourceTagResourceDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ResourceTagResourceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
