// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewResourceTagResourceGetParams creates a new ResourceTagResourceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceTagResourceGetParams() *ResourceTagResourceGetParams {
	return &ResourceTagResourceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceTagResourceGetParamsWithTimeout creates a new ResourceTagResourceGetParams object
// with the ability to set a timeout on a request.
func NewResourceTagResourceGetParamsWithTimeout(timeout time.Duration) *ResourceTagResourceGetParams {
	return &ResourceTagResourceGetParams{
		timeout: timeout,
	}
}

// NewResourceTagResourceGetParamsWithContext creates a new ResourceTagResourceGetParams object
// with the ability to set a context for a request.
func NewResourceTagResourceGetParamsWithContext(ctx context.Context) *ResourceTagResourceGetParams {
	return &ResourceTagResourceGetParams{
		Context: ctx,
	}
}

// NewResourceTagResourceGetParamsWithHTTPClient creates a new ResourceTagResourceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceTagResourceGetParamsWithHTTPClient(client *http.Client) *ResourceTagResourceGetParams {
	return &ResourceTagResourceGetParams{
		HTTPClient: client,
	}
}

/*
ResourceTagResourceGetParams contains all the parameters to send to the API endpoint

	for the resource tag resource get operation.

	Typically these are written to a http.Request.
*/
type ResourceTagResourceGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	// Href.
	Href string

	// ResourceTagValue.
	//
	// Format: key:value
	ResourceTagValue string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource tag resource get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagResourceGetParams) WithDefaults() *ResourceTagResourceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource tag resource get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceTagResourceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the resource tag resource get params
func (o *ResourceTagResourceGetParams) WithTimeout(timeout time.Duration) *ResourceTagResourceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource tag resource get params
func (o *ResourceTagResourceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource tag resource get params
func (o *ResourceTagResourceGetParams) WithContext(ctx context.Context) *ResourceTagResourceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource tag resource get params
func (o *ResourceTagResourceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource tag resource get params
func (o *ResourceTagResourceGetParams) WithHTTPClient(client *http.Client) *ResourceTagResourceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource tag resource get params
func (o *ResourceTagResourceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the resource tag resource get params
func (o *ResourceTagResourceGetParams) WithFields(fields []string) *ResourceTagResourceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the resource tag resource get params
func (o *ResourceTagResourceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHref adds the href to the resource tag resource get params
func (o *ResourceTagResourceGetParams) WithHref(href string) *ResourceTagResourceGetParams {
	o.SetHref(href)
	return o
}

// SetHref adds the href to the resource tag resource get params
func (o *ResourceTagResourceGetParams) SetHref(href string) {
	o.Href = href
}

// WithResourceTagValue adds the resourceTagValue to the resource tag resource get params
func (o *ResourceTagResourceGetParams) WithResourceTagValue(resourceTagValue string) *ResourceTagResourceGetParams {
	o.SetResourceTagValue(resourceTagValue)
	return o
}

// SetResourceTagValue adds the resourceTagValue to the resource tag resource get params
func (o *ResourceTagResourceGetParams) SetResourceTagValue(resourceTagValue string) {
	o.ResourceTagValue = resourceTagValue
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceTagResourceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param href
	if err := r.SetPathParam("href", o.Href); err != nil {
		return err
	}

	// path param resource_tag.value
	if err := r.SetPathParam("resource_tag.value", o.ResourceTagValue); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamResourceTagResourceGet binds the parameter fields
func (o *ResourceTagResourceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
