// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewScheduleCollectionGetParams creates a new ScheduleCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewScheduleCollectionGetParams() *ScheduleCollectionGetParams {
	return &ScheduleCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewScheduleCollectionGetParamsWithTimeout creates a new ScheduleCollectionGetParams object
// with the ability to set a timeout on a request.
func NewScheduleCollectionGetParamsWithTimeout(timeout time.Duration) *ScheduleCollectionGetParams {
	return &ScheduleCollectionGetParams{
		timeout: timeout,
	}
}

// NewScheduleCollectionGetParamsWithContext creates a new ScheduleCollectionGetParams object
// with the ability to set a context for a request.
func NewScheduleCollectionGetParamsWithContext(ctx context.Context) *ScheduleCollectionGetParams {
	return &ScheduleCollectionGetParams{
		Context: ctx,
	}
}

// NewScheduleCollectionGetParamsWithHTTPClient creates a new ScheduleCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewScheduleCollectionGetParamsWithHTTPClient(client *http.Client) *ScheduleCollectionGetParams {
	return &ScheduleCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ScheduleCollectionGetParams contains all the parameters to send to the API endpoint

	for the schedule collection get operation.

	Typically these are written to a http.Request.
*/
type ScheduleCollectionGetParams struct {

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* CronDays.

	   Filter by cron.days
	*/
	CronDays *int64

	/* CronHours.

	   Filter by cron.hours
	*/
	CronHours *int64

	/* CronMinutes.

	   Filter by cron.minutes
	*/
	CronMinutes *int64

	/* CronMonths.

	   Filter by cron.months
	*/
	CronMonths *int64

	/* CronWeekdays.

	   Filter by cron.weekdays
	*/
	CronWeekdays *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	   Filter by interval
	*/
	Interval *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the schedule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleCollectionGetParams) WithDefaults() *ScheduleCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the schedule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ScheduleCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithTimeout(timeout time.Duration) *ScheduleCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithContext(ctx context.Context) *ScheduleCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithHTTPClient(client *http.Client) *ScheduleCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterName adds the clusterName to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithClusterName(clusterName *string) *ScheduleCollectionGetParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithClusterUUID(clusterUUID *string) *ScheduleCollectionGetParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithCronDays adds the cronDays to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithCronDays(cronDays *int64) *ScheduleCollectionGetParams {
	o.SetCronDays(cronDays)
	return o
}

// SetCronDays adds the cronDays to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetCronDays(cronDays *int64) {
	o.CronDays = cronDays
}

// WithCronHours adds the cronHours to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithCronHours(cronHours *int64) *ScheduleCollectionGetParams {
	o.SetCronHours(cronHours)
	return o
}

// SetCronHours adds the cronHours to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetCronHours(cronHours *int64) {
	o.CronHours = cronHours
}

// WithCronMinutes adds the cronMinutes to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithCronMinutes(cronMinutes *int64) *ScheduleCollectionGetParams {
	o.SetCronMinutes(cronMinutes)
	return o
}

// SetCronMinutes adds the cronMinutes to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetCronMinutes(cronMinutes *int64) {
	o.CronMinutes = cronMinutes
}

// WithCronMonths adds the cronMonths to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithCronMonths(cronMonths *int64) *ScheduleCollectionGetParams {
	o.SetCronMonths(cronMonths)
	return o
}

// SetCronMonths adds the cronMonths to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetCronMonths(cronMonths *int64) {
	o.CronMonths = cronMonths
}

// WithCronWeekdays adds the cronWeekdays to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithCronWeekdays(cronWeekdays *int64) *ScheduleCollectionGetParams {
	o.SetCronWeekdays(cronWeekdays)
	return o
}

// SetCronWeekdays adds the cronWeekdays to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetCronWeekdays(cronWeekdays *int64) {
	o.CronWeekdays = cronWeekdays
}

// WithFields adds the fields to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithFields(fields []string) *ScheduleCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithInterval(interval *string) *ScheduleCollectionGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithMaxRecords adds the maxRecords to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithMaxRecords(maxRecords *int64) *ScheduleCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithName(name *string) *ScheduleCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithOrderBy(orderBy []string) *ScheduleCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithReturnRecords(returnRecords *bool) *ScheduleCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ScheduleCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithScope(scope *string) *ScheduleCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithSvmName(svmName *string) *ScheduleCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithSvmUUID(svmUUID *string) *ScheduleCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithType(typeVar *string) *ScheduleCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the schedule collection get params
func (o *ScheduleCollectionGetParams) WithUUID(uuid *string) *ScheduleCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the schedule collection get params
func (o *ScheduleCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ScheduleCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.CronDays != nil {

		// query param cron.days
		var qrCronDays int64

		if o.CronDays != nil {
			qrCronDays = *o.CronDays
		}
		qCronDays := swag.FormatInt64(qrCronDays)
		if qCronDays != "" {

			if err := r.SetQueryParam("cron.days", qCronDays); err != nil {
				return err
			}
		}
	}

	if o.CronHours != nil {

		// query param cron.hours
		var qrCronHours int64

		if o.CronHours != nil {
			qrCronHours = *o.CronHours
		}
		qCronHours := swag.FormatInt64(qrCronHours)
		if qCronHours != "" {

			if err := r.SetQueryParam("cron.hours", qCronHours); err != nil {
				return err
			}
		}
	}

	if o.CronMinutes != nil {

		// query param cron.minutes
		var qrCronMinutes int64

		if o.CronMinutes != nil {
			qrCronMinutes = *o.CronMinutes
		}
		qCronMinutes := swag.FormatInt64(qrCronMinutes)
		if qCronMinutes != "" {

			if err := r.SetQueryParam("cron.minutes", qCronMinutes); err != nil {
				return err
			}
		}
	}

	if o.CronMonths != nil {

		// query param cron.months
		var qrCronMonths int64

		if o.CronMonths != nil {
			qrCronMonths = *o.CronMonths
		}
		qCronMonths := swag.FormatInt64(qrCronMonths)
		if qCronMonths != "" {

			if err := r.SetQueryParam("cron.months", qCronMonths); err != nil {
				return err
			}
		}
	}

	if o.CronWeekdays != nil {

		// query param cron.weekdays
		var qrCronWeekdays int64

		if o.CronWeekdays != nil {
			qrCronWeekdays = *o.CronWeekdays
		}
		qCronWeekdays := swag.FormatInt64(qrCronWeekdays)
		if qCronWeekdays != "" {

			if err := r.SetQueryParam("cron.weekdays", qCronWeekdays); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamScheduleCollectionGet binds the parameter fields
func (o *ScheduleCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamScheduleCollectionGet binds the parameter order_by
func (o *ScheduleCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
