// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ScheduleCollectionGetReader is a Reader for the ScheduleCollectionGet structure.
type ScheduleCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ScheduleCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewScheduleCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewScheduleCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewScheduleCollectionGetOK creates a ScheduleCollectionGetOK with default headers values
func NewScheduleCollectionGetOK() *ScheduleCollectionGetOK {
	return &ScheduleCollectionGetOK{}
}

/*
ScheduleCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ScheduleCollectionGetOK struct {
	Payload *models.ScheduleResponse
}

// IsSuccess returns true when this schedule collection get o k response has a 2xx status code
func (o *ScheduleCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this schedule collection get o k response has a 3xx status code
func (o *ScheduleCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schedule collection get o k response has a 4xx status code
func (o *ScheduleCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this schedule collection get o k response has a 5xx status code
func (o *ScheduleCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this schedule collection get o k response a status code equal to that given
func (o *ScheduleCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the schedule collection get o k response
func (o *ScheduleCollectionGetOK) Code() int {
	return 200
}

func (o *ScheduleCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/schedules][%d] scheduleCollectionGetOK %s", 200, payload)
}

func (o *ScheduleCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/schedules][%d] scheduleCollectionGetOK %s", 200, payload)
}

func (o *ScheduleCollectionGetOK) GetPayload() *models.ScheduleResponse {
	return o.Payload
}

func (o *ScheduleCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ScheduleResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduleCollectionGetDefault creates a ScheduleCollectionGetDefault with default headers values
func NewScheduleCollectionGetDefault(code int) *ScheduleCollectionGetDefault {
	return &ScheduleCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	ScheduleCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 459760 | The schedule specified is not a valid schedule. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ScheduleCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schedule collection get default response has a 2xx status code
func (o *ScheduleCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this schedule collection get default response has a 3xx status code
func (o *ScheduleCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this schedule collection get default response has a 4xx status code
func (o *ScheduleCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this schedule collection get default response has a 5xx status code
func (o *ScheduleCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this schedule collection get default response a status code equal to that given
func (o *ScheduleCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the schedule collection get default response
func (o *ScheduleCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ScheduleCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/schedules][%d] schedule_collection_get default %s", o._statusCode, payload)
}

func (o *ScheduleCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cluster/schedules][%d] schedule_collection_get default %s", o._statusCode, payload)
}

func (o *ScheduleCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ScheduleCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
