// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewScheduleCreateParams creates a new ScheduleCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewScheduleCreateParams() *ScheduleCreateParams {
	return &ScheduleCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewScheduleCreateParamsWithTimeout creates a new ScheduleCreateParams object
// with the ability to set a timeout on a request.
func NewScheduleCreateParamsWithTimeout(timeout time.Duration) *ScheduleCreateParams {
	return &ScheduleCreateParams{
		timeout: timeout,
	}
}

// NewScheduleCreateParamsWithContext creates a new ScheduleCreateParams object
// with the ability to set a context for a request.
func NewScheduleCreateParamsWithContext(ctx context.Context) *ScheduleCreateParams {
	return &ScheduleCreateParams{
		Context: ctx,
	}
}

// NewScheduleCreateParamsWithHTTPClient creates a new ScheduleCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewScheduleCreateParamsWithHTTPClient(client *http.Client) *ScheduleCreateParams {
	return &ScheduleCreateParams{
		HTTPClient: client,
	}
}

/*
ScheduleCreateParams contains all the parameters to send to the API endpoint

	for the schedule create operation.

	Typically these are written to a http.Request.
*/
type ScheduleCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.Schedule

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the schedule create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleCreateParams) WithDefaults() *ScheduleCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the schedule create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := ScheduleCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the schedule create params
func (o *ScheduleCreateParams) WithTimeout(timeout time.Duration) *ScheduleCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the schedule create params
func (o *ScheduleCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the schedule create params
func (o *ScheduleCreateParams) WithContext(ctx context.Context) *ScheduleCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the schedule create params
func (o *ScheduleCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the schedule create params
func (o *ScheduleCreateParams) WithHTTPClient(client *http.Client) *ScheduleCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the schedule create params
func (o *ScheduleCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the schedule create params
func (o *ScheduleCreateParams) WithInfo(info *models.Schedule) *ScheduleCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the schedule create params
func (o *ScheduleCreateParams) SetInfo(info *models.Schedule) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the schedule create params
func (o *ScheduleCreateParams) WithReturnRecords(returnRecords *bool) *ScheduleCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the schedule create params
func (o *ScheduleCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *ScheduleCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
