// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewScheduleDeleteCollectionParams creates a new ScheduleDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewScheduleDeleteCollectionParams() *ScheduleDeleteCollectionParams {
	return &ScheduleDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewScheduleDeleteCollectionParamsWithTimeout creates a new ScheduleDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewScheduleDeleteCollectionParamsWithTimeout(timeout time.Duration) *ScheduleDeleteCollectionParams {
	return &ScheduleDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewScheduleDeleteCollectionParamsWithContext creates a new ScheduleDeleteCollectionParams object
// with the ability to set a context for a request.
func NewScheduleDeleteCollectionParamsWithContext(ctx context.Context) *ScheduleDeleteCollectionParams {
	return &ScheduleDeleteCollectionParams{
		Context: ctx,
	}
}

// NewScheduleDeleteCollectionParamsWithHTTPClient creates a new ScheduleDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewScheduleDeleteCollectionParamsWithHTTPClient(client *http.Client) *ScheduleDeleteCollectionParams {
	return &ScheduleDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ScheduleDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the schedule delete collection operation.

	Typically these are written to a http.Request.
*/
type ScheduleDeleteCollectionParams struct {

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CronDays.

	   Filter by cron.days
	*/
	CronDays *int64

	/* CronHours.

	   Filter by cron.hours
	*/
	CronHours *int64

	/* CronMinutes.

	   Filter by cron.minutes
	*/
	CronMinutes *int64

	/* CronMonths.

	   Filter by cron.months
	*/
	CronMonths *int64

	/* CronWeekdays.

	   Filter by cron.weekdays
	*/
	CronWeekdays *int64

	/* Info.

	   Info specification
	*/
	Info ScheduleDeleteCollectionBody

	/* Interval.

	   Filter by interval
	*/
	Interval *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the schedule delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleDeleteCollectionParams) WithDefaults() *ScheduleDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the schedule delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduleDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ScheduleDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithTimeout(timeout time.Duration) *ScheduleDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithContext(ctx context.Context) *ScheduleDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithHTTPClient(client *http.Client) *ScheduleDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterName adds the clusterName to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithClusterName(clusterName *string) *ScheduleDeleteCollectionParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithClusterUUID(clusterUUID *string) *ScheduleDeleteCollectionParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithContinueOnFailure adds the continueOnFailure to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ScheduleDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCronDays adds the cronDays to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithCronDays(cronDays *int64) *ScheduleDeleteCollectionParams {
	o.SetCronDays(cronDays)
	return o
}

// SetCronDays adds the cronDays to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetCronDays(cronDays *int64) {
	o.CronDays = cronDays
}

// WithCronHours adds the cronHours to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithCronHours(cronHours *int64) *ScheduleDeleteCollectionParams {
	o.SetCronHours(cronHours)
	return o
}

// SetCronHours adds the cronHours to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetCronHours(cronHours *int64) {
	o.CronHours = cronHours
}

// WithCronMinutes adds the cronMinutes to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithCronMinutes(cronMinutes *int64) *ScheduleDeleteCollectionParams {
	o.SetCronMinutes(cronMinutes)
	return o
}

// SetCronMinutes adds the cronMinutes to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetCronMinutes(cronMinutes *int64) {
	o.CronMinutes = cronMinutes
}

// WithCronMonths adds the cronMonths to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithCronMonths(cronMonths *int64) *ScheduleDeleteCollectionParams {
	o.SetCronMonths(cronMonths)
	return o
}

// SetCronMonths adds the cronMonths to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetCronMonths(cronMonths *int64) {
	o.CronMonths = cronMonths
}

// WithCronWeekdays adds the cronWeekdays to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithCronWeekdays(cronWeekdays *int64) *ScheduleDeleteCollectionParams {
	o.SetCronWeekdays(cronWeekdays)
	return o
}

// SetCronWeekdays adds the cronWeekdays to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetCronWeekdays(cronWeekdays *int64) {
	o.CronWeekdays = cronWeekdays
}

// WithInfo adds the info to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithInfo(info ScheduleDeleteCollectionBody) *ScheduleDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetInfo(info ScheduleDeleteCollectionBody) {
	o.Info = info
}

// WithInterval adds the interval to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithInterval(interval *string) *ScheduleDeleteCollectionParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithName adds the name to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithName(name *string) *ScheduleDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ScheduleDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ScheduleDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithScope(scope *string) *ScheduleDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ScheduleDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithSvmName(svmName *string) *ScheduleDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithSvmUUID(svmUUID *string) *ScheduleDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithType(typeVar *string) *ScheduleDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) WithUUID(uuid *string) *ScheduleDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the schedule delete collection params
func (o *ScheduleDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ScheduleDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CronDays != nil {

		// query param cron.days
		var qrCronDays int64

		if o.CronDays != nil {
			qrCronDays = *o.CronDays
		}
		qCronDays := swag.FormatInt64(qrCronDays)
		if qCronDays != "" {

			if err := r.SetQueryParam("cron.days", qCronDays); err != nil {
				return err
			}
		}
	}

	if o.CronHours != nil {

		// query param cron.hours
		var qrCronHours int64

		if o.CronHours != nil {
			qrCronHours = *o.CronHours
		}
		qCronHours := swag.FormatInt64(qrCronHours)
		if qCronHours != "" {

			if err := r.SetQueryParam("cron.hours", qCronHours); err != nil {
				return err
			}
		}
	}

	if o.CronMinutes != nil {

		// query param cron.minutes
		var qrCronMinutes int64

		if o.CronMinutes != nil {
			qrCronMinutes = *o.CronMinutes
		}
		qCronMinutes := swag.FormatInt64(qrCronMinutes)
		if qCronMinutes != "" {

			if err := r.SetQueryParam("cron.minutes", qCronMinutes); err != nil {
				return err
			}
		}
	}

	if o.CronMonths != nil {

		// query param cron.months
		var qrCronMonths int64

		if o.CronMonths != nil {
			qrCronMonths = *o.CronMonths
		}
		qCronMonths := swag.FormatInt64(qrCronMonths)
		if qCronMonths != "" {

			if err := r.SetQueryParam("cron.months", qCronMonths); err != nil {
				return err
			}
		}
	}

	if o.CronWeekdays != nil {

		// query param cron.weekdays
		var qrCronWeekdays int64

		if o.CronWeekdays != nil {
			qrCronWeekdays = *o.CronWeekdays
		}
		qCronWeekdays := swag.FormatInt64(qrCronWeekdays)
		if qCronWeekdays != "" {

			if err := r.SetQueryParam("cron.weekdays", qCronWeekdays); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
