// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ScheduleDeleteCollectionReader is a Reader for the ScheduleDeleteCollection structure.
type ScheduleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ScheduleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewScheduleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewScheduleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewScheduleDeleteCollectionOK creates a ScheduleDeleteCollectionOK with default headers values
func NewScheduleDeleteCollectionOK() *ScheduleDeleteCollectionOK {
	return &ScheduleDeleteCollectionOK{}
}

/*
ScheduleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ScheduleDeleteCollectionOK struct {
}

// IsSuccess returns true when this schedule delete collection o k response has a 2xx status code
func (o *ScheduleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this schedule delete collection o k response has a 3xx status code
func (o *ScheduleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schedule delete collection o k response has a 4xx status code
func (o *ScheduleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this schedule delete collection o k response has a 5xx status code
func (o *ScheduleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this schedule delete collection o k response a status code equal to that given
func (o *ScheduleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the schedule delete collection o k response
func (o *ScheduleDeleteCollectionOK) Code() int {
	return 200
}

func (o *ScheduleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /cluster/schedules][%d] scheduleDeleteCollectionOK", 200)
}

func (o *ScheduleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /cluster/schedules][%d] scheduleDeleteCollectionOK", 200)
}

func (o *ScheduleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewScheduleDeleteCollectionDefault creates a ScheduleDeleteCollectionDefault with default headers values
func NewScheduleDeleteCollectionDefault(code int) *ScheduleDeleteCollectionDefault {
	return &ScheduleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	ScheduleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 459758 | Cannot delete a job schedule that is in use. Remove all references to the schedule, and then try to delete again. |
| 459761 | Schedule cannot be deleted on this cluster because it is replicated from the remote cluster. |
| 459762 | The schedule cannot be deleted because it is a system-level schedule. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ScheduleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schedule delete collection default response has a 2xx status code
func (o *ScheduleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this schedule delete collection default response has a 3xx status code
func (o *ScheduleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this schedule delete collection default response has a 4xx status code
func (o *ScheduleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this schedule delete collection default response has a 5xx status code
func (o *ScheduleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this schedule delete collection default response a status code equal to that given
func (o *ScheduleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the schedule delete collection default response
func (o *ScheduleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ScheduleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/schedules][%d] schedule_delete_collection default %s", o._statusCode, payload)
}

func (o *ScheduleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cluster/schedules][%d] schedule_delete_collection default %s", o._statusCode, payload)
}

func (o *ScheduleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ScheduleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ScheduleDeleteCollectionBody schedule delete collection body
swagger:model ScheduleDeleteCollectionBody
*/
type ScheduleDeleteCollectionBody struct {

	// schedule response inline records
	ScheduleResponseInlineRecords []*models.Schedule `json:"records,omitempty"`
}

// Validate validates this schedule delete collection body
func (o *ScheduleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateScheduleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ScheduleDeleteCollectionBody) validateScheduleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ScheduleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ScheduleResponseInlineRecords); i++ {
		if swag.IsZero(o.ScheduleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ScheduleResponseInlineRecords[i] != nil {
			if err := o.ScheduleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this schedule delete collection body based on the context it is used
func (o *ScheduleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateScheduleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ScheduleDeleteCollectionBody) contextValidateScheduleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ScheduleResponseInlineRecords); i++ {

		if o.ScheduleResponseInlineRecords[i] != nil {
			if err := o.ScheduleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ScheduleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ScheduleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ScheduleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
