// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ScheduleModifyReader is a Reader for the ScheduleModify structure.
type ScheduleModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ScheduleModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewScheduleModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewScheduleModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewScheduleModifyOK creates a ScheduleModifyOK with default headers values
func NewScheduleModifyOK() *ScheduleModifyOK {
	return &ScheduleModifyOK{}
}

/*
ScheduleModifyOK describes a response with status code 200, with default header values.

OK
*/
type ScheduleModifyOK struct {
}

// IsSuccess returns true when this schedule modify o k response has a 2xx status code
func (o *ScheduleModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this schedule modify o k response has a 3xx status code
func (o *ScheduleModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schedule modify o k response has a 4xx status code
func (o *ScheduleModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this schedule modify o k response has a 5xx status code
func (o *ScheduleModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this schedule modify o k response a status code equal to that given
func (o *ScheduleModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the schedule modify o k response
func (o *ScheduleModifyOK) Code() int {
	return 200
}

func (o *ScheduleModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /cluster/schedules/{uuid}][%d] scheduleModifyOK", 200)
}

func (o *ScheduleModifyOK) String() string {
	return fmt.Sprintf("[PATCH /cluster/schedules/{uuid}][%d] scheduleModifyOK", 200)
}

func (o *ScheduleModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewScheduleModifyDefault creates a ScheduleModifyDefault with default headers values
func NewScheduleModifyDefault(code int) *ScheduleModifyDefault {
	return &ScheduleModifyDefault{
		_statusCode: code,
	}
}

/*
	ScheduleModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 458788 | The schedule specified is not a valid schedule. |
| 459760 | The schedule specified is not a valid schedule. |
| 459761 | Schedule cannot be modified on this cluster because it is replicated from the remote cluster. |
| 460783 | As this is a MetroCluster configuration and the local cluster is waiting for switchback, changes to non-system schedules are not allowed. |
| 461785 | A cron schedule cannot have an interval field. |
| 461786 | An interval schedule cannot have a cron field. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ScheduleModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schedule modify default response has a 2xx status code
func (o *ScheduleModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this schedule modify default response has a 3xx status code
func (o *ScheduleModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this schedule modify default response has a 4xx status code
func (o *ScheduleModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this schedule modify default response has a 5xx status code
func (o *ScheduleModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this schedule modify default response a status code equal to that given
func (o *ScheduleModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the schedule modify default response
func (o *ScheduleModifyDefault) Code() int {
	return o._statusCode
}

func (o *ScheduleModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/schedules/{uuid}][%d] schedule_modify default %s", o._statusCode, payload)
}

func (o *ScheduleModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /cluster/schedules/{uuid}][%d] schedule_modify default %s", o._statusCode, payload)
}

func (o *ScheduleModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ScheduleModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
