// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSensorsCollectionGetParams creates a new SensorsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSensorsCollectionGetParams() *SensorsCollectionGetParams {
	return &SensorsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSensorsCollectionGetParamsWithTimeout creates a new SensorsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSensorsCollectionGetParamsWithTimeout(timeout time.Duration) *SensorsCollectionGetParams {
	return &SensorsCollectionGetParams{
		timeout: timeout,
	}
}

// NewSensorsCollectionGetParamsWithContext creates a new SensorsCollectionGetParams object
// with the ability to set a context for a request.
func NewSensorsCollectionGetParamsWithContext(ctx context.Context) *SensorsCollectionGetParams {
	return &SensorsCollectionGetParams{
		Context: ctx,
	}
}

// NewSensorsCollectionGetParamsWithHTTPClient creates a new SensorsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSensorsCollectionGetParamsWithHTTPClient(client *http.Client) *SensorsCollectionGetParams {
	return &SensorsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SensorsCollectionGetParams contains all the parameters to send to the API endpoint

	for the sensors collection get operation.

	Typically these are written to a http.Request.
*/
type SensorsCollectionGetParams struct {

	/* CriticalHighThreshold.

	   Filter by critical_high_threshold
	*/
	CriticalHighThreshold *int64

	/* CriticalLowThreshold.

	   Filter by critical_low_threshold
	*/
	CriticalLowThreshold *int64

	/* DiscreteState.

	   Filter by discrete_state
	*/
	DiscreteState *string

	/* DiscreteValue.

	   Filter by discrete_value
	*/
	DiscreteValue *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ThresholdState.

	   Filter by threshold_state
	*/
	ThresholdState *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* Value.

	   Filter by value
	*/
	Value *int64

	/* ValueUnits.

	   Filter by value_units
	*/
	ValueUnits *string

	/* WarningHighThreshold.

	   Filter by warning_high_threshold
	*/
	WarningHighThreshold *int64

	/* WarningLowThreshold.

	   Filter by warning_low_threshold
	*/
	WarningLowThreshold *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the sensors collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SensorsCollectionGetParams) WithDefaults() *SensorsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the sensors collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SensorsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SensorsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the sensors collection get params
func (o *SensorsCollectionGetParams) WithTimeout(timeout time.Duration) *SensorsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the sensors collection get params
func (o *SensorsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the sensors collection get params
func (o *SensorsCollectionGetParams) WithContext(ctx context.Context) *SensorsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the sensors collection get params
func (o *SensorsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the sensors collection get params
func (o *SensorsCollectionGetParams) WithHTTPClient(client *http.Client) *SensorsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the sensors collection get params
func (o *SensorsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCriticalHighThreshold adds the criticalHighThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) WithCriticalHighThreshold(criticalHighThreshold *int64) *SensorsCollectionGetParams {
	o.SetCriticalHighThreshold(criticalHighThreshold)
	return o
}

// SetCriticalHighThreshold adds the criticalHighThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) SetCriticalHighThreshold(criticalHighThreshold *int64) {
	o.CriticalHighThreshold = criticalHighThreshold
}

// WithCriticalLowThreshold adds the criticalLowThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) WithCriticalLowThreshold(criticalLowThreshold *int64) *SensorsCollectionGetParams {
	o.SetCriticalLowThreshold(criticalLowThreshold)
	return o
}

// SetCriticalLowThreshold adds the criticalLowThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) SetCriticalLowThreshold(criticalLowThreshold *int64) {
	o.CriticalLowThreshold = criticalLowThreshold
}

// WithDiscreteState adds the discreteState to the sensors collection get params
func (o *SensorsCollectionGetParams) WithDiscreteState(discreteState *string) *SensorsCollectionGetParams {
	o.SetDiscreteState(discreteState)
	return o
}

// SetDiscreteState adds the discreteState to the sensors collection get params
func (o *SensorsCollectionGetParams) SetDiscreteState(discreteState *string) {
	o.DiscreteState = discreteState
}

// WithDiscreteValue adds the discreteValue to the sensors collection get params
func (o *SensorsCollectionGetParams) WithDiscreteValue(discreteValue *string) *SensorsCollectionGetParams {
	o.SetDiscreteValue(discreteValue)
	return o
}

// SetDiscreteValue adds the discreteValue to the sensors collection get params
func (o *SensorsCollectionGetParams) SetDiscreteValue(discreteValue *string) {
	o.DiscreteValue = discreteValue
}

// WithFields adds the fields to the sensors collection get params
func (o *SensorsCollectionGetParams) WithFields(fields []string) *SensorsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the sensors collection get params
func (o *SensorsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the sensors collection get params
func (o *SensorsCollectionGetParams) WithIndex(index *int64) *SensorsCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the sensors collection get params
func (o *SensorsCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithMaxRecords adds the maxRecords to the sensors collection get params
func (o *SensorsCollectionGetParams) WithMaxRecords(maxRecords *int64) *SensorsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the sensors collection get params
func (o *SensorsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the sensors collection get params
func (o *SensorsCollectionGetParams) WithName(name *string) *SensorsCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the sensors collection get params
func (o *SensorsCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the sensors collection get params
func (o *SensorsCollectionGetParams) WithNodeName(nodeName *string) *SensorsCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the sensors collection get params
func (o *SensorsCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the sensors collection get params
func (o *SensorsCollectionGetParams) WithNodeUUID(nodeUUID *string) *SensorsCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the sensors collection get params
func (o *SensorsCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the sensors collection get params
func (o *SensorsCollectionGetParams) WithOrderBy(orderBy []string) *SensorsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the sensors collection get params
func (o *SensorsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the sensors collection get params
func (o *SensorsCollectionGetParams) WithReturnRecords(returnRecords *bool) *SensorsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the sensors collection get params
func (o *SensorsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the sensors collection get params
func (o *SensorsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SensorsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the sensors collection get params
func (o *SensorsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithThresholdState adds the thresholdState to the sensors collection get params
func (o *SensorsCollectionGetParams) WithThresholdState(thresholdState *string) *SensorsCollectionGetParams {
	o.SetThresholdState(thresholdState)
	return o
}

// SetThresholdState adds the thresholdState to the sensors collection get params
func (o *SensorsCollectionGetParams) SetThresholdState(thresholdState *string) {
	o.ThresholdState = thresholdState
}

// WithType adds the typeVar to the sensors collection get params
func (o *SensorsCollectionGetParams) WithType(typeVar *string) *SensorsCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the sensors collection get params
func (o *SensorsCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithValue adds the value to the sensors collection get params
func (o *SensorsCollectionGetParams) WithValue(value *int64) *SensorsCollectionGetParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the sensors collection get params
func (o *SensorsCollectionGetParams) SetValue(value *int64) {
	o.Value = value
}

// WithValueUnits adds the valueUnits to the sensors collection get params
func (o *SensorsCollectionGetParams) WithValueUnits(valueUnits *string) *SensorsCollectionGetParams {
	o.SetValueUnits(valueUnits)
	return o
}

// SetValueUnits adds the valueUnits to the sensors collection get params
func (o *SensorsCollectionGetParams) SetValueUnits(valueUnits *string) {
	o.ValueUnits = valueUnits
}

// WithWarningHighThreshold adds the warningHighThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) WithWarningHighThreshold(warningHighThreshold *int64) *SensorsCollectionGetParams {
	o.SetWarningHighThreshold(warningHighThreshold)
	return o
}

// SetWarningHighThreshold adds the warningHighThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) SetWarningHighThreshold(warningHighThreshold *int64) {
	o.WarningHighThreshold = warningHighThreshold
}

// WithWarningLowThreshold adds the warningLowThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) WithWarningLowThreshold(warningLowThreshold *int64) *SensorsCollectionGetParams {
	o.SetWarningLowThreshold(warningLowThreshold)
	return o
}

// SetWarningLowThreshold adds the warningLowThreshold to the sensors collection get params
func (o *SensorsCollectionGetParams) SetWarningLowThreshold(warningLowThreshold *int64) {
	o.WarningLowThreshold = warningLowThreshold
}

// WriteToRequest writes these params to a swagger request
func (o *SensorsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CriticalHighThreshold != nil {

		// query param critical_high_threshold
		var qrCriticalHighThreshold int64

		if o.CriticalHighThreshold != nil {
			qrCriticalHighThreshold = *o.CriticalHighThreshold
		}
		qCriticalHighThreshold := swag.FormatInt64(qrCriticalHighThreshold)
		if qCriticalHighThreshold != "" {

			if err := r.SetQueryParam("critical_high_threshold", qCriticalHighThreshold); err != nil {
				return err
			}
		}
	}

	if o.CriticalLowThreshold != nil {

		// query param critical_low_threshold
		var qrCriticalLowThreshold int64

		if o.CriticalLowThreshold != nil {
			qrCriticalLowThreshold = *o.CriticalLowThreshold
		}
		qCriticalLowThreshold := swag.FormatInt64(qrCriticalLowThreshold)
		if qCriticalLowThreshold != "" {

			if err := r.SetQueryParam("critical_low_threshold", qCriticalLowThreshold); err != nil {
				return err
			}
		}
	}

	if o.DiscreteState != nil {

		// query param discrete_state
		var qrDiscreteState string

		if o.DiscreteState != nil {
			qrDiscreteState = *o.DiscreteState
		}
		qDiscreteState := qrDiscreteState
		if qDiscreteState != "" {

			if err := r.SetQueryParam("discrete_state", qDiscreteState); err != nil {
				return err
			}
		}
	}

	if o.DiscreteValue != nil {

		// query param discrete_value
		var qrDiscreteValue string

		if o.DiscreteValue != nil {
			qrDiscreteValue = *o.DiscreteValue
		}
		qDiscreteValue := qrDiscreteValue
		if qDiscreteValue != "" {

			if err := r.SetQueryParam("discrete_value", qDiscreteValue); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ThresholdState != nil {

		// query param threshold_state
		var qrThresholdState string

		if o.ThresholdState != nil {
			qrThresholdState = *o.ThresholdState
		}
		qThresholdState := qrThresholdState
		if qThresholdState != "" {

			if err := r.SetQueryParam("threshold_state", qThresholdState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue int64

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := swag.FormatInt64(qrValue)
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if o.ValueUnits != nil {

		// query param value_units
		var qrValueUnits string

		if o.ValueUnits != nil {
			qrValueUnits = *o.ValueUnits
		}
		qValueUnits := qrValueUnits
		if qValueUnits != "" {

			if err := r.SetQueryParam("value_units", qValueUnits); err != nil {
				return err
			}
		}
	}

	if o.WarningHighThreshold != nil {

		// query param warning_high_threshold
		var qrWarningHighThreshold int64

		if o.WarningHighThreshold != nil {
			qrWarningHighThreshold = *o.WarningHighThreshold
		}
		qWarningHighThreshold := swag.FormatInt64(qrWarningHighThreshold)
		if qWarningHighThreshold != "" {

			if err := r.SetQueryParam("warning_high_threshold", qWarningHighThreshold); err != nil {
				return err
			}
		}
	}

	if o.WarningLowThreshold != nil {

		// query param warning_low_threshold
		var qrWarningLowThreshold int64

		if o.WarningLowThreshold != nil {
			qrWarningLowThreshold = *o.WarningLowThreshold
		}
		qWarningLowThreshold := swag.FormatInt64(qrWarningLowThreshold)
		if qWarningLowThreshold != "" {

			if err := r.SetQueryParam("warning_low_threshold", qWarningLowThreshold); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSensorsCollectionGet binds the parameter fields
func (o *SensorsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSensorsCollectionGet binds the parameter order_by
func (o *SensorsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
